package GetWeb;
$VERSION = '1.15';
sub Version { $VERSION }

package GetWeb::GetWeb;

=head1 NAME

GetWeb::GetWeb - provide the GetWeb service

=head1 SYNOPSIS

use MailBot::Config;
use GetWeb::GetWeb;
MailBot::Config -> setRoot("/usr/local/getweb");
GetWeb::GetWeb -> new -> run;  # see MailBot::MailBot

=head1 DESCRIPTION

GetWeb extends MailBot's message-processing capability to enable email
users to access documents from the World Wide Web.

=head1 SEE ALSO

L<GetWeb::ProcMsg>, L<getweb>, L<MailBot::MailBot>,
L<http://www.healthnet.org/dist/getweb/>

=head1 COPYRIGHT

Copyright (c) 1997 SatelLife.  All rights reserved.

This library is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 AUTHOR

Rolf Nelson <rolf@usa.healthnet.org>

=cut

use LWP::UserAgent;
use MailBot::MailBot;
use GetWeb::ProcMsg;
use GetWeb::Cmd;
use Carp;
use MailBot::Util;
#use LWP::Debug qw(+);

@ISA = qw( MailBot::MailBot );
use strict;

sub sDie
{
     croak "SYNTAX ERROR: ". shift;
}

sub d
{
    &MailBot::Util::debug(@_);
}

sub vProcess
{
    my $self = shift;
    my $incoming = shift;

    new GetWeb::ProcMsg($self,$incoming);
}

1;
