/* Copyright (C) 2024 Free Software Foundation, Inc.
   Contributed by Oracle.

   This file is part of GNU Binutils.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, 51 Franklin Street - Fifth Floor, Boston,
   MA 02110-1301, USA.  */

#ifndef _HWC_ARM_AMPERE_1_H_
#define _HWC_ARM_AMPERE_1_H_

#define I(nm, event, mtr) INIT_HWC(nm, mtr, (event), PERF_TYPE_RAW)

static Hwcentry arm_ampere_1_list[] = {
  HWC_GENERIC
/* branch: */
  { I("br_immed_spec", 0x78,
    STXT("Branch speculatively executed, immediate branch")) },
  { I("br_indirect_spec", 0x7a,
    STXT("Branch speculatively executed, indirect branch")) },
  { I("br_mis_pred", 0x10,
    STXT("Mispredicted or not predicted branch speculatively executed. Unit:"
      " armv8_pmuv3_0")) },
  { I("br_pred", 0x12,
    STXT("Predictable branch speculatively executed. Unit: armv8_pmuv3_0")) },
  { I("br_return_spec", 0x79,
    STXT("Branch speculatively executed, procedure return")) },
/* bus: */
  { I("bus_access", 0x19,
    STXT("Attributable Bus access. Unit: armv8_pmuv3_0")) },
  { I("bus_access_normal", 0x64, STXT("Bus access, Normal")) },
  { I("bus_access_not_shared", 0x63,
    STXT("Bus access, not Normal, Cacheable, Shareable")) },
  { I("bus_access_periph", 0x65, STXT("Bus access, peripheral")) },
  { I("bus_access_rd", 0x60, STXT("Bus access read")) },
  { I("bus_access_shared", 0x62,
    STXT("Bus access, Normal, Cacheable, Shareable")) },
  { I("bus_access_wr", 0x61, STXT("Bus access write")) },
  { I("bus_cycles", 0x1d, STXT("Bus cycle. Unit: armv8_pmuv3_0")) },
  { I("cnt_cycles", 0x4004,
    STXT("Constant frequency cycles. Unit: armv8_pmuv3_0")) },
  { I("cpu_cycles", 0x11, STXT("Cycle. Unit: armv8_pmuv3_0")) },
/* cache: */
  { I("dtlb_walk", 0x34,
    STXT("Access to data TLB causes a translation table walk. Unit:"
      " armv8_pmuv3_0")) },
  { I("itlb_walk", 0x35,
    STXT("Access to instruction TLB that causes a translation table walk. Unit:"
      " armv8_pmuv3_0")) },
  { I("l1d_cache", 0x4,
    STXT("Level 1 data cache access. Unit: armv8_pmuv3_0")) },
  { I("l1d_cache_inval", 0x48, STXT("L1D cache invalidate")) },
  { I("l1d_cache_lmiss_rd", 0x39,
    STXT("Level 1 data cache long-latency read miss. Unit: armv8_pmuv3_0")) },
  { I("l1d_cache_rd", 0x40, STXT("L1D cache access, read")) },
  { I("l1d_cache_refill", 0x3,
    STXT("Level 1 data cache refill. Unit: armv8_pmuv3_0")) },
  { I("l1d_cache_refill_rd", 0x42, STXT("L1D cache refill, read")) },
  { I("l1d_cache_wr", 0x41, STXT("L1D cache access, write")) },
  { I("l1d_tlb", 0x25,
    STXT("Attributable Level 1 data or unified TLB access. Unit: armv8_pmuv3_0")) },
  { I("l1d_tlb_refill", 0x5,
    STXT("Attributable Level 1 data TLB refill. Unit: armv8_pmuv3_0")) },
  { I("l1d_tlb_refill_rd", 0x4c, STXT("L1D tlb refill, read")) },
  { I("l1d_tlb_refill_wr", 0x4d, STXT("L1D tlb refill, write")) },
  { I("l1i_cache", 0x14,
    STXT("Attributable Level 1 instruction cache access. Unit: armv8_pmuv3_0")) },
  { I("l1i_cache_lmiss", 0x4006,
    STXT("Level 1 instruction cache long-latency read miss. Unit: armv8_pmuv3_0")) },
  { I("l1i_cache_refill", 0x1,
    STXT("Level 1 instruction cache refill. Unit: armv8_pmuv3_0")) },
  { I("l1i_tlb", 0x26,
    STXT("Attributable Level 1 instruction TLB access. Unit: armv8_pmuv3_0")) },
  { I("l1i_tlb_refill", 0x2,
    STXT("Attributable Level 1 instruction TLB refill. Unit: armv8_pmuv3_0")) },
  { I("l2d_cache", 0x16,
    STXT("Level 2 data cache access. Unit: armv8_pmuv3_0")) },
  { I("l2d_cache_inval", 0x58, STXT("L2D cache invalidate")) },
  { I("l2d_cache_lmiss_rd", 0x4009,
    STXT("Level 2 data cache long-latency read miss. Unit: armv8_pmuv3_0")) },
  { I("l2d_cache_rd", 0x50, STXT("L2D cache access, read")) },
  { I("l2d_cache_refill", 0x17,
    STXT("Level 2 data refill. Unit: armv8_pmuv3_0")) },
  { I("l2d_cache_refill_rd", 0x52, STXT("L2D cache refill, read")) },
  { I("l2d_cache_refill_wr", 0x53, STXT("L2D cache refill, write")) },
  { I("l2d_cache_wb", 0x18,
    STXT("Attributable Level 2 data cache write-back. Unit: armv8_pmuv3_0")) },
  { I("l2d_cache_wb_clean", 0x57,
    STXT("L2D cache Write-Back, cleaning and coherency")) },
  { I("l2d_cache_wb_victim", 0x56, STXT("L2D cache Write-Back, victim")) },
  { I("l2d_cache_wr", 0x51, STXT("L2D cache access, write")) },
  { I("l2d_tlb", 0x2f,
    STXT("Attributable Level 2 data or unified TLB access. Unit: armv8_pmuv3_0")) },
  { I("l2d_tlb_refill", 0x2d,
    STXT("Attributable Level 2 data TLB refill. Unit: armv8_pmuv3_0")) },
  { I("l2i_tlb", 0x30,
    STXT("Attributable Level 2 instruction TLB access. Unit: armv8_pmuv3_0")) },
  { I("l2i_tlb_refill", 0x2e,
    STXT("Attributable Level 2 instruction TLB refill. Unit: armv8_pmuv3_0")) },
/* core imp def: */
  { I("bpu_branch_no_hit", 0x115,
    STXT("Predictable branch speculatively executed, unpredicted")) },
  { I("bpu_btb_update", 0x11c,
    STXT("Predictable branch speculatively executed, unpredicted, that"
      " mispredict")) },
  { I("bpu_conditional_branch_hit_btb", 0x111,
    STXT("Predictable conditional branch speculatively executed that hit any"
      " level of BTB")) },
  { I("bpu_conditional_branch_hit_btb_and_mispredict", 0x117,
    STXT("Predictable conditional branch speculatively executed that hit any"
      " level of BTB that (direction) mispredict")) },
  { I("bpu_flush_mem_fault", 0x121, STXT("Flushes due to memory hazards")) },
  { I("bpu_hit_btb", 0x110,
    STXT("Predictable branch speculatively executed that hit any level of BTB")) },
  { I("bpu_hit_btb_and_mispredict", 0x116,
    STXT("Predictable branch speculatively executed that hit any level of BTB"
      " that mispredict")) },
  { I("bpu_hit_indirect_predictor", 0x112,
    STXT("Predictable taken branch speculatively executed that hit any level of"
      " BTB that access the indirect predictor")) },
  { I("bpu_hit_rsb", 0x113,
    STXT("Predictable taken branch speculatively executed that hit any level of"
      " BTB that access the return predictor")) },
  { I("bpu_hit_rsb_and_mispredict", 0x119,
    STXT("Predictable taken branch speculatively executed that hit any level of"
      " BTB that access the return predictor that mispredict")) },
  { I("bpu_indirect_branch_hit_btb_and_mispredict", 0x118,
    STXT("Predictable taken branch speculatively executed that hit any level of"
      " BTB that access the indirect predictor that mispredict")) },
  { I("bpu_miss_rsb_and_mispredict", 0x11a,
    STXT("Predictable taken branch speculatively executed that hit any level of"
      " BTB that access the overflow/underflow return predictor that"
      " mispredict")) },
  { I("bpu_no_prediction_mispredict", 0x11b,
    STXT("Predictable branch speculatively executed, unpredicted, that"
      " mispredict")) },
  { I("bpu_rsb_full_stall", 0x11d,
    STXT("Count predict pipe stalls due to speculative return address predictor"
      " full")) },
  { I("bpu_unconditional_branch_miss_btb", 0x114,
    STXT("Predictable unconditional branch speculatively executed that did not"
      " hit any level of BTB")) },
  { I("breakpoint_match", 0xd501,
    STXT("GPC detected a Breakpoint instruction match")) },
  { I("fsu_cancel", 0xd404, STXT("Uops canceled (load cancels)")) },
  { I("fsu_div_sqrt_stall", 0xd405,
    STXT("Count scheduler stalls due to divide/sqrt")) },
  { I("fsu_fsx_issued", 0xd401,
    STXT("Uops issued by the scheduler on pipe X")) },
  { I("fsu_fsy_issued", 0xd402,
    STXT("Uops issued by the scheduler on pipe Y")) },
  { I("fsu_fsz_issued", 0xd403,
    STXT("Uops issued by the scheduler on pipe Z")) },
  { I("fsu_issued", 0xd400, STXT("Uops issued by the FSU scheduler")) },
  { I("gpc_flush", 0x120, STXT("Flushes")) },
  { I("gpc_swob_drain", 0xd500, STXT("Number of SWOB drains")) },
  { I("icf_early_mis_pred", 0xd100, STXT("Early mispredict")) },
  { I("icf_feq_full", 0xd101, STXT("FEQ full cycles")) },
  { I("icf_inst_fifo_full", 0xd102, STXT("Instruction FIFO Full")) },
  { I("icf_inst_spec_decode", 0x11f,
    STXT("Macro-ops speculatively decoded")) },
  { I("icf_pc_fifo_full", 0xd105, STXT("PC FIFO Full")) },
  { I("icf_stall", 0xd104,
    STXT("ICF sent 0 instructions to IDR this cycle")) },
  { I("idr_stall_bob_id", 0xd200, STXT("Stall due to BOB ID")) },
  { I("idr_stall_flush", 0xd206,
    STXT("Dispatch stall due to flush (6 cycles)")) },
  { I("idr_stall_fsu_sched", 0xd204,
    STXT("Dispatch stall due to FSU scheduler entries")) },
  { I("idr_stall_ixu_sched", 0xd203,
    STXT("Dispatch stall due to IXU scheduler entries")) },
  { I("idr_stall_lob_id", 0xd201, STXT("Dispatch stall due to LOB entries")) },
  { I("idr_stall_rob_id", 0xd205, STXT("Dispatch stall due to ROB entries")) },
  { I("idr_stall_sob_id", 0xd202, STXT("Dispatch stall due to SOB entries")) },
  { I("idr_stall_swob_full", 0xd20a,
    STXT("Number of SWOB drains triggered by system register write when SWOB"
      " full")) },
  { I("idr_stall_swob_raw", 0xd209,
    STXT("Number of SWOB drains triggered by system register or special-purpose"
      " register read-after-write or specific special-purpose register writes"
      " that cause SWOB drain")) },
  { I("idr_stall_swob_timeout", 0xd208,
    STXT("Number of SWOB drains triggered by timeout")) },
  { I("idr_stall_wfi", 0xd207, STXT("Dispatch stall due to WFI")) },
  { I("ixu_issue_cancel", 0xd301,
    STXT("Any uop issued was canceled for any reason")) },
  { I("ixu_ixa_issued", 0xd304, STXT("Uops issued by the scheduler on IXA")) },
  { I("ixu_ixa_par0_issued", 0xd305,
    STXT("Uops issued by the scheduler on IXA Par 0")) },
  { I("ixu_ixa_par1_issued", 0xd306,
    STXT("Uops issued by the scheduler on IXA Par 1")) },
  { I("ixu_ixb_issued", 0xd307, STXT("Uops issued by the scheduler on IXB")) },
  { I("ixu_ixb_par0_issued", 0xd308,
    STXT("Uops issued by the scheduler on IXB Par 0")) },
  { I("ixu_ixb_par1_issued", 0xd309,
    STXT("Uops issued by the scheduler on IXB Par 1")) },
  { I("ixu_ixc_issued", 0xd30a, STXT("Uops issued by the scheduler on IXC")) },
  { I("ixu_ixc_par0_issued", 0xd30b,
    STXT("Uops issued by the scheduler on IXC Par 0")) },
  { I("ixu_ixc_par1_issued", 0xd30c,
    STXT("Uops issued by the scheduler on IXC Par 1")) },
  { I("ixu_ixd_issued", 0xd30d, STXT("Uops issued by the scheduler on IXD")) },
  { I("ixu_ixd_par0_issued", 0xd30e,
    STXT("Uops issued by the scheduler on IXD Par 0")) },
  { I("ixu_ixd_par1_issued", 0xd30f,
    STXT("Uops issued by the scheduler on IXD Par 1")) },
  { I("ixu_load_cancel", 0xd302,
    STXT("A load wakeup to the scheduler has been cancelled")) },
  { I("ixu_num_uops_issued", 0xd300,
    STXT("Instructions issued by the scheduler")) },
  { I("ixu_slow_cancel", 0xd303,
    STXT("The scheduler had to cancel one slow Uop due to resource conflict")) },
  { I("l1_pfetch_dist_inc", 0xd60a,
    STXT("L1 prefetcher, distance was increased")) },
  { I("l1_pfetch_dist_rst", 0xd609,
    STXT("L1 prefetcher, distance was reset")) },
  { I("l1_pfetch_entry_trained", 0xd60b,
    STXT("L1 prefetcher, table entry is trained")) },
  { I("l1_pfetch_l2_req", 0xd608,
    STXT("L1 prefetcher, load prefetch to L2 generated")) },
  { I("l1_pfetch_ld_fill", 0xd607,
    STXT("L1 prefetcher, load prefetch fills into the L1 cache")) },
  { I("l1_pfetch_ld_gen", 0xd606,
    STXT("L1 prefetcher, load prefetch requests generated")) },
  { I("l1d_tlb_miss", 0xd600, STXT("L1D TLB miss")) },
  { I("l1i_tlb_miss", 0xd103, STXT("L1I TLB miss")) },
  { I("l2_prefetch_refill", 0x10a,
    STXT("Level 2 prefetch requests, refilled to L2 cache")) },
  { I("l2_prefetch_req", 0xd703,
    STXT("L2 prefetcher, load prefetch requests generated")) },
  { I("l2_prefetch_upgrade", 0x10b, STXT("Level 2 prefetch requests, late")) },
  { I("l2c_dat_crd_stall", 0x169, STXT("L2 TXDAT LCRD blocked")) },
  { I("l2c_data_refill", 0xd702, STXT("L2 refill from D-side miss")) },
  { I("l2c_inst_refill", 0xd701, STXT("L2 refill from I-side miss")) },
  { I("l2c_pipe_replay", 0xd700, STXT("L2 pipeline replay")) },
  { I("l2c_req_crd_stall", 0x16b, STXT("L2 TXREQ LCRD blocked")) },
  { I("l2c_rsp_crd_stall", 0x16a, STXT("L2 TXRSP LCRD blocked")) },
  { I("l2c_snoop", 0x156, STXT("Bus request sn")) },
  { I("ld_from_st_fwd", 0xd605,
    STXT("Load satisified from store forwarded data")) },
  { I("lsu_st_retire_stall", 0xd60c, STXT("Store retirement pipe stall")) },
  { I("mmu_d_otb_alloc", 0xd800, STXT("L2D OTB allocate")) },
  { I("mmu_d_s1_walk_fault", 0xd80b, STXT("D-side Stage1 tablewalk fault")) },
  { I("mmu_d_s2_walk_fault", 0xd80c, STXT("D-side Stage2 tablewalk fault")) },
  { I("mmu_d_walk_steps", 0xd80d,
    STXT("D-side Tablewalk steps or descriptor fetches")) },
  { I("mmu_i_otb_alloc", 0xd900, STXT("L2I OTB allocate")) },
  { I("mmu_i_s1_walk_fault", 0xd90b, STXT("I-side Stage1 tablewalk fault")) },
  { I("mmu_i_s2_walk_fault", 0xd90c, STXT("I-side Stage2 tablewalk fault")) },
  { I("mmu_i_walk_steps", 0xd90d,
    STXT("I-side Tablewalk steps or descriptor fetches")) },
  { I("msc_etm_extout0", 0x141, STXT("ETM extout bit 0")) },
  { I("msc_etm_extout1", 0x142, STXT("ETM extout bit 1")) },
  { I("msc_etm_extout2", 0x143, STXT("ETM extout bit 2")) },
  { I("msc_etm_extout3", 0x144, STXT("ETM extout bit 3")) },
  { I("ofb_full", 0xd601, STXT("OFB full cycles")) },
  { I("stall_backend_cache", 0xd20d,
    STXT("Dispatch stall due to L1 data cache miss")) },
  { I("stall_backend_resource", 0xd20f,
    STXT("Dispatch stall due to lack of any core resource")) },
  { I("stall_backend_tlb", 0xd20e,
    STXT("Dispatch stall due to L1 data TLB miss")) },
  { I("stall_frontend_cache", 0xd20b,
    STXT("Dispatch stall due to L1 instruction cache miss")) },
  { I("stall_frontend_tlb", 0xd20c,
    STXT("Dispatch stall due to L1 instruction TLB miss")) },
  { I("watchpoint_match", 0xd60d,
    STXT("LSU detected a Watchpoint data match")) },
/* exception: */
  { I("exc_dabort", 0x84, STXT("Exception taken, Data Abort and SError")) },
  { I("exc_fiq", 0x87, STXT("Exception taken, FIQ")) },
  { I("exc_hvc", 0x8a, STXT("Exception taken, Hypervisor Call")) },
  { I("exc_irq", 0x86, STXT("Exception taken, IRQ")) },
  { I("exc_pabort", 0x83, STXT("Exception taken, Instruction Abort")) },
  { I("exc_return", 0xa,
    STXT("Instruction architecturally executed, condition check pass, exception"
      " return. Unit: armv8_pmuv3_0")) },
  { I("exc_svc", 0x82, STXT("Exception taken, Supervisor Call")) },
  { I("exc_taken", 0x9, STXT("Exception taken. Unit: armv8_pmuv3_0")) },
  { I("exc_trap_dabort", 0x8c,
    STXT("Exception taken, Data Abort or SError not taken locally")) },
  { I("exc_trap_fiq", 0x8f, STXT("Exception taken, FIQ not taken locally")) },
  { I("exc_trap_irq", 0x8e, STXT("Exception taken, IRQ not taken locally")) },
  { I("exc_trap_other", 0x8d,
    STXT("Exception taken, Other traps not taken locally")) },
  { I("exc_trap_pabort", 0x8b,
    STXT("Exception taken, Instruction Abort not taken locally")) },
  { I("exc_undef", 0x81, STXT("Exception taken, Other synchronous")) },
/* instruction: */
  { I("ase_spec", 0x74,
    STXT("Operation speculatively executed, Advanced SIMD instruction")) },
  { I("br_immed_retired", 0xd,
    STXT("Instruction architecturally executed, immediate branch. Unit:"
      " armv8_pmuv3_0")) },
  { I("br_mis_pred_retired", 0x22,
    STXT("Instruction architecturally executed, mispredicted branch. Unit:"
      " armv8_pmuv3_0")) },
  { I("br_retired", 0x21,
    STXT("Instruction architecturally executed, branch. Unit: armv8_pmuv3_0")) },
  { I("br_return_retired", 0xe,
    STXT("Instruction architecturally executed, condition code check pass,"
      " procedure return. Unit: armv8_pmuv3_0")) },
  { I("cid_write_retired", 0xb,
    STXT("Instruction architecturally executed, condition code check pass, write"
      " to CONTEXTIDR. Unit: armv8_pmuv3_0")) },
  { I("crypto_spec", 0x77,
    STXT("Operation speculatively executed, Cryptographic instruction")) },
  { I("dmb_spec", 0x7e, STXT("Barrier speculatively executed, DMB")) },
  { I("dp_spec", 0x73,
    STXT("Operation speculatively executed, integer data processing")) },
  { I("dsb_spec", 0x7d, STXT("Barrier speculatively executed, DSB")) },
  { I("inst_retired", 0x8,
    STXT("Instruction architecturally executed. Unit: armv8_pmuv3_0")) },
  { I("inst_spec", 0x1b,
    STXT("Operation speculatively executed. Unit: armv8_pmuv3_0")) },
  { I("isb_spec", 0x7c, STXT("Barrier speculatively executed, ISB")) },
  { I("ld_spec", 0x70, STXT("Operation speculatively executed, load")) },
  { I("ldst_spec", 0x72,
    STXT("Operation speculatively executed, load or store")) },
  { I("nop_spec", 0x100, STXT("Speculatively executed, NOP")) },
  { I("op_retired", 0x3a,
    STXT("Micro-operation architecturally executed. Unit: armv8_pmuv3_0")) },
  { I("op_spec", 0x3b,
    STXT("Micro-operation speculatively executed. Unit: armv8_pmuv3_0")) },
  { I("pc_write_retired", 0xc,
    STXT("Instruction architecturally executed, condition code check pass,"
      " software change of the PC. Unit: armv8_pmuv3_0")) },
  { I("pc_write_spec", 0x76,
    STXT("Operation speculatively executed, software change of the PC")) },
  { I("rc_ld_spec", 0x90,
    STXT("Release consistency operation speculatively executed, Load-Acquire")) },
  { I("rc_st_spec", 0x91,
    STXT("Release consistency operation speculatively executed, Store-Release")) },
  { I("st_retired", 0x7,
    STXT("Instruction architecturally executed, condition code check pass,"
      " store. Unit: armv8_pmuv3_0")) },
  { I("st_spec", 0x71, STXT("Operation speculatively executed, store")) },
  { I("sw_incr", 0,
    STXT("Instruction architecturally executed, Condition code check pass,"
      " software increment")) },
  { I("ttbr_write_retired", 0x1c,
    STXT("Instruction architecturally executed, Condition code check pass, write"
      " to TTBR. Unit: armv8_pmuv3_0")) },
  { I("vfp_spec", 0x75,
    STXT("Operation speculatively executed, floating-point instruction")) },
/* intrinsic: */
  { I("ldrex_spec", 0x6c,
    STXT("Exclusive operation speculatively executed, LDREX or LDX")) },
  { I("strex_fail_spec", 0x6e,
    STXT("Exclusive operation speculatively executed, STREX or STX fail")) },
  { I("strex_pass_spec", 0x6d,
    STXT("Exclusive operation speculatively executed, STREX or STX pass")) },
  { I("strex_spec", 0x6f,
    STXT("Exclusive operation speculatively executed, STREX or STX")) },
/* memory: */
  { I("ld_align_lat", 0x4021,
    STXT("Load with additional latency from alignment. Unit: armv8_pmuv3_0")) },
  { I("ld_retired", 0x6,
    STXT("Instruction architecturally executed, condition code check pass, load."
      " Unit: armv8_pmuv3_0")) },
  { I("ldst_align_lat", 0x4020,
    STXT("Access with additional latency from alignment. Unit: armv8_pmuv3_0")) },
  { I("mem_access", 0x13, STXT("Data memory access. Unit: armv8_pmuv3_0")) },
  { I("mem_access_checked", 0x4024,
    STXT("Checked data memory access. Unit: armv8_pmuv3_0")) },
  { I("mem_access_checked_rd", 0x4025,
    STXT("Checked data memory access, read. Unit: armv8_pmuv3_0")) },
  { I("mem_access_checked_wr", 0x4026,
    STXT("Checked data memory access, write. Unit: armv8_pmuv3_0")) },
  { I("mem_access_rd", 0x66, STXT("Data memory access, read")) },
  { I("mem_access_wr", 0x67, STXT("Data memory access, write")) },
  { I("memory_error", 0x1a, STXT("Local memory error. Unit: armv8_pmuv3_0")) },
  { I("st_align_lat", 0x4022,
    STXT("Store with additional latency from alignment. Unit: armv8_pmuv3_0")) },
  { I("unaligned_ld_spec", 0x68, STXT("Unaligned access, read")) },
  { I("unaligned_ldst_spec", 0x6a, STXT("Unaligned access")) },
  { I("unaligned_st_spec", 0x69, STXT("Unaligned access, write")) },
/* pipeline: */
  { I("stall", 0x3c,
    STXT("Impacted by errata, use metrics instead - Spec update: Errata"
      " AC03_CPU_29. Unit: armv8_pmuv3_0")) },
  { I("stall_backend", 0x24,
    STXT("No operation issued due to the backend. Unit: armv8_pmuv3_0")) },
  { I("stall_backend_mem", 0x4005,
    STXT("Memory stall cycles. Unit: armv8_pmuv3_0")) },
  { I("stall_frontend", 0x23,
    STXT("Impacted by errata, use metrics instead - Spec update: Errata"
      " AC03_CPU_29. Unit: armv8_pmuv3_0")) },
  { I("stall_slot", 0x3f, STXT("No operation sent for execution on a slot")) },
  { I("stall_slot_backend", 0x3d,
    STXT("No operation sent for execution on a slot due to the backend. Unit:"
      " armv8_pmuv3_0")) },
  { I("stall_slot_frontend", 0x3e,
    STXT("Impacted by errata, use metrics instead - Spec update: Errata"
      " AC03_CPU_29. Unit: armv8_pmuv3_0")) },
/* spe: */
  { I("sample_collision", 0x4003,
    STXT("Sample collided with previous sample. Unit: armv8_pmuv3_0")) },
  { I("sample_feed", 0x4001, STXT("Sample Taken. Unit: armv8_pmuv3_0")) },
  { I("sample_filtrate", 0x4002,
    STXT("Sample Taken and not removed by filtering. Unit: armv8_pmuv3_0")) },
  { I("sample_pop", 0x4000, STXT("Sample Population. Unit: armv8_pmuv3_0")) },
  { NULL, NULL, 0, NULL }
};

#undef I
#endif
