{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdBackUrl: TMFString;
    { Internal wrapper for property @link(BackUrl). This wrapper API may change, we advise to access simpler @link(BackUrl) instead. }
    public property FdBackUrl: TMFString read FFdBackUrl;
    {  }
    procedure SetBackUrl(const Value: array of string); overload;
    {  }
    procedure SetBackUrl(const Value: TCastleStringList); overload;

    strict private FFdBottomUrl: TMFString;
    { Internal wrapper for property @link(BottomUrl). This wrapper API may change, we advise to access simpler @link(BottomUrl) instead. }
    public property FdBottomUrl: TMFString read FFdBottomUrl;
    {  }
    procedure SetBottomUrl(const Value: array of string); overload;
    {  }
    procedure SetBottomUrl(const Value: TCastleStringList); overload;

    strict private FFdFrontUrl: TMFString;
    { Internal wrapper for property @link(FrontUrl). This wrapper API may change, we advise to access simpler @link(FrontUrl) instead. }
    public property FdFrontUrl: TMFString read FFdFrontUrl;
    {  }
    procedure SetFrontUrl(const Value: array of string); overload;
    {  }
    procedure SetFrontUrl(const Value: TCastleStringList); overload;

    strict private FFdLeftUrl: TMFString;
    { Internal wrapper for property @link(LeftUrl). This wrapper API may change, we advise to access simpler @link(LeftUrl) instead. }
    public property FdLeftUrl: TMFString read FFdLeftUrl;
    {  }
    procedure SetLeftUrl(const Value: array of string); overload;
    {  }
    procedure SetLeftUrl(const Value: TCastleStringList); overload;

    strict private FFdRightUrl: TMFString;
    { Internal wrapper for property @link(RightUrl). This wrapper API may change, we advise to access simpler @link(RightUrl) instead. }
    public property FdRightUrl: TMFString read FFdRightUrl;
    {  }
    procedure SetRightUrl(const Value: array of string); overload;
    {  }
    procedure SetRightUrl(const Value: TCastleStringList); overload;

    strict private FFdTopUrl: TMFString;
    { Internal wrapper for property @link(TopUrl). This wrapper API may change, we advise to access simpler @link(TopUrl) instead. }
    public property FdTopUrl: TMFString read FFdTopUrl;
    {  }
    procedure SetTopUrl(const Value: array of string); overload;
    {  }
    procedure SetTopUrl(const Value: TCastleStringList); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TBackgroundNode ----------------------------------------------- }

procedure TBackgroundNode.SetBackUrl(const Value: array of string);
begin
  FdBackUrl.Send(Value);
end;

procedure TBackgroundNode.SetBackUrl(const Value: TCastleStringList);
begin
  FdBackUrl.Send(Value);
end;

procedure TBackgroundNode.SetBottomUrl(const Value: array of string);
begin
  FdBottomUrl.Send(Value);
end;

procedure TBackgroundNode.SetBottomUrl(const Value: TCastleStringList);
begin
  FdBottomUrl.Send(Value);
end;

procedure TBackgroundNode.SetFrontUrl(const Value: array of string);
begin
  FdFrontUrl.Send(Value);
end;

procedure TBackgroundNode.SetFrontUrl(const Value: TCastleStringList);
begin
  FdFrontUrl.Send(Value);
end;

procedure TBackgroundNode.SetLeftUrl(const Value: array of string);
begin
  FdLeftUrl.Send(Value);
end;

procedure TBackgroundNode.SetLeftUrl(const Value: TCastleStringList);
begin
  FdLeftUrl.Send(Value);
end;

procedure TBackgroundNode.SetRightUrl(const Value: array of string);
begin
  FdRightUrl.Send(Value);
end;

procedure TBackgroundNode.SetRightUrl(const Value: TCastleStringList);
begin
  FdRightUrl.Send(Value);
end;

procedure TBackgroundNode.SetTopUrl(const Value: array of string);
begin
  FdTopUrl.Send(Value);
end;

procedure TBackgroundNode.SetTopUrl(const Value: TCastleStringList);
begin
  FdTopUrl.Send(Value);
end;

class function TBackgroundNode.ClassX3DType: String;
begin
  Result := 'Background';
end;

procedure TBackgroundNode.CreateNode;
begin
  inherited;

  FFdBackUrl := TMFString.Create(Self, True, 'backUrl', []);
   FdBackUrl.ChangeAlways := chEverything;
  AddField(FFdBackUrl);

  FFdBottomUrl := TMFString.Create(Self, True, 'bottomUrl', []);
   FdBottomUrl.ChangeAlways := chEverything;
  AddField(FFdBottomUrl);

  FFdFrontUrl := TMFString.Create(Self, True, 'frontUrl', []);
   FdFrontUrl.ChangeAlways := chEverything;
  AddField(FFdFrontUrl);

  FFdLeftUrl := TMFString.Create(Self, True, 'leftUrl', []);
   FdLeftUrl.ChangeAlways := chEverything;
  AddField(FFdLeftUrl);

  FFdRightUrl := TMFString.Create(Self, True, 'rightUrl', []);
   FdRightUrl.ChangeAlways := chEverything;
  AddField(FFdRightUrl);

  FFdTopUrl := TMFString.Create(Self, True, 'topUrl', []);
   FdTopUrl.ChangeAlways := chEverything;
  AddField(FFdTopUrl);
end;

{$endif read_implementation}
