{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetControlPoint: TAbstractCoordinateNode;
    procedure SetControlPoint(const Value: TAbstractCoordinateNode);
    function GetUTessellation: Integer;
    procedure SetUTessellation(const Value: Integer);
    function GetVTessellation: Integer;
    procedure SetVTessellation(const Value: Integer);
    function GetUClosed: Boolean;
    procedure SetUClosed(const Value: Boolean);
    function GetUDimension: Integer;
    procedure SetUDimension(const Value: Integer);
    function GetUOrder: Integer;
    procedure SetUOrder(const Value: Integer);
    function GetVClosed: Boolean;
    procedure SetVClosed(const Value: Boolean);
    function GetVDimension: Integer;
    procedure SetVDimension(const Value: Integer);
    function GetVOrder: Integer;
    procedure SetVOrder(const Value: Integer);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdControlPoint: TSFNode;
    { Internal wrapper for property @link(ControlPoint). This wrapper API may change, we advise to access simpler @link(ControlPoint) instead. }
    public property FdControlPoint: TSFNode read FFdControlPoint;
    {  }
    property ControlPoint: TAbstractCoordinateNode read GetControlPoint write SetControlPoint;

    strict private FFdTexCoord: TSFNode;
    { Internal wrapper for property @link(TexCoord). This wrapper API may change, we advise to access simpler @link(TexCoord) instead. }
    public property FdTexCoord: TSFNode read FFdTexCoord;

    strict private FFdUTessellation: TSFInt32;
    { Internal wrapper for property @link(UTessellation). This wrapper API may change, we advise to access simpler @link(UTessellation) instead. }
    public property FdUTessellation: TSFInt32 read FFdUTessellation;
    {  }
    property UTessellation: Integer read GetUTessellation write SetUTessellation;

    strict private FFdVTessellation: TSFInt32;
    { Internal wrapper for property @link(VTessellation). This wrapper API may change, we advise to access simpler @link(VTessellation) instead. }
    public property FdVTessellation: TSFInt32 read FFdVTessellation;
    {  }
    property VTessellation: Integer read GetVTessellation write SetVTessellation;

    strict private FFdWeight: TMFDouble;
    { Internal wrapper for property @link(Weight). This wrapper API may change, we advise to access simpler @link(Weight) instead. }
    public property FdWeight: TMFDouble read FFdWeight;
    {  }
    procedure SetWeight(const Value: array of Double); overload;
    {  }
    procedure SetWeight(const Value: TDoubleList); overload;

    strict private FFdSolid: TSFBool;
    { Internal wrapper for property @link(Solid). This wrapper API may change, we advise to access simpler @link(Solid) instead. }
    public property FdSolid: TSFBool read FFdSolid;

    strict private FFdUClosed: TSFBool;
    { Internal wrapper for property @link(UClosed). This wrapper API may change, we advise to access simpler @link(UClosed) instead. }
    public property FdUClosed: TSFBool read FFdUClosed;
    {  }
    property UClosed: Boolean read GetUClosed write SetUClosed;

    strict private FFdUDimension: TSFInt32;
    { Internal wrapper for property @link(UDimension). This wrapper API may change, we advise to access simpler @link(UDimension) instead. }
    public property FdUDimension: TSFInt32 read FFdUDimension;
    {  }
    property UDimension: Integer read GetUDimension write SetUDimension;

    strict private FFdUKnot: TMFDouble;
    { Internal wrapper for property @link(UKnot). This wrapper API may change, we advise to access simpler @link(UKnot) instead. }
    public property FdUKnot: TMFDouble read FFdUKnot;
    {  }
    procedure SetUKnot(const Value: array of Double); overload;
    {  }
    procedure SetUKnot(const Value: TDoubleList); overload;

    strict private FFdUOrder: TSFInt32;
    { Internal wrapper for property @link(UOrder). This wrapper API may change, we advise to access simpler @link(UOrder) instead. }
    public property FdUOrder: TSFInt32 read FFdUOrder;
    {  }
    property UOrder: Integer read GetUOrder write SetUOrder;

    strict private FFdVClosed: TSFBool;
    { Internal wrapper for property @link(VClosed). This wrapper API may change, we advise to access simpler @link(VClosed) instead. }
    public property FdVClosed: TSFBool read FFdVClosed;
    {  }
    property VClosed: Boolean read GetVClosed write SetVClosed;

    strict private FFdVDimension: TSFInt32;
    { Internal wrapper for property @link(VDimension). This wrapper API may change, we advise to access simpler @link(VDimension) instead. }
    public property FdVDimension: TSFInt32 read FFdVDimension;
    {  }
    property VDimension: Integer read GetVDimension write SetVDimension;

    strict private FFdVKnot: TMFDouble;
    { Internal wrapper for property @link(VKnot). This wrapper API may change, we advise to access simpler @link(VKnot) instead. }
    public property FdVKnot: TMFDouble read FFdVKnot;
    {  }
    procedure SetVKnot(const Value: array of Double); overload;
    {  }
    procedure SetVKnot(const Value: TDoubleList); overload;

    strict private FFdVOrder: TSFInt32;
    { Internal wrapper for property @link(VOrder). This wrapper API may change, we advise to access simpler @link(VOrder) instead. }
    public property FdVOrder: TSFInt32 read FFdVOrder;
    {  }
    property VOrder: Integer read GetVOrder write SetVOrder;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractNurbsSurfaceGeometryNode ----------------------------------------------- }

function TAbstractNurbsSurfaceGeometryNode.GetControlPoint: TAbstractCoordinateNode;
begin
  if FdControlPoint.Value is TAbstractCoordinateNode then
    Result := TAbstractCoordinateNode(FdControlPoint.Value)
  else
    Result := nil;
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetControlPoint(const Value: TAbstractCoordinateNode);
begin
  FdControlPoint.Send(Value);
end;

function TAbstractNurbsSurfaceGeometryNode.GetUTessellation: Integer;
begin
  Result := FdUTessellation.Value;
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetUTessellation(const Value: Integer);
begin
  FdUTessellation.Send(Value);
end;

function TAbstractNurbsSurfaceGeometryNode.GetVTessellation: Integer;
begin
  Result := FdVTessellation.Value;
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetVTessellation(const Value: Integer);
begin
  FdVTessellation.Send(Value);
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetWeight(const Value: array of Double);
begin
  FdWeight.Send(Value);
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetWeight(const Value: TDoubleList);
begin
  FdWeight.Send(Value);
end;

function TAbstractNurbsSurfaceGeometryNode.GetUClosed: Boolean;
begin
  Result := FdUClosed.Value;
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetUClosed(const Value: Boolean);
begin
  FdUClosed.Send(Value);
end;

function TAbstractNurbsSurfaceGeometryNode.GetUDimension: Integer;
begin
  Result := FdUDimension.Value;
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetUDimension(const Value: Integer);
begin
  FdUDimension.Send(Value);
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetUKnot(const Value: array of Double);
begin
  FdUKnot.Send(Value);
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetUKnot(const Value: TDoubleList);
begin
  FdUKnot.Send(Value);
end;

function TAbstractNurbsSurfaceGeometryNode.GetUOrder: Integer;
begin
  Result := FdUOrder.Value;
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetUOrder(const Value: Integer);
begin
  FdUOrder.Send(Value);
end;

function TAbstractNurbsSurfaceGeometryNode.GetVClosed: Boolean;
begin
  Result := FdVClosed.Value;
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetVClosed(const Value: Boolean);
begin
  FdVClosed.Send(Value);
end;

function TAbstractNurbsSurfaceGeometryNode.GetVDimension: Integer;
begin
  Result := FdVDimension.Value;
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetVDimension(const Value: Integer);
begin
  FdVDimension.Send(Value);
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetVKnot(const Value: array of Double);
begin
  FdVKnot.Send(Value);
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetVKnot(const Value: TDoubleList);
begin
  FdVKnot.Send(Value);
end;

function TAbstractNurbsSurfaceGeometryNode.GetVOrder: Integer;
begin
  Result := FdVOrder.Value;
end;

procedure TAbstractNurbsSurfaceGeometryNode.SetVOrder(const Value: Integer);
begin
  FdVOrder.Send(Value);
end;

class function TAbstractNurbsSurfaceGeometryNode.ClassX3DType: String;
begin
  Result := 'X3DNurbsSurfaceGeometryNode';
end;

procedure TAbstractNurbsSurfaceGeometryNode.CreateNode;
begin
  inherited;

  FFdControlPoint := TSFNode.Create(Self, True, 'controlPoint', [TAbstractCoordinateNode]);
   FdControlPoint.ChangeAlways := chGeometry;
  AddField(FFdControlPoint);

  FFdTexCoord := TSFNode.Create(Self, True, 'texCoord', [TAbstractTextureCoordinateNode, TNurbsTextureCoordinateNode]);
   FdTexCoord.ChangeAlways := chGeometry;
  AddField(FFdTexCoord);

  FFdUTessellation := TSFInt32.Create(Self, True, 'uTessellation', 0);
   FdUTessellation.ChangeAlways := chGeometry;
  AddField(FFdUTessellation);

  FFdVTessellation := TSFInt32.Create(Self, True, 'vTessellation', 0);
   FdVTessellation.ChangeAlways := chGeometry;
  AddField(FFdVTessellation);

  FFdWeight := TMFDouble.Create(Self, True, 'weight', []);
   FdWeight.ChangeAlways := chGeometry;
  AddField(FFdWeight);

  FFdSolid := TSFBool.Create(Self, False, 'solid', true);
   FdSolid.ChangeAlways := chGeometry;
  AddField(FFdSolid);

  FFdUClosed := TSFBool.Create(Self, False, 'uClosed', false);
   FdUClosed.ChangeAlways := chGeometry;
  AddField(FFdUClosed);

  FFdUDimension := TSFInt32.Create(Self, False, 'uDimension', 0);
   FdUDimension.ChangeAlways := chGeometry;
   FdUDimension.MustBeNonnegative := true;
  AddField(FFdUDimension);

  FFdUKnot := TMFDouble.Create(Self, False, 'uKnot', []);
   FdUKnot.ChangeAlways := chGeometry;
  AddField(FFdUKnot);

  FFdUOrder := TSFInt32.Create(Self, False, 'uOrder', 3);
   FdUOrder.ChangeAlways := chGeometry;
  AddField(FFdUOrder);

  FFdVClosed := TSFBool.Create(Self, False, 'vClosed', false);
   FdVClosed.ChangeAlways := chGeometry;
  AddField(FFdVClosed);

  FFdVDimension := TSFInt32.Create(Self, False, 'vDimension', 0);
   FdVDimension.ChangeAlways := chGeometry;
   FdVDimension.MustBeNonnegative := true;
  AddField(FFdVDimension);

  FFdVKnot := TMFDouble.Create(Self, False, 'vKnot', []);
   FdVKnot.ChangeAlways := chGeometry;
  AddField(FFdVKnot);

  FFdVOrder := TSFInt32.Create(Self, False, 'vOrder', 3);
   FdVOrder.ChangeAlways := chGeometry;
  AddField(FFdVOrder);
end;

{$endif read_implementation}
