{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetNameField: String;
    procedure SetNameField(const Value: String);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdName: TSFString;
    { Internal wrapper for property @link(NameField). This wrapper API may change, we advise to access simpler @link(NameField) instead. }
    public property FdName: TSFString read FFdName;
    {  }
    property NameField: String read GetNameField write SetNameField;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractProductStructureChildNode ----------------------------------------------- }

function TAbstractProductStructureChildNode.GetNameField: String;
begin
  Result := FdName.Value;
end;

procedure TAbstractProductStructureChildNode.SetNameField(const Value: String);
begin
  FdName.Send(Value);
end;

class function TAbstractProductStructureChildNode.ClassX3DType: String;
begin
  Result := 'X3DProductStructureChildNode';
end;

procedure TAbstractProductStructureChildNode.CreateNode;
begin
  inherited;

  FFdName := TSFString.Create(Self, True, 'name', '');
   FdName.ChangeAlways := chNone;
  AddField(FFdName);

  DefaultContainerField := 'children';
end;

{$endif read_implementation}
