{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetShadows: Boolean;
    procedure SetShadows(const Value: Boolean);
    function GetShadowVolumesMain: Boolean;
    procedure SetShadowVolumesMain(const Value: Boolean);
    function GetShowProxyGeometry: Boolean;
    procedure SetShowProxyGeometry(const Value: Boolean);
    function GetProjectionNear: Single;
    procedure SetProjectionNear(const Value: Single);
    function GetProjectionFar: Single;
    procedure SetProjectionFar(const Value: Single);
    function GetUp: TVector3;
    procedure SetUp(const Value: TVector3);
    function GetDefaultShadowMap: TGeneratedShadowMapNode;
    procedure SetDefaultShadowMap(const Value: TGeneratedShadowMapNode);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdShadows: TSFBool;
    { Internal wrapper for property @link(Shadows). This wrapper API may change, we advise to access simpler @link(Shadows) instead. }
    public property FdShadows: TSFBool read FFdShadows;
    {  }
    property Shadows: Boolean read GetShadows write SetShadows;

    strict private FFdShadowVolumesMain: TSFBool;
    { Internal wrapper for property @link(ShadowVolumesMain). This wrapper API may change, we advise to access simpler @link(ShadowVolumesMain) instead. }
    public property FdShadowVolumesMain: TSFBool read FFdShadowVolumesMain;
    { Does this light determine shadows (when using shadow volumes). Ignored if not @link(ShadowVolumes). }
    property ShadowVolumesMain: Boolean read GetShadowVolumesMain write SetShadowVolumesMain;

    strict private FFdShowProxyGeometry: TSFBool;
    { Internal wrapper for property @link(ShowProxyGeometry). This wrapper API may change, we advise to access simpler @link(ShowProxyGeometry) instead. }
    public property FdShowProxyGeometry: TSFBool read FFdShowProxyGeometry;
    { InstantReality extension, see [http://instant-reality.com/documentation/nodetype/Light/]. }
    property ShowProxyGeometry: Boolean read GetShowProxyGeometry write SetShowProxyGeometry;

    strict private FFdProjectionNear: TSFFloat;
    { Internal wrapper for property @link(ProjectionNear). This wrapper API may change, we advise to access simpler @link(ProjectionNear) instead. }
    public property FdProjectionNear: TSFFloat read FFdProjectionNear;
    { Projection near, for shadow maps. See https://castle-engine.io/x3d_extensions_shadow_maps.php }
    property ProjectionNear: Single read GetProjectionNear write SetProjectionNear;

    strict private FFdProjectionFar: TSFFloat;
    { Internal wrapper for property @link(ProjectionFar). This wrapper API may change, we advise to access simpler @link(ProjectionFar) instead. }
    public property FdProjectionFar: TSFFloat read FFdProjectionFar;
    { Projection far, for shadow maps. See https://castle-engine.io/x3d_extensions_shadow_maps.php }
    property ProjectionFar: Single read GetProjectionFar write SetProjectionFar;

    strict private FFdUp: TSFVec3f;
    { Internal wrapper for property @link(Up). This wrapper API may change, we advise to access simpler @link(Up) instead. }
    public property FdUp: TSFVec3f read FFdUp;
    { View up vector, for shadow maps. See https://castle-engine.io/x3d_extensions_shadow_maps.php }
    property Up: TVector3 read GetUp write SetUp;

    strict private FFdDefaultShadowMap: TSFNode;
    { Internal wrapper for property @link(DefaultShadowMap). This wrapper API may change, we advise to access simpler @link(DefaultShadowMap) instead. }
    public property FdDefaultShadowMap: TSFNode read FFdDefaultShadowMap;
    { Shadow map used by this light source. See https://castle-engine.io/x3d_extensions_shadow_maps.php }
    property DefaultShadowMap: TGeneratedShadowMapNode read GetDefaultShadowMap write SetDefaultShadowMap;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractPunctualLightNode ----------------------------------------------- }

function TAbstractPunctualLightNode.GetShadows: Boolean;
begin
  Result := FdShadows.Value;
end;

procedure TAbstractPunctualLightNode.SetShadows(const Value: Boolean);
begin
  FdShadows.Send(Value);
end;

function TAbstractPunctualLightNode.GetShadowVolumesMain: Boolean;
begin
  Result := FdShadowVolumesMain.Value;
end;

procedure TAbstractPunctualLightNode.SetShadowVolumesMain(const Value: Boolean);
begin
  FdShadowVolumesMain.Send(Value);
end;

function TAbstractPunctualLightNode.GetShowProxyGeometry: Boolean;
begin
  Result := FdShowProxyGeometry.Value;
end;

procedure TAbstractPunctualLightNode.SetShowProxyGeometry(const Value: Boolean);
begin
  FdShowProxyGeometry.Send(Value);
end;

function TAbstractPunctualLightNode.GetProjectionNear: Single;
begin
  Result := FdProjectionNear.Value;
end;

procedure TAbstractPunctualLightNode.SetProjectionNear(const Value: Single);
begin
  FdProjectionNear.Send(Value);
end;

function TAbstractPunctualLightNode.GetProjectionFar: Single;
begin
  Result := FdProjectionFar.Value;
end;

procedure TAbstractPunctualLightNode.SetProjectionFar(const Value: Single);
begin
  FdProjectionFar.Send(Value);
end;

function TAbstractPunctualLightNode.GetUp: TVector3;
begin
  Result := FdUp.Value;
end;

procedure TAbstractPunctualLightNode.SetUp(const Value: TVector3);
begin
  FdUp.Send(Value);
end;

function TAbstractPunctualLightNode.GetDefaultShadowMap: TGeneratedShadowMapNode;
begin
  if FdDefaultShadowMap.Value is TGeneratedShadowMapNode then
    Result := TGeneratedShadowMapNode(FdDefaultShadowMap.Value)
  else
    Result := nil;
end;

procedure TAbstractPunctualLightNode.SetDefaultShadowMap(const Value: TGeneratedShadowMapNode);
begin
  FdDefaultShadowMap.Send(Value);
end;

class function TAbstractPunctualLightNode.ClassX3DType: String;
begin
  Result := 'X3DPunctualLightNode';
end;

procedure TAbstractPunctualLightNode.CreateNode;
begin
  inherited;

  FFdShadows := TSFBool.Create(Self, False, 'shadows', false);
   FdShadows.ChangeAlways := chShadowMaps;
  AddField(FFdShadows);

  FFdShadowVolumesMain := TSFBool.Create(Self, True, 'shadowVolumesMain', false);
   FdShadowVolumesMain.ChangeAlways := chLightForShadowVolumes;
  AddField(FFdShadowVolumesMain);

  FFdShowProxyGeometry := TSFBool.Create(Self, True, 'showProxyGeometry', false);
   FdShowProxyGeometry.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdShowProxyGeometry);

  FFdProjectionNear := TSFFloat.Create(Self, True, 'projectionNear', 0);
   FdProjectionNear.ChangeAlways := chVisibleGeometry;
  AddField(FFdProjectionNear);

  FFdProjectionFar := TSFFloat.Create(Self, True, 'projectionFar', 0);
   FdProjectionFar.ChangeAlways := chVisibleGeometry;
  AddField(FFdProjectionFar);

  FFdUp := TSFVec3f.Create(Self, True, 'up', Vector3(0, 0, 0));
   FdUp.ChangeAlways := chVisibleGeometry;
  AddField(FFdUp);

  FFdDefaultShadowMap := TSFNode.Create(Self, False, 'defaultShadowMap', [TGeneratedShadowMapNode]);
   FdDefaultShadowMap.ChangeAlways := chEverything;
  AddField(FFdDefaultShadowMap);
end;

{$endif read_implementation}
