{ -*- buffer-read-only: t -*-

  Copyright 2018-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated wrapper to make vectors/colors persistent.

  Do not edit this file manually!
  Instead
  - edit tools/internal/generate-persistent-vectors/persistent_vectors_input.txt
  - and run generate-persistent-vectors in that directory.
}

{$ifdef read_interface_class}
strict private
  FDirectionPersistent: TCastleVector3Persistent;
  function GetDirectionForPersistent: TVector3;
  procedure SetDirectionForPersistent(const AValue: TVector3);
published
  { @link(Direction) that can be visually edited in
    Castle Game Engine Editor, Lazarus and Delphi.
    Normal user code does not need to deal with this,
    instead read or write @link(Direction) directly.

    @seealso Direction }
  property DirectionPersistent: TCastleVector3Persistent read FDirectionPersistent ;
{$endif read_interface_class}

{$ifdef read_implementation_methods}
function TCastleStickToSurface.GetDirectionForPersistent: TVector3;
begin
  Result := Direction;
end;

procedure TCastleStickToSurface.SetDirectionForPersistent(const AValue: TVector3);
begin
  Direction := AValue;
end;
{$endif read_implementation_methods}

{$ifdef read_implementation_constructor}
  FDirectionPersistent := TCastleVector3Persistent.Create;
  FDirectionPersistent.InternalGetValue := {$ifdef FPC}@{$endif}GetDirectionForPersistent;
  FDirectionPersistent.InternalSetValue := {$ifdef FPC}@{$endif}SetDirectionForPersistent;
  FDirectionPersistent.InternalDefaultValue := Direction; // current value is default
{$endif read_implementation_constructor}

{$ifdef read_implementation_destructor}
  FreeAndNil(FDirectionPersistent);
{$endif read_implementation_destructor}

