package org.eclipse.webdav.dom;

/*
 * (c) Copyright IBM Corp. 2000, 2001.
 * All Rights Reserved.
 */

import org.eclipse.webdav.Policy;
import org.w3c.dom.Element;

/**
 * <b>Note:</b> This class/interface is part of an interim API that is still under 
 * development and expected to change significantly before reaching stability. 
 * It is being made available at this early stage to solicit feedback from pioneering 
 * adopters on the understanding that any code that uses this API will almost 
 * certainly be broken (repeatedly) as the API evolves.
 */
public class Label extends ElementEditor {

	// An ordered collection of the element names of the label
	// element's possible children.
	protected static final String[] childNames = 
		new String[] {"add", "set", "remove"}; 
public Label(Element root) throws MalformedElementException {

	super(root, "label");
}
public String getLabelName() throws MalformedElementException {

	Element child = getFirstChild(root, childNames);
	ensureNotNull(Policy.bind("ensure.missingElmt"), child);

	String labelName = getChildText(child, "label-name", true);
	ensureNotNull(Policy.bind("ensure.missingLabel"), labelName);

	return labelName;
}
public boolean isAdd() {

	Element child = getFirstChild(root, childNames);

	return getNSLocalName(child).equals("add");
}
public boolean isRemove() {

	Element child = getFirstChild(root, childNames);

	return getNSLocalName(child).equals("remove");
}
public boolean isSet() {

	Element child = getFirstChild(root, childNames);

	return getNSLocalName(child).equals("set");
}
}
