# Final shaders

It is possible to specify a final full screen shader with the option `--final-shader`.
It is executed as the last shader in the rendering pipeline.

The shader code can be passed directly as a single code line.
It's possible to pass the content of a shader file using the following command:

```sh
f3d model.obj --final-shader "$(cat final.glsl)"
```

Note that the command above works on Linux and bash, and should be adapted depending on the operating system and the shell/terminal used.

## Requirements

It is required to implement the function `vec4 pixel(vec2 uv)`.
The value `uv` is ranging from 0 to 1 in both directions. `(0,0)` is the bottom left corner, and `(1,1)` is the upper right corner.
The first component is the horizontal direction.

## Uniforms

It is possible to access these uniforms:

- `source` (type: `sampler2d`): texture of the image generated by rendering pipeline.
- `resolution` (type: `ivec2`): resolution of the texture `source`.

## Examples

Here are three shader examples to illustrate how an implementation looks like.

### Negative

```glsl
vec4 pixel(vec2 uv)
{
    vec3 value = texture(source, uv).rgb;
    return vec4(vec3(1.0) - value, 1.0);
}
```

### Vignette

```glsl
vec4 pixel(vec2 uv)
{
    float l = clamp(1.0 - 2.0 * length(uv - 0.5), 0.0, 1.0);
    return vec4(l*texture(source, uv).rgb, 1.0);
}
```

### Box blur

```glsl
vec4 pixel(vec2 uv)
{
    const float radius = 0.03;
    const int samples = 20;
    const float step = radius / float(samples);

    vec3 sum = vec3(0);

	for (int i = -samples; i <= samples; i++)
    {
		for (int j = -samples; j <= samples; j++)
        {
			sum += texture(source, uv + vec2(i, j) * step).rgb;
		}
    }

    float d = 1.0 + 2.0 * float(samples);
    sum /= d * d;

	return vec4(sum, 1.0);
}
```
