/* Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/ */
/* eslint-disable max-len */

"use strict";

/*
 * THIS FILE IS AUTOGENERATED. DO NOT MODIFY BY HAND. RUN TESTS IN FIXTURES/ TO UPDATE.
 */

const {
  parsePacketsWithFronts,
} = require("chrome://mochitests/content/browser/devtools/client/webconsole/test/browser/stub-generator-helpers");
const { prepareMessage } = require("devtools/client/webconsole/utils/messages");
const {
  ConsoleMessage,
  NetworkEventMessage,
} = require("devtools/client/webconsole/types");

const rawPackets = new Map();
rawPackets.set(`GET request`, {
  "resourceType": "network-event",
  "timeStamp": 1572867483805,
  "actor": "server0.conn0.netEvent4",
  "startedDateTime": "2019-11-04T11:06:34.542Z",
  "method": "GET",
  "url": "http://example.com/inexistent.html",
  "isXHR": false,
  "cause": {
    "type": "img",
    "loadingDocumentUri": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
    "stacktraceAvailable": true,
    "lastFrame": {
      "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
      "lineNumber": 3,
      "columnNumber": 1,
      "functionName": "triggerPacket",
      "asyncCause": null
    }
  },
  "httpVersion": "HTTP/1.1",
  "status": "404",
  "statusText": "Not Found",
  "remoteAddress": "127.0.0.1",
  "remotePort": 8888,
  "mimeType": "text/html; charset=utf-8",
  "waitingTime": 1,
  "contentSize": 418,
  "transferredSize": 578,
  "timings": {},
  "private": false,
  "isThirdPartyTrackingResource": false,
  "referrerPolicy": "strict-origin-when-cross-origin",
  "blockedReason": 0,
  "totalTime": 2,
  "securityState": "insecure",
  "isRacing": false
});

rawPackets.set(`GET request update`, {
  "resourceType": "network-event",
  "timeStamp": 1572867483805,
  "actor": "server0.conn0.netEvent5",
  "startedDateTime": "2020-07-07T14:41:14.572Z",
  "method": "GET",
  "url": "http://example.com/inexistent.html",
  "isXHR": false,
  "cause": {
    "type": "img",
    "loadingDocumentUri": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
    "stacktraceAvailable": true,
    "lastFrame": {
      "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
      "lineNumber": 3,
      "columnNumber": 1,
      "functionName": "triggerPacket",
      "asyncCause": null
    }
  },
  "httpVersion": "HTTP/1.1",
  "status": "404",
  "statusText": "Not Found",
  "remoteAddress": "127.0.0.1",
  "remotePort": 8888,
  "mimeType": "text/html; charset=utf-8",
  "waitingTime": 1,
  "contentSize": 418,
  "transferredSize": 578,
  "timings": {},
  "private": false,
  "isThirdPartyTrackingResource": false,
  "referrerPolicy": "strict-origin-when-cross-origin",
  "blockedReason": 0,
  "totalTime": 3,
  "securityState": "insecure",
  "isRacing": false
});

rawPackets.set(`XHR GET request`, {
  "resourceType": "network-event",
  "timeStamp": 1572867483805,
  "actor": "server0.conn0.netEvent21",
  "startedDateTime": "2020-07-07T14:41:14.612Z",
  "method": "GET",
  "url": "http://example.com/inexistent.html",
  "isXHR": true,
  "cause": {
    "type": "xhr",
    "loadingDocumentUri": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
    "stacktraceAvailable": true,
    "lastFrame": {
      "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
      "lineNumber": 4,
      "columnNumber": 5,
      "functionName": "triggerPacket",
      "asyncCause": null
    }
  },
  "httpVersion": "HTTP/1.1",
  "status": "404",
  "statusText": "Not Found",
  "remoteAddress": "127.0.0.1",
  "remotePort": 8888,
  "mimeType": "text/html; charset=utf-8",
  "waitingTime": 1,
  "contentSize": 418,
  "transferredSize": 578,
  "timings": {},
  "private": false,
  "isThirdPartyTrackingResource": false,
  "referrerPolicy": "strict-origin-when-cross-origin",
  "blockedReason": 0,
  "totalTime": 1,
  "securityState": "insecure",
  "isRacing": false
});

rawPackets.set(`XHR GET request update`, {
  "resourceType": "network-event",
  "timeStamp": 1572867483805,
  "actor": "server0.conn0.netEvent20",
  "method": "GET",
  "url": "http://example.com/inexistent.html",
  "isXHR": true,
  "cause": {
    "type": "xhr",
    "loadingDocumentUri": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
    "stacktraceAvailable": true,
    "lastFrame": {
      "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
      "lineNumber": 4,
      "columnNumber": 5,
      "functionName": "triggerPacket",
      "asyncCause": null
    }
  },
  "httpVersion": "HTTP/1.1",
  "status": "404",
  "statusText": "Not Found",
  "remoteAddress": "127.0.0.1",
  "remotePort": 8888,
  "mimeType": "text/html; charset=utf-8",
  "waitingTime": 1,
  "contentSize": 418,
  "transferredSize": 578,
  "timings": {},
  "private": false,
  "isThirdPartyTrackingResource": false,
  "referrerPolicy": "strict-origin-when-cross-origin",
  "blockedReason": 0,
  "totalTime": 1,
  "securityState": "insecure",
  "isRacing": false
});

rawPackets.set(`XHR POST request`, {
  "resourceType": "network-event",
  "timeStamp": 1572867483805,
  "actor": "server0.conn0.netEvent36",
  "startedDateTime": "2019-11-04T11:06:35.007Z",
  "method": "POST",
  "url": "http://example.com/inexistent.html",
  "isXHR": true,
  "cause": {
    "type": "xhr",
    "loadingDocumentUri": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
    "stacktraceAvailable": true,
    "lastFrame": {
      "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
      "lineNumber": 4,
      "columnNumber": 5,
      "functionName": "triggerPacket",
      "asyncCause": null
    }
  },
  "httpVersion": "HTTP/1.1",
  "status": "404",
  "statusText": "Not Found",
  "remoteAddress": "127.0.0.1",
  "remotePort": 8888,
  "mimeType": "text/html; charset=utf-8",
  "waitingTime": 1,
  "contentSize": 418,
  "transferredSize": 578,
  "timings": {},
  "private": false,
  "isThirdPartyTrackingResource": false,
  "referrerPolicy": "strict-origin-when-cross-origin",
  "blockedReason": 0,
  "totalTime": 1,
  "securityState": "insecure",
  "isRacing": false
});

rawPackets.set(`XHR POST request update`, {
  "resourceType": "network-event",
  "timeStamp": 1572867483805,
  "actor": "server0.conn0.netEvent36",
  "method": "POST",
  "url": "http://example.com/inexistent.html",
  "isXHR": true,
  "cause": {
    "type": "xhr",
    "loadingDocumentUri": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
    "stacktraceAvailable": true,
    "lastFrame": {
      "filename": "http://example.com/browser/devtools/client/webconsole/test/browser/stub-generators/test-network-event.html",
      "lineNumber": 4,
      "columnNumber": 5,
      "functionName": "triggerPacket",
      "asyncCause": null
    }
  },
  "httpVersion": "HTTP/1.1",
  "status": "404",
  "statusText": "Not Found",
  "remoteAddress": "127.0.0.1",
  "remotePort": 8888,
  "mimeType": "text/html; charset=utf-8",
  "waitingTime": 1,
  "contentSize": 418,
  "transferredSize": 578,
  "timings": {},
  "private": false,
  "isThirdPartyTrackingResource": false,
  "referrerPolicy": "strict-origin-when-cross-origin",
  "blockedReason": 0,
  "totalTime": 2,
  "securityState": "insecure",
  "isRacing": false
});


const stubPackets = parsePacketsWithFronts(rawPackets);

const stubPreparedMessages = new Map();
for (const [key, packet] of Array.from(stubPackets.entries())) {
  const transformedPacket = prepareMessage(packet, {
    getNextId: () => "1",
  });
  const message = NetworkEventMessage(transformedPacket);
  stubPreparedMessages.set(key, message);
}

module.exports = {
  rawPackets,
  stubPreparedMessages,
  stubPackets,
};
