--  Environment definition for synthesis.
--  Copyright (C) 2023 Tristan Gingold
--
--  GHDL is free software; you can redistribute it and/or modify it under
--  the terms of the GNU General Public License as published by the Free
--  Software Foundation; either version 2, or (at your option) any later
--  version.
--
--  GHDL is distributed in the hope that it will be useful, but WITHOUT ANY
--  WARRANTY; without even the implied warranty of MERCHANTABILITY or
--  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
--  for more details.
--
--  You should have received a copy of the GNU General Public License
--  along with GHDL; see the file COPYING.  If not, see:
--  <http://www.gnu.org/licenses>.

with Types; use Types;

with Netlists; use Netlists;
with Netlists.Builders;

with Verilog.Nodes; use Verilog.Nodes;

with Elab.Memtype; use Elab.Memtype;
with Synth.Environment;
with Synth.Environment.Debug;

package Synth.Verilog_Environment is

   type Memtyp is record
      Mem : Memory_Ptr;
      Typ : Node;
   end record;

   function Get_Bitwidth (Val : Memtyp) return Uns32;

   function Is_Equal (L, R : Memtyp) return Boolean;

   function Memtyp_To_Net (Ctxt : Builders.Context_Acc; Val : Memtyp)
                          return Net;

   function Partial_Memtyp_To_Net
     (Ctxt : Builders.Context_Acc; Val : Memtyp; Off : Uns32; Wd : Uns32)
     return Net;

   procedure Warning_No_Assignment
     (Decl : Node; First_Off : Uns32; Last_Off : Uns32);

   procedure Error_Multiple_Assignments
     (Decl : Node; First_Off : Uns32; Last_Off : Uns32);

   package Env is new Synth.Environment
     (Decl_Type => Node,
      Static_Type => Memtyp,
      Get_Width => Get_Bitwidth,
      Is_Equal => Is_Equal,
      Static_To_Net => Memtyp_To_Net,
      Partial_Static_To_Net => Partial_Memtyp_To_Net,
      Warning_No_Assignment => Warning_No_Assignment,
      Error_Multiple_Assignments => Error_Multiple_Assignments);

   procedure Dump_Memtyp (Val : Memtyp) is null;

   package Debug is new Env.Debug
     (Dump_Static => Dump_Memtyp);
end Synth.Verilog_Environment;
