// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

type Label struct {
	Common
	Name        string `json:"name"`
	Color       string `json:"color"`
	Description string `json:"description"`
}

func (o Label) Equal(other Label) bool {
	return o.Common.Equal(other.Common) &&
		o.Name == other.Name &&
		o.Color == other.Color &&
		o.Description == other.Description
}

func (o *Label) Clone() Interface {
	clone := &Label{}
	*clone = *o
	return clone
}
