// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

import (
	"time"
)

type ReviewComment struct {
	Common
	Content    string     `json:"content"`
	TreePath   string     `json:"tree_path"`
	DiffHunk   string     `json:"diff_hunk"`
	Line       int        `json:"line"`
	LinesCount int        `json:"lines_count"`
	CommitID   string     `json:"commit_id"`
	PosterID   *Reference `json:"poster_id"`
	CreatedAt  time.Time  `json:"created_at"`
	UpdatedAt  time.Time  `json:"updated_at"`
}

func (o ReviewComment) Equal(other ReviewComment) bool {
	return o.Common.Equal(other.Common) &&
		o.Content == other.Content &&
		o.TreePath == other.TreePath &&
		o.Line == other.Line &&
		o.LinesCount == other.LinesCount &&
		o.CommitID == other.CommitID &&
		nilOrEqual(o.PosterID, other.PosterID)
}

func (o *ReviewComment) GetReferences() References {
	references := o.Common.GetReferences()
	if !o.PosterID.IsNil() {
		references = append(references, o.PosterID)
	}
	return references
}

func (o *ReviewComment) Clone() Interface {
	clone := &ReviewComment{}
	*clone = *o
	return clone
}
