Purpose
-------

Execute grml-debootstrap inside a docker container.
This is useful e.g. for developing new features, reproducing problems and writing tests in a clean and reproducible environment.

Files
-----

The Dockerfile is controlling the [automated builds at the Docker Hub Registry](https://registry.hub.docker.com/u/mika/grml-debootstrap/).

The `*.bats` files are test scripts, used for verifying the Debian installations as generated by the `test*.sh` scripts.

Usage instructions
------------------

Make sure the docker image generated by the Dockerfile is available on your system:

````
% docker pull mika/grml-debootstrap
````

Start a container instance and switch into it via e.g.:

````
% docker run -it --privileged=true mika/grml-debootstrap
````

*NOTE:* `--privileged=true` is required for usage with loop devices and mounting proc, sysfs etc inside the container

*TIP:* add the `--rm` option to the command line to automatically remove the container when it exits

Use grml-debootstrap inside the container, e.g.:

* Install Debian inside a VM image:

````
# grml-debootstrap --vmfile --target /srv/debian.img --password grml --hostname docker [--force]
````

* Install Debian system in a directory:

````
# grml-debootstrap --target /srv/debian --password grml --hostname docker [--force]
````

*TIP:* to speed up the build prepend `eatmydata` in the grml-debootstrap command line

*TIP:* if you want to have access to the generated Debian systems after exiting the container make sure to share your working directory as `/srv` via adding `-v $PWD:/srv/` to your `docker run` command line

Usage of test scripts
---------------------

This directory provides example scripts (`test*.sh`) and tests (`*.bats`) for building and verifying Debian installations, generated via grml-debootstrap.
To use them make sure this docker directory is available inside the docker container at /srv:

````
% docker run -it --privileged=true -v $PWD:/srv/ --rm mika/grml-debootstrap
````

Then you can simply invoke `/srv/test_dirinstall.sh` or `/srv/test_vminstall.sh`, which will install Debian systems at `/srv/debian` or `/srv/debian.img` respectively and run some tests on the resulting systems.
