; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -sroa -S | FileCheck %s
; RUN: opt < %s -passes=sroa -S | FileCheck %s

; This test checks that SROA runs mem2reg on scalable vectors.

define <vscale x 16 x i1> @alloca_nxv16i1(<vscale x 16 x i1> %pg) {
; CHECK-LABEL: @alloca_nxv16i1(
; CHECK-NEXT:    ret <vscale x 16 x i1> [[PG:%.*]]
;
  %pg.addr = alloca <vscale x 16 x i1>
  store <vscale x 16 x i1> %pg, <vscale x 16 x i1>* %pg.addr
  %1 = load <vscale x 16 x i1>, <vscale x 16 x i1>* %pg.addr
  ret <vscale x 16 x i1> %1
}

define <vscale x 16 x i8> @alloca_nxv16i8(<vscale x 16 x i8> %vec) {
; CHECK-LABEL: @alloca_nxv16i8(
; CHECK-NEXT:    ret <vscale x 16 x i8> [[VEC:%.*]]
;
  %vec.addr = alloca <vscale x 16 x i8>
  store <vscale x 16 x i8> %vec, <vscale x 16 x i8>* %vec.addr
  %1 = load <vscale x 16 x i8>, <vscale x 16 x i8>* %vec.addr
  ret <vscale x 16 x i8> %1
}

; Test scalable alloca that can't be promoted. Mem2Reg only considers
; non-volatile loads and stores for promotion.
define <vscale x 16 x i8> @unpromotable_alloca(<vscale x 16 x i8> %vec) {
; CHECK-LABEL: @unpromotable_alloca(
; CHECK-NEXT:    [[VEC_ADDR:%.*]] = alloca <vscale x 16 x i8>, align 16
; CHECK-NEXT:    store volatile <vscale x 16 x i8> [[VEC:%.*]], <vscale x 16 x i8>* [[VEC_ADDR]], align 16
; CHECK-NEXT:    [[TMP1:%.*]] = load volatile <vscale x 16 x i8>, <vscale x 16 x i8>* [[VEC_ADDR]], align 16
; CHECK-NEXT:    ret <vscale x 16 x i8> [[TMP1]]
;
  %vec.addr = alloca <vscale x 16 x i8>
  store volatile <vscale x 16 x i8> %vec, <vscale x 16 x i8>* %vec.addr
  %1 = load volatile <vscale x 16 x i8>, <vscale x 16 x i8>* %vec.addr
  ret <vscale x 16 x i8> %1
}

; Test we bail out when using an alloca of a fixed-length vector (VLS) that was
; bitcasted to a scalable vector.
define <vscale x 4 x i32> @cast_alloca_to_svint32_t(<vscale x 4 x i32> %type.coerce) {
; CHECK-LABEL: @cast_alloca_to_svint32_t(
; CHECK-NEXT:    [[TYPE:%.*]] = alloca <16 x i32>, align 64
; CHECK-NEXT:    [[TYPE_ADDR:%.*]] = alloca <16 x i32>, align 64
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast <16 x i32>* [[TYPE]] to <vscale x 4 x i32>*
; CHECK-NEXT:    store <vscale x 4 x i32> [[TYPE_COERCE:%.*]], <vscale x 4 x i32>* [[TMP1]], align 16
; CHECK-NEXT:    [[TYPE1:%.*]] = load <16 x i32>, <16 x i32>* [[TYPE]], align 64
; CHECK-NEXT:    store <16 x i32> [[TYPE1]], <16 x i32>* [[TYPE_ADDR]], align 64
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i32>, <16 x i32>* [[TYPE_ADDR]], align 64
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <16 x i32>* [[TYPE_ADDR]] to <vscale x 4 x i32>*
; CHECK-NEXT:    [[TMP4:%.*]] = load <vscale x 4 x i32>, <vscale x 4 x i32>* [[TMP3]], align 16
; CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP4]]
;
  %type = alloca <16 x i32>
  %type.addr = alloca <16 x i32>
  %1 = bitcast <16 x i32>* %type to <vscale x 4 x i32>*
  store <vscale x 4 x i32> %type.coerce, <vscale x 4 x i32>* %1
  %type1 = load <16 x i32>, <16 x i32>* %type
  store <16 x i32> %type1, <16 x i32>* %type.addr
  %2 = load <16 x i32>, <16 x i32>* %type.addr
  %3 = bitcast <16 x i32>* %type.addr to <vscale x 4 x i32>*
  %4 = load <vscale x 4 x i32>, <vscale x 4 x i32>* %3
  ret <vscale x 4 x i32> %4
}

; When casting from VLA to VLS via memory check we bail out when producing a
; GEP where the element type is a scalable vector.
define <vscale x 4 x i32> @cast_alloca_from_svint32_t() {
; CHECK-LABEL: @cast_alloca_from_svint32_t(
; CHECK-NEXT:    [[RETVAL_COERCE:%.*]] = alloca <vscale x 4 x i32>, align 16
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast <vscale x 4 x i32>* [[RETVAL_COERCE]] to i8*
; CHECK-NEXT:    [[RETVAL_0__SROA_CAST:%.*]] = bitcast i8* [[TMP1]] to <16 x i32>*
; CHECK-NEXT:    store <16 x i32> undef, <16 x i32>* [[RETVAL_0__SROA_CAST]], align 16
; CHECK-NEXT:    [[TMP2:%.*]] = load <vscale x 4 x i32>, <vscale x 4 x i32>* [[RETVAL_COERCE]], align 16
; CHECK-NEXT:    ret <vscale x 4 x i32> [[TMP2]]
;
  %retval = alloca <16 x i32>
  %retval.coerce = alloca <vscale x 4 x i32>
  %1 = bitcast <vscale x 4 x i32>* %retval.coerce to i8*
  %2 = bitcast <16 x i32>* %retval to i8*
  call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 16 %1, i8* align 16 %2, i64 64, i1 false)
  %3 = load <vscale x 4 x i32>, <vscale x 4 x i32>* %retval.coerce
  ret <vscale x 4 x i32> %3
}

declare void @llvm.memcpy.p0i8.p0i8.i64(i8* nocapture, i8* nocapture, i64, i1) nounwind
