; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -codegenprepare < %s | FileCheck %s --check-prefix=SLOW
; RUN: opt -S -codegenprepare -mattr=+bmi < %s | FileCheck %s --check-prefix=FAST_TZ
; RUN: opt -S -codegenprepare -mattr=+lzcnt < %s | FileCheck %s --check-prefix=FAST_LZ

target triple = "x86_64-unknown-unknown"
target datalayout = "e-n32:64"

; If the intrinsic is cheap, nothing should change.
; If the intrinsic is expensive, check if the input is zero to avoid the call.
; This is undoing speculation that may have been created by SimplifyCFG + InstCombine.

define i64 @cttz(i64 %A) {
; SLOW-LABEL: @cttz(
; SLOW-NEXT:  entry:
; SLOW-NEXT:    [[A_FR:%.*]] = freeze i64 [[A:%.*]]
; SLOW-NEXT:    [[CMPZ:%.*]] = icmp eq i64 [[A_FR]], 0
; SLOW-NEXT:    br i1 [[CMPZ]], label [[COND_END:%.*]], label [[COND_FALSE:%.*]]
; SLOW:       cond.false:
; SLOW-NEXT:    [[Z:%.*]] = call i64 @llvm.cttz.i64(i64 [[A_FR]], i1 true)
; SLOW-NEXT:    br label [[COND_END]]
; SLOW:       cond.end:
; SLOW-NEXT:    [[CTZ:%.*]] = phi i64 [ 64, [[ENTRY:%.*]] ], [ [[Z]], [[COND_FALSE]] ]
; SLOW-NEXT:    ret i64 [[CTZ]]
;
; FAST_TZ-LABEL: @cttz(
; FAST_TZ-NEXT:  entry:
; FAST_TZ-NEXT:    [[Z:%.*]] = call i64 @llvm.cttz.i64(i64 [[A:%.*]], i1 false)
; FAST_TZ-NEXT:    ret i64 [[Z]]
;
; FAST_LZ-LABEL: @cttz(
; FAST_LZ-NEXT:  entry:
; FAST_LZ-NEXT:    [[A_FR:%.*]] = freeze i64 [[A:%.*]]
; FAST_LZ-NEXT:    [[CMPZ:%.*]] = icmp eq i64 [[A_FR]], 0
; FAST_LZ-NEXT:    br i1 [[CMPZ]], label [[COND_END:%.*]], label [[COND_FALSE:%.*]]
; FAST_LZ:       cond.false:
; FAST_LZ-NEXT:    [[Z:%.*]] = call i64 @llvm.cttz.i64(i64 [[A_FR]], i1 true)
; FAST_LZ-NEXT:    br label [[COND_END]]
; FAST_LZ:       cond.end:
; FAST_LZ-NEXT:    [[CTZ:%.*]] = phi i64 [ 64, [[ENTRY:%.*]] ], [ [[Z]], [[COND_FALSE]] ]
; FAST_LZ-NEXT:    ret i64 [[CTZ]]
;
entry:
  %z = call i64 @llvm.cttz.i64(i64 %A, i1 false)
  ret i64 %z
}

define i64 @ctlz(i64 %A) {
; SLOW-LABEL: @ctlz(
; SLOW-NEXT:  entry:
; SLOW-NEXT:    [[A_FR:%.*]] = freeze i64 [[A:%.*]]
; SLOW-NEXT:    [[CMPZ:%.*]] = icmp eq i64 [[A_FR]], 0
; SLOW-NEXT:    br i1 [[CMPZ]], label [[COND_END:%.*]], label [[COND_FALSE:%.*]]
; SLOW:       cond.false:
; SLOW-NEXT:    [[Z:%.*]] = call i64 @llvm.ctlz.i64(i64 [[A_FR]], i1 true)
; SLOW-NEXT:    br label [[COND_END]]
; SLOW:       cond.end:
; SLOW-NEXT:    [[CTZ:%.*]] = phi i64 [ 64, [[ENTRY:%.*]] ], [ [[Z]], [[COND_FALSE]] ]
; SLOW-NEXT:    ret i64 [[CTZ]]
;
; FAST_TZ-LABEL: @ctlz(
; FAST_TZ-NEXT:  entry:
; FAST_TZ-NEXT:    [[A_FR:%.*]] = freeze i64 [[A:%.*]]
; FAST_TZ-NEXT:    [[CMPZ:%.*]] = icmp eq i64 [[A_FR]], 0
; FAST_TZ-NEXT:    br i1 [[CMPZ]], label [[COND_END:%.*]], label [[COND_FALSE:%.*]]
; FAST_TZ:       cond.false:
; FAST_TZ-NEXT:    [[Z:%.*]] = call i64 @llvm.ctlz.i64(i64 [[A_FR]], i1 true)
; FAST_TZ-NEXT:    br label [[COND_END]]
; FAST_TZ:       cond.end:
; FAST_TZ-NEXT:    [[CTZ:%.*]] = phi i64 [ 64, [[ENTRY:%.*]] ], [ [[Z]], [[COND_FALSE]] ]
; FAST_TZ-NEXT:    ret i64 [[CTZ]]
;
; FAST_LZ-LABEL: @ctlz(
; FAST_LZ-NEXT:  entry:
; FAST_LZ-NEXT:    [[Z:%.*]] = call i64 @llvm.ctlz.i64(i64 [[A:%.*]], i1 false)
; FAST_LZ-NEXT:    ret i64 [[Z]]
;
entry:
  %z = call i64 @llvm.ctlz.i64(i64 %A, i1 false)
  ret i64 %z
}

declare i64 @llvm.cttz.i64(i64, i1)
declare i64 @llvm.ctlz.i64(i64, i1)

