; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=instcombine < %s | FileCheck %s

declare void @llvm.assume(i1)
declare void @use(i16)
define i1 @icmp_trunc_x_trunc_y(i32 %x, i32 %y) {
; CHECK-LABEL: @icmp_trunc_x_trunc_y(
; CHECK-NEXT:    [[X_LB_ONLY:%.*]] = icmp ult i32 [[X:%.*]], 65536
; CHECK-NEXT:    [[Y_LB_ONLY:%.*]] = icmp ult i32 [[Y:%.*]], 65536
; CHECK-NEXT:    call void @llvm.assume(i1 [[X_LB_ONLY]])
; CHECK-NEXT:    call void @llvm.assume(i1 [[Y_LB_ONLY]])
; CHECK-NEXT:    [[R:%.*]] = icmp eq i32 [[X]], [[Y]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_lb_only = icmp ult i32 %x, 65536
  %y_lb_only = icmp ult i32 %y, 65536
  call void @llvm.assume(i1 %x_lb_only)
  call void @llvm.assume(i1 %y_lb_only)
  %x16 = trunc i32 %x to i16
  %y16 = trunc i32 %y to i16
  %r = icmp eq i16 %x16, %y16
  ret i1 %r
}

define i1 @icmp_trunc_x_trunc_y_fail_from_illegal1(i256 %x, i256 %y) {
; CHECK-LABEL: @icmp_trunc_x_trunc_y_fail_from_illegal1(
; CHECK-NEXT:    [[X_LB_ONLY:%.*]] = icmp ult i256 [[X:%.*]], 65536
; CHECK-NEXT:    [[Y_LB_ONLY:%.*]] = icmp ult i256 [[Y:%.*]], 65536
; CHECK-NEXT:    call void @llvm.assume(i1 [[X_LB_ONLY]])
; CHECK-NEXT:    call void @llvm.assume(i1 [[Y_LB_ONLY]])
; CHECK-NEXT:    [[X16:%.*]] = trunc i256 [[X]] to i16
; CHECK-NEXT:    [[Y16:%.*]] = trunc i256 [[Y]] to i16
; CHECK-NEXT:    [[R:%.*]] = icmp eq i16 [[X16]], [[Y16]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_lb_only = icmp ult i256 %x, 65536
  %y_lb_only = icmp ult i256 %y, 65536
  call void @llvm.assume(i1 %x_lb_only)
  call void @llvm.assume(i1 %y_lb_only)
  %x16 = trunc i256 %x to i16
  %y16 = trunc i256 %y to i16
  %r = icmp eq i16 %x16, %y16
  ret i1 %r
}

define i1 @icmp_trunc_x_trunc_y_illegal_trunc_to_legal_anyways(i123 %x, i32 %y) {
; CHECK-LABEL: @icmp_trunc_x_trunc_y_illegal_trunc_to_legal_anyways(
; CHECK-NEXT:    [[X_LB_ONLY:%.*]] = icmp ult i123 [[X:%.*]], 65536
; CHECK-NEXT:    [[Y_LB_ONLY:%.*]] = icmp ult i32 [[Y:%.*]], 65536
; CHECK-NEXT:    call void @llvm.assume(i1 [[X_LB_ONLY]])
; CHECK-NEXT:    call void @llvm.assume(i1 [[Y_LB_ONLY]])
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i123 [[X]] to i32
; CHECK-NEXT:    [[R:%.*]] = icmp eq i32 [[TMP1]], [[Y]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_lb_only = icmp ult i123 %x, 65536
  %y_lb_only = icmp ult i32 %y, 65536
  call void @llvm.assume(i1 %x_lb_only)
  call void @llvm.assume(i1 %y_lb_only)
  %x16 = trunc i123 %x to i16
  %y16 = trunc i32 %y to i16
  %r = icmp eq i16 %x16, %y16
  ret i1 %r
}

define i1 @icmp_trunc_x_trunc_y_2_illegal_anyways(i33 %x, i63 %y) {
; CHECK-LABEL: @icmp_trunc_x_trunc_y_2_illegal_anyways(
; CHECK-NEXT:    [[X_LB_ONLY:%.*]] = icmp ult i33 [[X:%.*]], 512
; CHECK-NEXT:    [[Y_LB_ONLY:%.*]] = icmp ult i63 [[Y:%.*]], 512
; CHECK-NEXT:    call void @llvm.assume(i1 [[X_LB_ONLY]])
; CHECK-NEXT:    call void @llvm.assume(i1 [[Y_LB_ONLY]])
; CHECK-NEXT:    [[TMP1:%.*]] = zext nneg i33 [[X]] to i63
; CHECK-NEXT:    [[R:%.*]] = icmp ugt i63 [[TMP1]], [[Y]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_lb_only = icmp ult i33 %x, 512
  %y_lb_only = icmp ult i63 %y, 512
  call void @llvm.assume(i1 %x_lb_only)
  call void @llvm.assume(i1 %y_lb_only)
  %x16 = trunc i33 %x to i9
  %y16 = trunc i63 %y to i9
  %r = icmp ult i9 %y16, %x16
  ret i1 %r
}

define i1 @icmp_trunc_x_trunc_y_3(i64 %x, i32 %y) {
; CHECK-LABEL: @icmp_trunc_x_trunc_y_3(
; CHECK-NEXT:    [[X_LB_ONLY:%.*]] = icmp ult i64 [[X:%.*]], 123
; CHECK-NEXT:    [[Y_LB_ONLY:%.*]] = icmp ult i32 [[Y:%.*]], 256
; CHECK-NEXT:    call void @llvm.assume(i1 [[X_LB_ONLY]])
; CHECK-NEXT:    call void @llvm.assume(i1 [[Y_LB_ONLY]])
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i64 [[X]] to i32
; CHECK-NEXT:    [[R:%.*]] = icmp uge i32 [[TMP1]], [[Y]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_lb_only = icmp ult i64 %x, 123
  %y_lb_only = icmp ult i32 %y, 256
  call void @llvm.assume(i1 %x_lb_only)
  call void @llvm.assume(i1 %y_lb_only)
  %xi8 = trunc i64 %x to i8
  %yi8 = trunc i32 %y to i8
  %r = icmp ule i8 %yi8, %xi8
  ret i1 %r
}

define i1 @icmp_trunc_x_trunc_y_fail_maybe_dirty_upper(i32 %x, i32 %y) {
; CHECK-LABEL: @icmp_trunc_x_trunc_y_fail_maybe_dirty_upper(
; CHECK-NEXT:    [[X_LB_ONLY:%.*]] = icmp ult i32 [[X:%.*]], 65536
; CHECK-NEXT:    [[Y_LB_ONLY:%.*]] = icmp ult i32 [[Y:%.*]], 65537
; CHECK-NEXT:    call void @llvm.assume(i1 [[X_LB_ONLY]])
; CHECK-NEXT:    call void @llvm.assume(i1 [[Y_LB_ONLY]])
; CHECK-NEXT:    [[X16:%.*]] = trunc i32 [[X]] to i16
; CHECK-NEXT:    [[Y16:%.*]] = trunc i32 [[Y]] to i16
; CHECK-NEXT:    [[R:%.*]] = icmp ne i16 [[X16]], [[Y16]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_lb_only = icmp ult i32 %x, 65536
  %y_lb_only = icmp ult i32 %y, 65537
  call void @llvm.assume(i1 %x_lb_only)
  call void @llvm.assume(i1 %y_lb_only)
  %x16 = trunc i32 %x to i16
  %y16 = trunc i32 %y to i16
  %r = icmp ne i16 %x16, %y16
  ret i1 %r
}

define i1 @icmp_trunc_x_trunc_y_fail_maybe_dirty_upper_2(i32 %x, i32 %y) {
; CHECK-LABEL: @icmp_trunc_x_trunc_y_fail_maybe_dirty_upper_2(
; CHECK-NEXT:    [[X_LB_ONLY:%.*]] = icmp slt i32 [[X:%.*]], 65536
; CHECK-NEXT:    [[Y_LB_ONLY:%.*]] = icmp ult i32 [[Y:%.*]], 65536
; CHECK-NEXT:    call void @llvm.assume(i1 [[X_LB_ONLY]])
; CHECK-NEXT:    call void @llvm.assume(i1 [[Y_LB_ONLY]])
; CHECK-NEXT:    [[X16:%.*]] = trunc i32 [[X]] to i16
; CHECK-NEXT:    [[Y16:%.*]] = trunc i32 [[Y]] to i16
; CHECK-NEXT:    [[R:%.*]] = icmp ne i16 [[X16]], [[Y16]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_lb_only = icmp slt i32 %x, 65536
  %y_lb_only = icmp ult i32 %y, 65536
  call void @llvm.assume(i1 %x_lb_only)
  call void @llvm.assume(i1 %y_lb_only)
  %x16 = trunc i32 %x to i16
  %y16 = trunc i32 %y to i16
  %r = icmp ne i16 %x16, %y16
  ret i1 %r
}

define i1 @icmp_trunc_x_trunc_y_swap0(i33 %x, i32 %y) {
; CHECK-LABEL: @icmp_trunc_x_trunc_y_swap0(
; CHECK-NEXT:    [[X_LB_ONLY:%.*]] = icmp ult i33 [[X:%.*]], 65536
; CHECK-NEXT:    [[Y_LB_ONLY:%.*]] = icmp ult i32 [[Y:%.*]], 65536
; CHECK-NEXT:    call void @llvm.assume(i1 [[X_LB_ONLY]])
; CHECK-NEXT:    call void @llvm.assume(i1 [[Y_LB_ONLY]])
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i33 [[X]] to i32
; CHECK-NEXT:    [[R:%.*]] = icmp ule i32 [[TMP1]], [[Y]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_lb_only = icmp ult i33 %x, 65536
  %y_lb_only = icmp ult i32 %y, 65536
  call void @llvm.assume(i1 %x_lb_only)
  call void @llvm.assume(i1 %y_lb_only)
  %x16 = trunc i33 %x to i16
  %y16 = trunc i32 %y to i16
  %r = icmp ule i16 %x16, %y16
  ret i1 %r
}

define i1 @icmp_trunc_x_trunc_y_swap1(i33 %x, i32 %y) {
; CHECK-LABEL: @icmp_trunc_x_trunc_y_swap1(
; CHECK-NEXT:    [[X_LB_ONLY:%.*]] = icmp ult i33 [[X:%.*]], 65536
; CHECK-NEXT:    [[Y_LB_ONLY:%.*]] = icmp ult i32 [[Y:%.*]], 65536
; CHECK-NEXT:    call void @llvm.assume(i1 [[X_LB_ONLY]])
; CHECK-NEXT:    call void @llvm.assume(i1 [[Y_LB_ONLY]])
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i33 [[X]] to i32
; CHECK-NEXT:    [[R:%.*]] = icmp uge i32 [[TMP1]], [[Y]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_lb_only = icmp ult i33 %x, 65536
  %y_lb_only = icmp ult i32 %y, 65536
  call void @llvm.assume(i1 %x_lb_only)
  call void @llvm.assume(i1 %y_lb_only)
  %x16 = trunc i33 %x to i16
  %y16 = trunc i32 %y to i16
  %r = icmp ule i16 %y16, %x16
  ret i1 %r
}

define i1 @icmp_trunc_x_zext_y(i32 %x, i8 %y) {
; CHECK-LABEL: @icmp_trunc_x_zext_y(
; CHECK-NEXT:    [[X_LB_ONLY:%.*]] = icmp ult i32 [[X:%.*]], 65536
; CHECK-NEXT:    call void @llvm.assume(i1 [[X_LB_ONLY]])
; CHECK-NEXT:    [[TMP1:%.*]] = zext i8 [[Y:%.*]] to i32
; CHECK-NEXT:    [[R:%.*]] = icmp ult i32 [[TMP1]], [[X]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_lb_only = icmp ult i32 %x, 65536
  call void @llvm.assume(i1 %x_lb_only)
  %x16 = trunc i32 %x to i16
  %y16 = zext i8 %y to i16
  %r = icmp ugt i16 %x16, %y16
  ret i1 %r
}

define i1 @icmp_trunc_x_zext_y_2(i32 %x, i8 %y) {
; CHECK-LABEL: @icmp_trunc_x_zext_y_2(
; CHECK-NEXT:    [[X_LB_ONLY:%.*]] = icmp ult i32 [[X:%.*]], 65536
; CHECK-NEXT:    call void @llvm.assume(i1 [[X_LB_ONLY]])
; CHECK-NEXT:    [[TMP1:%.*]] = zext i8 [[Y:%.*]] to i32
; CHECK-NEXT:    [[R:%.*]] = icmp uge i32 [[TMP1]], [[X]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_lb_only = icmp ult i32 %x, 65536
  call void @llvm.assume(i1 %x_lb_only)
  %x16 = trunc i32 %x to i16
  %y16 = zext i8 %y to i16
  %r = icmp uge i16 %y16, %x16
  ret i1 %r
}

define i1 @icmp_trunc_x_zext_y_3(i6 %x, i32 %y) {
; CHECK-LABEL: @icmp_trunc_x_zext_y_3(
; CHECK-NEXT:    [[Y_LB_ONLY:%.*]] = icmp ult i32 [[Y:%.*]], 65536
; CHECK-NEXT:    call void @llvm.assume(i1 [[Y_LB_ONLY]])
; CHECK-NEXT:    [[TMP1:%.*]] = zext i6 [[X:%.*]] to i32
; CHECK-NEXT:    [[R:%.*]] = icmp ne i32 [[TMP1]], [[Y]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %y_lb_only = icmp ult i32 %y, 65536
  call void @llvm.assume(i1 %y_lb_only)
  %x16 = zext i6 %x to i16
  %y16 = trunc i32 %y to i16
  %r = icmp ne i16 %y16, %x16
  ret i1 %r
}

define i1 @icmp_trunc_x_zext_y_3_fail_illegal(i6 %x, i45 %y) {
; CHECK-LABEL: @icmp_trunc_x_zext_y_3_fail_illegal(
; CHECK-NEXT:    [[Y_LB_ONLY:%.*]] = icmp ult i45 [[Y:%.*]], 65536
; CHECK-NEXT:    call void @llvm.assume(i1 [[Y_LB_ONLY]])
; CHECK-NEXT:    [[X16:%.*]] = zext i6 [[X:%.*]] to i16
; CHECK-NEXT:    [[Y16:%.*]] = trunc i45 [[Y]] to i16
; CHECK-NEXT:    [[R:%.*]] = icmp ne i16 [[Y16]], [[X16]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %y_lb_only = icmp ult i45 %y, 65536
  call void @llvm.assume(i1 %y_lb_only)
  %x16 = zext i6 %x to i16
  %y16 = trunc i45 %y to i16
  %r = icmp ne i16 %y16, %x16
  ret i1 %r
}

define i1 @icmp_trunc_x_zext_y_fail_multiuse(i32 %x, i8 %y) {
; CHECK-LABEL: @icmp_trunc_x_zext_y_fail_multiuse(
; CHECK-NEXT:    [[X_LB_ONLY:%.*]] = icmp ult i32 [[X:%.*]], 65536
; CHECK-NEXT:    call void @llvm.assume(i1 [[X_LB_ONLY]])
; CHECK-NEXT:    [[X16:%.*]] = trunc i32 [[X]] to i16
; CHECK-NEXT:    [[Y16:%.*]] = zext i8 [[Y:%.*]] to i16
; CHECK-NEXT:    call void @use(i16 [[Y16]])
; CHECK-NEXT:    [[R:%.*]] = icmp ule i16 [[X16]], [[Y16]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_lb_only = icmp ult i32 %x, 65536
  call void @llvm.assume(i1 %x_lb_only)
  %x16 = trunc i32 %x to i16
  %y16 = zext i8 %y to i16
  call void @use(i16 %y16)
  %r = icmp ule i16 %x16, %y16
  ret i1 %r
}
