package org.jaudiotagger.issues;

import org.jaudiotagger.AbstractTestCase;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.ID3v23Tag;
import org.jaudiotagger.tag.reference.ID3V2Version;

import java.io.File;

/**
 * Test Problem saving to Mp3 caused by duplicate CHAP frames
 */
public class Issue276Test extends AbstractTestCase
{
    public void testCHAPV24ToV23() throws Exception
    {
        File orig = new File("testdata", "test536.mp3");
        if (!orig.isFile())
        {
            System.err.println("Unable to test file - not available");
            return;
        }

        Exception ex=null;
        try
        {
            TagOptionSingleton.getInstance().setID3V2Version(ID3V2Version.ID3_V23);
            File testFile = AbstractTestCase.copyAudioToTmp("test536.mp3");
            AudioFile af = AudioFileIO.read(testFile);
            assertNotNull(af.getTag());
            System.out.println(af.getTag());
            Tag tag=af.getTagAndConvertOrCreateAndSetDefault();
            tag.setField(FieldKey.YEAR, "year");
            af.commit();
            assertTrue((AbstractID3v2Tag)af.getTag() instanceof ID3v23Tag);
        }
        catch(Exception e)
        {
            e.printStackTrace();
            ex=e;
        }
        assertNull(ex);
    }
}