/*
   mkvmerge -- utility for splicing together matroska files
   from component media subtypes

   Distributed under the GPL v2
   see the file COPYING for details
   or visit https://www.gnu.org/licenses/old-licenses/gpl-2.0.html

   IANA language subtag registry

   Written by Moritz Bunkus <moritz@bunkus.org>.
*/

// ----------------------------------------------------------------------------------------------
// NOTE: this file is auto-generated by the "dev:iana_language_subtag_registry_list" rake target.
// ----------------------------------------------------------------------------------------------

#include "common/common_pch.h"

#include "common/bcp47.h"
#include "common/iana_language_subtag_registry.h"

namespace mtx::iana::language_subtag_registry {

std::vector<entry_t> g_extlangs, g_variants, g_grandfathered;
std::vector<std::pair<mtx::bcp47::language_c, mtx::bcp47::language_c>> g_preferred_values;
std::unordered_map<std::string, std::string> g_suppress_scripts;

using VS = std::vector<std::string>;

struct extlang_variant_init_t {
  char const *code, *description;
  char const *prefixes[12];
  bool is_deprecated;
};

struct suppress_script_init_t {
  char const *first, *second;
};

struct preferred_values_init_t {
  struct sub_t {
    char const *tag, *region, *variant;

    mtx::bcp47::language_c parse() const;
  };

  sub_t from, to;
};

mtx::bcp47::language_c
preferred_values_init_t::sub_t::parse()
  const {

  auto language = tag ? mtx::bcp47::language_c::parse(tag) : mtx::bcp47::language_c{};

  if (region)
    language.set_region(region);

  if (variant)
    language.set_variants({ variant });

  if (!tag)
    language.set_valid(true);

  return language;
}

static extlang_variant_init_t s_extlangs_init[] = {
  { "aao", "Algerian Saharan Arabic",             { "ar", NULL },  false },
  { "abh", "Tajiki Arabic",                       { "ar", NULL },  false },
  { "abv", "Baharna Arabic",                      { "ar", NULL },  false },
  { "acm", "Mesopotamian Arabic",                 { "ar", NULL },  false },
  { "acq", "Ta'izzi-Adeni Arabic",                { "ar", NULL },  false },
  { "acw", "Hijazi Arabic",                       { "ar", NULL },  false },
  { "acx", "Omani Arabic",                        { "ar", NULL },  false },
  { "acy", "Cypriot Arabic",                      { "ar", NULL },  false },
  { "adf", "Dhofari Arabic",                      { "ar", NULL },  false },
  { "ads", "Adamorobe Sign Language",             { "sgn", NULL }, false },
  { "aeb", "Tunisian Arabic",                     { "ar", NULL },  false },
  { "aec", "Saidi Arabic",                        { "ar", NULL },  false },
  { "aed", "Argentine Sign Language",             { "sgn", NULL }, false },
  { "aen", "Armenian Sign Language",              { "sgn", NULL }, false },
  { "afb", "Gulf Arabic",                         { "ar", NULL },  false },
  { "afg", "Afghan Sign Language",                { "sgn", NULL }, false },
  { "ajp", "South Levantine Arabic",              { "ar", NULL },  false },
  { "ajs", "Algerian Jewish Sign Language",       { "sgn", NULL }, false },
  { "apc", "North Levantine Arabic",              { "ar", NULL },  false },
  { "apd", "Sudanese Arabic",                     { "ar", NULL },  false },
  { "arb", "Standard Arabic",                     { "ar", NULL },  false },
  { "arq", "Algerian Arabic",                     { "ar", NULL },  false },
  { "ars", "Najdi Arabic",                        { "ar", NULL },  false },
  { "ary", "Moroccan Arabic",                     { "ar", NULL },  false },
  { "arz", "Egyptian Arabic",                     { "ar", NULL },  false },
  { "ase", "American Sign Language",              { "sgn", NULL }, false },
  { "asf", "Australian Sign Language",            { "sgn", NULL }, false },
  { "asp", "Algerian Sign Language",              { "sgn", NULL }, false },
  { "asq", "Austrian Sign Language",              { "sgn", NULL }, false },
  { "asw", "Australian Aborigines Sign Language", { "sgn", NULL }, false },
  { "auz", "Uzbeki Arabic",                       { "ar", NULL },  false },
  { "avl", "Eastern Egyptian Bedawi Arabic",      { "ar", NULL },  false },
  { "ayh", "Hadrami Arabic",                      { "ar", NULL },  false },
  { "ayl", "Libyan Arabic",                       { "ar", NULL },  false },
  { "ayn", "Sanaani Arabic",                      { "ar", NULL },  false },
  { "ayp", "North Mesopotamian Arabic",           { "ar", NULL },  false },
  { "bbz", "Babalia Creole Arabic",               { "ar", NULL },  true  },
  { "bfi", "British Sign Language",               { "sgn", NULL }, false },
  { "bfk", "Ban Khor Sign Language",              { "sgn", NULL }, false },
  { "bjn", "Banjar",                              { "ms", NULL },  false },
  { "bog", "Bamako Sign Language",                { "sgn", NULL }, false },
  { "bqn", "Bulgarian Sign Language",             { "sgn", NULL }, false },
  { "bqy", "Bengkala Sign Language",              { "sgn", NULL }, false },
  { "btj", "Bacanese Malay",                      { "ms", NULL },  false },
  { "bve", "Berau Malay",                         { "ms", NULL },  false },
  { "bvl", "Bolivian Sign Language",              { "sgn", NULL }, false },
  { "bvu", "Bukit Malay",                         { "ms", NULL },  false },
  { "bzs", "Brazilian Sign Language",             { "sgn", NULL }, false },
  { "cdo", "Min Dong Chinese",                    { "zh", NULL },  false },
  { "cds", "Chadian Sign Language",               { "sgn", NULL }, false },
  { "cjy", "Jinyu Chinese",                       { "zh", NULL },  false },
  { "cmn", "Mandarin Chinese",                    { "zh", NULL },  false },
  { "cnp", "Northern Pinghua",                    { "zh", NULL },  false },
  { "coa", "Cocos Islands Malay",                 { "ms", NULL },  false },
  { "cpx", "Pu-Xian Chinese",                     { "zh", NULL },  false },
  { "csc", "Llengua de Signes Catalana",          { "sgn", NULL }, false },
  { "csd", "Chiangmai Sign Language",             { "sgn", NULL }, false },
  { "cse", "Czech Sign Language",                 { "sgn", NULL }, false },
  { "csf", "Cuba Sign Language",                  { "sgn", NULL }, false },
  { "csg", "Chilean Sign Language",               { "sgn", NULL }, false },
  { "csl", "Chinese Sign Language",               { "sgn", NULL }, false },
  { "csn", "Colombian Sign Language",             { "sgn", NULL }, false },
  { "csp", "Southern Pinghua",                    { "zh", NULL },  false },
  { "csq", "Croatia Sign Language",               { "sgn", NULL }, false },
  { "csr", "Costa Rican Sign Language",           { "sgn", NULL }, false },
  { "csx", "Cambodian Sign Language",             { "sgn", NULL }, false },
  { "czh", "Huizhou Chinese",                     { "zh", NULL },  false },
  { "czo", "Min Zhong Chinese",                   { "zh", NULL },  false },
  { "doq", "Dominican Sign Language",             { "sgn", NULL }, false },
  { "dse", "Dutch Sign Language",                 { "sgn", NULL }, false },
  { "dsl", "Danish Sign Language",                { "sgn", NULL }, false },
  { "dsz", "Mardin Sign Language",                { "sgn", NULL }, false },
  { "dup", "Duano",                               { "ms", NULL },  false },
  { "ecs", "Ecuadorian Sign Language",            { "sgn", NULL }, false },
  { "ehs", "Miyakubo Sign Language",              { "sgn", NULL }, false },
  { "esl", "Egypt Sign Language",                 { "sgn", NULL }, false },
  { "esn", "Salvadoran Sign Language",            { "sgn", NULL }, false },
  { "eso", "Estonian Sign Language",              { "sgn", NULL }, false },
  { "eth", "Ethiopian Sign Language",             { "sgn", NULL }, false },
  { "fcs", "Quebec Sign Language",                { "sgn", NULL }, false },
  { "fse", "Finnish Sign Language",               { "sgn", NULL }, false },
  { "fsl", "French Sign Language",                { "sgn", NULL }, false },
  { "fss", "suomenruotsalainen viittomakieli",    { "sgn", NULL }, false },
  { "gan", "Gan Chinese",                         { "zh", NULL },  false },
  { "gds", "Ghandruk Sign Language",              { "sgn", NULL }, false },
  { "gom", "Goan Konkani",                        { "kok", NULL }, false },
  { "gse", "Ghanaian Sign Language",              { "sgn", NULL }, false },
  { "gsg", "German Sign Language",                { "sgn", NULL }, false },
  { "gsm", "Guatemalan Sign Language",            { "sgn", NULL }, false },
  { "gss", "Greek Sign Language",                 { "sgn", NULL }, false },
  { "gus", "Guinean Sign Language",               { "sgn", NULL }, false },
  { "hab", "Hanoi Sign Language",                 { "sgn", NULL }, false },
  { "haf", "Haiphong Sign Language",              { "sgn", NULL }, false },
  { "hak", "Hakka Chinese",                       { "zh", NULL },  false },
  { "hds", "Honduras Sign Language",              { "sgn", NULL }, false },
  { "hji", "Haji",                                { "ms", NULL },  false },
  { "hks", "Heung Kong Sau Yue",                  { "sgn", NULL }, false },
  { "hos", "Ho Chi Minh City Sign Language",      { "sgn", NULL }, false },
  { "hps", "Hawai'i Pidgin Sign Language",        { "sgn", NULL }, false },
  { "hsh", "Hungarian Sign Language",             { "sgn", NULL }, false },
  { "hsl", "Hausa Sign Language",                 { "sgn", NULL }, false },
  { "hsn", "Xiang Chinese",                       { "zh", NULL },  false },
  { "icl", "Icelandic Sign Language",             { "sgn", NULL }, false },
  { "iks", "Inuit Sign Language",                 { "sgn", NULL }, false },
  { "ils", "International Sign",                  { "sgn", NULL }, false },
  { "inl", "Indonesian Sign Language",            { "sgn", NULL }, false },
  { "ins", "Indian Sign Language",                { "sgn", NULL }, false },
  { "ise", "Italian Sign Language",               { "sgn", NULL }, false },
  { "isg", "Irish Sign Language",                 { "sgn", NULL }, false },
  { "isr", "Israeli Sign Language",               { "sgn", NULL }, false },
  { "jak", "Jakun",                               { "ms", NULL },  false },
  { "jax", "Jambi Malay",                         { "ms", NULL },  false },
  { "jcs", "Jamaican Country Sign Language",      { "sgn", NULL }, false },
  { "jhs", "Jhankot Sign Language",               { "sgn", NULL }, false },
  { "jks", "Amami Koniya Sign Language",          { "sgn", NULL }, false },
  { "jls", "Jamaican Sign Language",              { "sgn", NULL }, false },
  { "jos", "Jordanian Sign Language",             { "sgn", NULL }, false },
  { "jsl", "Japanese Sign Language",              { "sgn", NULL }, false },
  { "jus", "Jumla Sign Language",                 { "sgn", NULL }, false },
  { "kgi", "Selangor Sign Language",              { "sgn", NULL }, false },
  { "knn", "Konkani (individual language)",       { "kok", NULL }, false },
  { "kvb", "Kubu",                                { "ms", NULL },  false },
  { "kvk", "Korean Sign Language",                { "sgn", NULL }, false },
  { "kvr", "Kerinci",                             { "ms", NULL },  false },
  { "kxd", "Brunei",                              { "ms", NULL },  false },
  { "lbs", "Libyan Sign Language",                { "sgn", NULL }, false },
  { "lce", "Sekak",                               { "ms", NULL },  false },
  { "lcf", "Lubu",                                { "ms", NULL },  false },
  { "liw", "Col",                                 { "ms", NULL },  false },
  { "lls", "Lithuanian Sign Language",            { "sgn", NULL }, false },
  { "lsb", "Langue des Signes Burundaise",        { "sgn", NULL }, false },
  { "lsc", "Lengua de señas Albarradas",          { "sgn", NULL }, false },
  { "lsg", "Lyons Sign Language",                 { "sgn", NULL }, true  },
  { "lsl", "Latvian Sign Language",               { "sgn", NULL }, false },
  { "lsn", "Tibetan Sign Language",               { "sgn", NULL }, false },
  { "lso", "Laos Sign Language",                  { "sgn", NULL }, false },
  { "lsp", "Lengua de Señas Panameñas",           { "sgn", NULL }, false },
  { "lst", "Trinidad and Tobago Sign Language",   { "sgn", NULL }, false },
  { "lsv", "Sivia Sign Language",                 { "sgn", NULL }, false },
  { "lsw", "Langue des Signes Seychelloise",      { "sgn", NULL }, false },
  { "lsy", "Mauritian Sign Language",             { "sgn", NULL }, false },
  { "ltg", "Latgalian",                           { "lv", NULL },  false },
  { "lvs", "Standard Latvian",                    { "lv", NULL },  false },
  { "lws", "Malawian Sign Language",              { "sgn", NULL }, false },
  { "lzh", "Literary Chinese",                    { "zh", NULL },  false },
  { "max", "North Moluccan Malay",                { "ms", NULL },  false },
  { "mdl", "Maltese Sign Language",               { "sgn", NULL }, false },
  { "meo", "Kedah Malay",                         { "ms", NULL },  false },
  { "mfa", "Pattani Malay",                       { "ms", NULL },  false },
  { "mfb", "Bangka",                              { "ms", NULL },  false },
  { "mfs", "Mexican Sign Language",               { "sgn", NULL }, false },
  { "min", "Minangkabau",                         { "ms", NULL },  false },
  { "mnp", "Min Bei Chinese",                     { "zh", NULL },  false },
  { "mqg", "Kota Bangun Kutai Malay",             { "ms", NULL },  false },
  { "mre", "Martha's Vineyard Sign Language",     { "sgn", NULL }, false },
  { "msd", "Yucatec Maya Sign Language",          { "sgn", NULL }, false },
  { "msi", "Sabah Malay",                         { "ms", NULL },  false },
  { "msr", "Mongolian Sign Language",             { "sgn", NULL }, false },
  { "mui", "Musi",                                { "ms", NULL },  false },
  { "mzc", "Madagascar Sign Language",            { "sgn", NULL }, false },
  { "mzg", "Monastic Sign Language",              { "sgn", NULL }, false },
  { "mzy", "Mozambican Sign Language",            { "sgn", NULL }, false },
  { "nan", "Min Nan Chinese",                     { "zh", NULL },  false },
  { "nbs", "Namibian Sign Language",              { "sgn", NULL }, false },
  { "ncs", "Nicaraguan Sign Language",            { "sgn", NULL }, false },
  { "nsi", "Nigerian Sign Language",              { "sgn", NULL }, false },
  { "nsl", "Norwegian Sign Language",             { "sgn", NULL }, false },
  { "nsp", "Nepalese Sign Language",              { "sgn", NULL }, false },
  { "nsr", "Maritime Sign Language",              { "sgn", NULL }, false },
  { "nzs", "New Zealand Sign Language",           { "sgn", NULL }, false },
  { "okl", "Old Kentish Sign Language",           { "sgn", NULL }, false },
  { "orn", "Orang Kanaq",                         { "ms", NULL },  false },
  { "ors", "Orang Seletar",                       { "ms", NULL },  false },
  { "pel", "Pekal",                               { "ms", NULL },  false },
  { "pga", "Sudanese Creole Arabic",              { "ar", NULL },  false },
  { "pgz", "Papua New Guinean Sign Language",     { "sgn", NULL }, false },
  { "pks", "Pakistan Sign Language",              { "sgn", NULL }, false },
  { "prl", "Peruvian Sign Language",              { "sgn", NULL }, false },
  { "prz", "Providencia Sign Language",           { "sgn", NULL }, false },
  { "psc", "Persian Sign Language",               { "sgn", NULL }, false },
  { "psd", "Plains Indian Sign Language",         { "sgn", NULL }, false },
  { "pse", "Central Malay",                       { "ms", NULL },  false },
  { "psg", "Penang Sign Language",                { "sgn", NULL }, false },
  { "psl", "Puerto Rican Sign Language",          { "sgn", NULL }, false },
  { "pso", "Polish Sign Language",                { "sgn", NULL }, false },
  { "psp", "Philippine Sign Language",            { "sgn", NULL }, false },
  { "psr", "Portuguese Sign Language",            { "sgn", NULL }, false },
  { "pys", "Lengua de Señas del Paraguay",        { "sgn", NULL }, false },
  { "rib", "Bribri Sign Language",                { "sgn", NULL }, false },
  { "rms", "Romanian Sign Language",              { "sgn", NULL }, false },
  { "rnb", "Brunca Sign Language",                { "sgn", NULL }, false },
  { "rsi", "Rennellese Sign Language",            { "sgn", NULL }, true  },
  { "rsl", "Russian Sign Language",               { "sgn", NULL }, false },
  { "rsm", "Miriwoong Sign Language",             { "sgn", NULL }, false },
  { "rsn", "Rwandan Sign Language",               { "sgn", NULL }, false },
  { "sdl", "Saudi Arabian Sign Language",         { "sgn", NULL }, false },
  { "sfb", "French Belgian Sign Language",        { "sgn", NULL }, false },
  { "sfs", "South African Sign Language",         { "sgn", NULL }, false },
  { "sgg", "Swiss-German Sign Language",          { "sgn", NULL }, false },
  { "sgx", "Sierra Leone Sign Language",          { "sgn", NULL }, false },
  { "shu", "Chadian Arabic",                      { "ar", NULL },  false },
  { "slf", "Swiss-Italian Sign Language",         { "sgn", NULL }, false },
  { "sls", "Singapore Sign Language",             { "sgn", NULL }, false },
  { "sqk", "Albanian Sign Language",              { "sgn", NULL }, false },
  { "sqs", "Sri Lankan Sign Language",            { "sgn", NULL }, false },
  { "sqx", "Kufr Qassem Sign Language (KQSL)",    { "sgn", NULL }, false },
  { "ssh", "Shihhi Arabic",                       { "ar", NULL },  false },
  { "ssp", "Spanish Sign Language",               { "sgn", NULL }, false },
  { "ssr", "Swiss-French Sign Language",          { "sgn", NULL }, false },
  { "svk", "Slovakian Sign Language",             { "sgn", NULL }, false },
  { "swc", "Congo Swahili",                       { "sw", NULL },  false },
  { "swh", "Kiswahili",                           { "sw", NULL },  false },
  { "swl", "Swedish Sign Language",               { "sgn", NULL }, false },
  { "syy", "Al-Sayyid Bedouin Sign Language",     { "sgn", NULL }, false },
  { "szs", "Solomon Islands Sign Language",       { "sgn", NULL }, false },
  { "tmw", "Temuan",                              { "ms", NULL },  false },
  { "tse", "Tunisian Sign Language",              { "sgn", NULL }, false },
  { "tsm", "Türk İşaret Dili",                    { "sgn", NULL }, false },
  { "tsq", "Thai Sign Language",                  { "sgn", NULL }, false },
  { "tss", "Taiwan Sign Language",                { "sgn", NULL }, false },
  { "tsy", "Tebul Sign Language",                 { "sgn", NULL }, false },
  { "tza", "Tanzanian Sign Language",             { "sgn", NULL }, false },
  { "ugn", "Ugandan Sign Language",               { "sgn", NULL }, false },
  { "ugy", "Uruguayan Sign Language",             { "sgn", NULL }, false },
  { "ukl", "Ukrainian Sign Language",             { "sgn", NULL }, false },
  { "uks", "Kaapor Sign Language",                { "sgn", NULL }, false },
  { "urk", "Urak Lawoi'",                         { "ms", NULL },  false },
  { "uzn", "Northern Uzbek",                      { "uz", NULL },  false },
  { "uzs", "Southern Uzbek",                      { "uz", NULL },  false },
  { "vgt", "Flemish Sign Language",               { "sgn", NULL }, false },
  { "vkk", "Kaur",                                { "ms", NULL },  false },
  { "vkt", "Tenggarong Kutai Malay",              { "ms", NULL },  false },
  { "vsi", "Moldova Sign Language",               { "sgn", NULL }, false },
  { "vsl", "Venezuelan Sign Language",            { "sgn", NULL }, false },
  { "vsv", "Llengua de signes valenciana",        { "sgn", NULL }, false },
  { "wbs", "West Bengal Sign Language",           { "sgn", NULL }, false },
  { "wuu", "Wu Chinese",                          { "zh", NULL },  false },
  { "xki", "Kenyan Sign Language",                { "sgn", NULL }, false },
  { "xml", "Malaysian Sign Language",             { "sgn", NULL }, false },
  { "xmm", "Manado Malay",                        { "ms", NULL },  false },
  { "xms", "Moroccan Sign Language",              { "sgn", NULL }, false },
  { "yds", "Yiddish Sign Language",               { "sgn", NULL }, true  },
  { "ygs", "Yolŋu Sign Language",                 { "sgn", NULL }, false },
  { "yhs", "Yan-nhaŋu Sign Language",             { "sgn", NULL }, false },
  { "ysl", "Yugoslavian Sign Language",           { "sgn", NULL }, false },
  { "ysm", "Myanmar Sign Language",               { "sgn", NULL }, false },
  { "yue", "Cantonese",                           { "zh", NULL },  false },
  { "zib", "Zimbabwe Sign Language",              { "sgn", NULL }, false },
  { "zlm", "Malay (individual language)",         { "ms", NULL },  false },
  { "zmi", "Negeri Sembilan Malay",               { "ms", NULL },  false },
  { "zsl", "Zambian Sign Language",               { "sgn", NULL }, false },
  { "zsm", "Standard Malay",                      { "ms", NULL },  false },
};

static extlang_variant_init_t s_variants_init[] = {
  { "1606nict", "Late Middle French (to 1606)",                                   { "frm", NULL },                                                                                                                                        false },
  { "1694acad", "Early Modern French",                                            { "fr", NULL },                                                                                                                                         false },
  { "1901",     "Traditional German orthography",                                 { "de", NULL },                                                                                                                                         false },
  { "1959acad", "\"Academic\" variant of Belarusian as codified in 1959",         { "be", NULL },                                                                                                                                         false },
  { "1994",     "Standardized Resian orthography",                                { "sl-rozaj", "sl-rozaj-biske", "sl-rozaj-njiva", "sl-rozaj-osojs", "sl-rozaj-solba", NULL },                                                           false },
  { "1996",     "German orthography of 1996",                                     { "de", NULL },                                                                                                                                         false },
  { "abl1943",  "Orthographic formulation of 1943 - Official in Brazil",          { "pt-BR", NULL },                                                                                                                                      false },
  { "akuapem",  "Akuapem Twi",                                                    { "tw", NULL },                                                                                                                                         false },
  { "alalc97",  "ALA-LC Romanization, 1997 edition",                              { NULL },                                                                                                                                               false },
  { "aluku",    "Boni dialect",                                                   { "djk", NULL },                                                                                                                                        false },
  { "ao1990",   "Portuguese Language Orthographic Agreement of 1990",             { "gl", "pt", NULL },                                                                                                                                   false },
  { "aranes",   "Aranese",                                                        { "oc", NULL },                                                                                                                                         false },
  { "arevela",  "Eastern Armenian",                                               { "hy", NULL },                                                                                                                                         true  },
  { "arevmda",  "Western Armenian",                                               { "hy", NULL },                                                                                                                                         true  },
  { "arkaika",  "Arkaika Esperanto",                                              { "eo", NULL },                                                                                                                                         false },
  { "asante",   "Ashanti Twi",                                                    { "tw", NULL },                                                                                                                                         false },
  { "auvern",   "Auvergnat",                                                      { "oc", NULL },                                                                                                                                         false },
  { "baku1926", "Unified Turkic Latin Alphabet (Historical)",                     { "az", "ba", "crh", "kk", "krc", "ky", "sah", "tk", "tt", "uz", NULL },                                                                                false },
  { "balanka",  "The Balanka dialect of Anii",                                    { "blo", NULL },                                                                                                                                        false },
  { "barla",    "The Barlavento dialect group of Kabuverdianu",                   { "kea", NULL },                                                                                                                                        false },
  { "basiceng", "Basic English",                                                  { "en", NULL },                                                                                                                                         false },
  { "bauddha",  "Buddhist Hybrid Sanskrit",                                       { "sa", NULL },                                                                                                                                         false },
  { "biscayan", "Biscayan dialect of Basque",                                     { "eu", NULL },                                                                                                                                         false },
  { "biske",    "The Bila dialect of Resian",                                     { "sl-rozaj", NULL },                                                                                                                                   false },
  { "bohoric",  "Slovene in Bohorič alphabet",                                    { "sl", NULL },                                                                                                                                         false },
  { "boont",    "Boontling",                                                      { "en", NULL },                                                                                                                                         false },
  { "bornholm", "Bornholmsk",                                                     { "da", NULL },                                                                                                                                         false },
  { "cisaup",   "Cisalpine",                                                      { "oc", NULL },                                                                                                                                         false },
  { "colb1945", "Portuguese-Brazilian Orthographic Convention of 1945",           { "pt", NULL },                                                                                                                                         false },
  { "cornu",    "Anglo-Cornish",                                                  { "en", NULL },                                                                                                                                         false },
  { "creiss",   "Occitan variants of the Croissant area",                         { "oc", NULL },                                                                                                                                         false },
  { "dajnko",   "Slovene in Dajnko alphabet",                                     { "sl", NULL },                                                                                                                                         false },
  { "ekavsk",   "Serbian with Ekavian pronunciation",                             { "sr", "sr-Cyrl", "sr-Latn", NULL },                                                                                                                   false },
  { "emodeng",  "Early Modern English (1500-1700)",                               { "en", NULL },                                                                                                                                         false },
  { "fonipa",   "International Phonetic Alphabet",                                { NULL },                                                                                                                                               false },
  { "fonkirsh", "Kirshenbaum Phonetic Alphabet",                                  { NULL },                                                                                                                                               false },
  { "fonnapa",  "Americanist Phonetic Notation",                                  { NULL },                                                                                                                                               false },
  { "fonupa",   "Uralic Phonetic Alphabet",                                       { NULL },                                                                                                                                               false },
  { "fonxsamp", "X-SAMPA transcription",                                          { NULL },                                                                                                                                               false },
  { "gallo",    "Gallo",                                                          { "fr", NULL },                                                                                                                                         false },
  { "gascon",   "Gascon",                                                         { "oc", NULL },                                                                                                                                         false },
  { "grclass",  "Classical Occitan orthography",                                  { "oc", "oc-aranes", "oc-auvern", "oc-cisaup", "oc-creiss", "oc-gascon", "oc-lemosin", "oc-lengadoc", "oc-nicard", "oc-provenc", "oc-vivaraup", NULL }, false },
  { "grital",   "Italian-inspired Occitan orthography",                           { "oc", "oc-cisaup", "oc-nicard", "oc-provenc", NULL },                                                                                                 false },
  { "grmistr",  "Mistralian or Mistralian-inspired Occitan orthography",          { "oc", "oc-aranes", "oc-auvern", "oc-cisaup", "oc-creiss", "oc-gascon", "oc-lemosin", "oc-lengadoc", "oc-nicard", "oc-provenc", "oc-vivaraup", NULL }, false },
  { "hepburn",  "Hepburn romanization",                                           { "ja-Latn", NULL },                                                                                                                                    false },
  { "heploc",   "Hepburn romanization, Library of Congress method",               { "ja-Latn-hepburn", NULL },                                                                                                                            true  },
  { "hognorsk", "Norwegian in Høgnorsk (High Norwegian) orthography",             { "nn", NULL },                                                                                                                                         false },
  { "hsistemo", "Standard H-system orthographic fallback for spelling Esperanto", { "eo", NULL },                                                                                                                                         false },
  { "ijekavsk", "Serbian with Ijekavian pronunciation",                           { "sr", "sr-Cyrl", "sr-Latn", NULL },                                                                                                                   false },
  { "itihasa",  "Epic Sanskrit",                                                  { "sa", NULL },                                                                                                                                         false },
  { "ivanchov", "Bulgarian in 1899 orthography",                                  { "bg", NULL },                                                                                                                                         false },
  { "jauer",    "Jauer dialect of Romansh",                                       { "rm", NULL },                                                                                                                                         false },
  { "jyutping", "Jyutping Cantonese Romanization",                                { "yue", NULL },                                                                                                                                        false },
  { "kkcor",    "Common Cornish orthography of Revived Cornish",                  { "kw", NULL },                                                                                                                                         false },
  { "kociewie", "The Kociewie dialect of Polish",                                 { "pl", NULL },                                                                                                                                         false },
  { "kscor",    "Kernowek Standard",                                              { "kw", NULL },                                                                                                                                         false },
  { "laukika",  "Classical Sanskrit",                                             { "sa", NULL },                                                                                                                                         false },
  { "lemosin",  "Limousin",                                                       { "oc", NULL },                                                                                                                                         false },
  { "lengadoc", "Languedocien",                                                   { "oc", NULL },                                                                                                                                         false },
  { "lipaw",    "The Lipovec dialect of Resian",                                  { "sl-rozaj", NULL },                                                                                                                                   false },
  { "luna1918", "Post-1917 Russian orthography",                                  { "ru", NULL },                                                                                                                                         false },
  { "metelko",  "Slovene in Metelko alphabet",                                    { "sl", NULL },                                                                                                                                         false },
  { "monoton",  "Monotonic Greek",                                                { "el", NULL },                                                                                                                                         false },
  { "ndyuka",   "Aukan dialect",                                                  { "djk", NULL },                                                                                                                                        false },
  { "nedis",    "Nadiza dialect",                                                 { "sl", NULL },                                                                                                                                         false },
  { "newfound", "Newfoundland English",                                           { "en-CA", NULL },                                                                                                                                      false },
  { "nicard",   "Niçard",                                                         { "oc", NULL },                                                                                                                                         false },
  { "njiva",    "The Njiva dialect of Resian",                                    { "sl-rozaj", NULL },                                                                                                                                   false },
  { "nulik",    "Modern Volapük",                                                 { "vo", NULL },                                                                                                                                         false },
  { "osojs",    "The Osojane dialect of Resian",                                  { "sl-rozaj", NULL },                                                                                                                                   false },
  { "oxendict", "Oxford English Dictionary spelling",                             { "en", NULL },                                                                                                                                         false },
  { "pahawh2",  "Pahawh Hmong Second Stage Reduced orthography",                  { "hnj", "mww", NULL },                                                                                                                                 false },
  { "pahawh3",  "Pahawh Hmong Third Stage Reduced orthography",                   { "hnj", "mww", NULL },                                                                                                                                 false },
  { "pahawh4",  "Pahawh Hmong Final Version orthography",                         { "hnj", "mww", NULL },                                                                                                                                 false },
  { "pamaka",   "Pamaka dialect",                                                 { "djk", NULL },                                                                                                                                        false },
  { "peano",    "Interlingua de Peano",                                           { "la", NULL },                                                                                                                                         false },
  { "petr1708", "Petrine orthography",                                            { "ru", NULL },                                                                                                                                         false },
  { "pinyin",   "Pinyin romanization",                                            { "bo-Latn", "zh-Latn", NULL },                                                                                                                         false },
  { "polyton",  "Polytonic Greek",                                                { "el", NULL },                                                                                                                                         false },
  { "provenc",  "Provençal",                                                      { "oc", NULL },                                                                                                                                         false },
  { "puter",    "Puter idiom of Romansh",                                         { "rm", NULL },                                                                                                                                         false },
  { "rigik",    "Classic Volapük",                                                { "vo", NULL },                                                                                                                                         false },
  { "rozaj",    "Rezijan",                                                        { "sl", NULL },                                                                                                                                         false },
  { "rumgr",    "Rumantsch Grischun",                                             { "rm", NULL },                                                                                                                                         false },
  { "scotland", "Scottish Standard English",                                      { "en", NULL },                                                                                                                                         false },
  { "scouse",   "Scouse",                                                         { "en", NULL },                                                                                                                                         false },
  { "simple",   "Simplified form",                                                { NULL },                                                                                                                                               false },
  { "solba",    "The Solbica dialect of Resian",                                  { "sl-rozaj", NULL },                                                                                                                                   false },
  { "sotav",    "The Sotavento dialect group of Kabuverdianu",                    { "kea", NULL },                                                                                                                                        false },
  { "spanglis", "Spanglish",                                                      { "en", "es", NULL },                                                                                                                                   false },
  { "surmiran", "Surmiran idiom of Romansh",                                      { "rm", NULL },                                                                                                                                         false },
  { "sursilv",  "Sursilvan idiom of Romansh",                                     { "rm", NULL },                                                                                                                                         false },
  { "sutsilv",  "Sutsilvan idiom of Romansh",                                     { "rm", NULL },                                                                                                                                         false },
  { "synnejyl", "South Jutish",                                                   { "da", NULL },                                                                                                                                         false },
  { "tarask",   "Belarusian in Taraskievica orthography",                         { "be", NULL },                                                                                                                                         false },
  { "tongyong", "Tongyong Pinyin romanization",                                   { "zh-Latn", NULL },                                                                                                                                    false },
  { "tunumiit", "Østgrønlandsk",                                                  { "kl", NULL },                                                                                                                                         false },
  { "uccor",    "Unified Cornish orthography of Revived Cornish",                 { "kw", NULL },                                                                                                                                         false },
  { "ucrcor",   "Unified Cornish Revised orthography of Revived Cornish",         { "kw", NULL },                                                                                                                                         false },
  { "ulster",   "Ulster dialect of Scots",                                        { "sco", NULL },                                                                                                                                        false },
  { "unifon",   "Unifon phonetic alphabet",                                       { "en", "hup", "kyh", "tol", "yur", NULL },                                                                                                             false },
  { "vaidika",  "Vedic Sanskrit",                                                 { "sa", NULL },                                                                                                                                         false },
  { "valencia", "Valencian",                                                      { "ca", NULL },                                                                                                                                         false },
  { "vallader", "Vallader idiom of Romansh",                                      { "rm", NULL },                                                                                                                                         false },
  { "vecdruka", "Latvian orthography used before 1920s (\"vecā druka\")",         { "lv", NULL },                                                                                                                                         false },
  { "vivaraup", "Vivaro-Alpine",                                                  { "oc", NULL },                                                                                                                                         false },
  { "wadegile", "Wade-Giles romanization",                                        { "zh-Latn", NULL },                                                                                                                                    false },
  { "xsistemo", "Standard X-system orthographic fallback for spelling Esperanto", { "eo", NULL },                                                                                                                                         false },
};

static extlang_variant_init_t s_grandfathered_init[] = {
  { "art-lojban",  "Lojban",                                                                                         { NULL }, true },
  { "cel-gaulish", "Gaulish",                                                                                        { NULL }, true },
  { "en-GB-oed",   "English, Oxford English Dictionary spelling",                                                    { NULL }, true },
  { "i-ami",       "Amis",                                                                                           { NULL }, true },
  { "i-bnn",       "Bunun",                                                                                          { NULL }, true },
  { "i-default",   "Default Language",                                                                               { NULL }, true },
  { "i-enochian",  "Enochian",                                                                                       { NULL }, true },
  { "i-hak",       "Hakka",                                                                                          { NULL }, true },
  { "i-klingon",   "Klingon",                                                                                        { NULL }, true },
  { "i-lux",       "Luxembourgish",                                                                                  { NULL }, true },
  { "i-mingo",     "Mingo",                                                                                          { NULL }, true },
  { "i-navajo",    "Navajo",                                                                                         { NULL }, true },
  { "i-pwn",       "Paiwan",                                                                                         { NULL }, true },
  { "i-tao",       "Tao",                                                                                            { NULL }, true },
  { "i-tay",       "Tayal",                                                                                          { NULL }, true },
  { "i-tsu",       "Tsou",                                                                                           { NULL }, true },
  { "no-bok",      "Norwegian Bokmal",                                                                               { NULL }, true },
  { "no-nyn",      "Norwegian Nynorsk",                                                                              { NULL }, true },
  { "sgn-BE-FR",   "Belgian-French Sign Language",                                                                   { NULL }, true },
  { "sgn-BE-NL",   "Belgian-Flemish Sign Language",                                                                  { NULL }, true },
  { "sgn-CH-DE",   "Swiss German Sign Language",                                                                     { NULL }, true },
  { "zh-guoyu",    "Mandarin or Standard Chinese",                                                                   { NULL }, true },
  { "zh-hakka",    "Hakka",                                                                                          { NULL }, true },
  { "zh-min",      "Min, Fuzhou, Hokkien, Amoy, or Taiwanese",                                                       { NULL }, true },
  { "zh-min-nan",  "Minnan, Hokkien, Amoy, Taiwanese, Southern Min, Southern Fujian, Hoklo, Southern Fukien, Ho-lo", { NULL }, true },
  { "zh-xiang",    "Xiang or Hunanese",                                                                              { NULL }, true },
};

static suppress_script_init_t s_suppress_scripts_init[] = {
  { "ab",  "Cyrl" },
  { "af",  "Latn" },
  { "am",  "Ethi" },
  { "ar",  "Arab" },
  { "as",  "Beng" },
  { "ay",  "Latn" },
  { "be",  "Cyrl" },
  { "bg",  "Cyrl" },
  { "bn",  "Beng" },
  { "bs",  "Latn" },
  { "ca",  "Latn" },
  { "ch",  "Latn" },
  { "cs",  "Latn" },
  { "cy",  "Latn" },
  { "da",  "Latn" },
  { "de",  "Latn" },
  { "dsb", "Latn" },
  { "dv",  "Thaa" },
  { "dz",  "Tibt" },
  { "el",  "Grek" },
  { "en",  "Latn" },
  { "eo",  "Latn" },
  { "es",  "Latn" },
  { "et",  "Latn" },
  { "eu",  "Latn" },
  { "fa",  "Arab" },
  { "fi",  "Latn" },
  { "fj",  "Latn" },
  { "fo",  "Latn" },
  { "fr",  "Latn" },
  { "frr", "Latn" },
  { "frs", "Latn" },
  { "fy",  "Latn" },
  { "ga",  "Latn" },
  { "gl",  "Latn" },
  { "gn",  "Latn" },
  { "gsw", "Latn" },
  { "gu",  "Gujr" },
  { "gv",  "Latn" },
  { "he",  "Hebr" },
  { "hi",  "Deva" },
  { "hr",  "Latn" },
  { "hsb", "Latn" },
  { "ht",  "Latn" },
  { "hu",  "Latn" },
  { "hy",  "Armn" },
  { "id",  "Latn" },
  { "in",  "Latn" },
  { "is",  "Latn" },
  { "it",  "Latn" },
  { "iw",  "Hebr" },
  { "ja",  "Jpan" },
  { "ka",  "Geor" },
  { "kk",  "Cyrl" },
  { "kl",  "Latn" },
  { "km",  "Khmr" },
  { "kn",  "Knda" },
  { "ko",  "Kore" },
  { "kok", "Deva" },
  { "la",  "Latn" },
  { "lb",  "Latn" },
  { "ln",  "Latn" },
  { "lo",  "Laoo" },
  { "lt",  "Latn" },
  { "lv",  "Latn" },
  { "mai", "Deva" },
  { "men", "Latn" },
  { "mg",  "Latn" },
  { "mh",  "Latn" },
  { "mk",  "Cyrl" },
  { "ml",  "Mlym" },
  { "mo",  "Latn" },
  { "mr",  "Deva" },
  { "ms",  "Latn" },
  { "mt",  "Latn" },
  { "my",  "Mymr" },
  { "na",  "Latn" },
  { "nb",  "Latn" },
  { "nd",  "Latn" },
  { "nds", "Latn" },
  { "ne",  "Deva" },
  { "niu", "Latn" },
  { "nl",  "Latn" },
  { "nn",  "Latn" },
  { "no",  "Latn" },
  { "nqo", "Nkoo" },
  { "nr",  "Latn" },
  { "nso", "Latn" },
  { "ny",  "Latn" },
  { "om",  "Latn" },
  { "or",  "Orya" },
  { "pa",  "Guru" },
  { "pl",  "Latn" },
  { "ps",  "Arab" },
  { "pt",  "Latn" },
  { "qu",  "Latn" },
  { "rm",  "Latn" },
  { "rn",  "Latn" },
  { "ro",  "Latn" },
  { "ru",  "Cyrl" },
  { "rw",  "Latn" },
  { "sg",  "Latn" },
  { "si",  "Sinh" },
  { "sk",  "Latn" },
  { "sl",  "Latn" },
  { "sm",  "Latn" },
  { "so",  "Latn" },
  { "sq",  "Latn" },
  { "ss",  "Latn" },
  { "st",  "Latn" },
  { "sv",  "Latn" },
  { "sw",  "Latn" },
  { "ta",  "Taml" },
  { "te",  "Telu" },
  { "tem", "Latn" },
  { "th",  "Thai" },
  { "ti",  "Ethi" },
  { "tkl", "Latn" },
  { "tl",  "Latn" },
  { "tmh", "Latn" },
  { "tn",  "Latn" },
  { "to",  "Latn" },
  { "tpi", "Latn" },
  { "tr",  "Latn" },
  { "ts",  "Latn" },
  { "tvl", "Latn" },
  { "uk",  "Cyrl" },
  { "ur",  "Arab" },
  { "ve",  "Latn" },
  { "vi",  "Latn" },
  { "xh",  "Latn" },
  { "yi",  "Hebr" },
  { "zbl", "Blis" },
  { "zu",  "Latn" },
};

static preferred_values_init_t s_preferred_values_init[] = {
  { { "ja-Latn-hepburn-heploc", NULL, NULL, }, { NULL,             NULL, "alalc97", } },
  { { "en-GB-oed",              NULL, NULL, }, { "en-GB-oxendict", NULL, NULL,      } },
  { { "sgn-BE-FR",              NULL, NULL, }, { "sfb",            NULL, NULL,      } },
  { { "sgn-BE-NL",              NULL, NULL, }, { "vgt",            NULL, NULL,      } },
  { { "sgn-CH-DE",              NULL, NULL, }, { "sgg",            NULL, NULL,      } },
  { { "zh-cmn-Hans",            NULL, NULL, }, { "cmn-Hans",       NULL, NULL,      } },
  { { "zh-cmn-Hant",            NULL, NULL, }, { "cmn-Hant",       NULL, NULL,      } },
  { { "zh-min-nan",             NULL, NULL, }, { "nan",            NULL, NULL,      } },
  { { "ar-aao",                 NULL, NULL, }, { "aao",            NULL, NULL,      } },
  { { "ar-abh",                 NULL, NULL, }, { "abh",            NULL, NULL,      } },
  { { "ar-abv",                 NULL, NULL, }, { "abv",            NULL, NULL,      } },
  { { "ar-acm",                 NULL, NULL, }, { "acm",            NULL, NULL,      } },
  { { "ar-acq",                 NULL, NULL, }, { "acq",            NULL, NULL,      } },
  { { "ar-acw",                 NULL, NULL, }, { "acw",            NULL, NULL,      } },
  { { "ar-acx",                 NULL, NULL, }, { "acx",            NULL, NULL,      } },
  { { "ar-acy",                 NULL, NULL, }, { "acy",            NULL, NULL,      } },
  { { "ar-adf",                 NULL, NULL, }, { "adf",            NULL, NULL,      } },
  { { "ar-aeb",                 NULL, NULL, }, { "aeb",            NULL, NULL,      } },
  { { "ar-aec",                 NULL, NULL, }, { "aec",            NULL, NULL,      } },
  { { "ar-afb",                 NULL, NULL, }, { "afb",            NULL, NULL,      } },
  { { "ar-ajp",                 NULL, NULL, }, { "ajp",            NULL, NULL,      } },
  { { "ar-apc",                 NULL, NULL, }, { "apc",            NULL, NULL,      } },
  { { "ar-apd",                 NULL, NULL, }, { "apd",            NULL, NULL,      } },
  { { "ar-arb",                 NULL, NULL, }, { "arb",            NULL, NULL,      } },
  { { "ar-arq",                 NULL, NULL, }, { "arq",            NULL, NULL,      } },
  { { "ar-ars",                 NULL, NULL, }, { "ars",            NULL, NULL,      } },
  { { "ar-ary",                 NULL, NULL, }, { "ary",            NULL, NULL,      } },
  { { "ar-arz",                 NULL, NULL, }, { "arz",            NULL, NULL,      } },
  { { "ar-auz",                 NULL, NULL, }, { "auz",            NULL, NULL,      } },
  { { "ar-avl",                 NULL, NULL, }, { "avl",            NULL, NULL,      } },
  { { "ar-ayh",                 NULL, NULL, }, { "ayh",            NULL, NULL,      } },
  { { "ar-ayl",                 NULL, NULL, }, { "ayl",            NULL, NULL,      } },
  { { "ar-ayn",                 NULL, NULL, }, { "ayn",            NULL, NULL,      } },
  { { "ar-ayp",                 NULL, NULL, }, { "ayp",            NULL, NULL,      } },
  { { "ar-bbz",                 NULL, NULL, }, { "bbz",            NULL, NULL,      } },
  { { "ar-pga",                 NULL, NULL, }, { "pga",            NULL, NULL,      } },
  { { "ar-shu",                 NULL, NULL, }, { "shu",            NULL, NULL,      } },
  { { "ar-ssh",                 NULL, NULL, }, { "ssh",            NULL, NULL,      } },
  { { "art-lojban",             NULL, NULL, }, { "jbo",            NULL, NULL,      } },
  { { "i-ami",                  NULL, NULL, }, { "ami",            NULL, NULL,      } },
  { { "i-bnn",                  NULL, NULL, }, { "bnn",            NULL, NULL,      } },
  { { "i-hak",                  NULL, NULL, }, { "hak",            NULL, NULL,      } },
  { { "i-klingon",              NULL, NULL, }, { "tlh",            NULL, NULL,      } },
  { { "i-lux",                  NULL, NULL, }, { "lb",             NULL, NULL,      } },
  { { "i-navajo",               NULL, NULL, }, { "nv",             NULL, NULL,      } },
  { { "i-pwn",                  NULL, NULL, }, { "pwn",            NULL, NULL,      } },
  { { "i-tao",                  NULL, NULL, }, { "tao",            NULL, NULL,      } },
  { { "i-tay",                  NULL, NULL, }, { "tay",            NULL, NULL,      } },
  { { "i-tsu",                  NULL, NULL, }, { "tsu",            NULL, NULL,      } },
  { { "kok-gom",                NULL, NULL, }, { "gom",            NULL, NULL,      } },
  { { "kok-knn",                NULL, NULL, }, { "knn",            NULL, NULL,      } },
  { { "lv-ltg",                 NULL, NULL, }, { "ltg",            NULL, NULL,      } },
  { { "lv-lvs",                 NULL, NULL, }, { "lvs",            NULL, NULL,      } },
  { { "ms-bjn",                 NULL, NULL, }, { "bjn",            NULL, NULL,      } },
  { { "ms-btj",                 NULL, NULL, }, { "btj",            NULL, NULL,      } },
  { { "ms-bve",                 NULL, NULL, }, { "bve",            NULL, NULL,      } },
  { { "ms-bvu",                 NULL, NULL, }, { "bvu",            NULL, NULL,      } },
  { { "ms-coa",                 NULL, NULL, }, { "coa",            NULL, NULL,      } },
  { { "ms-dup",                 NULL, NULL, }, { "dup",            NULL, NULL,      } },
  { { "ms-hji",                 NULL, NULL, }, { "hji",            NULL, NULL,      } },
  { { "ms-jak",                 NULL, NULL, }, { "jak",            NULL, NULL,      } },
  { { "ms-jax",                 NULL, NULL, }, { "jax",            NULL, NULL,      } },
  { { "ms-kvb",                 NULL, NULL, }, { "kvb",            NULL, NULL,      } },
  { { "ms-kvr",                 NULL, NULL, }, { "kvr",            NULL, NULL,      } },
  { { "ms-kxd",                 NULL, NULL, }, { "kxd",            NULL, NULL,      } },
  { { "ms-lce",                 NULL, NULL, }, { "lce",            NULL, NULL,      } },
  { { "ms-lcf",                 NULL, NULL, }, { "lcf",            NULL, NULL,      } },
  { { "ms-liw",                 NULL, NULL, }, { "liw",            NULL, NULL,      } },
  { { "ms-max",                 NULL, NULL, }, { "max",            NULL, NULL,      } },
  { { "ms-meo",                 NULL, NULL, }, { "meo",            NULL, NULL,      } },
  { { "ms-mfa",                 NULL, NULL, }, { "mfa",            NULL, NULL,      } },
  { { "ms-mfb",                 NULL, NULL, }, { "mfb",            NULL, NULL,      } },
  { { "ms-min",                 NULL, NULL, }, { "min",            NULL, NULL,      } },
  { { "ms-mqg",                 NULL, NULL, }, { "mqg",            NULL, NULL,      } },
  { { "ms-msi",                 NULL, NULL, }, { "msi",            NULL, NULL,      } },
  { { "ms-mui",                 NULL, NULL, }, { "mui",            NULL, NULL,      } },
  { { "ms-orn",                 NULL, NULL, }, { "orn",            NULL, NULL,      } },
  { { "ms-ors",                 NULL, NULL, }, { "ors",            NULL, NULL,      } },
  { { "ms-pel",                 NULL, NULL, }, { "pel",            NULL, NULL,      } },
  { { "ms-pse",                 NULL, NULL, }, { "pse",            NULL, NULL,      } },
  { { "ms-tmw",                 NULL, NULL, }, { "tmw",            NULL, NULL,      } },
  { { "ms-urk",                 NULL, NULL, }, { "urk",            NULL, NULL,      } },
  { { "ms-vkk",                 NULL, NULL, }, { "vkk",            NULL, NULL,      } },
  { { "ms-vkt",                 NULL, NULL, }, { "vkt",            NULL, NULL,      } },
  { { "ms-xmm",                 NULL, NULL, }, { "xmm",            NULL, NULL,      } },
  { { "ms-zlm",                 NULL, NULL, }, { "zlm",            NULL, NULL,      } },
  { { "ms-zmi",                 NULL, NULL, }, { "zmi",            NULL, NULL,      } },
  { { "ms-zsm",                 NULL, NULL, }, { "zsm",            NULL, NULL,      } },
  { { "no-bok",                 NULL, NULL, }, { "nb",             NULL, NULL,      } },
  { { "no-nyn",                 NULL, NULL, }, { "nn",             NULL, NULL,      } },
  { { "sgn-ads",                NULL, NULL, }, { "ads",            NULL, NULL,      } },
  { { "sgn-aed",                NULL, NULL, }, { "aed",            NULL, NULL,      } },
  { { "sgn-aen",                NULL, NULL, }, { "aen",            NULL, NULL,      } },
  { { "sgn-afg",                NULL, NULL, }, { "afg",            NULL, NULL,      } },
  { { "sgn-ajs",                NULL, NULL, }, { "ajs",            NULL, NULL,      } },
  { { "sgn-ase",                NULL, NULL, }, { "ase",            NULL, NULL,      } },
  { { "sgn-asf",                NULL, NULL, }, { "asf",            NULL, NULL,      } },
  { { "sgn-asp",                NULL, NULL, }, { "asp",            NULL, NULL,      } },
  { { "sgn-asq",                NULL, NULL, }, { "asq",            NULL, NULL,      } },
  { { "sgn-asw",                NULL, NULL, }, { "asw",            NULL, NULL,      } },
  { { "sgn-bfi",                NULL, NULL, }, { "bfi",            NULL, NULL,      } },
  { { "sgn-bfk",                NULL, NULL, }, { "bfk",            NULL, NULL,      } },
  { { "sgn-bog",                NULL, NULL, }, { "bog",            NULL, NULL,      } },
  { { "sgn-bqn",                NULL, NULL, }, { "bqn",            NULL, NULL,      } },
  { { "sgn-bqy",                NULL, NULL, }, { "bqy",            NULL, NULL,      } },
  { { "sgn-BR",                 NULL, NULL, }, { "bzs",            NULL, NULL,      } },
  { { "sgn-bvl",                NULL, NULL, }, { "bvl",            NULL, NULL,      } },
  { { "sgn-bzs",                NULL, NULL, }, { "bzs",            NULL, NULL,      } },
  { { "sgn-cds",                NULL, NULL, }, { "cds",            NULL, NULL,      } },
  { { "sgn-CO",                 NULL, NULL, }, { "csn",            NULL, NULL,      } },
  { { "sgn-csc",                NULL, NULL, }, { "csc",            NULL, NULL,      } },
  { { "sgn-csd",                NULL, NULL, }, { "csd",            NULL, NULL,      } },
  { { "sgn-cse",                NULL, NULL, }, { "cse",            NULL, NULL,      } },
  { { "sgn-csf",                NULL, NULL, }, { "csf",            NULL, NULL,      } },
  { { "sgn-csg",                NULL, NULL, }, { "csg",            NULL, NULL,      } },
  { { "sgn-csl",                NULL, NULL, }, { "csl",            NULL, NULL,      } },
  { { "sgn-csn",                NULL, NULL, }, { "csn",            NULL, NULL,      } },
  { { "sgn-csq",                NULL, NULL, }, { "csq",            NULL, NULL,      } },
  { { "sgn-csr",                NULL, NULL, }, { "csr",            NULL, NULL,      } },
  { { "sgn-csx",                NULL, NULL, }, { "csx",            NULL, NULL,      } },
  { { "sgn-DE",                 NULL, NULL, }, { "gsg",            NULL, NULL,      } },
  { { "sgn-DK",                 NULL, NULL, }, { "dsl",            NULL, NULL,      } },
  { { "sgn-doq",                NULL, NULL, }, { "doq",            NULL, NULL,      } },
  { { "sgn-dse",                NULL, NULL, }, { "dse",            NULL, NULL,      } },
  { { "sgn-dsl",                NULL, NULL, }, { "dsl",            NULL, NULL,      } },
  { { "sgn-dsz",                NULL, NULL, }, { "dsz",            NULL, NULL,      } },
  { { "sgn-ecs",                NULL, NULL, }, { "ecs",            NULL, NULL,      } },
  { { "sgn-ehs",                NULL, NULL, }, { "ehs",            NULL, NULL,      } },
  { { "sgn-ES",                 NULL, NULL, }, { "ssp",            NULL, NULL,      } },
  { { "sgn-esl",                NULL, NULL, }, { "esl",            NULL, NULL,      } },
  { { "sgn-esn",                NULL, NULL, }, { "esn",            NULL, NULL,      } },
  { { "sgn-eso",                NULL, NULL, }, { "eso",            NULL, NULL,      } },
  { { "sgn-eth",                NULL, NULL, }, { "eth",            NULL, NULL,      } },
  { { "sgn-fcs",                NULL, NULL, }, { "fcs",            NULL, NULL,      } },
  { { "sgn-FR",                 NULL, NULL, }, { "fsl",            NULL, NULL,      } },
  { { "sgn-fse",                NULL, NULL, }, { "fse",            NULL, NULL,      } },
  { { "sgn-fsl",                NULL, NULL, }, { "fsl",            NULL, NULL,      } },
  { { "sgn-fss",                NULL, NULL, }, { "fss",            NULL, NULL,      } },
  { { "sgn-GB",                 NULL, NULL, }, { "bfi",            NULL, NULL,      } },
  { { "sgn-gds",                NULL, NULL, }, { "gds",            NULL, NULL,      } },
  { { "sgn-GR",                 NULL, NULL, }, { "gss",            NULL, NULL,      } },
  { { "sgn-gse",                NULL, NULL, }, { "gse",            NULL, NULL,      } },
  { { "sgn-gsg",                NULL, NULL, }, { "gsg",            NULL, NULL,      } },
  { { "sgn-gsm",                NULL, NULL, }, { "gsm",            NULL, NULL,      } },
  { { "sgn-gss",                NULL, NULL, }, { "gss",            NULL, NULL,      } },
  { { "sgn-gus",                NULL, NULL, }, { "gus",            NULL, NULL,      } },
  { { "sgn-hab",                NULL, NULL, }, { "hab",            NULL, NULL,      } },
  { { "sgn-haf",                NULL, NULL, }, { "haf",            NULL, NULL,      } },
  { { "sgn-hds",                NULL, NULL, }, { "hds",            NULL, NULL,      } },
  { { "sgn-hks",                NULL, NULL, }, { "hks",            NULL, NULL,      } },
  { { "sgn-hos",                NULL, NULL, }, { "hos",            NULL, NULL,      } },
  { { "sgn-hps",                NULL, NULL, }, { "hps",            NULL, NULL,      } },
  { { "sgn-hsh",                NULL, NULL, }, { "hsh",            NULL, NULL,      } },
  { { "sgn-hsl",                NULL, NULL, }, { "hsl",            NULL, NULL,      } },
  { { "sgn-icl",                NULL, NULL, }, { "icl",            NULL, NULL,      } },
  { { "sgn-IE",                 NULL, NULL, }, { "isg",            NULL, NULL,      } },
  { { "sgn-iks",                NULL, NULL, }, { "iks",            NULL, NULL,      } },
  { { "sgn-ils",                NULL, NULL, }, { "ils",            NULL, NULL,      } },
  { { "sgn-inl",                NULL, NULL, }, { "inl",            NULL, NULL,      } },
  { { "sgn-ins",                NULL, NULL, }, { "ins",            NULL, NULL,      } },
  { { "sgn-ise",                NULL, NULL, }, { "ise",            NULL, NULL,      } },
  { { "sgn-isg",                NULL, NULL, }, { "isg",            NULL, NULL,      } },
  { { "sgn-isr",                NULL, NULL, }, { "isr",            NULL, NULL,      } },
  { { "sgn-IT",                 NULL, NULL, }, { "ise",            NULL, NULL,      } },
  { { "sgn-jcs",                NULL, NULL, }, { "jcs",            NULL, NULL,      } },
  { { "sgn-jhs",                NULL, NULL, }, { "jhs",            NULL, NULL,      } },
  { { "sgn-jks",                NULL, NULL, }, { "jks",            NULL, NULL,      } },
  { { "sgn-jls",                NULL, NULL, }, { "jls",            NULL, NULL,      } },
  { { "sgn-jos",                NULL, NULL, }, { "jos",            NULL, NULL,      } },
  { { "sgn-JP",                 NULL, NULL, }, { "jsl",            NULL, NULL,      } },
  { { "sgn-jsl",                NULL, NULL, }, { "jsl",            NULL, NULL,      } },
  { { "sgn-jus",                NULL, NULL, }, { "jus",            NULL, NULL,      } },
  { { "sgn-kgi",                NULL, NULL, }, { "kgi",            NULL, NULL,      } },
  { { "sgn-kvk",                NULL, NULL, }, { "kvk",            NULL, NULL,      } },
  { { "sgn-lbs",                NULL, NULL, }, { "lbs",            NULL, NULL,      } },
  { { "sgn-lls",                NULL, NULL, }, { "lls",            NULL, NULL,      } },
  { { "sgn-lsb",                NULL, NULL, }, { "lsb",            NULL, NULL,      } },
  { { "sgn-lsc",                NULL, NULL, }, { "lsc",            NULL, NULL,      } },
  { { "sgn-lsg",                NULL, NULL, }, { "lsg",            NULL, NULL,      } },
  { { "sgn-lsl",                NULL, NULL, }, { "lsl",            NULL, NULL,      } },
  { { "sgn-lsn",                NULL, NULL, }, { "lsn",            NULL, NULL,      } },
  { { "sgn-lso",                NULL, NULL, }, { "lso",            NULL, NULL,      } },
  { { "sgn-lsp",                NULL, NULL, }, { "lsp",            NULL, NULL,      } },
  { { "sgn-lst",                NULL, NULL, }, { "lst",            NULL, NULL,      } },
  { { "sgn-lsv",                NULL, NULL, }, { "lsv",            NULL, NULL,      } },
  { { "sgn-lsw",                NULL, NULL, }, { "lsw",            NULL, NULL,      } },
  { { "sgn-lsy",                NULL, NULL, }, { "lsy",            NULL, NULL,      } },
  { { "sgn-lws",                NULL, NULL, }, { "lws",            NULL, NULL,      } },
  { { "sgn-mdl",                NULL, NULL, }, { "mdl",            NULL, NULL,      } },
  { { "sgn-mfs",                NULL, NULL, }, { "mfs",            NULL, NULL,      } },
  { { "sgn-mre",                NULL, NULL, }, { "mre",            NULL, NULL,      } },
  { { "sgn-msd",                NULL, NULL, }, { "msd",            NULL, NULL,      } },
  { { "sgn-msr",                NULL, NULL, }, { "msr",            NULL, NULL,      } },
  { { "sgn-MX",                 NULL, NULL, }, { "mfs",            NULL, NULL,      } },
  { { "sgn-mzc",                NULL, NULL, }, { "mzc",            NULL, NULL,      } },
  { { "sgn-mzg",                NULL, NULL, }, { "mzg",            NULL, NULL,      } },
  { { "sgn-mzy",                NULL, NULL, }, { "mzy",            NULL, NULL,      } },
  { { "sgn-nbs",                NULL, NULL, }, { "nbs",            NULL, NULL,      } },
  { { "sgn-ncs",                NULL, NULL, }, { "ncs",            NULL, NULL,      } },
  { { "sgn-NI",                 NULL, NULL, }, { "ncs",            NULL, NULL,      } },
  { { "sgn-NL",                 NULL, NULL, }, { "dse",            NULL, NULL,      } },
  { { "sgn-NO",                 NULL, NULL, }, { "nsl",            NULL, NULL,      } },
  { { "sgn-nsi",                NULL, NULL, }, { "nsi",            NULL, NULL,      } },
  { { "sgn-nsl",                NULL, NULL, }, { "nsl",            NULL, NULL,      } },
  { { "sgn-nsp",                NULL, NULL, }, { "nsp",            NULL, NULL,      } },
  { { "sgn-nsr",                NULL, NULL, }, { "nsr",            NULL, NULL,      } },
  { { "sgn-nzs",                NULL, NULL, }, { "nzs",            NULL, NULL,      } },
  { { "sgn-okl",                NULL, NULL, }, { "okl",            NULL, NULL,      } },
  { { "sgn-pgz",                NULL, NULL, }, { "pgz",            NULL, NULL,      } },
  { { "sgn-pks",                NULL, NULL, }, { "pks",            NULL, NULL,      } },
  { { "sgn-prl",                NULL, NULL, }, { "prl",            NULL, NULL,      } },
  { { "sgn-prz",                NULL, NULL, }, { "prz",            NULL, NULL,      } },
  { { "sgn-psc",                NULL, NULL, }, { "psc",            NULL, NULL,      } },
  { { "sgn-psd",                NULL, NULL, }, { "psd",            NULL, NULL,      } },
  { { "sgn-psg",                NULL, NULL, }, { "psg",            NULL, NULL,      } },
  { { "sgn-psl",                NULL, NULL, }, { "psl",            NULL, NULL,      } },
  { { "sgn-pso",                NULL, NULL, }, { "pso",            NULL, NULL,      } },
  { { "sgn-psp",                NULL, NULL, }, { "psp",            NULL, NULL,      } },
  { { "sgn-psr",                NULL, NULL, }, { "psr",            NULL, NULL,      } },
  { { "sgn-PT",                 NULL, NULL, }, { "psr",            NULL, NULL,      } },
  { { "sgn-pys",                NULL, NULL, }, { "pys",            NULL, NULL,      } },
  { { "sgn-rib",                NULL, NULL, }, { "rib",            NULL, NULL,      } },
  { { "sgn-rms",                NULL, NULL, }, { "rms",            NULL, NULL,      } },
  { { "sgn-rnb",                NULL, NULL, }, { "rnb",            NULL, NULL,      } },
  { { "sgn-rsi",                NULL, NULL, }, { "rsi",            NULL, NULL,      } },
  { { "sgn-rsl",                NULL, NULL, }, { "rsl",            NULL, NULL,      } },
  { { "sgn-rsm",                NULL, NULL, }, { "rsm",            NULL, NULL,      } },
  { { "sgn-rsn",                NULL, NULL, }, { "rsn",            NULL, NULL,      } },
  { { "sgn-sdl",                NULL, NULL, }, { "sdl",            NULL, NULL,      } },
  { { "sgn-SE",                 NULL, NULL, }, { "swl",            NULL, NULL,      } },
  { { "sgn-sfb",                NULL, NULL, }, { "sfb",            NULL, NULL,      } },
  { { "sgn-sfs",                NULL, NULL, }, { "sfs",            NULL, NULL,      } },
  { { "sgn-sgg",                NULL, NULL, }, { "sgg",            NULL, NULL,      } },
  { { "sgn-sgx",                NULL, NULL, }, { "sgx",            NULL, NULL,      } },
  { { "sgn-slf",                NULL, NULL, }, { "slf",            NULL, NULL,      } },
  { { "sgn-sls",                NULL, NULL, }, { "sls",            NULL, NULL,      } },
  { { "sgn-sqk",                NULL, NULL, }, { "sqk",            NULL, NULL,      } },
  { { "sgn-sqs",                NULL, NULL, }, { "sqs",            NULL, NULL,      } },
  { { "sgn-sqx",                NULL, NULL, }, { "sqx",            NULL, NULL,      } },
  { { "sgn-ssp",                NULL, NULL, }, { "ssp",            NULL, NULL,      } },
  { { "sgn-ssr",                NULL, NULL, }, { "ssr",            NULL, NULL,      } },
  { { "sgn-svk",                NULL, NULL, }, { "svk",            NULL, NULL,      } },
  { { "sgn-swl",                NULL, NULL, }, { "swl",            NULL, NULL,      } },
  { { "sgn-syy",                NULL, NULL, }, { "syy",            NULL, NULL,      } },
  { { "sgn-szs",                NULL, NULL, }, { "szs",            NULL, NULL,      } },
  { { "sgn-tse",                NULL, NULL, }, { "tse",            NULL, NULL,      } },
  { { "sgn-tsm",                NULL, NULL, }, { "tsm",            NULL, NULL,      } },
  { { "sgn-tsq",                NULL, NULL, }, { "tsq",            NULL, NULL,      } },
  { { "sgn-tss",                NULL, NULL, }, { "tss",            NULL, NULL,      } },
  { { "sgn-tsy",                NULL, NULL, }, { "tsy",            NULL, NULL,      } },
  { { "sgn-tza",                NULL, NULL, }, { "tza",            NULL, NULL,      } },
  { { "sgn-ugn",                NULL, NULL, }, { "ugn",            NULL, NULL,      } },
  { { "sgn-ugy",                NULL, NULL, }, { "ugy",            NULL, NULL,      } },
  { { "sgn-ukl",                NULL, NULL, }, { "ukl",            NULL, NULL,      } },
  { { "sgn-uks",                NULL, NULL, }, { "uks",            NULL, NULL,      } },
  { { "sgn-US",                 NULL, NULL, }, { "ase",            NULL, NULL,      } },
  { { "sgn-vgt",                NULL, NULL, }, { "vgt",            NULL, NULL,      } },
  { { "sgn-vsi",                NULL, NULL, }, { "vsi",            NULL, NULL,      } },
  { { "sgn-vsl",                NULL, NULL, }, { "vsl",            NULL, NULL,      } },
  { { "sgn-vsv",                NULL, NULL, }, { "vsv",            NULL, NULL,      } },
  { { "sgn-wbs",                NULL, NULL, }, { "wbs",            NULL, NULL,      } },
  { { "sgn-xki",                NULL, NULL, }, { "xki",            NULL, NULL,      } },
  { { "sgn-xml",                NULL, NULL, }, { "xml",            NULL, NULL,      } },
  { { "sgn-xms",                NULL, NULL, }, { "xms",            NULL, NULL,      } },
  { { "sgn-yds",                NULL, NULL, }, { "yds",            NULL, NULL,      } },
  { { "sgn-ygs",                NULL, NULL, }, { "ygs",            NULL, NULL,      } },
  { { "sgn-yhs",                NULL, NULL, }, { "yhs",            NULL, NULL,      } },
  { { "sgn-ysl",                NULL, NULL, }, { "ysl",            NULL, NULL,      } },
  { { "sgn-ysm",                NULL, NULL, }, { "ysm",            NULL, NULL,      } },
  { { "sgn-ZA",                 NULL, NULL, }, { "sfs",            NULL, NULL,      } },
  { { "sgn-zib",                NULL, NULL, }, { "zib",            NULL, NULL,      } },
  { { "sgn-zsl",                NULL, NULL, }, { "zsl",            NULL, NULL,      } },
  { { "sw-swc",                 NULL, NULL, }, { "swc",            NULL, NULL,      } },
  { { "sw-swh",                 NULL, NULL, }, { "swh",            NULL, NULL,      } },
  { { "uz-uzn",                 NULL, NULL, }, { "uzn",            NULL, NULL,      } },
  { { "uz-uzs",                 NULL, NULL, }, { "uzs",            NULL, NULL,      } },
  { { "zh-cdo",                 NULL, NULL, }, { "cdo",            NULL, NULL,      } },
  { { "zh-cjy",                 NULL, NULL, }, { "cjy",            NULL, NULL,      } },
  { { "zh-cmn",                 NULL, NULL, }, { "cmn",            NULL, NULL,      } },
  { { "zh-cmn",                 NULL, NULL, }, { "cmn",            NULL, NULL,      } },
  { { "zh-cnp",                 NULL, NULL, }, { "cnp",            NULL, NULL,      } },
  { { "zh-cpx",                 NULL, NULL, }, { "cpx",            NULL, NULL,      } },
  { { "zh-csp",                 NULL, NULL, }, { "csp",            NULL, NULL,      } },
  { { "zh-czh",                 NULL, NULL, }, { "czh",            NULL, NULL,      } },
  { { "zh-czo",                 NULL, NULL, }, { "czo",            NULL, NULL,      } },
  { { "zh-gan",                 NULL, NULL, }, { "gan",            NULL, NULL,      } },
  { { "zh-gan",                 NULL, NULL, }, { "gan",            NULL, NULL,      } },
  { { "zh-guoyu",               NULL, NULL, }, { "cmn",            NULL, NULL,      } },
  { { "zh-hak",                 NULL, NULL, }, { "hak",            NULL, NULL,      } },
  { { "zh-hakka",               NULL, NULL, }, { "hak",            NULL, NULL,      } },
  { { "zh-hsn",                 NULL, NULL, }, { "hsn",            NULL, NULL,      } },
  { { "zh-lzh",                 NULL, NULL, }, { "lzh",            NULL, NULL,      } },
  { { "zh-mnp",                 NULL, NULL, }, { "mnp",            NULL, NULL,      } },
  { { "zh-nan",                 NULL, NULL, }, { "nan",            NULL, NULL,      } },
  { { "zh-wuu",                 NULL, NULL, }, { "wuu",            NULL, NULL,      } },
  { { "zh-wuu",                 NULL, NULL, }, { "wuu",            NULL, NULL,      } },
  { { "zh-xiang",               NULL, NULL, }, { "hsn",            NULL, NULL,      } },
  { { "zh-yue",                 NULL, NULL, }, { "yue",            NULL, NULL,      } },
  { { "zh-yue",                 NULL, NULL, }, { "yue",            NULL, NULL,      } },
  { { "aam",                    NULL, NULL, }, { "aas",            NULL, NULL,      } },
  { { "adp",                    NULL, NULL, }, { "dz",             NULL, NULL,      } },
  { { "ajt",                    NULL, NULL, }, { "aeb",            NULL, NULL,      } },
  { { "asd",                    NULL, NULL, }, { "snz",            NULL, NULL,      } },
  { { "aue",                    NULL, NULL, }, { "ktz",            NULL, NULL,      } },
  { { "ayx",                    NULL, NULL, }, { "nun",            NULL, NULL,      } },
  { { "bgm",                    NULL, NULL, }, { "bcg",            NULL, NULL,      } },
  { { "bic",                    NULL, NULL, }, { "bir",            NULL, NULL,      } },
  { { "bjd",                    NULL, NULL, }, { "drl",            NULL, NULL,      } },
  { { "blg",                    NULL, NULL, }, { "iba",            NULL, NULL,      } },
  { { NULL,                     "BU", NULL, }, { NULL,             "MM", NULL,      } },
  { { "ccq",                    NULL, NULL, }, { "rki",            NULL, NULL,      } },
  { { "cjr",                    NULL, NULL, }, { "mom",            NULL, NULL,      } },
  { { "cka",                    NULL, NULL, }, { "cmr",            NULL, NULL,      } },
  { { "cmk",                    NULL, NULL, }, { "xch",            NULL, NULL,      } },
  { { "coy",                    NULL, NULL, }, { "pij",            NULL, NULL,      } },
  { { "cqu",                    NULL, NULL, }, { "quh",            NULL, NULL,      } },
  { { NULL,                     "DD", NULL, }, { NULL,             "DE", NULL,      } },
  { { "dit",                    NULL, NULL, }, { "dif",            NULL, NULL,      } },
  { { "drh",                    NULL, NULL, }, { "khk",            NULL, NULL,      } },
  { { "drr",                    NULL, NULL, }, { "kzk",            NULL, NULL,      } },
  { { "drw",                    NULL, NULL, }, { "prs",            NULL, NULL,      } },
  { { NULL,                     "FX", NULL, }, { NULL,             "FR", NULL,      } },
  { { "gav",                    NULL, NULL, }, { "dev",            NULL, NULL,      } },
  { { "gfx",                    NULL, NULL, }, { "vaj",            NULL, NULL,      } },
  { { "ggn",                    NULL, NULL, }, { "gvr",            NULL, NULL,      } },
  { { "gli",                    NULL, NULL, }, { "kzk",            NULL, NULL,      } },
  { { "gti",                    NULL, NULL, }, { "nyc",            NULL, NULL,      } },
  { { "guv",                    NULL, NULL, }, { "duz",            NULL, NULL,      } },
  { { "hrr",                    NULL, NULL, }, { "jal",            NULL, NULL,      } },
  { { "ibi",                    NULL, NULL, }, { "opa",            NULL, NULL,      } },
  { { "ilw",                    NULL, NULL, }, { "gal",            NULL, NULL,      } },
  { { "in",                     NULL, NULL, }, { "id",             NULL, NULL,      } },
  { { "iw",                     NULL, NULL, }, { "he",             NULL, NULL,      } },
  { { "jeg",                    NULL, NULL, }, { "oyb",            NULL, NULL,      } },
  { { "ji",                     NULL, NULL, }, { "yi",             NULL, NULL,      } },
  { { "jw",                     NULL, NULL, }, { "jv",             NULL, NULL,      } },
  { { "kgc",                    NULL, NULL, }, { "tdf",            NULL, NULL,      } },
  { { "kgh",                    NULL, NULL, }, { "kml",            NULL, NULL,      } },
  { { "koj",                    NULL, NULL, }, { "kwv",            NULL, NULL,      } },
  { { "krm",                    NULL, NULL, }, { "bmf",            NULL, NULL,      } },
  { { "ktr",                    NULL, NULL, }, { "dtp",            NULL, NULL,      } },
  { { "kvs",                    NULL, NULL, }, { "gdj",            NULL, NULL,      } },
  { { "kwq",                    NULL, NULL, }, { "yam",            NULL, NULL,      } },
  { { "kxe",                    NULL, NULL, }, { "tvd",            NULL, NULL,      } },
  { { "kxl",                    NULL, NULL, }, { "kru",            NULL, NULL,      } },
  { { "kzj",                    NULL, NULL, }, { "dtp",            NULL, NULL,      } },
  { { "kzt",                    NULL, NULL, }, { "dtp",            NULL, NULL,      } },
  { { "lak",                    NULL, NULL, }, { "ksp",            NULL, NULL,      } },
  { { "lii",                    NULL, NULL, }, { "raq",            NULL, NULL,      } },
  { { "llo",                    NULL, NULL, }, { "ngt",            NULL, NULL,      } },
  { { "lmm",                    NULL, NULL, }, { "rmx",            NULL, NULL,      } },
  { { "meg",                    NULL, NULL, }, { "cir",            NULL, NULL,      } },
  { { "mo",                     NULL, NULL, }, { "ro",             NULL, NULL,      } },
  { { "mst",                    NULL, NULL, }, { "mry",            NULL, NULL,      } },
  { { "mwj",                    NULL, NULL, }, { "vaj",            NULL, NULL,      } },
  { { "myd",                    NULL, NULL, }, { "aog",            NULL, NULL,      } },
  { { "myt",                    NULL, NULL, }, { "mry",            NULL, NULL,      } },
  { { "nad",                    NULL, NULL, }, { "xny",            NULL, NULL,      } },
  { { "ncp",                    NULL, NULL, }, { "kdz",            NULL, NULL,      } },
  { { "nns",                    NULL, NULL, }, { "nbr",            NULL, NULL,      } },
  { { "nnx",                    NULL, NULL, }, { "ngv",            NULL, NULL,      } },
  { { "nts",                    NULL, NULL, }, { "pij",            NULL, NULL,      } },
  { { "nxu",                    NULL, NULL, }, { "bpp",            NULL, NULL,      } },
  { { "oun",                    NULL, NULL, }, { "vaj",            NULL, NULL,      } },
  { { "pat",                    NULL, NULL, }, { "kxr",            NULL, NULL,      } },
  { { "pcr",                    NULL, NULL, }, { "adx",            NULL, NULL,      } },
  { { "pmc",                    NULL, NULL, }, { "huw",            NULL, NULL,      } },
  { { "pmu",                    NULL, NULL, }, { "phr",            NULL, NULL,      } },
  { { "ppa",                    NULL, NULL, }, { "bfy",            NULL, NULL,      } },
  { { "ppr",                    NULL, NULL, }, { "lcq",            NULL, NULL,      } },
  { { "pry",                    NULL, NULL, }, { "prt",            NULL, NULL,      } },
  { { "puz",                    NULL, NULL, }, { "pub",            NULL, NULL,      } },
  { { "sca",                    NULL, NULL, }, { "hle",            NULL, NULL,      } },
  { { "skk",                    NULL, NULL, }, { "oyb",            NULL, NULL,      } },
  { { "smd",                    NULL, NULL, }, { "kmb",            NULL, NULL,      } },
  { { "snb",                    NULL, NULL, }, { "iba",            NULL, NULL,      } },
  { { "tdu",                    NULL, NULL, }, { "dtp",            NULL, NULL,      } },
  { { "thc",                    NULL, NULL, }, { "tpo",            NULL, NULL,      } },
  { { "thw",                    NULL, NULL, }, { "ola",            NULL, NULL,      } },
  { { "thx",                    NULL, NULL, }, { "oyb",            NULL, NULL,      } },
  { { "tie",                    NULL, NULL, }, { "ras",            NULL, NULL,      } },
  { { "tkk",                    NULL, NULL, }, { "twm",            NULL, NULL,      } },
  { { "tlw",                    NULL, NULL, }, { "weo",            NULL, NULL,      } },
  { { "tmp",                    NULL, NULL, }, { "tyj",            NULL, NULL,      } },
  { { "tne",                    NULL, NULL, }, { "kak",            NULL, NULL,      } },
  { { "tnf",                    NULL, NULL, }, { "prs",            NULL, NULL,      } },
  { { NULL,                     "TP", NULL, }, { NULL,             "TL", NULL,      } },
  { { "tsf",                    NULL, NULL, }, { "taj",            NULL, NULL,      } },
  { { "uok",                    NULL, NULL, }, { "ema",            NULL, NULL,      } },
  { { "xba",                    NULL, NULL, }, { "cax",            NULL, NULL,      } },
  { { "xia",                    NULL, NULL, }, { "acn",            NULL, NULL,      } },
  { { "xkh",                    NULL, NULL, }, { "waw",            NULL, NULL,      } },
  { { "xrq",                    NULL, NULL, }, { "dmw",            NULL, NULL,      } },
  { { "ybd",                    NULL, NULL, }, { "rki",            NULL, NULL,      } },
  { { NULL,                     "YD", NULL, }, { NULL,             "YE", NULL,      } },
  { { "yma",                    NULL, NULL, }, { "lrr",            NULL, NULL,      } },
  { { "ymt",                    NULL, NULL, }, { "mtm",            NULL, NULL,      } },
  { { "yos",                    NULL, NULL, }, { "zom",            NULL, NULL,      } },
  { { "yuu",                    NULL, NULL, }, { "yug",            NULL, NULL,      } },
  { { "zir",                    NULL, NULL, }, { "scv",            NULL, NULL,      } },
  { { NULL,                     "ZR", NULL, }, { NULL,             "CD", NULL,      } },
  { { "QMS",                    NULL, NULL, }, { "cmn-Hans",       NULL, NULL,      } },
  { { "QMT",                    NULL, NULL, }, { "cmn-Hant",       NULL, NULL,      } },
  { { "QTM",                    NULL, NULL, }, { "cmn-TW",         NULL, NULL,      } },
  { { "QFC",                    NULL, NULL, }, { "fr-CA",          NULL, NULL,      } },
  { { "QBP",                    NULL, NULL, }, { "pt-BR",          NULL, NULL,      } },
  { { "QSA",                    NULL, NULL, }, { "es-AR",          NULL, NULL,      } },
  { { "QSB",                    NULL, NULL, }, { "es-BO",          NULL, NULL,      } },
  { { "QCL",                    NULL, NULL, }, { "es-CL",          NULL, NULL,      } },
  { { "QCO",                    NULL, NULL, }, { "es-CO",          NULL, NULL,      } },
  { { "QCA",                    NULL, NULL, }, { "es-CR",          NULL, NULL,      } },
  { { "QCU",                    NULL, NULL, }, { "es-CU",          NULL, NULL,      } },
  { { "QSD",                    NULL, NULL, }, { "es-DO",          NULL, NULL,      } },
  { { "QSE",                    NULL, NULL, }, { "es-EC",          NULL, NULL,      } },
  { { "QSL",                    NULL, NULL, }, { "es-SV",          NULL, NULL,      } },
  { { "QGU",                    NULL, NULL, }, { "es-GT",          NULL, NULL,      } },
  { { "QSH",                    NULL, NULL, }, { "es-HN",          NULL, NULL,      } },
  { { "QSM",                    NULL, NULL, }, { "es-MX",          NULL, NULL,      } },
  { { "QNI",                    NULL, NULL, }, { "es-NI",          NULL, NULL,      } },
  { { "QPA",                    NULL, NULL, }, { "es-PA",          NULL, NULL,      } },
  { { "QPY",                    NULL, NULL, }, { "es-PY",          NULL, NULL,      } },
  { { "QPE",                    NULL, NULL, }, { "es-PE",          NULL, NULL,      } },
  { { "QPR",                    NULL, NULL, }, { "es-PR",          NULL, NULL,      } },
};

void
init() {
  g_extlangs.reserve(252);

  for (auto const *extlang = s_extlangs_init, *end = extlang + 252; extlang < end; ++extlang) {
    g_extlangs.emplace_back(extlang->code, extlang->description, extlang->is_deprecated);

    auto &new_extlang = g_extlangs.back();
    for (auto prefix = extlang->prefixes; *prefix; ++prefix)
      new_extlang.prefixes.emplace_back(*prefix);
  }

  g_variants.reserve(108);

  for (auto const *variant = s_variants_init, *end = variant + 108; variant < end; ++variant) {
    g_variants.emplace_back(variant->code, variant->description, variant->is_deprecated);

    auto &new_variant = g_variants.back();
    for (auto prefix = variant->prefixes; *prefix; ++prefix)
      new_variant.prefixes.emplace_back(*prefix);
  }

  g_suppress_scripts.reserve(134);

  for (auto const *suppress_script = s_suppress_scripts_init, *end = suppress_script + 134; suppress_script < end; ++suppress_script)
    g_suppress_scripts.insert_or_assign(suppress_script->first, suppress_script->second);

  g_grandfathered.reserve(26);

  for (auto const *grandfathered = s_grandfathered_init, *end = grandfathered + 26; grandfathered < end; ++grandfathered)
    g_grandfathered.emplace_back(grandfathered->code, grandfathered->description, grandfathered->is_deprecated);
}

void
init_preferred_values() {
  mtx::bcp47::language_c::set_normalization_mode(mtx::bcp47::normalization_mode_e::none);

  g_preferred_values.reserve(423);

  for (auto const *preferred_value = s_preferred_values_init, *end = preferred_value + 423; preferred_value < end; ++preferred_value)
    g_preferred_values.emplace_back(preferred_value->from.parse(), preferred_value->to.parse());

  mtx::bcp47::language_c::set_normalization_mode(mtx::bcp47::normalization_mode_e::default_mode);
}

} // namespace mtx::iana::language_subtag_registry
