<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# isError

> Test if a value is an [Error][mdn-error] object.

<!-- Section to include introductory text. Make sure to keep an empty line after the intro `section` element and another before the `/section` close. -->

<section class="intro">

</section>

<!-- /.intro -->

<!-- Package usage documentation. -->

<section class="usage">

## Usage

```javascript
var isError = require( '@stdlib/assert/is-error' );
```

#### isError( value )

Tests if a `value` is an [`Error`][mdn-error] object.

```javascript
var bool = isError( new Error( 'beep' ) );
// returns true
```

</section>

<!-- /.usage -->

<!-- Package usage notes. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="notes">

</section>

<!-- /.notes -->

<!-- Package usage examples. -->

<section class="examples">

## Examples

<!-- eslint no-undef: "error" -->

```javascript
var isError = require( '@stdlib/assert/is-error' );

var bool = isError( new Error( 'error' ) );
// returns true

bool = isError( new EvalError( 'eval error' ) );
// returns true

bool = isError( new RangeError( 'range error' ) );
// returns true

bool = isError( new ReferenceError( 'reference error' ) );
// returns true

bool = isError( new SyntaxError( 'syntax error' ) );
// returns true

bool = isError( new TypeError( 'type error' ) );
// returns true

bool = isError( new URIError( 'URI error' ) );
// returns true

bool = isError( {} );
// returns false

bool = isError( null );
// returns false
```

</section>

<!-- /.examples -->

<!-- Section to include cited references. If references are included, add a horizontal rule *before* the section. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="references">

</section>

<!-- /.references -->

<!-- Section for all links. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="links">

[mdn-error]: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Error

</section>

<!-- /.links -->
