# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems


class V1ContainerPort(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Swagger model

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'host_port': 'int',
            'container_port': 'int',
            'protocol': 'str',
            'host_ip': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'host_port': 'hostPort',
            'container_port': 'containerPort',
            'protocol': 'protocol',
            'host_ip': 'hostIP'
        }

        self._name = None
        self._host_port = None
        self._container_port = None
        self._protocol = None
        self._host_ip = None

    @property
    def name(self):
        """
        Gets the name of this V1ContainerPort.
        If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.

        :return: The name of this V1ContainerPort.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this V1ContainerPort.
        If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.

        :param name: The name of this V1ContainerPort.
        :type: str
        """
        self._name = name

    @property
    def host_port(self):
        """
        Gets the host_port of this V1ContainerPort.
        Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.

        :return: The host_port of this V1ContainerPort.
        :rtype: int
        """
        return self._host_port

    @host_port.setter
    def host_port(self, host_port):
        """
        Sets the host_port of this V1ContainerPort.
        Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.

        :param host_port: The host_port of this V1ContainerPort.
        :type: int
        """
        self._host_port = host_port

    @property
    def container_port(self):
        """
        Gets the container_port of this V1ContainerPort.
        Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.

        :return: The container_port of this V1ContainerPort.
        :rtype: int
        """
        return self._container_port

    @container_port.setter
    def container_port(self, container_port):
        """
        Sets the container_port of this V1ContainerPort.
        Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.

        :param container_port: The container_port of this V1ContainerPort.
        :type: int
        """
        self._container_port = container_port

    @property
    def protocol(self):
        """
        Gets the protocol of this V1ContainerPort.
        Protocol for port. Must be UDP or TCP. Defaults to \"TCP\".

        :return: The protocol of this V1ContainerPort.
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """
        Sets the protocol of this V1ContainerPort.
        Protocol for port. Must be UDP or TCP. Defaults to \"TCP\".

        :param protocol: The protocol of this V1ContainerPort.
        :type: str
        """
        self._protocol = protocol

    @property
    def host_ip(self):
        """
        Gets the host_ip of this V1ContainerPort.
        What host IP to bind the external port to.

        :return: The host_ip of this V1ContainerPort.
        :rtype: str
        """
        return self._host_ip

    @host_ip.setter
    def host_ip(self, host_ip):
        """
        Sets the host_ip of this V1ContainerPort.
        What host IP to bind the external port to.

        :param host_ip: The host_ip of this V1ContainerPort.
        :type: str
        """
        self._host_ip = host_ip

    def to_dict(self):
        """
        Return model properties dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Return model properties str
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()
