% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence.R
\name{diagnostics}
\alias{diagnostics}
\alias{convergence}
\title{List of available convergence diagnostics}
\value{
See individual functions for a description of return types.
}
\description{
A list of available diagnostics and links to their individual help pages.
}
\details{
\tabular{ll}{
   \strong{Function} \tab \strong{Description} \cr
   \code{\link[=ess_basic]{ess_basic()}} \tab Basic version of effective sample size \cr
   \code{\link[=ess_bulk]{ess_bulk()}} \tab Bulk effective sample size \cr
   \code{\link[=ess_tail]{ess_tail()}} \tab Tail effective sample size \cr
   \code{\link[=ess_mean]{ess_mean()}} \tab Effective sample sizes for the mean \cr
   \code{\link[=ess_median]{ess_median()}} \tab Effective sample sizes for the median \cr
   \code{\link[=ess_quantile]{ess_quantile()}} \tab Effective sample sizes for quantiles \cr
   \code{\link[=ess_sd]{ess_sd()}} \tab Effective sample sizes for the standard deviation \cr
   \code{\link[=mcse_mean]{mcse_mean()}} \tab Monte Carlo standard error for the mean \cr
   \code{\link[=mcse_median]{mcse_median()}} \tab Monte Carlo standard error for the median \cr
   \code{\link[=mcse_quantile]{mcse_quantile()}} \tab Monte Carlo standard error for quantiles \cr
   \code{\link[=mcse_sd]{mcse_sd()}} \tab Monte Carlo standard error for the standard deviation \cr
   \code{\link[=pareto_khat]{pareto_khat()}} \tab Pareto khat diagnostic for tail(s) \cr
   \code{\link[=pareto_diags]{pareto_diags()}} \tab Additional diagnostics related to Pareto khat \cr
   \code{\link[=rhat_basic]{rhat_basic()}} \tab Basic version of Rhat \cr
   \code{\link[=rhat]{rhat()}} \tab Improved, rank-based version of Rhat \cr
   \code{\link[=rhat_nested]{rhat_nested()}} \tab Rhat for use with many short chains \cr
   \code{\link[=rstar]{rstar()}} \tab R* diagnostic \cr
}
}
