% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation_split.R
\name{validation_split}
\alias{validation_split}
\alias{validation_time_split}
\alias{group_validation_split}
\title{Create a Validation Set}
\usage{
validation_split(data, prop = 3/4, strata = NULL, breaks = 4, pool = 0.1, ...)

validation_time_split(data, prop = 3/4, lag = 0, ...)

group_validation_split(data, group, prop = 3/4, ..., strata = NULL, pool = 0.1)
}
\arguments{
\item{data}{A data frame.}

\item{prop}{The proportion of data to be retained for modeling/analysis.}

\item{strata}{A variable in \code{data} (single character or name) used to conduct
stratified sampling. When not \code{NULL}, each resample is created within the
stratification variable. Numeric \code{strata} are binned into quartiles.}

\item{breaks}{A single number giving the number of bins desired to stratify a
numeric stratification variable.}

\item{pool}{A proportion of data used to determine if a particular group is
too small and should be pooled into another group. We do not recommend
decreasing this argument below its default of 0.1 because of the dangers
of stratifying groups that are too small.}

\item{...}{Not currently used.}

\item{lag}{A value to include a lag between the assessment
and analysis set. This is useful if lagged predictors will be used
during training and testing.}

\item{group}{A variable in \code{data} (single character or name) used for
grouping observations with the same value to either the analysis or
assessment set within a fold.}
}
\value{
An tibble with classes \code{validation_split}, \code{rset}, \code{tbl_df}, \code{tbl},
and \code{data.frame}. The results include a column for the data split objects
and a column called \code{id} that has a character string with the resample
identifier.
}
\description{
\code{validation_split()} takes a single random sample (without replacement) of
the original data set to be used for analysis. All other data points are
added to the assessment set (to be used as the validation set).
\code{validation_time_split()} does the same, but takes the \emph{first} \code{prop} samples
for training, instead of a random selection.
\code{group_validation_split()} creates splits of the data based
on some grouping variable, so that all data in a "group" is assigned to
the same split.
}
\details{
With a \code{strata} argument, the random sampling is conducted
\emph{within the stratification variable}. This can help ensure that the
resamples have equivalent proportions as the original data set. For
a categorical variable, sampling is conducted separately within each class.
For a numeric stratification variable, \code{strata} is binned into quartiles,
which are then used to stratify. Strata below 10\% of the total are
pooled together; see \code{\link[=make_strata]{make_strata()}} for more details.
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
validation_split(mtcars, prop = .9)

data(drinks, package = "modeldata")
validation_time_split(drinks)

group_validation_split(mtcars, cyl)
\dontshow{\}) # examplesIf}
}
