### New features

* Add support for subclassing using `Class.new` to `Lint/InheritException`. ([@houli][])
* [#6779](https://github.com/rubocop-hq/rubocop/issues/6779): Add new cop `Style/NegativeUnless` that checks for unless with negative condition. ([@tejasbubane][])

### Bug fixes

* [#6900](https://github.com/rubocop-hq/rubocop/issues/6900): Fix `Rails/TimeZone` autocorrect `Time.current` to `Time.zone.now`. ([@vfonic][])
* [#6900](https://github.com/rubocop-hq/rubocop/issues/6900): Fix `Rails/TimeZone` to prefer `Time.zone.#{method}` over other acceptable corrections. ([@vfonic][])
* [#7007](https://github.com/rubocop-hq/rubocop/pull/7007): Fix `Style/BlockDelimiters` with `braces_for_chaining` style false positive, when chaining using safe navigation. ([@Darhazer][])
* [#6880](https://github.com/rubocop-hq/rubocop/issues/6880): Fix `.rubocop` file parsing. ([@hoshinotsuyoshi][])
* [#5782](https://github.com/rubocop-hq/rubocop/issues/5782): Do not autocorrect `Lint/UnifiedInteger` if `TargetRubyVersion < 2.4`. ([@lavoiesl][])
* [#6387](https://github.com/rubocop-hq/rubocop/issues/6387): Prevent `Lint/NumberConversion` from reporting error with `Time`/`DateTime`. ([@tejasbubane][])
* [#6980](https://github.com/rubocop-hq/rubocop/issues/6980): Fix `Style/StringHashKeys` to allow string as keys for hash arguments to gsub methods. ([@tejasbubane][])
* [#6969](https://github.com/rubocop-hq/rubocop/issues/6969): Fix a false positive with block methods in `Style/InverseMethods`. ([@dduugg][])
* [#6729](https://github.com/rubocop-hq/rubocop/pull/6729): Handle array spread for `change_column_default` in `Rails/ReversibleMigration` cop. ([@tejasbubane][])
* [#7033](https://github.com/rubocop-hq/rubocop/issues/7033): Fix an error for `Layout/EmptyLineAfterGuardClause` when guard clause is a ternary operator. ([@koic][])

### Changes

* [#6945](https://github.com/rubocop-hq/rubocop/issues/6945): Drop support for Ruby 2.2. ([@koic][])
* [#6945](https://github.com/rubocop-hq/rubocop/issues/6945): Set default `EnforcedStyle` to `squiggly` option for `Layout/IndentHeredoc` and `auto_detection` option is removed. ([@koic][])
* [#6945](https://github.com/rubocop-hq/rubocop/issues/6945): Set default `EnforcedStyle` to `always` option for `Style/FrozenStringLiteralComment` and `when_needed` option is removed. ([@koic][])
* [#7027](https://github.com/rubocop-hq/rubocop/pull/7027): Allow unicode/display_width dependency version 1.6.0. ([@tagliala][])

[@houli]: https://github.com/houli
[@tejasbubane]: https://github.com/tejasbubane
[@vfonic]: https://github.com/vfonic
[@Darhazer]: https://github.com/Darhazer
[@hoshinotsuyoshi]: https://github.com/hoshinotsuyoshi
[@lavoiesl]: https://github.com/lavoiesl
[@dduugg]: https://github.com/dduugg
[@koic]: https://github.com/koic
[@tagliala]: https://github.com/tagliala
