# 2021-03-16 Triage Log

Added two benchmarks over the past week to the perf suite - diesel and stm32f4,
which are intended to add to the level of tracking for rustdoc and, for both, a
focus on compiler trait machinery.

Performance results for this week are mixed, but overall largely positive.

Triage done by **@simulacrum**.
Revision range: [861872bc453bde79b83ff99d443d035225f10e87..f24ce9b0140d9be5a336954e878d0c1522966bb8](https://perf.rust-lang.org/?start=861872bc453bde79b83ff99d443d035225f10e87&end=f24ce9b0140d9be5a336954e878d0c1522966bb8&absolute=false&stat=instructions%3Au)

3 Regressions, 3 Improvements, 4 Mixed

0 of them in rollups

#### Regressions

Shorten `rustc_middle::ty::mod` [#82964](https://github.com/rust-lang/rust/issues/82964)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=066f01d81bfbed746f6b6cf27a0426d829e8e832&end=b3ac52646f7591a811fa9bf55995b24fd17ece08&stat=instructions:u) (up to 4.0% on `full` builds of `deeply-nested-check`)
- Largely limited to diesel-doc builds, but a big regression there; left a nag
  to followup. Likely caused by a change to inlining.

Allow calling *const methods on *mut values [#82436](https://github.com/rust-lang/rust/issues/82436)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=4d76b4ca52a65d63ab83d82d6630f1df8ec05a93&end=f42888c15fd370b8bca4c5646ffc3aac3005dca8&stat=instructions:u) (up to 11.3% on `incr-full` builds of `packed-simd-check`)
- Unfortunate and unexpected regression. Left a nag.

Turn `-Z incremental-verify-ich` on by default [#83007](https://github.com/rust-lang/rust/issues/83007)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=56f74c52c1bb627ada01992787116054bf1e66e9&end=e7e1dc158c3de232750b568163f6941a184ee8be&stat=instructions:u) (up to 15.1% on `incr-unchanged` builds of `issue-46449-debug`)
- Expected mitigation, essentially part of a soundness fix (though due to other
  bugs in the compiler - this just adds asserts that catches those).

#### Improvements

Eagerly construct bodies of THIR [#82495](https://github.com/rust-lang/rust/issues/82495)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=5c6d3bf3896b465e15550f49c2861e3d18102270&end=61365c06250e2ba6e0a578ae990f055ac5339107&stat=instructions:u) (up to -1.7% on `full` builds of `tuple-stress-check`)

Iterate on crate_inherent_impls for metadata. [#83082](https://github.com/rust-lang/rust/issues/83082)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=84c08f82b46986fcd5cbd1a637582bd1325fa970&end=9320b121b5b20d2201c9f5ec40fb3c241fcac6f0&stat=instructions:u) (up to -1.3% on `incr-unchanged` builds of `externs-check`)

Tweaks to stable hashing [#83064](https://github.com/rust-lang/rust/issues/83064)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=e7e1dc158c3de232750b568163f6941a184ee8be&end=acca818928654807ed3bc1ce0e97df118f8716c8&stat=instructions:u) (up to -12.4% on `incr-unchanged` builds of `ctfe-stress-4-check`)

#### Mixed

Store HIR attributes in a side table [#79519](https://github.com/rust-lang/rust/issues/79519)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=861872bc453bde79b83ff99d443d035225f10e87&end=dff1edf919198aa4dea106e63b7d1899f1061fe0&stat=instructions:u) (up to -44.2% on `incr-patched: minor change` builds of `tokio-webpush-simple-debug`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=861872bc453bde79b83ff99d443d035225f10e87&end=dff1edf919198aa4dea106e63b7d1899f1061fe0&stat=instructions:u) (up to 5.2% on `incr-unchanged` builds of `cranelift-codegen-check`)

Enable MemorySSA in MemCpyOpt [#82806](https://github.com/rust-lang/rust/issues/82806)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=61365c06250e2ba6e0a578ae990f055ac5339107&end=4a8b6f708c38342a6c74aa00cf4323774c7381a6&stat=instructions:u) (up to 10.6% on `full` builds of `deep-vector-opt`)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=61365c06250e2ba6e0a578ae990f055ac5339107&end=4a8b6f708c38342a6c74aa00cf4323774c7381a6&stat=instructions:u) (up to -4.9% on `full` builds of `ctfe-stress-4-check`)

Don't implement mem::replace with mem::swap. [#83022](https://github.com/rust-lang/rust/issues/83022)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=b3e19a221e63dcffdef87e12eadf1f36a8b90295&end=46a934a1dc789b9441e5fb5cd043287baddcc5c7&stat=instructions:u) (up to -12.5% on `incr-patched: empty 3072` builds of `issue-46449-opt`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=b3e19a221e63dcffdef87e12eadf1f36a8b90295&end=46a934a1dc789b9441e5fb5cd043287baddcc5c7&stat=instructions:u) (up to 1.2% on `incr-patched: println` builds of `coercions-debug`)

Rebase and fixup #80493: Remove MIR assignments to ZST types [#83118](https://github.com/rust-lang/rust/issues/83118)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=2a55274e0ca9bf0b60cf72744b91237de625863e&end=7a7bbdb3abfa72ca717ef54ffc4f307d0d44de67&stat=instructions:u) (up to -3.2% on `full` builds of `ctfe-stress-4-check`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=2a55274e0ca9bf0b60cf72744b91237de625863e&end=7a7bbdb3abfa72ca717ef54ffc4f307d0d44de67&stat=instructions:u) (up to 1.8% on `incr-patched: b9b3e592dd cherry picked` builds of `style-servo-debug`)

#### Nags requiring follow up

- https://github.com/rust-lang/rust/pull/82964#issuecomment-800663588
- https://github.com/rust-lang/rust/pull/82436#issuecomment-800668093
