# 2020-11-03 Triage Log

A number of improvements on various benchmarks. The most notable news this week
in compiler performance is the progress on instruction metric collection on a
per-query level; see
[measureme#143](https://github.com/rust-lang/measureme/pull/143) for the latest.

Otherwise, this week was an excellent one for performance (though mostly on
stress tests rather than commonly seen code).

Triage done by **@simulacrum**.
Revision range: [824f900a96d752da2d882863c65f9736e5f2b347..5cdf5b882da9e8b7c73b5cadeb7745cb68f6ff63](https://perf.rust-lang.org/?start=824f900a96d752da2d882863c65f9736e5f2b347&end=5cdf5b882da9e8b7c73b5cadeb7745cb68f6ff63&absolute=false&stat=instructions%3Au)

0 Regressions, 5 Improvements, 0 Mixed

#### Improvements

[#78323](https://github.com/rust-lang/rust/issues/78323)
- Slight improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=db241bb0c8d257e13c1560f6250e49879477039e&end=2eb4fc800aaf5006f89af3af591e2aa34f469d81&stat=instructions:u) (up to -1.3% on `incr-unchanged` builds of `packed-simd-check`)
- Possibly within noise; unclear.

[#78508](https://github.com/rust-lang/rust/issues/78508)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=a53fb30e3bf2655b0563da6d561c23cda5f3ec11&end=6bdae9edd0cc099daa6038bca469dc09b6fc078a&stat=instructions:u) (up to -2.0% on `incr-unchanged` builds of `packed-simd-check`)

[#78432](https://github.com/rust-lang/rust/issues/78432)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=c792f03379617efa7deb6ab8c20709c45e81670a&end=0d33ab7af4aebe786410b4c10367eb6ddf13af0b&stat=instructions:u) (up to -5.7% on `full` builds of `match-stress-enum-check`)
- An unexpected improvement for a seemingly bugfix PR; would be good to verify
  this is not an unintentional behavior change (nag left).

[#78553](https://github.com/rust-lang/rust/issues/78553)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=e8cbaf2ae7fc5c564cacedbe55664797dc62d920&end=1899c489d4c30b2640d30b77ac04f0a548834d81&stat=instructions:u) (up to -10.1% on `full` builds of `match-stress-enum-check`)

[#78448](https://github.com/rust-lang/rust/issues/78448)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=4c0c5e099a3b1f1c6ad53115189c2710495588b3&end=7b5a9e9cd27f01311b5e19cefa1fb574d086d3da&stat=instructions:u) (up to -95.4% on `full` builds of `externs-debug`)
- Notable case of adding a new benchmark to perf; this is much appreciated and
  illustrates that perf does not yet have full coverage of Rust code (though
  this is not really expected either, though is always a goal).

[#78430](https://github.com/rust-lang/rust/issues/78430)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=31ee872db5aae4750e3da1ca4ed1523c4356947f&end=f9187adaef2005b903f666bf323ac675cadf8407&stat=instructions:u) (up to -23.6% on `incr-patched: println` builds of `unicode_normalization-check`)
- Fairly large refactor to the match checking infrastructure, with a
  correspondigly large performance improvement. There does appear to be a slight
  regression on #58319, but this is in the "Improvements" category since it seem
  categorically a win.

#### Nags requiring follow up

Compiler team attention requested:

- <https://github.com/rust-lang/rust/pull/78432#issuecomment-721388323>
