## TFSA-2019-001: Null Pointer Dereference Error in Decoding GIF Files

### CVE Number

CVE-2019-9635

### Issue Description

Certain invalid GIF files can produce a null pointer dereference when reading
from the color map of a frame if the color map is missing.

### Impact

A maliciously crafted GIF file could cause a denial of service attack for
TensorFlow by making it crash.

### Vulnerable Versions

TensorFlow 1.0.0, 1.0.1, 1.1.0, 1.2.0, 1.2.1, 1.3.0, 1.3.1, 1.4.0, 1.4.1, 1.5.0,
1.5.1, 1.6.0, 1.7.0, 1.7.1, 1.8.0, 1.9.0, 1.10.0, 1.10.1, 1.11.0, 1.12.0

### Mitigation

We have patched the vulnerability in GitHub commit
[e41cb124](https://github.com/tensorflow/tensorflow/commit/e41cb124cd0b325821af85cdacd9d8a12e206418).

If users are loading untrusted configurations in TensorFlow, we encourage users
to apply the patch to upgrade the version of TensorFlow they are currently using.

Additionally, we have released TensorFlow version 1.12.2 to mitigate this
vulnerability. Versions 1.13.0 and later were released using the patched commit.

### Credits

This issue was discovered by Yakun Zhang and Zheng Huang of Baidu Security Lab.
