// re2c $INPUT -o $OUTPUT -i --header lexer/state.h
#include <assert.h>
#include <stddef.h>
#include "lexer/state.h" // the header is generated by re2c

/*!header:re2c:on*/
typedef struct {
    const char *str, *cur;
    /*!stags:re2c format = "const char *@@;"; */
} LexerState;
/*!header:re2c:off*/

long lex(LexerState* st) {
    const char *t;
    /*!re2c
        re2c:header = "lexer/state.h";
        re2c:yyfill:enable = 0;
        re2c:define:YYCTYPE = char;
        re2c:define:YYCURSOR = "st->cur";
        re2c:tags = 1;
        re2c:tags:expression = "st->@@";

        [a]* @t [b]* { return t - st->str; }
    */
}

int main() {
    const char *s = "ab";
    LexerState st = { s, s /*!stags:re2c format = ", NULL"; */ };
    assert(lex(&st) == 1);
    return 0;
}
