/*
	Challenge - Virtual Robot Challenge System
	Copyright (C) 1999--2008:
		Stephane Magnenat <stephane at magnenat dot net>
		(http://stephane.magnenat.net)
	3D models
	Copyright (C) 2008:
		Basilio Noris
	Aseba - an event-based framework for distributed robot control
	Copyright (C) 2007--2016:
		Stephane Magnenat <stephane at magnenat dot net>
		(http://stephane.magnenat.net)
		and other contributors, see authors.txt for details
	
	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published
	by the Free Software Foundation, version 3 of the License.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.
	
	You should have received a copy of the GNU Lesser General Public License
	along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

#include <QtOpenGL>
#define BYTE unsigned char

namespace Enki
{
	// 72 Verticies
	// 100 Texture Coordinates
	// 72 Normals
	// 118 Triangles
	
	static BYTE face_indicies[118][9] = {
	// Object #-1
		{45,37,44 ,0,1,2 ,0,1,2 }, {55,37,45 ,3,1,0 ,3,1,0 }, {55,35,37 ,3,4,1 ,3,4,1 },
		{56,35,55 ,5,4,3 ,5,4,3 }, {56,34,35 ,5,6,4 ,5,6,4 }, {57,34,56 ,7,6,5 ,7,6,5 },
		{57,33,34 ,7,8,6 ,7,8,6 }, {71,33,57 ,9,8,7 ,9,8,7 }, {71,29,33 ,9,10,8 ,9,10,8 },
		{29,71,28 ,10,9,11 ,10,9,11 }, {67,28,71 ,12,11,9 ,12,11,9 },
		{28,67,25 ,11,12,13 ,11,12,13 }, {68,25,67 ,14,13,12 ,14,13,12 },
		{25,68,41 ,13,14,15 ,13,14,15 }, {69,41,68 ,16,15,14 ,16,15,14 },
		{62,41,69 ,17,15,16 ,17,15,16 }, {62,40,41 ,17,18,15 ,17,18,15 },
		{63,40,62 ,19,18,17 ,19,18,17 }, {40,63,51 ,18,19,20 ,18,19,20 },
		{51,63,50 ,20,19,21 ,20,19,21 }, {59,50,63 ,22,21,19 ,22,21,19 },
		{49,50,59 ,23,21,22 ,23,21,22 }, {1,51,0 ,24,20,25 ,24,25,26 },
		{1,40,51 ,24,18,20 ,24,27,25 }, {0,50,23 ,25,21,26 ,26,28,29 },
		{0,51,50 ,25,20,21 ,26,25,28 }, {23,49,22 ,26,23,27 ,29,30,31 },
		{23,50,49 ,26,21,23 ,29,28,30 }, {22,59,21 ,27,22,28 ,31,32,33 },
		{22,49,59 ,27,23,22 ,31,30,32 }, {21,63,20 ,28,19,29 ,33,34,35 },
		{21,59,63 ,28,22,19 ,33,32,34 }, {20,62,19 ,29,17,30 ,35,36,37 },
		{20,63,62 ,29,19,17 ,35,34,36 }, {19,69,18 ,30,16,31 ,37,38,39 },
		{19,62,69 ,30,17,16 ,37,36,38 }, {69,17,18 ,16,32,31 ,38,40,39 },
		{69,68,17 ,16,14,32 ,38,41,40 }, {68,16,17 ,14,33,32 ,41,42,40 },
		{68,67,16 ,14,12,33 ,41,43,42 }, {67,15,16 ,12,34,33 ,43,44,42 },
		{67,71,15 ,12,9,34 ,43,45,44 }, {71,14,15 ,9,35,34 ,45,46,44 },
		{71,57,14 ,9,7,35 ,45,47,46 }, {57,13,14 ,7,36,35 ,47,48,46 },
		{57,56,13 ,7,5,36 ,47,49,48 }, {56,12,13 ,5,37,36 ,49,50,48 },
		{56,55,12 ,5,3,37 ,49,51,50 }, {55,11,12 ,3,38,37 ,52,53,54 },
		{55,45,11 ,3,0,38 ,52,55,53 }, {45,10,11 ,0,39,38 ,55,56,53 },
		{45,44,10 ,0,2,39 ,55,57,56 }, {44,9,10 ,2,40,39 ,57,58,56 },
		{44,37,9 ,2,1,40 ,57,59,58 }, {37,8,9 ,1,41,40 ,59,60,58 }, {37,35,8 ,1,4,41 ,59,61,60 },
		{35,7,8 ,4,42,41 ,61,62,60 }, {35,34,7 ,4,6,42 ,61,63,62 }, {34,6,7 ,6,43,42 ,63,64,62 },
		{34,33,6 ,6,8,43 ,63,65,64 }, {6,29,5 ,43,10,44 ,64,66,67 },
		{6,33,29 ,43,8,10 ,64,65,66 }, {5,28,4 ,44,11,45 ,67,68,69 },
		{5,29,28 ,44,10,11 ,67,66,68 }, {4,25,3 ,45,13,46 ,69,70,71 },
		{4,28,25 ,45,11,13 ,69,68,70 }, {3,41,2 ,46,15,47 ,71,72,73 },
		{3,25,41 ,46,13,15 ,71,70,72 }, {2,40,1 ,47,18,24 ,73,27,24 },
		{2,41,40 ,47,15,18 ,73,72,27 }, {26,4,27 ,48,45,49 ,74,69,75 },
		{26,5,4 ,48,44,45 ,74,67,69 }, {32,5,26 ,50,44,48 ,76,67,74 },
		{32,6,5 ,50,43,44 ,76,64,67 }, {31,6,32 ,51,43,50 ,77,64,76 },
		{31,7,6 ,51,42,43 ,77,62,64 }, {30,7,31 ,52,42,51 ,78,62,77 },
		{30,8,7 ,52,41,42 ,78,60,62 }, {36,8,30 ,53,41,52 ,79,60,78 },
		{36,9,8 ,53,40,41 ,79,58,60 }, {43,9,36 ,54,40,53 ,80,58,79 },
		{43,10,9 ,54,39,40 ,80,56,58 }, {42,10,43 ,55,39,54 ,81,56,80 },
		{42,11,10 ,55,38,39 ,81,53,56 }, {54,11,42 ,56,38,55 ,82,53,81 },
		{54,12,11 ,56,37,38 ,82,54,53 }, {53,12,54 ,57,37,56 ,83,84,85 },
		{53,13,12 ,57,36,37 ,83,48,84 }, {52,13,53 ,58,36,57 ,86,48,83 },
		{52,14,13 ,58,35,36 ,86,46,48 }, {70,14,52 ,59,35,58 ,87,46,86 },
		{70,15,14 ,59,34,35 ,87,44,46 }, {66,15,70 ,60,34,59 ,88,44,87 },
		{66,16,15 ,60,33,34 ,88,42,44 }, {65,16,66 ,61,33,60 ,89,42,88 },
		{65,17,16 ,61,32,33 ,89,40,42 }, {64,17,65 ,62,32,61 ,90,40,89 },
		{64,18,17 ,62,31,32 ,90,39,40 }, {61,18,64 ,63,31,62 ,91,39,90 },
		{61,19,18 ,63,30,31 ,91,37,39 }, {60,19,61 ,64,30,63 ,92,37,91 },
		{60,20,19 ,64,29,30 ,92,35,37 }, {58,20,60 ,65,29,64 ,93,35,92 },
		{58,21,20 ,65,28,29 ,93,33,35 }, {48,21,58 ,66,28,65 ,94,33,93 },
		{48,22,21 ,66,27,28 ,94,31,33 }, {47,22,48 ,67,27,66 ,95,31,94 },
		{47,23,22 ,67,26,27 ,95,29,31 }, {46,23,47 ,68,26,67 ,96,29,95 },
		{46,0,23 ,68,25,26 ,96,26,29 }, {39,0,46 ,69,25,68 ,97,26,96 },
		{39,1,0 ,69,24,25 ,97,24,26 }, {38,1,39 ,70,24,69 ,98,24,97 },
		{38,2,1 ,70,47,24 ,98,73,24 }, {24,2,38 ,71,47,70 ,99,73,98 },
		{24,3,2 ,71,46,47 ,99,71,73 }, {27,3,24 ,49,46,71 ,75,71,99 },
		{27,4,3 ,49,45,46 ,75,69,71 }
	};
	static GLfloat vertices [72][3] = {
	{0.02268f,0.0f,0.101f},{0.0219072f,0.00587002f,0.101f},{0.0196415f,0.01134f,0.101f},
	{0.0160372f,0.0160372f,0.101f},{0.01134f,0.0196415f,0.101f},{0.00587002f,0.0219072f,0.101f},
	{0.0f,0.02268f,0.101f},{-0.00587002f,0.0219072f,0.101f},{-0.01134f,0.0196415f,0.101f},
	{-0.0160372f,0.0160372f,0.101f},{-0.0196415f,0.01134f,0.101f},{-0.0219072f,0.00587002f,0.101f},
	{-0.02268f,0.0f,0.101f},{-0.0219072f,-0.00587002f,0.101f},{-0.0196415f,-0.01134f,0.101f},
	{-0.0160372f,-0.0160372f,0.101f},{-0.01134f,-0.0196415f,0.101f},{-0.00587002f,-0.0219072f,0.101f},
	{0.0f,-0.02268f,0.101f},{0.00587002f,-0.0219072f,0.101f},{0.01134f,-0.0196415f,0.101f},
	{0.0160372f,-0.0160372f,0.101f},{0.0196415f,-0.01134f,0.101f},{0.0219072f,-0.00587002f,0.101f},
	{0.0155634f,0.0155634f,0.09225f},{0.0156806f,0.0156806f,0.102f},{0.00569661f,0.02126f,0.09225f},
	{0.011005f,0.0190612f,0.09225f},{0.0110878f,0.0192047f,0.102f},{0.00573949f,0.0214201f,0.102f},
	{-0.011005f,0.0190612f,0.09225f},{-0.00569661f,0.02126f,0.09225f},{0.0f,0.02201f,0.09225f},
	{0.0f,0.0221757f,0.102f},{-0.00573949f,0.0214201f,0.102f},{-0.0110878f,0.0192047f,0.102f},
	{-0.0155634f,0.0155634f,0.09225f},{-0.0156806f,0.0156806f,0.102f},{0.0190612f,0.011005f,0.09225f},
	{0.02126f,0.00569661f,0.09225f},{0.0214201f,0.00573949f,0.102f},{0.0192047f,0.0110878f,0.102f},
	{-0.02126f,0.00569661f,0.09225f},{-0.0190612f,0.011005f,0.09225f},{-0.0192047f,0.0110878f,0.102f},
	{-0.0214201f,0.00573949f,0.102f},{0.02201f,0.0f,0.09225f},{0.02126f,-0.00569661f,0.09225f},
	{0.0190612f,-0.011005f,0.09225f},{0.0192047f,-0.0110878f,0.102f},{0.0214201f,-0.00573949f,0.102f},
	{0.0221757f,0.0f,0.102f},{-0.0190612f,-0.011005f,0.09225f},{-0.02126f,-0.00569661f,0.09225f},
	{-0.02201f,0.0f,0.09225f},{-0.0221757f,0.0f,0.102f},{-0.0214201f,-0.00573949f,0.102f},
	{-0.0192047f,-0.0110878f,0.102f},{0.0155634f,-0.0155634f,0.09225f},{0.0156806f,-0.0156806f,0.102f},
	{0.011005f,-0.0190612f,0.09225f},{0.00569661f,-0.02126f,0.09225f},{0.00573949f,-0.0214201f,0.102f},
	{0.0110878f,-0.0192047f,0.102f},{0.0f,-0.02201f,0.09225f},{-0.00569661f,-0.02126f,0.09225f},
	{-0.011005f,-0.0190612f,0.09225f},{-0.0110878f,-0.0192047f,0.102f},{-0.00573949f,-0.0214201f,0.102f},
	{0.0f,-0.0221757f,0.102f},{-0.0155634f,-0.0155634f,0.09225f},{-0.0156806f,-0.0156806f,0.102f}
	};
	static GLfloat normals [72][3] = {
	{-0.59432f,0.187534f,0.782058f},{-0.353134f,0.38555f,0.852436f},{-0.633257f,0.403627f,0.660357f},
	{-0.522328f,0.0229219f,0.852437f},{-0.241313f,0.46381f,0.852436f},{-0.510462f,-0.113047f,0.852437f},
	{-0.113047f,0.510462f,0.852437f},{-0.46381f,-0.241313f,0.852436f},{0.0f,0.414453f,0.910071f},
	{-0.329004f,-0.301342f,0.894958f},{0.134751f,0.608464f,0.782058f},{0.241313f,0.46381f,0.852436f},
	{-0.281015f,-0.440889f,0.852436f},{0.353134f,0.38555f,0.852436f},{-0.157329f,-0.498597f,0.852437f},
	{0.376226f,0.2398f,0.894958f},{-1.43553e-009f,-0.683433f,0.730013f},{0.157329f,-0.498597f,0.852437f},
	{0.498597f,0.157329f,0.852437f},{0.2398f,-0.376226f,0.894958f},{0.622607f,0.0273226f,0.782058f},
	{0.510462f,-0.113047f,0.852437f},{0.45957f,-0.42093f,0.782057f},{0.666179f,-0.346603f,0.660357f},
	{0.946905f,0.256142f,0.194325f},{0.980935f,0.00233735f,0.194325f},{0.948115f,-0.251627f,0.194325f},
	{0.850683f,-0.488443f,0.194324f},{0.695278f,-0.691973f,0.194324f},{0.492492f,-0.848346f,0.194324f},
	{0.256142f,-0.946905f,0.194325f},{0.0271837f,-0.989866f,0.139379f},{-0.212108f,-0.957767f,0.194146f},
	{-0.452769f,-0.870234f,0.194145f},{-0.662575f,-0.723397f,0.194145f},{-0.827227f,-0.527261f,0.194145f},
	{-0.935505f,-0.295193f,0.194145f},{-0.98003f,-0.0430079f,0.194145f},{-0.957767f,0.212108f,0.194146f},
	{-0.870234f,0.452769f,0.194145f},{-0.723397f,0.662575f,0.194145f},{-0.527261f,0.827227f,0.194145f},
	{-0.295193f,0.935505f,0.194145f},{-0.0194292f,0.972249f,0.23314f},{0.251627f,0.948115f,0.194325f},
	{0.488443f,0.850683f,0.194324f},{0.691973f,0.695278f,0.194324f},{0.848346f,0.492492f,0.194324f},
	{0.300042f,0.950872f,-0.0762751f},{0.535922f,0.840815f,-0.076275f},{0.0437142f,0.996128f,-0.076275f},
	{-0.215592f,0.9735f,-0.0762751f},{-0.460207f,0.884529f,-0.076275f},{-0.673458f,0.73528f,-0.076275f},
	{-0.840815f,0.535922f,-0.076275f},{-0.950872f,0.300042f,-0.0762751f},{-0.996128f,0.0437142f,-0.076275f},
	{-0.9735f,-0.215592f,-0.0762751f},{-0.884529f,-0.460207f,-0.076275f},{-0.73528f,-0.673458f,-0.076275f},
	{-0.535922f,-0.840815f,-0.076275f},{-0.300042f,-0.950872f,-0.0762751f},{-0.0437142f,-0.996128f,-0.076275f},
	{0.215592f,-0.9735f,-0.0762751f},{0.460207f,-0.884529f,-0.076275f},{0.673458f,-0.73528f,-0.076275f},
	{0.840815f,-0.535922f,-0.076275f},{0.950872f,-0.300042f,-0.0762751f},{0.996128f,-0.0437142f,-0.076275f},
	{0.9735f,0.215592f,-0.0762751f},{0.884529f,0.460207f,-0.076275f},{0.73528f,0.673458f,-0.076275f}
	};
	static GLfloat textures [100][2] = {
	{0.434063f,0.130342f},{0.443646f,0.14694f},{0.437762f,0.139272f},
	{0.432802f,0.12076f},{0.451314f,0.152824f},{0.434063f,0.111177f},
	{0.460243f,0.156522f},{0.437762f,0.102248f},{0.469826f,0.157784f},
	{0.443646f,0.0945801f},{0.479408f,0.156522f},{0.488338f,0.152824f},
	{0.451314f,0.0886962f},{0.496006f,0.14694f},{0.460243f,0.0849975f},
	{0.501889f,0.139272f},{0.469826f,0.083736f},{0.479408f,0.0849975f},
	{0.505588f,0.130342f},{0.488338f,0.0886962f},{0.50685f,0.12076f},
	{0.505588f,0.111177f},{0.496006f,0.0945801f},{0.501889f,0.102248f},
	{0.580938f,0.291037f},{0.57f,0.294715f},{0.57f,0.291037f},
	{0.580938f,0.294715f},{0.559062f,0.294715f},{0.559062f,0.291037f},
	{0.548125f,0.294715f},{0.548125f,0.291037f},{0.537187f,0.294715f},
	{0.537187f,0.291037f},{0.526249f,0.294715f},{0.526249f,0.291037f},
	{0.515311f,0.294715f},{0.515311f,0.291037f},{0.504374f,0.294715f},
	{0.504374f,0.291037f},{0.493436f,0.291037f},{0.493436f,0.294715f},
	{0.482498f,0.291037f},{0.482498f,0.294715f},{0.47156f,0.291037f},
	{0.47156f,0.294715f},{0.460623f,0.291037f},{0.460623f,0.294715f},
	{0.449685f,0.291037f},{0.449685f,0.294715f},{0.438747f,0.291037f},
	{0.438747f,0.294715f},{0.701253f,0.294715f},{0.690315f,0.291037f},
	{0.701253f,0.291037f},{0.690315f,0.294715f},{0.679377f,0.291037f},
	{0.679377f,0.294715f},{0.66844f,0.291037f},{0.66844f,0.294715f},
	{0.657502f,0.291037f},{0.657502f,0.294715f},{0.646564f,0.291037f},
	{0.646564f,0.294715f},{0.635626f,0.291037f},{0.635626f,0.294715f},
	{0.624689f,0.294715f},{0.624689f,0.291037f},{0.613751f,0.294715f},
	{0.613751f,0.291037f},{0.602813f,0.294715f},{0.602813f,0.291037f},
	{0.591875f,0.294715f},{0.591875f,0.291037f},{0.624689f,0.258856f},
	{0.613751f,0.258856f},{0.635626f,0.258856f},{0.646564f,0.258856f},
	{0.657502f,0.258856f},{0.66844f,0.258856f},{0.679377f,0.258856f},
	{0.690315f,0.258856f},{0.701253f,0.258856f},{0.449685f,0.258856f},
	{0.438747f,0.291016f},{0.438747f,0.258856f},{0.460623f,0.258856f},
	{0.47156f,0.258856f},{0.482498f,0.258856f},{0.493436f,0.258856f},
	{0.504374f,0.258856f},{0.515311f,0.258856f},{0.526249f,0.258856f},
	{0.537187f,0.258856f},{0.548125f,0.258856f},{0.559062f,0.258856f},
	{0.57f,0.258856f},{0.580938f,0.258856f},{0.591875f,0.258856f},
	{0.602813f,0.258856f}
	};
	GLint GenFeederCharge3()
	{
		GLint lid=glGenLists(1);
		glNewList(lid, GL_COMPILE);
		
		glBegin (GL_TRIANGLES);
		for(size_t i=0;i<sizeof(face_indicies)/sizeof(face_indicies[0]);i++)
		{
			for(size_t j=0;j<3;j++)
			{
				int vi=face_indicies[i][j];
				int ni=face_indicies[i][j+3];//Normal index
				int ti=face_indicies[i][j+6];//Texture index
				/*glNormal3f (normals[ni][0],normals[ni][1],normals[ni][2]);
				glTexCoord2f(textures[ti][0],textures[ti][1]);
				glVertex3f (vertices[vi][0],vertices[vi][1],vertices[vi][2]);*/
				
				// rotate 90 deg around z
				glNormal3f (normals[ni][1],-normals[ni][0],normals[ni][2]);
				glTexCoord2f(textures[ti][0],textures[ti][1]);
				glVertex3f (100.f*vertices[vi][1],-100.f*vertices[vi][0],100.f*vertices[vi][2]);
			}
		}
		glEnd ();
		
		glEndList();
		return lid;
	};
}
