/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.file.verify;

import java.lang.reflect.Modifier;
import net.sf.jiapi.file.ClassFile;
import net.sf.jiapi.file.Method;
import net.sf.jiapi.file.attribute.CodeAttribute;
import net.sf.jiapi.file.verify.AbstractTypeChecker;
import net.sf.jiapi.file.verify.Environment;

public class MethodVerifier
extends AbstractTypeChecker {
    public boolean methodIsTypeSafe(ClassFile clazz, Method method) {
        this.doesNotOverrideFinalMethod(clazz, method);
        short accessFlags = method.getAccessFlags();
        CodeAttribute code = (CodeAttribute)clazz.getAttribute("Code");
        if (Modifier.isAbstract(accessFlags) || Modifier.isNative(accessFlags)) {
            if (code != null) {
                this.verifyErrorMessage("Method " + method.getName() + " " + method.getDescriptor() + " is abstract or native. No Code attribute must exist");
                return false;
            }
        } else {
            if (code != null) {
                this.verifyErrorMessage("Method " + method.getName() + " " + method.getDescriptor() + " does not have Code attribute");
                return false;
            }
            return this.methodWithCodeIsTypeSafe(clazz, method);
        }
        return false;
    }

    private boolean methodWithCodeIsTypeSafe(ClassFile clazz, Method method) {
        Environment env = new Environment(clazz, method);
        return false;
    }

    private boolean doesNotOverrideFinalMethod(ClassFile clazz, Method method) {
        String superclassName = clazz.getSuperclassName();
        return false;
    }
}

