/*
 * Decompiled with CFR 0.152.
 */
package $installer$.org.aspectj;

import $installer$.org.aspectj.InstallContext;
import $installer$.org.aspectj.Installer;
import $installer$.org.aspectj.Options;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

abstract class WizardPane {
    static InstallContext context;
    protected JButton backButton = null;
    protected JButton nextButton = null;
    protected JButton cancelButton = null;
    static String styleHeader;
    private JPanel panel = null;
    private Component buttons = null;

    WizardPane() {
    }

    public static void setContext(InstallContext con) {
        context = con;
    }

    public abstract JPanel makePanel();

    protected JTextArea makeTextArea(String data) {
        JTextArea text = new JTextArea(data);
        text.setOpaque(false);
        text.setFont(context.getFont());
        text.setEditable(false);
        return text;
    }

    protected boolean hasGui() {
        InstallContext icontext = context;
        return null == icontext || icontext.hasGui();
    }

    public static String stringFromStream(InputStream stream) throws IOException {
        int data;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "US-ASCII"));
        StringBuffer ret = new StringBuffer();
        while ((data = reader.read()) != -1) {
            ret.append((char)data);
        }
        return ret.toString();
    }

    public static String removeHead(String text) {
        int startIndex = text.indexOf("<head>");
        int stopIndex = text.indexOf("</head>");
        if (startIndex == -1 || stopIndex == -1) {
            return text;
        }
        return text.substring(0, startIndex) + text.substring(stopIndex += 7);
    }

    public static String applyProperties(String text, Map map) {
        int endIndex;
        int startIndex;
        int lastIndex = 0;
        StringBuffer buf = new StringBuffer();
        while ((startIndex = text.indexOf("${", lastIndex)) != -1 && (endIndex = text.indexOf(125, startIndex)) != -1) {
            String replaceText;
            buf.append(text.substring(lastIndex, startIndex));
            String key = text.substring(startIndex + 2, endIndex);
            lastIndex = endIndex + 1;
            String string = replaceText = map == null ? null : (String)map.get(key);
            if (replaceText == null) {
                replaceText = "NOT_FOUND";
            }
            buf.append(replaceText.toString());
        }
        buf.append(text.substring(lastIndex));
        return buf.toString();
    }

    public static String applyProperties(String text) {
        return WizardPane.applyProperties(text, context == null ? null : context.getProperties());
    }

    protected String loadText(String filename) {
        String fullname = "resources/" + filename;
        try {
            String text = WizardPane.stringFromStream(this.getClass().getResourceAsStream(fullname));
            text = styleHeader + WizardPane.removeHead(text);
            text = WizardPane.applyProperties(text);
            return text;
        }
        catch (IOException e) {
            context.handleException(e);
            return "";
        }
    }

    protected JEditorPane makeHTMLArea(String filename) {
        JEditorPane editorPane = new JEditorPane("text/html", this.loadText(filename));
        editorPane.setEditable(false);
        editorPane.setOpaque(false);
        return editorPane;
    }

    protected void setHTMLArea(JEditorPane pane, String filename) {
        pane.setText(this.loadText(filename));
    }

    protected JPanel makeLocationBox(String label, JTextField textField, JButton browseButton) {
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 0));
        textField.setFont(context.getFont());
        textField.selectAll();
        box.add(textField);
        box.add(browseButton);
        AbstractBorder border = BorderFactory.createTitledBorder(label);
        int INSET = 8;
        border = new CompoundBorder(border, new EmptyBorder(1, 8, 8, 8));
        box.setBorder(border);
        return box;
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            this.panel = this.makePanel();
            this.panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        }
        return this.panel;
    }

    protected void setListener(JButton button, ActionListener listener) {
        if (listener == null) {
            button.setEnabled(false);
        } else {
            button.addActionListener(listener);
        }
    }

    protected Component makeButtons(Installer installer2) {
        JPanel panel = new JPanel(new FlowLayout(2));
        this.backButton = new JButton("Back");
        this.setListener(this.backButton, installer2.makeBackAction(this));
        panel.add(this.backButton);
        this.nextButton = new JButton("Next");
        this.setListener(this.nextButton, installer2.makeNextAction(this));
        panel.add(this.nextButton);
        JLabel space = new JLabel();
        space.setPreferredSize(new Dimension(20, 0));
        panel.add(space);
        this.cancelButton = new JButton("Cancel");
        this.setListener(this.cancelButton, installer2.makeCancelAction(this));
        panel.add(this.cancelButton);
        return panel;
    }

    public Component getButtons() {
        if (this.buttons == null) {
            this.buttons = this.makeButtons(WizardPane.context.installer);
        }
        WizardPane.context.installer.frame.getRootPane().setDefaultButton(this.nextButton);
        return this.buttons;
    }

    public void finish() {
        if (Options.forceError2) {
            throw new RuntimeException("forced error2 for testing purposes");
        }
    }

    public void run() {
    }

    static {
        styleHeader = "<head></head>";
    }
}

