+++
title = "Core and shell"
weight = 10
+++

## Core-and-shell particle

To construct a particle made of a core and a shell, use
```python
composite_particle = ba.CoreAndShell(core, shell, core_position=R3())
```
where `core` and `shell` typically are simple particles generated by the
[Particle](/ref/sample/particle) constructor.

The optional argument `core_position` can be used to adjsut the position of the core particle.
It is equivalent to a prior call
```python
core = core_raw.translate(core_position)
```

Note that core must be fully contained in shell.
The scattering is computed as the coherent sum of the scattering from
shell and core where the scattering power of the latter has been modified
by subtracting the scattering power of the shell material.

##### History

Prior to BornAgain1.19.80, the constructor `ParticleCoreShell` had the
opposite argument order, namely `(shell, core)`.

##### Example

See [Core-and-shell example](/ex/sample/particles/core-shell-particle).
Validated through an alternative implementation that uses particle composition,
{{% ref-ex "scatter2d/CoreShellNanoparticles2.py" %}}.
