/*
 * Copyright (C) Research In Motion Limited 2011. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "config.h"

#include "core/svg/SVGAnimatedNumberOptionalNumber.h"

namespace WebCore {

SVGAnimatedNumberOptionalNumber::SVGAnimatedNumberOptionalNumber(SVGElement* contextElement, const QualifiedName& attributeName, float initialFirstValue, float initialSecondValue)
    : NewSVGAnimatedPropertyCommon<SVGNumberOptionalNumber>(contextElement, attributeName,
        SVGNumberOptionalNumber::create(SVGNumber::create(initialFirstValue), SVGNumber::create(initialSecondValue)))
    , m_firstNumber(SVGAnimatedNumber::create(contextElement, attributeName, baseValue()->firstNumber()))
    , m_secondNumber(SVGAnimatedNumber::create(contextElement, attributeName, baseValue()->secondNumber()))
{
    m_firstNumber->setParentOptionalNumber(this);
    m_secondNumber->setParentOptionalNumber(this);
}

void SVGAnimatedNumberOptionalNumber::animationStarted()
{
    NewSVGAnimatedPropertyCommon<SVGNumberOptionalNumber>::animationStarted();
    m_firstNumber->animationStarted();
    m_secondNumber->animationStarted();
}

void SVGAnimatedNumberOptionalNumber::setAnimatedValue(PassRefPtr<NewSVGPropertyBase> value)
{
    NewSVGAnimatedPropertyCommon<SVGNumberOptionalNumber>::setAnimatedValue(value);
    m_firstNumber->setAnimatedValue(currentValue()->firstNumber());
    m_secondNumber->setAnimatedValue(currentValue()->secondNumber());
}

void SVGAnimatedNumberOptionalNumber::animationEnded()
{
    NewSVGAnimatedPropertyCommon<SVGNumberOptionalNumber>::animationEnded();
    m_firstNumber->animationEnded();
    m_secondNumber->animationEnded();
}

void SVGAnimatedNumberOptionalNumber::animValWillChange()
{
    NewSVGAnimatedPropertyCommon<SVGNumberOptionalNumber>::animValWillChange();
    m_firstNumber->animValWillChange();
    m_secondNumber->animValWillChange();
}

void SVGAnimatedNumberOptionalNumber::animValDidChange()
{
    NewSVGAnimatedPropertyCommon<SVGNumberOptionalNumber>::animValDidChange();
    m_firstNumber->animValDidChange();
    m_secondNumber->animValDidChange();
}

bool SVGAnimatedNumberOptionalNumber::needsSynchronizeAttribute()
{
    return m_firstNumber->needsSynchronizeAttribute()
        || m_secondNumber->needsSynchronizeAttribute();
}

}
