/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.PrintWriter;
import java.util.Enumeration;
import opendap.dap.Attribute;
import opendap.dap.BaseType;
import opendap.dap.NoSuchVariableException;
import opendap.dap.XMLparser.DDSXMLParser;

public abstract class DConstructor
extends BaseType {
    public DConstructor() {
    }

    public DConstructor(String n) {
        super(n);
    }

    public abstract void addVariable(BaseType var1, int var2);

    public final void addVariable(BaseType v) {
        this.addVariable(v, 0);
    }

    public abstract BaseType getVariable(String var1) throws NoSuchVariableException;

    public abstract BaseType getVar(int var1) throws NoSuchVariableException;

    public abstract Enumeration getVariables();

    protected boolean someChildHasAttributes(BaseType bt) {
        boolean foundit = false;
        if (bt.hasAttributes()) {
            return true;
        }
        if (bt instanceof DConstructor) {
            Enumeration e = ((DConstructor)bt).getVariables();
            while (e.hasMoreElements()) {
                BaseType thisBT = (BaseType)e.nextElement();
                foundit = foundit || this.someChildHasAttributes(thisBT);
            }
        }
        return foundit;
    }

    public void printXML(PrintWriter pw, String pad, boolean constrained) {
        Enumeration e = this.getAttributeNames();
        Enumeration ve = this.getVariables();
        boolean hasAttributes = e.hasMoreElements();
        boolean hasVariables = ve.hasMoreElements();
        pw.print(pad + "<" + this.getTypeName());
        if (this.getName() != null) {
            pw.print(" name=\"" + DDSXMLParser.normalizeToXML(this.getClearName()) + "\"");
        }
        if (hasAttributes || hasVariables) {
            pw.println(">");
            while (e.hasMoreElements()) {
                String aName = (String)e.nextElement();
                Attribute a = this.getAttribute(aName);
                if (a == null) continue;
                a.printXML(pw, pad + "\t", constrained);
            }
            while (ve.hasMoreElements()) {
                BaseType bt = (BaseType)ve.nextElement();
                bt.printXML(pw, pad + "\t", constrained);
            }
            pw.println(pad + "</" + this.getTypeName() + ">");
        } else {
            pw.println("/>");
        }
    }
}

