/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import ucar.grib.GribNumbers;
import ucar.grib.NotSupportedException;
import ucar.unidata.io.RandomAccessFile;

public final class Grib1IndicatorSection {
    private long gribLength;
    private int length;
    private int discipline;
    private final int edition;

    public Grib1IndicatorSection(RandomAccessFile raf) throws NotSupportedException, IOException {
        int[] data = new int[3];
        for (int i = 0; i < 3; ++i) {
            data[i] = raf.read();
        }
        this.edition = raf.read();
        if (this.edition == 1) {
            this.gribLength = GribNumbers.uint3(data[0], data[1], data[2]);
            this.length = 8;
        } else if (this.edition == 2) {
            this.discipline = data[2];
            this.gribLength = raf.readLong();
            raf.seek(raf.getFilePointer() + this.gribLength - 4L);
            this.length = 16;
        } else {
            throw new NotSupportedException("GRIB edition " + this.edition + " is not yet supported");
        }
    }

    public final long getGribLength() {
        return this.gribLength;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getGribEdition() {
        return this.edition;
    }
}

