/*
 * Decompiled with CFR 0.152.
 */
package visad.paoloa.spline;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.CellImpl;
import visad.ConstantMap;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded1DSet;
import visad.Linear1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.VisADException;
import visad.java2d.DirectManipulationRendererJ2D;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.VisADSlider;

public class Spline {
    boolean toggle = true;
    Real nothing = new Real(-1000.0);
    boolean java2d = false;
    DataReference rlambda_ref;
    DataReference lambda_ref;
    DataReference wk_ref;
    DataReference noise_ref;
    DataReference spline_ref;
    DataReference spline_fieldRef;
    DataReference rlambda_fieldRef;
    DataReference true_fieldRef;
    DataReference gcv_fieldRef;
    int n_samples = 50;
    float[] domain_values;
    double[] range_values;
    double[] true_values;
    double[] rlambda_values;
    double[] noise;
    double[] noise_a;
    double[][] d_range = new double[1][];
    double[][] f_range = new double[1][];
    double[][] g_range = new double[1][];
    double[] spline_range;
    double[] values = new double[2];
    double val;
    double[] wkvalue = new double[1];
    double noise_fac;
    double last_noise_fac;
    double wk_value;
    int mode;
    FlatField rlambda_field;
    FlatField spline_field;
    FlatField gcv_field;
    FlatField true_field;
    Set domainSet;
    FunctionType f_type;
    DataReference[] range_refs;
    RealTuple[] tuples;
    Real[] reals;
    ConstantMap[][] cmaps;

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        System.loadLibrary("Spline");
        Spline spline = new Spline("file");
    }

    public Spline(String filename) throws VisADException, RemoteException, IOException {
        int ii;
        this.rlambda_ref = new DataReferenceImpl("rlambda_ref");
        this.wk_ref = new DataReferenceImpl("wk_ref");
        this.lambda_ref = new DataReferenceImpl("lambda_ref");
        this.noise_ref = new DataReferenceImpl("noise_ref");
        this.spline_ref = new DataReferenceImpl("spline_ref");
        this.true_values = new double[this.n_samples];
        this.rlambda_values = new double[50];
        this.range_values = new double[this.n_samples];
        this.noise = new double[this.n_samples];
        this.domain_values = new float[this.n_samples];
        this.spline_range = new double[this.n_samples];
        this.range_refs = new DataReferenceImpl[this.n_samples];
        this.tuples = new RealTuple[this.n_samples];
        this.reals = new Real[this.n_samples];
        this.cmaps = new ConstantMap[this.n_samples][];
        double x_c = 0.0;
        this.last_noise_fac = this.noise_fac = 0.1;
        boolean iset = false;
        double gset = 0.0;
        for (ii = 0; ii < this.n_samples; ++ii) {
            double gasdev;
            if (!iset) {
                double v2;
                double v1;
                double r;
                while ((r = (v1 = 2.0 * Math.random() - 1.0) * v1 + (v2 = 2.0 * Math.random() - 1.0) * v2) >= 1.0 || r == 0.0) {
                }
                double fac = Math.sqrt(-2.0 * Math.log(r) / r);
                gset = v1 * fac;
                iset = true;
                gasdev = v2 * fac;
            } else {
                iset = false;
                gasdev = gset;
            }
            this.noise[ii] = gasdev;
            this.true_values[ii] = Math.cos(x_c * 3.1415926) * Math.exp(-3.0 * x_c);
            this.range_values[ii] = this.true_values[ii] + this.noise_fac * this.noise[ii];
            x_c += 0.02;
        }
        for (ii = 0; ii < this.n_samples; ++ii) {
            this.domain_values[ii] = ii;
            this.values[0] = this.domain_values[ii];
            this.values[1] = this.range_values[ii];
            this.tuples[ii] = new RealTuple(RealTupleType.SpatialCartesian2DTuple, this.values);
            this.reals[ii] = new Real(RealType.YAxis, this.values[1]);
            this.range_refs[ii] = new DataReferenceImpl("rangeRef_" + ii);
            this.range_refs[ii].setData(this.reals[ii]);
        }
        float[][] samples = new float[1][this.n_samples];
        samples[0] = this.domain_values;
        this.domainSet = new Gridded1DSet((MathType)RealType.XAxis, samples, this.n_samples);
        this.f_type = new FunctionType(RealType.XAxis, RealType.YAxis);
        this.spline_field = new FlatField(this.f_type, this.domainSet);
        Linear1DSet dset = new Linear1DSet((MathType)RealType.XAxis, -10.0, 0.0, this.n_samples);
        this.rlambda_field = new FlatField(this.f_type, dset);
        this.gcv_field = new FlatField(this.f_type, this.domainSet);
        this.true_field = new FlatField(this.f_type, this.domainSet);
        double[][] d_array = new double[][]{this.true_values};
        this.true_field.setSamples(d_array);
        JFrame frame = new JFrame("Spline VisAD Application");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        SplinePanel spline_panel0 = new SplinePanel();
        panel.add(spline_panel0);
        frame.getContentPane().add(panel);
        frame.setSize(900, 900);
        frame.setVisible(true);
    }

    public native void getspline_c(double[] var1, double[] var2, double var3, int var5, double[] var6);

    class SplinePanel
    extends JPanel
    implements ActionListener {
        JPanel panel_a;
        JPanel panel_b;
        JPanel panel_c;
        JPanel panel_d;
        JPanel panel_e;
        JPanel panel_left;
        Border etchedBorder5 = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5));

        SplinePanel() throws VisADException, RemoteException {
            int ii;
            this.setLayout(new BoxLayout(this, 0));
            this.setAlignmentY(0.0f);
            this.setAlignmentX(0.0f);
            JPanel left = new JPanel();
            left.setLayout(new BoxLayout(left, 1));
            left.setAlignmentY(0.0f);
            left.setAlignmentX(0.0f);
            this.add(left);
            left.add(new JLabel("Smoothing Spline"));
            left.add(new JLabel("using VisAD  -  see:"));
            left.add(new JLabel("  "));
            left.add(new JLabel("  http://www.ssec.wisc.edu/~billh/visad.html"));
            left.add(new JLabel("  "));
            left.add(new JLabel("for more information about VisAD."));
            left.add(new JLabel("  "));
            left.add(new JLabel("William Hibbard, Tom Rink"));
            left.add(new JLabel("Paolo Antonelli and Giulia Panegrossi"));
            left.add(new JLabel("Space Science and Engineering Center"));
            left.add(new JLabel("University of Wisconsin - Madison"));
            left.add(new JLabel("  "));
            left.add(new JLabel("  "));
            left.add(new JLabel("Select different functions using the buttons"));
            left.add(new JLabel("  "));
            JPanel leftbuttons = new JPanel();
            leftbuttons.setLayout(new BoxLayout(leftbuttons, 0));
            leftbuttons.setAlignmentY(0.0f);
            leftbuttons.setAlignmentX(0.0f);
            JButton fun0_button = new JButton("fun0");
            fun0_button.addActionListener(this);
            fun0_button.setActionCommand("fun0");
            leftbuttons.add(fun0_button);
            JButton fun1_button = new JButton("fun1");
            fun1_button.addActionListener(this);
            fun1_button.setActionCommand("fun1");
            leftbuttons.add(fun1_button);
            JButton fun2_button = new JButton("fun2");
            fun2_button.addActionListener(this);
            fun2_button.setActionCommand("fun2");
            leftbuttons.add(fun2_button);
            JButton fun3_button = new JButton("fun3");
            fun3_button.addActionListener(this);
            fun3_button.setActionCommand("fun3");
            leftbuttons.add(fun3_button);
            JButton fun4_button = new JButton("fun4");
            fun4_button.addActionListener(this);
            fun4_button.setActionCommand("fun4");
            leftbuttons.add(fun4_button);
            left.add(leftbuttons);
            left.add(new JLabel("  "));
            left.add(new JLabel("fun0: cos(x)exp(-3x)    x in [0,1]"));
            left.add(new JLabel("fun1: sin(x)exp(-3x)    x in [0,1]"));
            left.add(new JLabel("fun2: xsin(1/(x+1))exp(-3x)   x in [0,1]"));
            left.add(new JLabel("fun3: 2xxsin(x)          x in [0,1]"));
            left.add(new JLabel("fun4: sin(x)log(x+1)   x in [0,1]"));
            left.add(new JLabel("  "));
            JPanel sliders = new JPanel();
            sliders.setName("Smoothing Spline Sliders");
            sliders.setFont(new Font("Dialog", 0, 12));
            sliders.setLayout(new BoxLayout(sliders, 1));
            sliders.setAlignmentY(0.0f);
            sliders.setAlignmentX(0.0f);
            left.add(sliders);
            left.add(new JLabel("  "));
            left.add(new JLabel("The noise slider changes the value of sigma"));
            left.add(new JLabel("  "));
            VisADSlider noise_slider = new VisADSlider(Spline.this.noise_ref, 0.0f, 0.5f, 0.1f, RealType.Generic, "noise");
            left.add(noise_slider);
            left.add(new JLabel("  "));
            left.add(new JLabel("Manual tuning of the smoothing parameter"));
            left.add(new JLabel("  "));
            VisADSlider lambda_slider = new VisADSlider(Spline.this.lambda_ref, -10.0f, 0.0f, 0.5f, RealType.Generic, "lambda");
            left.add(lambda_slider);
            left.add(new JLabel("  "));
            left.add(new JLabel("Top Display:"));
            left.add(new JLabel("Blue Curve: True function"));
            left.add(new JLabel("Red Dots: noisy observations"));
            left.add(new JLabel("Green Curve: GCV solution"));
            left.add(new JLabel("White Curve: Solution for a fixed value of lambda  "));
            left.add(new JLabel("  "));
            left.add(new JLabel("Bottom Display: "));
            left.add(new JLabel("Green Curve: V(lambda)"));
            left.add(new JLabel("Red Dot: value of lambda selected by GCV"));
            left.add(new JLabel("  "));
            JPanel right = new JPanel();
            right.setLayout(new BoxLayout(right, 1));
            right.setAlignmentY(0.0f);
            right.setAlignmentX(0.0f);
            this.add(right);
            DisplayImpl displays = null;
            DisplayImpl display2 = null;
            if (!Spline.this.java2d) {
                try {
                    displays = new DisplayImplJ3D("display1", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
                    display2 = new DisplayImplJ3D("display2", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
                }
                catch (UnsatisfiedLinkError e) {
                    // empty catch block
                }
            }
            if (Spline.this.java2d) {
                displays = new DisplayImplJ2D("display1");
                display2 = new DisplayImplJ2D("display2");
            }
            GraphicsModeControl mode1 = displays.getGraphicsModeControl();
            mode1.setScaleEnable(true);
            GraphicsModeControl mode2 = display2.getGraphicsModeControl();
            mode2.setScaleEnable(true);
            this.panel_a = new JPanel();
            this.panel_a.setLayout(new BoxLayout(this.panel_a, 1));
            this.panel_a.setAlignmentY(0.0f);
            this.panel_a.setAlignmentX(0.0f);
            this.panel_a.add(displays.getComponent());
            this.panel_a.setBorder(this.etchedBorder5);
            right.add(this.panel_a);
            this.panel_b = new JPanel();
            this.panel_b.setLayout(new BoxLayout(this.panel_b, 0));
            this.panel_b.setAlignmentY(0.0f);
            this.panel_b.setAlignmentX(0.0f);
            this.panel_d = new JPanel();
            this.panel_d.setLayout(new BoxLayout(this.panel_d, 0));
            this.panel_d.setAlignmentX(0.0f);
            JButton spline_button = new JButton("spline");
            spline_button.addActionListener(this);
            spline_button.setActionCommand("spline");
            this.panel_d.add(spline_button);
            JButton GCV_button = new JButton("GCV");
            GCV_button.addActionListener(this);
            GCV_button.setActionCommand("GCV");
            this.panel_d.add(GCV_button);
            JButton nreset_button = new JButton("reset noise");
            nreset_button.addActionListener(this);
            nreset_button.setActionCommand("nreset");
            this.panel_d.add(nreset_button);
            JButton rlambda_button = new JButton("R(lambda)");
            rlambda_button.addActionListener(this);
            rlambda_button.setActionCommand("rlambda");
            this.panel_d.add(rlambda_button);
            JButton toggle_button = new JButton("toggle");
            toggle_button.addActionListener(this);
            toggle_button.setActionCommand("toggle");
            this.panel_d.add(toggle_button);
            this.panel_b.add(this.panel_d);
            this.panel_b.setBorder(this.etchedBorder5);
            right.add(this.panel_b);
            ConstantMap[] blue = new ConstantMap[]{new ConstantMap(0.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(1.0, Display.Blue)};
            ConstantMap[] rred = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(0.0, Display.Blue), new ConstantMap(4.0, Display.PointSize)};
            ConstantMap[] rgreen = new ConstantMap[]{new ConstantMap(0.0, Display.Red), new ConstantMap(1.0, Display.Green), new ConstantMap(0.0, Display.Blue)};
            ConstantMap[] green = new ConstantMap[]{new ConstantMap(0.0, Display.Red), new ConstantMap(1.0, Display.Green), new ConstantMap(0.0, Display.Blue)};
            ConstantMap[] cmaps = new ConstantMap[5];
            cmaps[0] = new ConstantMap(1.0, Display.Red);
            cmaps[1] = new ConstantMap(0.0, Display.Green);
            cmaps[2] = new ConstantMap(0.0, Display.Blue);
            cmaps[3] = new ConstantMap(3.0, Display.PointSize);
            ScalarMap map_x = new ScalarMap(RealType.XAxis, Display.XAxis);
            map_x.setRange(0.0, Spline.this.n_samples - 1);
            ScalarMap map_y = new ScalarMap(RealType.YAxis, Display.YAxis);
            displays.addMap(map_x);
            displays.addMap(map_y);
            double[] scale_offset = new double[2];
            double[] data_range = new double[2];
            double[] display = new double[2];
            map_x.getScale(scale_offset, data_range, display);
            if (Spline.this.java2d) {
                for (ii = 0; ii < Spline.this.n_samples; ++ii) {
                    double display_value = (double)Spline.this.domain_values[ii] * scale_offset[0] + scale_offset[1];
                    cmaps[4] = new ConstantMap(display_value, Display.XAxis);
                    displays.addReferences((DataRenderer)new DirectManipulationRendererJ2D(), Spline.this.range_refs[ii], cmaps);
                }
            } else {
                for (ii = 0; ii < Spline.this.n_samples; ++ii) {
                    double display_value = (double)Spline.this.domain_values[ii] * scale_offset[0] + scale_offset[1];
                    cmaps[4] = new ConstantMap(display_value, Display.XAxis);
                    displays.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), Spline.this.range_refs[ii], cmaps);
                }
            }
            ScalarMap map_rx = new ScalarMap(RealType.XAxis, Display.XAxis);
            map_rx.setRange(-10.0, 0.0);
            ScalarMap map_ry = new ScalarMap(RealType.YAxis, Display.YAxis);
            display2.addMap(map_rx);
            display2.addMap(map_ry);
            this.panel_e = new JPanel();
            this.panel_e.setLayout(new BoxLayout(this.panel_e, 1));
            this.panel_e.setAlignmentY(0.0f);
            this.panel_e.setAlignmentX(0.0f);
            this.panel_e.add(display2.getComponent());
            this.panel_e.setBorder(this.etchedBorder5);
            right.add(this.panel_e);
            Spline.this.spline_fieldRef = new DataReferenceImpl("spline_fieldRef");
            Spline.this.gcv_fieldRef = new DataReferenceImpl("gcv_fieldRef");
            Spline.this.true_fieldRef = new DataReferenceImpl("true_fieldRef");
            Spline.this.rlambda_fieldRef = new DataReferenceImpl("rlambda_fieldRef");
            Spline.this.rlambda_fieldRef.setData(Spline.this.rlambda_field);
            Spline.this.spline_fieldRef.setData(Spline.this.spline_field);
            Spline.this.gcv_fieldRef.setData(Spline.this.gcv_field);
            Spline.this.true_fieldRef.setData(Spline.this.true_field);
            displays.addReference(Spline.this.spline_fieldRef);
            displays.addReference(Spline.this.gcv_fieldRef, green);
            displays.addReference(Spline.this.true_fieldRef, blue);
            display2.addReference(Spline.this.rlambda_fieldRef, rgreen);
            display2.addReference(Spline.this.wk_ref, rred);
            CellImpl lambda_cell = new CellImpl(){

                public void doAction() throws VisADException, RemoteException {
                    for (int ii = 0; ii < Spline.this.n_samples; ++ii) {
                        Spline.this.range_values[ii] = ((Real)Spline.this.range_refs[ii].getData()).getValue();
                    }
                    Spline.this.val = ((Real)Spline.this.lambda_ref.getData()).getValue();
                    Spline.this.val = Math.pow(10.0, Spline.this.val);
                    Spline.this.mode = 1;
                    Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                    Spline.this.f_range[0] = Spline.this.spline_range;
                    Spline.this.spline_field.setSamples(Spline.this.f_range);
                }
            };
            lambda_cell.addReference(Spline.this.lambda_ref);
            CellImpl noise_cell = new CellImpl(){
                double[] noise_a;
                {
                    this.noise_a = new double[Spline.this.n_samples];
                }

                public void doAction() throws VisADException, RemoteException {
                    double noise_fac = ((Real)Spline.this.noise_ref.getData()).getValue();
                    for (int ii = 0; ii < Spline.this.n_samples; ++ii) {
                        Spline.this.range_values[ii] = ((Real)Spline.this.range_refs[ii].getData()).getValue();
                        this.noise_a[ii] = Spline.this.last_noise_fac == 0.0 ? Spline.this.noise[ii] : (Spline.this.range_values[ii] - Spline.this.true_values[ii]) / Spline.this.last_noise_fac;
                        Spline.this.range_values[ii] = Spline.this.true_values[ii] + noise_fac * this.noise_a[ii];
                        Spline.this.range_refs[ii].setData(new Real(RealType.YAxis, Spline.this.range_values[ii]));
                    }
                    Spline.this.val = ((Real)Spline.this.lambda_ref.getData()).getValue();
                    Spline.this.val = Math.pow(10.0, Spline.this.val);
                    Spline.this.mode = 1;
                    Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                    Spline.this.f_range[0] = Spline.this.spline_range;
                    Spline.this.spline_field.setSamples(Spline.this.f_range);
                    Spline.this.mode = 2;
                    Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                    System.out.print(Spline.this.wkvalue[0] + "\n");
                    Spline.this.f_range[0] = Spline.this.spline_range;
                    Spline.this.gcv_field.setSamples(Spline.this.f_range);
                    Spline.this.wk_value = Spline.this.wkvalue[0];
                    Spline.this.wk_ref.setData(new Real(RealType.XAxis, Spline.this.wkvalue[0]));
                    Spline.this.last_noise_fac = noise_fac;
                    double tval = -10.0;
                    for (int ii = 0; ii < 50; ++ii) {
                        Spline.this.mode = 1;
                        Spline.this.rlambda_values[ii] = 0.0;
                        Spline.this.val = Math.pow(10.0, tval);
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        for (int kk = 0; kk < Spline.this.n_samples; ++kk) {
                            int n = ii;
                            Spline.this.rlambda_values[n] = Spline.this.rlambda_values[n] + (Spline.this.spline_range[kk] - Spline.this.true_values[kk]) * (Spline.this.spline_range[kk] - Spline.this.true_values[kk]);
                        }
                        tval += 0.2;
                    }
                    Spline.this.g_range[0] = Spline.this.rlambda_values;
                    Spline.this.rlambda_field.setSamples(Spline.this.g_range);
                }
            };
            noise_cell.addReference(Spline.this.noise_ref);
        }

        public void actionPerformed(ActionEvent e) {
            int kk;
            int ii;
            double tval;
            double x_c;
            double noise_fac;
            String cmd = e.getActionCommand();
            if (cmd.equals("fun0")) {
                try {
                    if (Spline.this.toggle) {
                        noise_fac = ((Real)Spline.this.noise_ref.getData()).getValue();
                        x_c = 0.0;
                        for (int ii2 = 0; ii2 < Spline.this.n_samples; ++ii2) {
                            Spline.this.true_values[ii2] = Math.cos(x_c * 3.1415926) * Math.exp(-3.0 * x_c);
                            Spline.this.range_values[ii2] = Spline.this.true_values[ii2] + noise_fac * Spline.this.noise[ii2];
                            Spline.this.range_refs[ii2].setData(new Real(RealType.YAxis, Spline.this.range_values[ii2]));
                            x_c += 0.02;
                        }
                        Spline.this.d_range[0] = Spline.this.true_values;
                        Spline.this.true_field.setSamples(Spline.this.d_range);
                        Spline.this.val = ((Real)Spline.this.lambda_ref.getData()).getValue();
                        Spline.this.val = Math.pow(10.0, Spline.this.val);
                        Spline.this.mode = 1;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.spline_field.setSamples(Spline.this.f_range);
                        Spline.this.mode = 2;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        System.out.print(Spline.this.wkvalue[0] + "\n");
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.gcv_field.setSamples(Spline.this.f_range);
                        Spline.this.wk_value = Spline.this.wkvalue[0];
                        Spline.this.wk_ref.setData(new Real(RealType.XAxis, Spline.this.wk_value));
                        tval = -10.0;
                        for (ii = 0; ii < 50; ++ii) {
                            Spline.this.mode = 1;
                            Spline.this.rlambda_values[ii] = 0.0;
                            Spline.this.val = Math.pow(10.0, tval);
                            Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                            for (kk = 0; kk < Spline.this.n_samples; ++kk) {
                                int n = ii;
                                Spline.this.rlambda_values[n] = Spline.this.rlambda_values[n] + (Spline.this.spline_range[kk] - Spline.this.true_values[kk]) * (Spline.this.spline_range[kk] - Spline.this.true_values[kk]);
                            }
                            tval += 0.2;
                        }
                        Spline.this.g_range[0] = Spline.this.rlambda_values;
                        Spline.this.rlambda_field.setSamples(Spline.this.g_range);
                    }
                }
                catch (VisADException exc) {
                }
                catch (RemoteException exc) {
                    // empty catch block
                }
            }
            if (cmd.equals("fun1")) {
                try {
                    if (Spline.this.toggle) {
                        noise_fac = ((Real)Spline.this.noise_ref.getData()).getValue();
                        x_c = 0.0;
                        for (int ii3 = 0; ii3 < Spline.this.n_samples; ++ii3) {
                            Spline.this.true_values[ii3] = Math.sin(x_c * 3.1415926) * Math.exp(-3.0 * x_c);
                            Spline.this.range_values[ii3] = Spline.this.true_values[ii3] + noise_fac * Spline.this.noise[ii3];
                            Spline.this.range_refs[ii3].setData(new Real(RealType.YAxis, Spline.this.range_values[ii3]));
                            x_c += 0.02;
                        }
                        Spline.this.d_range[0] = Spline.this.true_values;
                        Spline.this.true_field.setSamples(Spline.this.d_range);
                        Spline.this.val = ((Real)Spline.this.lambda_ref.getData()).getValue();
                        Spline.this.val = Math.pow(10.0, Spline.this.val);
                        Spline.this.mode = 1;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.spline_field.setSamples(Spline.this.f_range);
                        Spline.this.mode = 2;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        System.out.print(Spline.this.wkvalue[0] + "\n");
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.gcv_field.setSamples(Spline.this.f_range);
                        Spline.this.wk_value = Spline.this.wkvalue[0];
                        Spline.this.wk_ref.setData(new Real(RealType.XAxis, Spline.this.wk_value));
                        tval = -10.0;
                        for (ii = 0; ii < 50; ++ii) {
                            Spline.this.mode = 1;
                            Spline.this.rlambda_values[ii] = 0.0;
                            Spline.this.val = Math.pow(10.0, tval);
                            Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                            for (kk = 0; kk < Spline.this.n_samples; ++kk) {
                                int n = ii;
                                Spline.this.rlambda_values[n] = Spline.this.rlambda_values[n] + (Spline.this.spline_range[kk] - Spline.this.true_values[kk]) * (Spline.this.spline_range[kk] - Spline.this.true_values[kk]);
                            }
                            tval += 0.2;
                        }
                        Spline.this.g_range[0] = Spline.this.rlambda_values;
                        Spline.this.rlambda_field.setSamples(Spline.this.g_range);
                    }
                }
                catch (VisADException exc) {
                }
                catch (RemoteException exc) {
                    // empty catch block
                }
            }
            if (cmd.equals("fun2")) {
                try {
                    if (Spline.this.toggle) {
                        double noise_fac2 = ((Real)Spline.this.noise_ref.getData()).getValue();
                        x_c = 0.0;
                        for (int ii4 = 0; ii4 < Spline.this.n_samples; ++ii4) {
                            Spline.this.true_values[ii4] = x_c * Math.sin(1.0 / (x_c + 1.0)) * Math.exp(-3.0 * x_c);
                            Spline.this.range_values[ii4] = Spline.this.true_values[ii4] + noise_fac2 * Spline.this.noise[ii4];
                            Spline.this.range_refs[ii4].setData(new Real(RealType.YAxis, Spline.this.range_values[ii4]));
                            x_c += 0.02;
                        }
                        Spline.this.d_range[0] = Spline.this.true_values;
                        Spline.this.true_field.setSamples(Spline.this.d_range);
                        Spline.this.val = ((Real)Spline.this.lambda_ref.getData()).getValue();
                        Spline.this.val = Math.pow(10.0, Spline.this.val);
                        Spline.this.mode = 1;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.spline_field.setSamples(Spline.this.f_range);
                        Spline.this.mode = 2;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        System.out.print(Spline.this.wkvalue[0] + "\n");
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.gcv_field.setSamples(Spline.this.f_range);
                        Spline.this.wk_value = Spline.this.wkvalue[0];
                        Spline.this.wk_ref.setData(new Real(RealType.XAxis, Spline.this.wk_value));
                        tval = -10.0;
                        for (ii = 0; ii < 50; ++ii) {
                            Spline.this.mode = 1;
                            Spline.this.rlambda_values[ii] = 0.0;
                            Spline.this.val = Math.pow(10.0, tval);
                            Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                            for (kk = 0; kk < Spline.this.n_samples; ++kk) {
                                int n = ii;
                                Spline.this.rlambda_values[n] = Spline.this.rlambda_values[n] + (Spline.this.spline_range[kk] - Spline.this.true_values[kk]) * (Spline.this.spline_range[kk] - Spline.this.true_values[kk]);
                            }
                            tval += 0.2;
                        }
                        Spline.this.g_range[0] = Spline.this.rlambda_values;
                        Spline.this.rlambda_field.setSamples(Spline.this.g_range);
                    }
                }
                catch (VisADException exc) {
                }
                catch (RemoteException exc) {
                    // empty catch block
                }
            }
            if (cmd.equals("fun3")) {
                try {
                    if (Spline.this.toggle) {
                        double noise_fac3 = ((Real)Spline.this.noise_ref.getData()).getValue();
                        x_c = 0.0;
                        for (int ii5 = 0; ii5 < Spline.this.n_samples; ++ii5) {
                            Spline.this.true_values[ii5] = 2.0 * x_c * x_c * Math.sin(x_c * 3.1415926);
                            Spline.this.range_values[ii5] = Spline.this.true_values[ii5] + noise_fac3 * Spline.this.noise[ii5];
                            Spline.this.range_refs[ii5].setData(new Real(RealType.YAxis, Spline.this.range_values[ii5]));
                            x_c += 0.02;
                        }
                        Spline.this.d_range[0] = Spline.this.true_values;
                        Spline.this.true_field.setSamples(Spline.this.d_range);
                        Spline.this.val = ((Real)Spline.this.lambda_ref.getData()).getValue();
                        Spline.this.val = Math.pow(10.0, Spline.this.val);
                        Spline.this.mode = 1;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.spline_field.setSamples(Spline.this.f_range);
                        Spline.this.mode = 2;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        System.out.print(Spline.this.wkvalue[0] + "\n");
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.gcv_field.setSamples(Spline.this.f_range);
                        Spline.this.wk_value = Spline.this.wkvalue[0];
                        Spline.this.wk_ref.setData(new Real(RealType.XAxis, Spline.this.wk_value));
                        tval = -10.0;
                        for (ii = 0; ii < 50; ++ii) {
                            Spline.this.mode = 1;
                            Spline.this.rlambda_values[ii] = 0.0;
                            Spline.this.val = Math.pow(10.0, tval);
                            Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                            for (kk = 0; kk < Spline.this.n_samples; ++kk) {
                                int n = ii;
                                Spline.this.rlambda_values[n] = Spline.this.rlambda_values[n] + (Spline.this.spline_range[kk] - Spline.this.true_values[kk]) * (Spline.this.spline_range[kk] - Spline.this.true_values[kk]);
                            }
                            tval += 0.2;
                        }
                        Spline.this.g_range[0] = Spline.this.rlambda_values;
                        Spline.this.rlambda_field.setSamples(Spline.this.g_range);
                    }
                }
                catch (VisADException exc) {
                }
                catch (RemoteException exc) {
                    // empty catch block
                }
            }
            if (cmd.equals("fun4")) {
                try {
                    if (Spline.this.toggle) {
                        double noise_fac4 = ((Real)Spline.this.noise_ref.getData()).getValue();
                        x_c = 0.0;
                        for (int ii6 = 0; ii6 < Spline.this.n_samples; ++ii6) {
                            Spline.this.true_values[ii6] = Math.sin(x_c * 3.1415926) * Math.log(x_c + 1.0);
                            Spline.this.range_values[ii6] = Spline.this.true_values[ii6] + noise_fac4 * Spline.this.noise[ii6];
                            Spline.this.range_refs[ii6].setData(new Real(RealType.YAxis, Spline.this.range_values[ii6]));
                            x_c += 0.02;
                        }
                        Spline.this.d_range[0] = Spline.this.true_values;
                        Spline.this.true_field.setSamples(Spline.this.d_range);
                        Spline.this.val = ((Real)Spline.this.lambda_ref.getData()).getValue();
                        Spline.this.val = Math.pow(10.0, Spline.this.val);
                        Spline.this.mode = 1;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.spline_field.setSamples(Spline.this.f_range);
                        Spline.this.mode = 2;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        System.out.print(Spline.this.wkvalue[0] + "\n");
                        Spline.this.f_range[0] = Spline.this.spline_range;
                        Spline.this.gcv_field.setSamples(Spline.this.f_range);
                        Spline.this.wk_value = Spline.this.wkvalue[0];
                        Spline.this.wk_ref.setData(new Real(RealType.XAxis, Spline.this.wk_value));
                        tval = -10.0;
                        for (ii = 0; ii < 50; ++ii) {
                            Spline.this.mode = 1;
                            Spline.this.rlambda_values[ii] = 0.0;
                            Spline.this.val = Math.pow(10.0, tval);
                            Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                            for (kk = 0; kk < Spline.this.n_samples; ++kk) {
                                int n = ii;
                                Spline.this.rlambda_values[n] = Spline.this.rlambda_values[n] + (Spline.this.spline_range[kk] - Spline.this.true_values[kk]) * (Spline.this.spline_range[kk] - Spline.this.true_values[kk]);
                            }
                            tval += 0.2;
                        }
                        Spline.this.g_range[0] = Spline.this.rlambda_values;
                        Spline.this.rlambda_field.setSamples(Spline.this.g_range);
                    }
                }
                catch (VisADException exc) {
                }
                catch (RemoteException exc) {
                    // empty catch block
                }
            }
            if (cmd.equals("toggle")) {
                try {
                    if (Spline.this.toggle) {
                        Spline.this.toggle = false;
                        Spline.this.true_fieldRef.setData(Spline.this.nothing);
                    } else {
                        Spline.this.toggle = true;
                        Spline.this.true_fieldRef.setData(Spline.this.true_field);
                    }
                }
                catch (VisADException exc) {
                }
                catch (RemoteException exc) {
                    // empty catch block
                }
            }
            if (cmd.equals("spline")) {
                try {
                    for (int ii7 = 0; ii7 < Spline.this.n_samples; ++ii7) {
                        Spline.this.range_values[ii7] = ((Real)Spline.this.range_refs[ii7].getData()).getValue();
                    }
                    Spline.this.val = ((Real)Spline.this.lambda_ref.getData()).getValue();
                    Spline.this.val = Math.pow(10.0, Spline.this.val);
                    Spline.this.mode = 1;
                    Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                    Spline.this.f_range[0] = Spline.this.spline_range;
                    Spline.this.spline_field.setSamples(Spline.this.f_range);
                }
                catch (VisADException exc) {
                }
                catch (RemoteException exc) {
                    // empty catch block
                }
            }
            if (cmd.equals("GCV")) {
                try {
                    for (int ii8 = 0; ii8 < Spline.this.n_samples; ++ii8) {
                        Spline.this.range_values[ii8] = ((Real)Spline.this.range_refs[ii8].getData()).getValue();
                    }
                    Spline.this.val = ((Real)Spline.this.lambda_ref.getData()).getValue();
                    Spline.this.val = Math.pow(10.0, Spline.this.val);
                    Spline.this.mode = 2;
                    Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                    System.out.print(Spline.this.wkvalue[0] + "\n");
                    Spline.this.wk_value = Spline.this.wkvalue[0];
                    Spline.this.wk_ref.setData(new Real(RealType.XAxis, Spline.this.wk_value));
                    Spline.this.f_range[0] = Spline.this.spline_range;
                    Spline.this.gcv_field.setSamples(Spline.this.f_range);
                }
                catch (VisADException exc) {
                }
                catch (RemoteException exc) {
                    // empty catch block
                }
            }
            if (cmd.equals("nreset")) {
                try {
                    double noise_fac5 = ((Real)Spline.this.noise_ref.getData()).getValue();
                    boolean iset = false;
                    double gset = 0.0;
                    for (int ii9 = 0; ii9 < Spline.this.n_samples; ++ii9) {
                        double gasdev;
                        if (!iset) {
                            double v2;
                            double v1;
                            double r;
                            while ((r = (v1 = 2.0 * Math.random() - 1.0) * v1 + (v2 = 2.0 * Math.random() - 1.0) * v2) >= 1.0 || r == 0.0) {
                            }
                            double fac = Math.sqrt(-2.0 * Math.log(r) / r);
                            gset = v1 * fac;
                            iset = true;
                            gasdev = v2 * fac;
                        } else {
                            iset = false;
                            gasdev = gset;
                        }
                        Spline.this.noise[ii9] = gasdev;
                        Spline.this.range_values[ii9] = Spline.this.true_values[ii9] + noise_fac5 * Spline.this.noise[ii9];
                        Spline.this.range_refs[ii9].setData(new Real(RealType.YAxis, Spline.this.range_values[ii9]));
                    }
                    Spline.this.val = ((Real)Spline.this.lambda_ref.getData()).getValue();
                    Spline.this.val = Math.pow(10.0, Spline.this.val);
                    Spline.this.mode = 1;
                    Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                    Spline.this.f_range[0] = Spline.this.spline_range;
                    Spline.this.spline_field.setSamples(Spline.this.f_range);
                    Spline.this.mode = 2;
                    Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                    System.out.print(Spline.this.wkvalue[0] + "\n");
                    Spline.this.wk_value = Spline.this.wkvalue[0];
                    Spline.this.wk_ref.setData(new Real(RealType.XAxis, Spline.this.wk_value));
                    Spline.this.f_range[0] = Spline.this.spline_range;
                    Spline.this.gcv_field.setSamples(Spline.this.f_range);
                    double tval2 = -10.0;
                    Spline.this.mode = 1;
                    for (int ii10 = 0; ii10 < 50; ++ii10) {
                        Spline.this.rlambda_values[ii10] = 0.0;
                        Spline.this.val = Math.pow(10.0, tval2);
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        for (int kk2 = 0; kk2 < Spline.this.n_samples; ++kk2) {
                            int n = ii10;
                            Spline.this.rlambda_values[n] = Spline.this.rlambda_values[n] + (Spline.this.spline_range[kk2] - Spline.this.true_values[kk2]) * (Spline.this.spline_range[kk2] - Spline.this.true_values[kk2]);
                        }
                        tval2 += 0.2;
                    }
                    Spline.this.g_range[0] = Spline.this.rlambda_values;
                    Spline.this.rlambda_field.setSamples(Spline.this.g_range);
                }
                catch (VisADException exc) {
                }
                catch (RemoteException exc) {
                    // empty catch block
                }
            }
            if (cmd.equals("rlambda")) {
                try {
                    for (int ii11 = 0; ii11 < Spline.this.n_samples; ++ii11) {
                        Spline.this.range_values[ii11] = ((Real)Spline.this.range_refs[ii11].getData()).getValue();
                    }
                    double tval3 = -10.0;
                    for (int ii12 = 0; ii12 < 50; ++ii12) {
                        Spline.this.rlambda_values[ii12] = 0.0;
                        Spline.this.val = Math.pow(10.0, tval3);
                        Spline.this.mode = 1;
                        Spline.this.getspline_c(Spline.this.range_values, Spline.this.spline_range, Spline.this.val, Spline.this.mode, Spline.this.wkvalue);
                        for (int kk3 = 0; kk3 < Spline.this.n_samples; ++kk3) {
                            int n = ii12;
                            Spline.this.rlambda_values[n] = Spline.this.rlambda_values[n] + (Spline.this.spline_range[kk3] - Spline.this.true_values[kk3]) * (Spline.this.spline_range[kk3] - Spline.this.true_values[kk3]);
                        }
                        tval3 += 0.2;
                    }
                    Spline.this.g_range[0] = Spline.this.rlambda_values;
                    Spline.this.rlambda_field.setSamples(Spline.this.g_range);
                }
                catch (VisADException exc) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }
}

