#!/bin/sh

MPLUSVER="062"
UMEVER="660"
DATE="20161108"

# 元のファイルを展開
rm -rf mplus-TESTFLIGHT-$MPLUSVER
tar xf mplus-TESTFLIGHT-$MPLUSVER.tar.xz
rm -rf umefont_$UMEVER
7z x umefont_$UMEVER.7z


# ==============================================================================
# umeplus gothicを作成
# ==============================================================================

# umeplus-gothic.ttf を作成
cp -f mplus-TESTFLIGHT-$MPLUSVER/mplus-1m-regular.ttf umeplus-fonts-dev/fontforge-scripts-umeplus/
cp -f umefont_$UMEVER/ume-tgo4.ttf umeplus-fonts-dev/fontforge-scripts-umeplus/
cd umeplus-fonts-dev/fontforge-scripts-umeplus/
fontforge -script fix-mplus-1m-regular.pe
fontforge -script import-mplus.pe
cd -

# umeplus-p-gothic.ttf を作成
cp -f mplus-TESTFLIGHT-$MPLUSVER/mplus-1c-regular.ttf umeplus-fonts-dev/fontforge-scripts-umeplus-p/
cp -f umefont_$UMEVER/ume-pgo4.ttf umeplus-fonts-dev/fontforge-scripts-umeplus-p/
cd umeplus-fonts-dev/fontforge-scripts-umeplus-p/
fontforge -script fix-mplus-1c-regular.pe
fontforge -script import-mplus.pe
cd -

# リリース用のディレクトリを作成
rm -rf umeplus-fonts-$DATE
mkdir -p umeplus-fonts-$DATE/{docs-mplus,docs-ume,fontforge-scripts-umeplus,fontforge-scripts-umeplus-p}
cp mplus-TESTFLIGHT-$MPLUSVER/{LICENSE_E,LICENSE_J,README_E,README_J} umeplus-fonts-$DATE/docs-mplus/
cp umefont_$UMEVER/license.html umeplus-fonts-$DATE/docs-ume/
cp umeplus-fonts-dev/fontforge-scripts-umeplus*/umeplus*-gothic.ttf umeplus-fonts-$DATE/
cp umeplus-fonts-dev/fontforge-scripts-umeplus/*.pe umeplus-fonts-$DATE/fontforge-scripts-umeplus/
cp umeplus-fonts-dev/fontforge-scripts-umeplus-p/*.pe umeplus-fonts-$DATE/fontforge-scripts-umeplus-p/
cp umeplus-fonts-dev/{ChangeLog,README} umeplus-fonts-$DATE/
cp update-umeplus-fonts.sh umeplus-fonts-$DATE/

# ファイルを圧縮
rm -f umeplus-fonts-$DATE.tar*
tar cf umeplus-fonts-$DATE.tar umeplus-fonts-$DATE
XZ_OPT="--threads=0" xz -f umeplus-fonts-$DATE.tar


# ==============================================================================
# umeplus cl gothicを作成
# ==============================================================================

# umeplus-cl-gothic.ttf を作成
cp -f mplus-TESTFLIGHT-$MPLUSVER/mplus-1m-regular.ttf umeplus-cl-fonts-dev/fontforge-scripts-umeplus-cl/
cp -f umefont_$UMEVER/ume-tgc4.ttf umeplus-cl-fonts-dev/fontforge-scripts-umeplus-cl/
cd umeplus-cl-fonts-dev/fontforge-scripts-umeplus-cl/
fontforge -script fix-mplus-1m-regular.pe
fontforge -script import-mplus.pe
cd -

# umeplus-clp-gothic.ttf を作成
cp -f mplus-TESTFLIGHT-$MPLUSVER/mplus-1c-regular.ttf umeplus-cl-fonts-dev/fontforge-scripts-umeplus-clp/
cp -f umefont_$UMEVER/ume-pgc4.ttf umeplus-cl-fonts-dev/fontforge-scripts-umeplus-clp/
cd umeplus-cl-fonts-dev/fontforge-scripts-umeplus-clp/
fontforge -script fix-mplus-1c-regular.pe
fontforge -script import-mplus.pe
cd -

# リリース用のディレクトリを作成
rm -rf umeplus-cl-fonts-$DATE
mkdir -p umeplus-cl-fonts-$DATE/{docs-mplus,docs-ume,fontforge-scripts-umeplus-cl,fontforge-scripts-umeplus-clp}
cp mplus-TESTFLIGHT-$MPLUSVER/{LICENSE_E,LICENSE_J,README_E,README_J} umeplus-cl-fonts-$DATE/docs-mplus/
cp umefont_$UMEVER/license.html umeplus-cl-fonts-$DATE/docs-ume/
cp umeplus-cl-fonts-dev/fontforge-scripts-umeplus*/umeplus*-gothic.ttf umeplus-cl-fonts-$DATE/
cp umeplus-cl-fonts-dev/fontforge-scripts-umeplus-cl/*.pe umeplus-cl-fonts-$DATE/fontforge-scripts-umeplus-cl/
cp umeplus-cl-fonts-dev/fontforge-scripts-umeplus-clp/*.pe umeplus-cl-fonts-$DATE/fontforge-scripts-umeplus-clp/
cp umeplus-cl-fonts-dev/{ChangeLog,README} umeplus-cl-fonts-$DATE/

# ファイルを圧縮
rm -f umeplus-cl-fonts-$DATE.tar*
tar cf umeplus-cl-fonts-$DATE.tar umeplus-cl-fonts-$DATE
XZ_OPT="--threads=0" xz -f umeplus-cl-fonts-$DATE.tar
