// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package apigateway_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/apigateway"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleAPIGateway_CreateApiKey() {
	svc := apigateway.New(session.New())

	params := &apigateway.CreateApiKeyInput{
		Description: aws.String("String"),
		Enabled:     aws.Bool(true),
		Name:        aws.String("String"),
		StageKeys: []*apigateway.StageKey{
			{ // Required
				RestApiId: aws.String("String"),
				StageName: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateApiKey(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_CreateBasePathMapping() {
	svc := apigateway.New(session.New())

	params := &apigateway.CreateBasePathMappingInput{
		DomainName: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
		BasePath:   aws.String("String"),
		Stage:      aws.String("String"),
	}
	resp, err := svc.CreateBasePathMapping(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_CreateDeployment() {
	svc := apigateway.New(session.New())

	params := &apigateway.CreateDeploymentInput{
		RestApiId:           aws.String("String"), // Required
		StageName:           aws.String("String"), // Required
		CacheClusterEnabled: aws.Bool(true),
		CacheClusterSize:    aws.String("CacheClusterSize"),
		Description:         aws.String("String"),
		StageDescription:    aws.String("String"),
		Variables: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.CreateDeployment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_CreateDomainName() {
	svc := apigateway.New(session.New())

	params := &apigateway.CreateDomainNameInput{
		CertificateBody:       aws.String("String"), // Required
		CertificateChain:      aws.String("String"), // Required
		CertificateName:       aws.String("String"), // Required
		CertificatePrivateKey: aws.String("String"), // Required
		DomainName:            aws.String("String"), // Required
	}
	resp, err := svc.CreateDomainName(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_CreateModel() {
	svc := apigateway.New(session.New())

	params := &apigateway.CreateModelInput{
		ContentType: aws.String("String"), // Required
		Name:        aws.String("String"), // Required
		RestApiId:   aws.String("String"), // Required
		Description: aws.String("String"),
		Schema:      aws.String("String"),
	}
	resp, err := svc.CreateModel(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_CreateResource() {
	svc := apigateway.New(session.New())

	params := &apigateway.CreateResourceInput{
		ParentId:  aws.String("String"), // Required
		PathPart:  aws.String("String"), // Required
		RestApiId: aws.String("String"), // Required
	}
	resp, err := svc.CreateResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_CreateRestApi() {
	svc := apigateway.New(session.New())

	params := &apigateway.CreateRestApiInput{
		Name:        aws.String("String"), // Required
		CloneFrom:   aws.String("String"),
		Description: aws.String("String"),
	}
	resp, err := svc.CreateRestApi(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_CreateStage() {
	svc := apigateway.New(session.New())

	params := &apigateway.CreateStageInput{
		DeploymentId:        aws.String("String"), // Required
		RestApiId:           aws.String("String"), // Required
		StageName:           aws.String("String"), // Required
		CacheClusterEnabled: aws.Bool(true),
		CacheClusterSize:    aws.String("CacheClusterSize"),
		Description:         aws.String("String"),
		Variables: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.CreateStage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteApiKey() {
	svc := apigateway.New(session.New())

	params := &apigateway.DeleteApiKeyInput{
		ApiKey: aws.String("String"), // Required
	}
	resp, err := svc.DeleteApiKey(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteBasePathMapping() {
	svc := apigateway.New(session.New())

	params := &apigateway.DeleteBasePathMappingInput{
		BasePath:   aws.String("String"), // Required
		DomainName: aws.String("String"), // Required
	}
	resp, err := svc.DeleteBasePathMapping(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteClientCertificate() {
	svc := apigateway.New(session.New())

	params := &apigateway.DeleteClientCertificateInput{
		ClientCertificateId: aws.String("String"), // Required
	}
	resp, err := svc.DeleteClientCertificate(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteDeployment() {
	svc := apigateway.New(session.New())

	params := &apigateway.DeleteDeploymentInput{
		DeploymentId: aws.String("String"), // Required
		RestApiId:    aws.String("String"), // Required
	}
	resp, err := svc.DeleteDeployment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteDomainName() {
	svc := apigateway.New(session.New())

	params := &apigateway.DeleteDomainNameInput{
		DomainName: aws.String("String"), // Required
	}
	resp, err := svc.DeleteDomainName(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteIntegration() {
	svc := apigateway.New(session.New())

	params := &apigateway.DeleteIntegrationInput{
		HttpMethod: aws.String("String"), // Required
		ResourceId: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
	}
	resp, err := svc.DeleteIntegration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteIntegrationResponse() {
	svc := apigateway.New(session.New())

	params := &apigateway.DeleteIntegrationResponseInput{
		HttpMethod: aws.String("String"),     // Required
		ResourceId: aws.String("String"),     // Required
		RestApiId:  aws.String("String"),     // Required
		StatusCode: aws.String("StatusCode"), // Required
	}
	resp, err := svc.DeleteIntegrationResponse(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteMethod() {
	svc := apigateway.New(session.New())

	params := &apigateway.DeleteMethodInput{
		HttpMethod: aws.String("String"), // Required
		ResourceId: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
	}
	resp, err := svc.DeleteMethod(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteMethodResponse() {
	svc := apigateway.New(session.New())

	params := &apigateway.DeleteMethodResponseInput{
		HttpMethod: aws.String("String"),     // Required
		ResourceId: aws.String("String"),     // Required
		RestApiId:  aws.String("String"),     // Required
		StatusCode: aws.String("StatusCode"), // Required
	}
	resp, err := svc.DeleteMethodResponse(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteModel() {
	svc := apigateway.New(session.New())

	params := &apigateway.DeleteModelInput{
		ModelName: aws.String("String"), // Required
		RestApiId: aws.String("String"), // Required
	}
	resp, err := svc.DeleteModel(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteResource() {
	svc := apigateway.New(session.New())

	params := &apigateway.DeleteResourceInput{
		ResourceId: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
	}
	resp, err := svc.DeleteResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteRestApi() {
	svc := apigateway.New(session.New())

	params := &apigateway.DeleteRestApiInput{
		RestApiId: aws.String("String"), // Required
	}
	resp, err := svc.DeleteRestApi(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_DeleteStage() {
	svc := apigateway.New(session.New())

	params := &apigateway.DeleteStageInput{
		RestApiId: aws.String("String"), // Required
		StageName: aws.String("String"), // Required
	}
	resp, err := svc.DeleteStage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_FlushStageCache() {
	svc := apigateway.New(session.New())

	params := &apigateway.FlushStageCacheInput{
		RestApiId: aws.String("String"), // Required
		StageName: aws.String("String"), // Required
	}
	resp, err := svc.FlushStageCache(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GenerateClientCertificate() {
	svc := apigateway.New(session.New())

	params := &apigateway.GenerateClientCertificateInput{
		Description: aws.String("String"),
	}
	resp, err := svc.GenerateClientCertificate(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetAccount() {
	svc := apigateway.New(session.New())

	var params *apigateway.GetAccountInput
	resp, err := svc.GetAccount(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetApiKey() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetApiKeyInput{
		ApiKey: aws.String("String"), // Required
	}
	resp, err := svc.GetApiKey(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetApiKeys() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetApiKeysInput{
		Limit:    aws.Int64(1),
		Position: aws.String("String"),
	}
	resp, err := svc.GetApiKeys(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetBasePathMapping() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetBasePathMappingInput{
		BasePath:   aws.String("String"), // Required
		DomainName: aws.String("String"), // Required
	}
	resp, err := svc.GetBasePathMapping(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetBasePathMappings() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetBasePathMappingsInput{
		DomainName: aws.String("String"), // Required
		Limit:      aws.Int64(1),
		Position:   aws.String("String"),
	}
	resp, err := svc.GetBasePathMappings(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetClientCertificate() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetClientCertificateInput{
		ClientCertificateId: aws.String("String"), // Required
	}
	resp, err := svc.GetClientCertificate(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetClientCertificates() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetClientCertificatesInput{
		Limit:    aws.Int64(1),
		Position: aws.String("String"),
	}
	resp, err := svc.GetClientCertificates(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetDeployment() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetDeploymentInput{
		DeploymentId: aws.String("String"), // Required
		RestApiId:    aws.String("String"), // Required
	}
	resp, err := svc.GetDeployment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetDeployments() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetDeploymentsInput{
		RestApiId: aws.String("String"), // Required
		Limit:     aws.Int64(1),
		Position:  aws.String("String"),
	}
	resp, err := svc.GetDeployments(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetDomainName() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetDomainNameInput{
		DomainName: aws.String("String"), // Required
	}
	resp, err := svc.GetDomainName(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetDomainNames() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetDomainNamesInput{
		Limit:    aws.Int64(1),
		Position: aws.String("String"),
	}
	resp, err := svc.GetDomainNames(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetIntegration() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetIntegrationInput{
		HttpMethod: aws.String("String"), // Required
		ResourceId: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
	}
	resp, err := svc.GetIntegration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetIntegrationResponse() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetIntegrationResponseInput{
		HttpMethod: aws.String("String"),     // Required
		ResourceId: aws.String("String"),     // Required
		RestApiId:  aws.String("String"),     // Required
		StatusCode: aws.String("StatusCode"), // Required
	}
	resp, err := svc.GetIntegrationResponse(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetMethod() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetMethodInput{
		HttpMethod: aws.String("String"), // Required
		ResourceId: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
	}
	resp, err := svc.GetMethod(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetMethodResponse() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetMethodResponseInput{
		HttpMethod: aws.String("String"),     // Required
		ResourceId: aws.String("String"),     // Required
		RestApiId:  aws.String("String"),     // Required
		StatusCode: aws.String("StatusCode"), // Required
	}
	resp, err := svc.GetMethodResponse(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetModel() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetModelInput{
		ModelName: aws.String("String"), // Required
		RestApiId: aws.String("String"), // Required
		Flatten:   aws.Bool(true),
	}
	resp, err := svc.GetModel(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetModelTemplate() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetModelTemplateInput{
		ModelName: aws.String("String"), // Required
		RestApiId: aws.String("String"), // Required
	}
	resp, err := svc.GetModelTemplate(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetModels() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetModelsInput{
		RestApiId: aws.String("String"), // Required
		Limit:     aws.Int64(1),
		Position:  aws.String("String"),
	}
	resp, err := svc.GetModels(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetResource() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetResourceInput{
		ResourceId: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
	}
	resp, err := svc.GetResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetResources() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetResourcesInput{
		RestApiId: aws.String("String"), // Required
		Limit:     aws.Int64(1),
		Position:  aws.String("String"),
	}
	resp, err := svc.GetResources(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetRestApi() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetRestApiInput{
		RestApiId: aws.String("String"), // Required
	}
	resp, err := svc.GetRestApi(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetRestApis() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetRestApisInput{
		Limit:    aws.Int64(1),
		Position: aws.String("String"),
	}
	resp, err := svc.GetRestApis(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetSdk() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetSdkInput{
		RestApiId: aws.String("String"), // Required
		SdkType:   aws.String("String"), // Required
		StageName: aws.String("String"), // Required
		Parameters: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.GetSdk(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetStage() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetStageInput{
		RestApiId: aws.String("String"), // Required
		StageName: aws.String("String"), // Required
	}
	resp, err := svc.GetStage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_GetStages() {
	svc := apigateway.New(session.New())

	params := &apigateway.GetStagesInput{
		RestApiId:    aws.String("String"), // Required
		DeploymentId: aws.String("String"),
	}
	resp, err := svc.GetStages(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_PutIntegration() {
	svc := apigateway.New(session.New())

	params := &apigateway.PutIntegrationInput{
		HttpMethod: aws.String("String"),          // Required
		ResourceId: aws.String("String"),          // Required
		RestApiId:  aws.String("String"),          // Required
		Type:       aws.String("IntegrationType"), // Required
		CacheKeyParameters: []*string{
			aws.String("String"), // Required
			// More values...
		},
		CacheNamespace:        aws.String("String"),
		Credentials:           aws.String("String"),
		IntegrationHttpMethod: aws.String("String"),
		RequestParameters: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		RequestTemplates: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		Uri: aws.String("String"),
	}
	resp, err := svc.PutIntegration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_PutIntegrationResponse() {
	svc := apigateway.New(session.New())

	params := &apigateway.PutIntegrationResponseInput{
		HttpMethod: aws.String("String"),     // Required
		ResourceId: aws.String("String"),     // Required
		RestApiId:  aws.String("String"),     // Required
		StatusCode: aws.String("StatusCode"), // Required
		ResponseParameters: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		ResponseTemplates: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		SelectionPattern: aws.String("String"),
	}
	resp, err := svc.PutIntegrationResponse(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_PutMethod() {
	svc := apigateway.New(session.New())

	params := &apigateway.PutMethodInput{
		AuthorizationType: aws.String("String"), // Required
		HttpMethod:        aws.String("String"), // Required
		ResourceId:        aws.String("String"), // Required
		RestApiId:         aws.String("String"), // Required
		ApiKeyRequired:    aws.Bool(true),
		RequestModels: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		RequestParameters: map[string]*bool{
			"Key": aws.Bool(true), // Required
			// More values...
		},
	}
	resp, err := svc.PutMethod(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_PutMethodResponse() {
	svc := apigateway.New(session.New())

	params := &apigateway.PutMethodResponseInput{
		HttpMethod: aws.String("String"),     // Required
		ResourceId: aws.String("String"),     // Required
		RestApiId:  aws.String("String"),     // Required
		StatusCode: aws.String("StatusCode"), // Required
		ResponseModels: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		ResponseParameters: map[string]*bool{
			"Key": aws.Bool(true), // Required
			// More values...
		},
	}
	resp, err := svc.PutMethodResponse(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_TestInvokeMethod() {
	svc := apigateway.New(session.New())

	params := &apigateway.TestInvokeMethodInput{
		HttpMethod:          aws.String("String"), // Required
		ResourceId:          aws.String("String"), // Required
		RestApiId:           aws.String("String"), // Required
		Body:                aws.String("String"),
		ClientCertificateId: aws.String("String"),
		Headers: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
		PathWithQueryString: aws.String("String"),
		StageVariables: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.TestInvokeMethod(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateAccount() {
	svc := apigateway.New(session.New())

	params := &apigateway.UpdateAccountInput{
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateAccount(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateApiKey() {
	svc := apigateway.New(session.New())

	params := &apigateway.UpdateApiKeyInput{
		ApiKey: aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateApiKey(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateBasePathMapping() {
	svc := apigateway.New(session.New())

	params := &apigateway.UpdateBasePathMappingInput{
		BasePath:   aws.String("String"), // Required
		DomainName: aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateBasePathMapping(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateClientCertificate() {
	svc := apigateway.New(session.New())

	params := &apigateway.UpdateClientCertificateInput{
		ClientCertificateId: aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateClientCertificate(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateDeployment() {
	svc := apigateway.New(session.New())

	params := &apigateway.UpdateDeploymentInput{
		DeploymentId: aws.String("String"), // Required
		RestApiId:    aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateDeployment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateDomainName() {
	svc := apigateway.New(session.New())

	params := &apigateway.UpdateDomainNameInput{
		DomainName: aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateDomainName(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateIntegration() {
	svc := apigateway.New(session.New())

	params := &apigateway.UpdateIntegrationInput{
		HttpMethod: aws.String("String"), // Required
		ResourceId: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateIntegration(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateIntegrationResponse() {
	svc := apigateway.New(session.New())

	params := &apigateway.UpdateIntegrationResponseInput{
		HttpMethod: aws.String("String"),     // Required
		ResourceId: aws.String("String"),     // Required
		RestApiId:  aws.String("String"),     // Required
		StatusCode: aws.String("StatusCode"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateIntegrationResponse(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateMethod() {
	svc := apigateway.New(session.New())

	params := &apigateway.UpdateMethodInput{
		HttpMethod: aws.String("String"), // Required
		ResourceId: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateMethod(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateMethodResponse() {
	svc := apigateway.New(session.New())

	params := &apigateway.UpdateMethodResponseInput{
		HttpMethod: aws.String("String"),     // Required
		ResourceId: aws.String("String"),     // Required
		RestApiId:  aws.String("String"),     // Required
		StatusCode: aws.String("StatusCode"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateMethodResponse(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateModel() {
	svc := apigateway.New(session.New())

	params := &apigateway.UpdateModelInput{
		ModelName: aws.String("String"), // Required
		RestApiId: aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateModel(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateResource() {
	svc := apigateway.New(session.New())

	params := &apigateway.UpdateResourceInput{
		ResourceId: aws.String("String"), // Required
		RestApiId:  aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateRestApi() {
	svc := apigateway.New(session.New())

	params := &apigateway.UpdateRestApiInput{
		RestApiId: aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateRestApi(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleAPIGateway_UpdateStage() {
	svc := apigateway.New(session.New())

	params := &apigateway.UpdateStageInput{
		RestApiId: aws.String("String"), // Required
		StageName: aws.String("String"), // Required
		PatchOperations: []*apigateway.PatchOperation{
			{ // Required
				From:  aws.String("String"),
				Op:    aws.String("op"),
				Path:  aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.UpdateStage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
