.\"
.\" Copyright (c) 2022 Oracle and/or its affiliates.
.\"
.\" ktls-utils is free software; you can redistribute it and/or
.\" modify it under the terms of the GNU General Public License as
.\" published by the Free Software Foundation; version 2.
.\"
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
.\" General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
.\" 02110-1301, USA.
.\"
.\" tlshd.conf(5)
.\"
.\" Copyright (c) 2022 Oracle and/or its affiliates.
.TH tlshd.conf 5 "20 Oct 2022"
.SH NAME
tlshd.conf \- tlshd configuration file
.SH SYNOPSIS
.B /etc/tlshd.conf
.SH DESCRIPTION
The
.B tlshd
program implements a user agent that services TLS handshake requests
on behalf of kernel TLS consumers.
Its configuration file contains information that the program reads
when it starts up.
The file is designed to be human readable and contains a list of keywords
with values that provide various types of information.
The configuration file is considered a trusted source of information.
.P
The
.B tlshd
program reads this file once when it is launched.
Thus changes made in this file take effect only when the
.B tlshd
program is restarted.
If this file does not exist, the
.B tlshd
program exits immediately.
.SH OPTIONS
The configuration file is split into sections.
.P
The
.I [debug]
section specifies debugging settings for the
.B tlshd
program.
In this section, there are three available options:
.TP
.B loglevel
This option specifies an integer which indicates the debug message level.
Zero, the quietest setting, is the default.
.TP
.B tls
This option specifies an integer which indicates the debug message level
for TLS library calls.
Zero, the quietest setting, is the default.
.TP
.B nl
This option specifies an integer which indicates the debug message level
for netlink library calls.
Zero, the quietest setting, is the default.
.P
The
.I [authenticate]
section specifies default authentication material when establishing
TLS sessions.
In this section, there is one available option:
.TP
.B keyrings
This option specifies a semicolon-separated list of auxiliary keyrings
that contain handshake authentication tokens.
.B tlshd
links these keyrings into its session keyring.
The configuration file may specify either a keyring's name or serial number.
The default is to provide no keyring.
.P
And, in this section, there are two subsections:
.I [client]
and
.IR [server] .
The
.B tlshd
program consults the settings in the
.I [client]
subsection when handling the client end of a handshake,
and it consults the settings in the
.I [server]
subsection when handling the server end of a handshake.
.P
In each of these two subsections, there are three available options:
.TP
.B x509.truststore
This option specifies the pathname of a file containing a
PEM-encoded trust store that is to be used to verify a
certificate during a handshake.
If this option is not specified,
.B tlshd
uses the system's trust store.
.TP
.B x509.certificate
This option specifies the pathname of a file containing
a PEM-encoded x.509 certificate that is to be presented during
a handshake request when no other certificate is available.
.TP
.B x509.private_key
This option specifies the pathname of a file containing
a PEM-encoded private key associated with the above certificate.
.SH NOTES
This software is a prototype.
It's purpose is for demonstration and as a proof-of-concept.
USE THIS SOFTWARE AT YOUR OWN RISK.
.SH SEE ALSO
.BR tlshd (8)
.SH AUTHOR
Chuck Lever
