package org.jaudiotagger.issues;

import org.jaudiotagger.AbstractTestCase;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.aiff.AiffAudioHeader;
import org.jaudiotagger.audio.wav.WavOptions;
import org.jaudiotagger.audio.wav.WavSaveOptions;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagOptionSingleton;
import java.io.File;

/**
 * #119:https://bitbucket.org/ijabz/jaudiotagger/issues/119/wav-aiff-add-padding-byte-if-missing-in
 */
public class Issue119Test extends AbstractTestCase
{
    public void testWriteAiffWithOddLengthDataChunk() {

        Exception exceptionCaught = null;

        File orig = new File("testdata", "test151.aif");
        if (!orig.isFile())
        {
            System.err.println("Unable to test file - not available");
            return;
        }


        File testFile = AbstractTestCase.copyAudioToTmp("test151.aif", new File("test151MissingByte.aiff"));
        try
        {
            System.out.println("1");
            AudioFile f = AudioFileIO.read(testFile);
            System.out.println("2");
            AudioHeader ah = f.getAudioHeader();
            System.out.println("3");
            assertTrue(ah instanceof AiffAudioHeader);
            System.out.println("4");
            Tag tag = f.getTag();
            System.out.println(tag);
            f.getTag().setField(FieldKey.ARTIST,"fred");
            f.commit();
            f = AudioFileIO.read(testFile);
            tag = f.getTag();
            System.out.println(tag);
            assertEquals("fred",tag.getFirst(FieldKey.ARTIST));

        }
        catch(Exception ex)
        {
            ex.printStackTrace();
            exceptionCaught = ex;
        }
        assertNull(exceptionCaught);
    }

    public void testWriteFileWithOddLengthLastDataChunkInfo()
    {
        TagOptionSingleton.getInstance().setWavOptions(WavOptions.READ_INFO_ONLY);
        TagOptionSingleton.getInstance().setWavSaveOptions(WavSaveOptions.SAVE_ACTIVE);

        File orig = new File("testdata", "test153.wav");
        if (!orig.isFile())
        {
            System.err.println("Unable to test file - not available");
            return;
        }

        Exception exceptionCaught = null;
        try
        {
            File testFile = AbstractTestCase.copyAudioToTmp("test153.wav",  new File("test153_odd_data_length_info.wav"));
            AudioFile f = AudioFileIO.read(testFile);
            System.out.println(f.getAudioHeader());
            System.out.println(f.getTag());

            f.getTag().setField(FieldKey.ARTIST,"freddy");
            f.commit();
            f = AudioFileIO.read(testFile);
            Tag tag = f.getTag();
            System.out.println(tag);
            assertEquals("freddy",tag.getFirst(FieldKey.ARTIST));
        }
        catch (Exception e)
        {
            e.printStackTrace();
            exceptionCaught = e;
        }
        assertNull(exceptionCaught);
    }

    public void testWriteFileWithOddLengthLastDataChunkId3()
    {
        TagOptionSingleton.getInstance().setWavOptions(WavOptions.READ_ID3_ONLY);
        TagOptionSingleton.getInstance().setWavSaveOptions(WavSaveOptions.SAVE_ACTIVE);

        File orig = new File("testdata", "test153.wav");
        if (!orig.isFile())
        {
            System.err.println("Unable to test file - not available");
            return;
        }

        Exception exceptionCaught = null;
        try
        {
            File testFile = AbstractTestCase.copyAudioToTmp("test153.wav",  new File("test153_odd_data_length_id3.wav"));
            AudioFile f = AudioFileIO.read(testFile);
            System.out.println(f.getAudioHeader());
            System.out.println(f.getTag());

            f.getTag().setField(FieldKey.ARTIST,"freddy");
            f.commit();
            f = AudioFileIO.read(testFile);
            Tag tag = f.getTag();
            System.out.println(tag);
            assertEquals("freddy",tag.getFirst(FieldKey.ARTIST));
        }
        catch (Exception e)
        {
            e.printStackTrace();
            exceptionCaught = e;
        }
        assertNull(exceptionCaught);
    }

    public void testWriteFileWithOddLengthLastDataChunkId3AndInfo()
    {
        TagOptionSingleton.getInstance().setWavOptions(WavOptions.READ_ID3_ONLY);
        TagOptionSingleton.getInstance().setWavSaveOptions(WavSaveOptions.SAVE_BOTH_AND_SYNC);

        File orig = new File("testdata", "test153.wav");
        if (!orig.isFile())
        {
            System.err.println("Unable to test file - not available");
            return;
        }

        Exception exceptionCaught = null;
        try
        {
            File testFile = AbstractTestCase.copyAudioToTmp("test153.wav",  new File("test153_odd_data_length_id3_and_info.wav"));
            AudioFile f = AudioFileIO.read(testFile);
            System.out.println(f.getAudioHeader());
            System.out.println(f.getTag());

            f.getTag().setField(FieldKey.ARTIST,"freddy");
            f.commit();
            f = AudioFileIO.read(testFile);
            Tag tag = f.getTag();
            System.out.println(tag);
            assertEquals("freddy",tag.getFirst(FieldKey.ARTIST));
        }
        catch (Exception e)
        {
            e.printStackTrace();
            exceptionCaught = e;
        }
        assertNull(exceptionCaught);
    }
}
