/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File FolderViewer.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef FolderViewer_H
#define FolderViewer_H

#ifndef FolderObserver_H  
#include "FolderObserver.h"
#endif

#ifndef DragWindow_H
#include "DragWindow.h"
#endif

#include "Folder.h"

class FolderViewer :  public FolderObserver, public DragWindow {

public:

// -- Exceptions
	// None

// -- Contructors

// -- Destructor

	virtual ~FolderViewer(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None 


// -- Class methods
	// None 
	

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected: 
	// -- Contructors

	FolderViewer(Folder*);

// -- Members
	// None

	FolderH    folder_;

// -- Methods

	void install(Widget);
	void redraw();
	
	IconObject* newIcon();
	IconObject* newLink();

	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods

	// From DropSite

	virtual void drop(Dropping&);

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed
	FolderViewer(const FolderViewer&);
	FolderViewer& operator=(const FolderViewer&);

// -- Members
	// None	

	int count_;

// -- Methods  

	void color(IconObject* o, const char* name);

	virtual bool accept(IconObject*);
	virtual bool clone();

	virtual bool fill(int);

	virtual void where(IconObject*,int&,int&);

// -- Overridden methods
       	 
	 // from FolderObserver

	virtual void arrived(IconObject*);
	virtual void gone(IconObject*);
	virtual void position(IconObject*,int,int);
	virtual void renamed(IconObject*);

	virtual void opened(IconObject*);
	virtual void closed(IconObject*);

	virtual void waiting(IconObject*);
	virtual void error(IconObject*);
	virtual void modified(IconObject*);
	virtual void ready(IconObject*);

	virtual void highlight(IconObject*);
	

	// From DragWindow
	virtual void doubleClick(IconObject*);
	virtual void rename(IconObject*,const string&);
	 
// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const FolderViewer& p)
	//	{ p.print(s); return s; }

};

inline void destroy(FolderViewer**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(FolderViewer);
//#endif

#endif
