/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef HelpFactory_H
#include "HelpFactory.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#ifndef Parameter_H
#include "Parameter.h"
#endif


static map<string,HelpFactory*>* makers = 0;

HelpFactory::HelpFactory(const string& name)
{
	if(makers == 0)
		makers = new map<string,HelpFactory*>;

	(*makers)[name] = this;
}

HelpFactory::~HelpFactory()
{
	// Not called
}

RequestPanelHelp* HelpFactory::create(Widget parent, RequestPanel& owner, const Parameter& param)
{
	const char* help = param.help();

	if(help) {
		map<string,HelpFactory*>::iterator j = makers->find(help);
		if(j != makers->end())
			return (*j).second->make(parent, owner, param);
	}

	return 0;
}
