/*
* Copyright (c) 1997 - 2016
* Actelion Pharmaceuticals Ltd.
* Gewerbestrasse 16
* CH-4123 Allschwil, Switzerland
*
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
* 1. Redistributions of source code must retain the above copyright notice, this
*    list of conditions and the following disclaimer.
* 2. Redistributions in binary form must reproduce the above copyright notice,
*    this list of conditions and the following disclaimer in the documentation
*    and/or other materials provided with the distribution.
* 3. Neither the name of the the copyright holder nor the
*    names of its contributors may be used to endorse or promote products
*    derived from this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
* ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

package com.actelion.research.chem;

public class IsotopeHelper {
	private static final Isotope[][] sIsotope = {
			null,
		{	new Isotope(0, 1.007825032, 100.0000),	// 1
			new Isotope(1, 2.014101778, 0.0150),
			new Isotope(2, 3.016049268, 0),
			new Isotope(3, 4.027834627, 0),
			new Isotope(4, 5.039542911, 0),
			new Isotope(5, 6.044942608, 0) },
		{	new Isotope(1, 3.016029310, 0.0001),	// 2
			new Isotope(2, 4.002603250, 100.0000),
			new Isotope(3, 5.012223628, 0),
			new Isotope(4, 6.018888072, 0),
			new Isotope(5, 7.028030527, 0),
			new Isotope(6, 8.033921838, 0),
			new Isotope(7, 9.043820323, 0),
			new Isotope(8, 10.052399713, 0) },
		{	new Isotope(1, 4.027182329, 0),			// 3
			new Isotope(2, 5.012537796, 0),
			new Isotope(3, 6.015122281, 8.1081),
			new Isotope(4, 7.016004049, 100.0000),
			new Isotope(5, 8.022486670, 0),
			new Isotope(6, 9.026789122, 0),
			new Isotope(7, 10.035480884, 0),
			new Isotope(8, 11.043796166, 0),
			new Isotope(9, 12.053780, 0) },
		{	new Isotope(1, 5.040790, 0),			// 4
			new Isotope(2, 6.019725804, 0),
			new Isotope(3, 7.016929246, 0),
			new Isotope(4, 8.005305094, 0),
			new Isotope(5, 9.012182135, 100.0000),
			new Isotope(6, 10.013533720, 0),
			new Isotope(7, 11.021657653, 0),
			new Isotope(8, 12.026920631, 0),
			new Isotope(9, 13.036133834, 0),
			new Isotope(10, 14.042815522, 0) },
		{	new Isotope(2, 7.029917389, 0),			// 5
			new Isotope(3, 8.024606713, 0),
			new Isotope(4, 9.013328806, 0),
			new Isotope(5, 10.012937027, 24.8439),
			new Isotope(6, 11.009305466, 100.0000),
			new Isotope(7, 12.014352109, 0),
			new Isotope(8, 13.017780267, 0),
			new Isotope(9, 14.025404064, 0),
			new Isotope(10, 15.031097291, 0),
			new Isotope(11, 16.039808836, 0),
			new Isotope(12, 17.046931399, 0),
			new Isotope(13, 18.056170, 0),
			new Isotope(14, 19.063730, 0) },
		{	new Isotope(2, 8.037675026, 0),			// 6
			new Isotope(3, 9.031040087, 0),
			new Isotope(4, 10.016853110, 0),
			new Isotope(5, 11.011433818, 0),
			new Isotope(6, 12.0000000, 100.0000),
			new Isotope(7, 13.003354838, 1.1122),
			new Isotope(8, 14.003241988, 0),
			new Isotope(9, 15.010599258, 0),
			new Isotope(10, 16.014701243, 0),
			new Isotope(11, 17.022583712, 0),
			new Isotope(12, 18.026757058, 0),
			new Isotope(13, 19.035248094, 0),
			new Isotope(14, 20.040322395, 0),
			new Isotope(15, 21.049340, 0),
			new Isotope(16, 22.056450, 0) },
		{	new Isotope(3, 10.042618, 0),			// 7
			new Isotope(4, 11.026796226, 0),
			new Isotope(5, 12.018613202, 0),
			new Isotope(6, 13.005738584, 0),
			new Isotope(7, 14.003074005, 100.0000),
			new Isotope(8, 15.000108898, 0.3673),
			new Isotope(9, 16.006101417, 0),
			new Isotope(10, 17.008449673, 0),
			new Isotope(11, 18.014081827, 0),
			new Isotope(12, 19.017026896, 0),
			new Isotope(13, 20.023367295, 0),
			new Isotope(14, 21.027087574, 0),
			new Isotope(15, 22.034440259, 0),
			new Isotope(16, 23.040510, 0),
			new Isotope(17, 24.050500, 0) },
		{	new Isotope(4, 12.034404776, 0),		// 8
			new Isotope(5, 13.024810400, 0),
			new Isotope(6, 14.008595285, 0),
			new Isotope(7, 15.003065386, 0),
			new Isotope(8, 15.994914622, 100.0000),
			new Isotope(9, 16.999131501, 0.0381),
			new Isotope(10, 17.999160419, 0.2005),
			new Isotope(11, 19.003578730, 0),
			new Isotope(12, 20.004076150, 0),
			new Isotope(13, 21.008654631, 0),
			new Isotope(14, 22.009967157, 0),
			new Isotope(15, 23.015691325, 0),
			new Isotope(16, 24.020369922, 0),
			new Isotope(17, 25.029140, 0),
			new Isotope(18, 26.037750, 0) },
		{	new Isotope(5, 14.036080, 0),			// 9
			new Isotope(6, 15.018010856, 0),
			new Isotope(7, 16.011465730, 0),
			new Isotope(8, 17.002095238, 0),
			new Isotope(9, 18.000937667, 0),
			new Isotope(10, 18.998403205, 100.0000),
			new Isotope(11, 19.999981324, 0),
			new Isotope(12, 20.999948921, 0),
			new Isotope(13, 22.002999250, 0),
			new Isotope(14, 23.003574385, 0),
			new Isotope(15, 24.008099371, 0),
			new Isotope(16, 25.012094963, 0),
			new Isotope(17, 26.019633157, 0),
			new Isotope(18, 27.026892316, 0),
			new Isotope(19, 28.035670, 0),
			new Isotope(20, 29.043260, 0) },
		{	new Isotope(6, 16.025756907, 0),		// 10
			new Isotope(7, 17.017697565, 0),
			new Isotope(8, 18.005697066, 0),
			new Isotope(9, 19.001879839, 0),
			new Isotope(10, 19.992440176, 100.0000),
			new Isotope(11, 20.993846744, 0.2983),
			new Isotope(12, 21.991385510, 10.1867),
			new Isotope(13, 22.994467337, 0),
			new Isotope(14, 23.993615074, 0),
			new Isotope(15, 24.997789899, 0),
			new Isotope(16, 26.000461498, 0),
			new Isotope(17, 27.007615200, 0),
			new Isotope(18, 28.012108072, 0),
			new Isotope(19, 29.019345902, 0),
			new Isotope(20, 30.023872000, 0),
			new Isotope(21, 31.033110, 0),
			new Isotope(22, 32.039910, 0) },
		{	new Isotope(7, 18.027180, 0),			// 11
			new Isotope(8, 19.013879450, 0),
			new Isotope(9, 20.007348260, 0),
			new Isotope(10, 20.997655099, 0),
			new Isotope(11, 21.994436782, 0),
			new Isotope(12, 22.989769675, 100.0000),
			new Isotope(13, 23.990963332, 0),
			new Isotope(14, 24.989954352, 0),
			new Isotope(15, 25.992589898, 0),
			new Isotope(16, 26.994008702, 0),
			new Isotope(17, 27.998890410, 0),
			new Isotope(18, 29.002811301, 0),
			new Isotope(19, 30.009226487, 0),
			new Isotope(20, 31.013595108, 0),
			new Isotope(21, 32.019649792, 0),
			new Isotope(22, 33.027386000, 0),
			new Isotope(23, 34.034900, 0),
			new Isotope(24, 35.044180, 0) },
		{	new Isotope(8, 20.018862744, 0),		// 12
			new Isotope(9, 21.011714174, 0),
			new Isotope(10, 21.999574055, 0),
			new Isotope(11, 22.994124850, 0),
			new Isotope(12, 23.985041898, 100.0000),
			new Isotope(13, 24.985837023, 12.6598),
			new Isotope(14, 25.982593040, 13.9380),
			new Isotope(15, 26.984340742, 0),
			new Isotope(16, 27.983876703, 0),
			new Isotope(17, 28.988554743, 0),
			new Isotope(18, 29.990464529, 0),
			new Isotope(19, 30.996548459, 0),
			new Isotope(20, 31.999145889, 0),
			new Isotope(21, 33.005586975, 0),
			new Isotope(22, 34.009072440, 0),
			new Isotope(23, 35.018669000, 0),
			new Isotope(24, 36.022450, 0),
			new Isotope(25, 37.031240, 0) },
		{	new Isotope(8, 21.028040, 0),			// 13
			new Isotope(9, 22.019520, 0),
			new Isotope(10, 23.007264900, 0),
			new Isotope(11, 23.999940911, 0),
			new Isotope(12, 24.990428555, 0),
			new Isotope(13, 25.986891659, 0),
			new Isotope(14, 26.981538441, 100.0000),
			new Isotope(15, 27.981910184, 0),
			new Isotope(16, 28.980444848, 0),
			new Isotope(17, 29.982960304, 0),
			new Isotope(18, 30.983946023, 0),
			new Isotope(19, 31.988124379, 0),
			new Isotope(20, 32.990869587, 0),
			new Isotope(21, 33.996927255, 0),
			new Isotope(22, 34.999937650, 0),
			new Isotope(23, 36.006351501, 0),
			new Isotope(24, 37.010310000, 0),
			new Isotope(25, 38.016900, 0),
			new Isotope(26, 39.021900, 0) },
		{	new Isotope(8, 22.034530, 0),			// 14
			new Isotope(9, 23.025520, 0),
			new Isotope(10, 24.011545711, 0),
			new Isotope(11, 25.004106640, 0),
			new Isotope(12, 25.992329935, 0),
			new Isotope(13, 26.986704764, 0),
			new Isotope(14, 27.976926533, 100.0000),
			new Isotope(15, 28.976494719, 5.0634),
			new Isotope(16, 29.973770218, 3.3612),
			new Isotope(17, 30.975363275, 0),
			new Isotope(18, 31.974148129, 0),
			new Isotope(19, 32.978000520, 0),
			new Isotope(20, 33.978575745, 0),
			new Isotope(21, 34.984584158, 0),
			new Isotope(22, 35.986687363, 0),
			new Isotope(23, 36.992995990, 0),
			new Isotope(24, 37.995980000, 0),
			new Isotope(25, 39.002300, 0),
			new Isotope(26, 40.005800, 0),
			new Isotope(27, 41.012700, 0),
			new Isotope(28, 42.016100, 0) },
		{	new Isotope(9, 24.034350, 0),			// 15
			new Isotope(10, 25.020260, 0),
			new Isotope(11, 26.011780, 0),
			new Isotope(12, 26.999191645, 0),
			new Isotope(13, 27.992312330, 0),
			new Isotope(14, 28.981801376, 0),
			new Isotope(15, 29.978313807, 0),
			new Isotope(16, 30.973761512, 100.0000),
			new Isotope(17, 31.973907163, 0),
			new Isotope(18, 32.971725281, 0),
			new Isotope(19, 33.973636381, 0),
			new Isotope(20, 34.973314249, 0),
			new Isotope(21, 35.978259824, 0),
			new Isotope(22, 36.979608338, 0),
			new Isotope(23, 37.984470000, 0),
			new Isotope(24, 38.986420000, 0),
			new Isotope(25, 39.991050000, 0),
			new Isotope(26, 40.994800000, 0),
			new Isotope(27, 42.000090, 0),
			new Isotope(28, 43.003310, 0),
			new Isotope(29, 44.009880, 0),
			new Isotope(30, 45.015140, 0),
			new Isotope(31, 46.023830, 0) },
		{	new Isotope(10, 26.027880, 0),			// 16
			new Isotope(11, 27.018795, 0),
			new Isotope(12, 28.004372661, 0),
			new Isotope(13, 28.996608805, 0),
			new Isotope(14, 29.984902954, 0),
			new Isotope(15, 30.979554421, 0),
			new Isotope(16, 31.972070690, 100.0000),
			new Isotope(17, 32.971458497, 0.7893),
			new Isotope(18, 33.967866831, 4.4306),
			new Isotope(19, 34.969032140, 0),
			new Isotope(20, 35.967080880, 0.0220),
			new Isotope(21, 36.971125716, 0),
			new Isotope(22, 37.971163443, 0),
			new Isotope(23, 38.975135275, 0),
			new Isotope(24, 39.975470000, 0),
			new Isotope(25, 40.980030000, 0),
			new Isotope(26, 41.981490000, 0),
			new Isotope(27, 42.986600000, 0),
			new Isotope(28, 43.988320, 0),
			new Isotope(29, 44.994820, 0),
			new Isotope(30, 45.999570, 0),
			new Isotope(31, 47.007620, 0),
			new Isotope(32, 48.012990, 0),
			new Isotope(33, 49.022010, 0) },
		{	new Isotope(11, 28.028510, 0),			// 17
			new Isotope(12, 29.014110, 0),
			new Isotope(13, 30.004770, 0),
			new Isotope(14, 30.992416014, 0),
			new Isotope(15, 31.985688908, 0),
			new Isotope(16, 32.977451798, 0),
			new Isotope(17, 33.973761967, 0),
			new Isotope(18, 34.968852707, 100.0000),
			new Isotope(19, 35.968306945, 0),
			new Isotope(20, 36.965902600, 31.9780),
			new Isotope(21, 37.968010550, 0),
			new Isotope(22, 38.968007677, 0),
			new Isotope(23, 39.970415555, 0),
			new Isotope(24, 40.970650212, 0),
			new Isotope(25, 41.973174994, 0),
			new Isotope(26, 42.974203385, 0),
			new Isotope(27, 43.978538712, 0),
			new Isotope(28, 44.979700000, 0),
			new Isotope(29, 45.984120, 0),
			new Isotope(30, 46.987950, 0),
			new Isotope(31, 47.994850, 0),
			new Isotope(32, 48.999890, 0),
			new Isotope(33, 50.007730, 0),
			new Isotope(34, 51.013530, 0) },
		{	new Isotope(12, 30.021560, 0),			// 18
			new Isotope(13, 31.012126, 0),
			new Isotope(14, 31.997660660, 0),
			new Isotope(15, 32.989928719, 0),
			new Isotope(16, 33.980270118, 0),
			new Isotope(17, 34.975256726, 0),
			new Isotope(18, 35.967546282, 0.3380),
			new Isotope(19, 36.966775912, 0),
			new Isotope(20, 37.962732161, 0.0630),
			new Isotope(21, 38.964313413, 0),
			new Isotope(22, 39.962383123, 100.0000),
			new Isotope(23, 40.964500828, 0),
			new Isotope(24, 41.963046386, 0),
			new Isotope(25, 42.965670701, 0),
			new Isotope(26, 43.965365269, 0),
			new Isotope(27, 44.968094979, 0),
			new Isotope(28, 45.968093467, 0),
			new Isotope(29, 46.972186238, 0),
			new Isotope(30, 47.975070, 0),
			new Isotope(31, 48.982180, 0),
			new Isotope(32, 49.985940, 0),
			new Isotope(33, 50.993240, 0),
			new Isotope(34, 51.998170, 0),
			new Isotope(35, 53.006227, 0) },
		{	new Isotope(13, 32.021920, 0),			// 19
			new Isotope(14, 33.007260, 0),
			new Isotope(15, 33.998410, 0),
			new Isotope(16, 34.988011615, 0),
			new Isotope(17, 35.981293405, 0),
			new Isotope(18, 36.973376915, 0),
			new Isotope(19, 37.969080107, 0),
			new Isotope(20, 38.963706861, 100.0000),
			new Isotope(21, 39.963998672, 0.0130),
			new Isotope(22, 40.961825972, 7.2170),
			new Isotope(23, 41.962403059, 0),
			new Isotope(24, 42.960715746, 0),
			new Isotope(25, 43.961556146, 0),
			new Isotope(26, 44.960699658, 0),
			new Isotope(27, 45.961976203, 0),
			new Isotope(28, 46.961677807, 0),
			new Isotope(29, 47.965512946, 0),
			new Isotope(30, 48.967450084, 0),
			new Isotope(31, 49.972782832, 0),
			new Isotope(32, 50.976380, 0),
			new Isotope(33, 51.982610, 0),
			new Isotope(34, 52.987120, 0),
			new Isotope(35, 53.993990, 0),
			new Isotope(36, 54.999388, 0) },
		{	new Isotope(14, 34.014120, 0),			// 20
			new Isotope(15, 35.004765, 0),
			new Isotope(16, 35.993087234, 0),
			new Isotope(17, 36.985871505, 0),
			new Isotope(18, 37.976318637, 0),
			new Isotope(19, 38.970717729, 0),
			new Isotope(20, 39.962591155, 100.0000),
			new Isotope(21, 40.962278349, 0),
			new Isotope(22, 41.958618337, 0.6674),
			new Isotope(23, 42.958766833, 0.1393),
			new Isotope(24, 43.955481094, 2.1518),
			new Isotope(25, 44.956185938, 0),
			new Isotope(26, 45.953692759, 0.0041),
			new Isotope(27, 46.954546459, 0),
			new Isotope(28, 47.952533512, 0.1929),
			new Isotope(29, 48.955673302, 0),
			new Isotope(30, 49.957518286, 0),
			new Isotope(31, 50.961474238, 0),
			new Isotope(32, 51.965100000, 0),
			new Isotope(33, 52.970050, 0),
			new Isotope(34, 53.974680, 0),
			new Isotope(35, 54.980550, 0),
			new Isotope(36, 55.985790, 0),
			new Isotope(37, 56.992356, 0) },
		{	new Isotope(15, 36.014920, 0),			// 21
			new Isotope(16, 37.003050, 0),
			new Isotope(17, 37.994700, 0),
			new Isotope(18, 38.984790009, 0),
			new Isotope(19, 39.977964014, 0),
			new Isotope(20, 40.969251316, 0),
			new Isotope(21, 41.965516761, 0),
			new Isotope(22, 42.961150980, 0),
			new Isotope(23, 43.959403048, 0),
			new Isotope(24, 44.955910243, 100.0000),
			new Isotope(25, 45.955170250, 0),
			new Isotope(26, 46.952408027, 0),
			new Isotope(27, 47.952234991, 0),
			new Isotope(28, 48.950024065, 0),
			new Isotope(29, 49.952187008, 0),
			new Isotope(30, 50.953602700, 0),
			new Isotope(31, 51.956650000, 0),
			new Isotope(32, 52.958170000, 0),
			new Isotope(33, 53.963000000, 0),
			new Isotope(34, 54.969400000, 0),
			new Isotope(35, 55.972660, 0),
			new Isotope(36, 56.977040, 0),
			new Isotope(37, 57.983070, 0),
			new Isotope(38, 58.988041, 0) },
		{	new Isotope(16, 38.009770, 0),			// 22
			new Isotope(17, 39.001323, 0),
			new Isotope(18, 39.990498907, 0),
			new Isotope(19, 40.983131, 0),
			new Isotope(20, 41.973031622, 0),
			new Isotope(21, 42.968523342, 0),
			new Isotope(22, 43.959690235, 0),
			new Isotope(23, 44.958124349, 0),
			new Isotope(24, 45.952629491, 10.8401),
			new Isotope(25, 46.951763792, 9.8916),
			new Isotope(26, 47.947947053, 100.0000),
			new Isotope(27, 48.947870789, 7.4526),
			new Isotope(28, 49.944792069, 7.3171),
			new Isotope(29, 50.946616017, 0),
			new Isotope(30, 51.946898175, 0),
			new Isotope(31, 52.949731709, 0),
			new Isotope(32, 53.950870000, 0),
			new Isotope(33, 54.955120000, 0),
			new Isotope(34, 55.957990000, 0),
			new Isotope(35, 56.964300000, 0),
			new Isotope(36, 57.966110, 0),
			new Isotope(37, 58.971960, 0),
			new Isotope(38, 59.975640, 0),
			new Isotope(39, 60.982018, 0) },
		{	new Isotope(17, 40.011090, 0),			// 23
			new Isotope(18, 40.999740, 0),
			new Isotope(19, 41.991230, 0),
			new Isotope(20, 42.980650, 0),
			new Isotope(21, 43.974400, 0),
			new Isotope(22, 44.965782286, 0),
			new Isotope(23, 45.960199491, 0),
			new Isotope(24, 46.954906918, 0),
			new Isotope(25, 47.952254480, 0),
			new Isotope(26, 48.948516914, 0),
			new Isotope(27, 49.947162792, 0.2510),
			new Isotope(28, 50.943963675, 100.0000),
			new Isotope(29, 51.944779658, 0),
			new Isotope(30, 52.944342517, 0),
			new Isotope(31, 53.946444381, 0),
			new Isotope(32, 54.947238194, 0),
			new Isotope(33, 55.950360000, 0),
			new Isotope(34, 56.952360000, 0),
			new Isotope(35, 57.956650000, 0),
			new Isotope(36, 58.959300000, 0),
			new Isotope(37, 59.964500000, 0),
			new Isotope(38, 60.967410, 0),
			new Isotope(39, 61.973140, 0),
			new Isotope(40, 62.976750, 0) },
		{	new Isotope(18, 42.006430, 0),			// 24
			new Isotope(19, 42.997707, 0),
			new Isotope(20, 43.985470, 0),
			new Isotope(21, 44.979160, 0),
			new Isotope(22, 45.968361649, 0),
			new Isotope(23, 46.962906512, 0),
			new Isotope(24, 47.954035861, 0),
			new Isotope(25, 48.951341135, 0),
			new Isotope(26, 49.946049607, 5.1915),
			new Isotope(27, 50.944771767, 0),
			new Isotope(28, 51.940511904, 100.0000),
			new Isotope(29, 52.940653781, 11.3379),
			new Isotope(30, 53.938884921, 2.8166),
			new Isotope(31, 54.940844164, 0),
			new Isotope(32, 55.940645238, 0),
			new Isotope(33, 56.943753800, 0),
			new Isotope(34, 57.944250000, 0),
			new Isotope(35, 58.948630000, 0),
			new Isotope(36, 59.949730000, 0),
			new Isotope(37, 60.954090000, 0),
			new Isotope(38, 61.955800000, 0),
			new Isotope(39, 62.961860, 0),
			new Isotope(40, 63.964200, 0),
			new Isotope(41, 64.970370, 0) },
		{	new Isotope(19, 44.006870, 0),			// 25
			new Isotope(20, 44.994510, 0),
			new Isotope(21, 45.986720, 0),
			new Isotope(22, 46.976100, 0),
			new Isotope(23, 47.968870, 0),
			new Isotope(24, 48.959623415, 0),
			new Isotope(25, 49.954243960, 0),
			new Isotope(26, 50.948215487, 0),
			new Isotope(27, 51.945570079, 0),
			new Isotope(28, 52.941294702, 0),
			new Isotope(29, 53.940363247, 0),
			new Isotope(30, 54.938049636, 100.0000),
			new Isotope(31, 55.938909366, 0),
			new Isotope(32, 56.938287458, 0),
			new Isotope(33, 57.939986451, 0),
			new Isotope(34, 58.940447166, 0),
			new Isotope(35, 59.943193998, 0),
			new Isotope(36, 60.944460000, 0),
			new Isotope(37, 61.947970000, 0),
			new Isotope(38, 62.949810000, 0),
			new Isotope(39, 63.953730000, 0),
			new Isotope(40, 64.956100000, 0),
			new Isotope(41, 65.960820, 0),
			new Isotope(42, 66.963820, 0) },
		{	new Isotope(19, 45.014560, 0),			// 26
			new Isotope(20, 46.000810, 0),
			new Isotope(21, 46.992890, 0),
			new Isotope(22, 47.980560, 0),
			new Isotope(23, 48.973610, 0),
			new Isotope(24, 49.962993316, 0),
			new Isotope(25, 50.956824936, 0),
			new Isotope(26, 51.948116526, 0),
			new Isotope(27, 52.945312282, 0),
			new Isotope(28, 53.939614836, 6.3236),
			new Isotope(29, 54.938298029, 0),
			new Isotope(30, 55.934942133, 100.0000),
			new Isotope(31, 56.935398707, 2.3986),
			new Isotope(32, 57.933280458, 0.3053),
			new Isotope(33, 58.934880493, 0),
			new Isotope(34, 59.934076943, 0),
			new Isotope(35, 60.936749461, 0),
			new Isotope(36, 61.936770495, 0),
			new Isotope(37, 62.940118442, 0),
			new Isotope(38, 63.940870000, 0),
			new Isotope(39, 64.944940000, 0),
			new Isotope(40, 65.945980000, 0),
			new Isotope(41, 66.950000000, 0),
			new Isotope(42, 67.952510, 0),
			new Isotope(43, 68.957700, 0) },
		{	new Isotope(21, 48.001760, 0),			// 27
			new Isotope(22, 48.989720, 0),
			new Isotope(23, 49.981540, 0),
			new Isotope(24, 50.970720, 0),
			new Isotope(25, 51.963590, 0),
			new Isotope(26, 52.954224985, 0),
			new Isotope(27, 53.948464147, 0),
			new Isotope(28, 54.942003149, 0),
			new Isotope(29, 55.939843937, 0),
			new Isotope(30, 56.936296235, 0),
			new Isotope(31, 57.935757571, 0),
			new Isotope(32, 58.933200194, 100.0000),
			new Isotope(33, 59.933822196, 0),
			new Isotope(34, 60.932479381, 0),
			new Isotope(35, 61.934054212, 0),
			new Isotope(36, 62.933615218, 0),
			new Isotope(37, 63.935813523, 0),
			new Isotope(38, 64.936484581, 0),
			new Isotope(39, 65.939825412, 0),
			new Isotope(40, 66.940610000, 0),
			new Isotope(41, 67.944360000, 0),
			new Isotope(42, 68.945200000, 0),
			new Isotope(43, 69.949810, 0),
			new Isotope(44, 70.951730, 0),
			new Isotope(45, 71.956410, 0) },
		{	new Isotope(22, 49.995930, 0),			// 28
			new Isotope(23, 50.987720, 0),
			new Isotope(24, 51.975680, 0),
			new Isotope(25, 52.968460, 0),
			new Isotope(26, 53.957910508, 0),
			new Isotope(27, 54.951336329, 0),
			new Isotope(28, 55.942136339, 0),
			new Isotope(29, 56.939800489, 0),
			new Isotope(30, 57.935347922, 100.0000),
			new Isotope(31, 58.934351553, 0),
			new Isotope(32, 59.930790633, 38.2305),
			new Isotope(33, 60.931060442, 1.6552),
			new Isotope(34, 61.928348763, 5.2585),
			new Isotope(35, 62.929672948, 0),
			new Isotope(36, 63.927969574, 1.3329),
			new Isotope(37, 64.930088013, 0),
			new Isotope(38, 65.929115232, 0),
			new Isotope(39, 66.931569638, 0),
			new Isotope(40, 67.931844932, 0),
			new Isotope(41, 68.935181837, 0),
			new Isotope(42, 69.936140000, 0),
			new Isotope(43, 70.940000000, 0),
			new Isotope(44, 71.941300000, 0),
			new Isotope(45, 72.946080, 0),
			new Isotope(46, 73.947910, 0),
			new Isotope(47, 74.952970, 0),
			new Isotope(48, 75.955330, 0),
			new Isotope(49, 76.960830, 0),
			new Isotope(50, 77.963800, 0) },
		{	new Isotope(23, 51.997180, 0),			// 29
			new Isotope(24, 52.985550, 0),
			new Isotope(25, 53.976710, 0),
			new Isotope(26, 54.966050, 0),
			new Isotope(27, 55.958560, 0),
			new Isotope(28, 56.949215695, 0),
			new Isotope(29, 57.944540734, 0),
			new Isotope(30, 58.939504114, 0),
			new Isotope(31, 59.937368123, 0),
			new Isotope(32, 60.933462181, 0),
			new Isotope(33, 61.932587299, 0),
			new Isotope(34, 62.929601079, 100.0000),
			new Isotope(35, 63.929767865, 0),
			new Isotope(36, 64.927793707, 44.5710),
			new Isotope(37, 65.928873041, 0),
			new Isotope(38, 66.927750294, 0),
			new Isotope(39, 67.929637875, 0),
			new Isotope(40, 68.929425281, 0),
			new Isotope(41, 69.932409287, 0),
			new Isotope(42, 70.932619818, 0),
			new Isotope(43, 71.935520, 0),
			new Isotope(44, 72.936490, 0),
			new Isotope(45, 73.940200, 0),
			new Isotope(46, 74.941700, 0),
			new Isotope(47, 75.945990, 0),
			new Isotope(48, 76.947950, 0),
			new Isotope(49, 77.952810, 0),
			new Isotope(50, 78.955280, 0),
			new Isotope(51, 79.961890, 0) },
		{	new Isotope(24, 53.992950, 0),			// 30
			new Isotope(25, 54.983980, 0),
			new Isotope(26, 55.972380, 0),
			new Isotope(27, 56.964910, 0),
			new Isotope(28, 57.954596465, 0),
			new Isotope(29, 58.949267074, 0),
			new Isotope(30, 59.941832031, 0),
			new Isotope(31, 60.939513907, 0),
			new Isotope(32, 61.934334132, 0),
			new Isotope(33, 62.933215563, 0),
			new Isotope(34, 63.929146578, 100.0000),
			new Isotope(35, 64.929245079, 0),
			new Isotope(36, 65.926036763, 57.4074),
			new Isotope(37, 66.927130859, 8.4362),
			new Isotope(38, 67.924847566, 38.6831),
			new Isotope(39, 68.926553538, 0),
			new Isotope(40, 69.925324870, 1.2346),
			new Isotope(41, 70.927727195, 0),
			new Isotope(42, 71.926861122, 0),
			new Isotope(43, 72.929779469, 0),
			new Isotope(44, 73.929458261, 0),
			new Isotope(45, 74.932937379, 0),
			new Isotope(46, 75.933394207, 0),
			new Isotope(47, 76.937085857, 0),
			new Isotope(48, 77.938569576, 0),
			new Isotope(49, 78.942095175, 0),
			new Isotope(50, 79.944414722, 0),
			new Isotope(51, 80.950480, 0),
			new Isotope(52, 81.954840, 0) },
		{	new Isotope(25, 55.994910, 0),			// 31
			new Isotope(26, 56.982930, 0),
			new Isotope(27, 57.974250, 0),
			new Isotope(28, 58.963370, 0),
			new Isotope(29, 59.957060, 0),
			new Isotope(30, 60.949170, 0),
			new Isotope(31, 61.944179608, 0),
			new Isotope(32, 62.939141527, 0),
			new Isotope(33, 63.936838307, 0),
			new Isotope(34, 64.932739322, 0),
			new Isotope(35, 65.931592355, 0),
			new Isotope(36, 66.928204915, 0),
			new Isotope(37, 67.927983497, 0),
			new Isotope(38, 68.925580912, 100.0000),
			new Isotope(39, 69.926027741, 0),
			new Isotope(40, 70.924705010, 66.3890),
			new Isotope(41, 71.926369350, 0),
			new Isotope(42, 72.925169832, 0),
			new Isotope(43, 73.926940999, 0),
			new Isotope(44, 74.926500645, 0),
			new Isotope(45, 75.928928262, 0),
			new Isotope(46, 76.929281189, 0),
			new Isotope(47, 77.931655950, 0),
			new Isotope(48, 78.932916371, 0),
			new Isotope(49, 79.936588154, 0),
			new Isotope(50, 80.937752955, 0),
			new Isotope(51, 81.943160, 0),
			new Isotope(52, 82.946870, 0),
			new Isotope(53, 83.952340, 0) },
		{	new Isotope(26, 57.991010, 0),			// 32
			new Isotope(27, 58.981750, 0),
			new Isotope(28, 59.970190, 0),
			new Isotope(29, 60.963790, 0),
			new Isotope(30, 61.954650, 0),
			new Isotope(31, 62.949640, 0),
			new Isotope(32, 63.941572638, 0),
			new Isotope(33, 64.939440762, 0),
			new Isotope(34, 65.933846798, 0),
			new Isotope(35, 66.932738415, 0),
			new Isotope(36, 67.928097266, 0),
			new Isotope(37, 68.927972002, 0),
			new Isotope(38, 69.924250365, 56.1644),
			new Isotope(39, 70.924953991, 0),
			new Isotope(40, 71.922076184, 75.0685),
			new Isotope(41, 72.923459361, 21.3698),
			new Isotope(42, 73.921178213, 100.0000),
			new Isotope(43, 74.922859494, 21.3698),
			new Isotope(44, 75.921402716, 0),
			new Isotope(45, 76.923548462, 0),
			new Isotope(46, 77.922852886, 0),
			new Isotope(47, 78.925401560, 0),
			new Isotope(48, 79.925444764, 0),
			new Isotope(49, 80.928821065, 0),
			new Isotope(50, 81.929550326, 0),
			new Isotope(51, 82.934510, 0),
			new Isotope(52, 83.937310, 0),
			new Isotope(53, 84.942690, 0),
			new Isotope(54, 85.946270, 0) },
		{	new Isotope(27, 59.993130, 0),			// 33
			new Isotope(28, 60.980620, 0),
			new Isotope(29, 61.973200, 0),
			new Isotope(30, 62.963690, 0),
			new Isotope(31, 63.957572, 0),
			new Isotope(32, 64.949484, 0),
			new Isotope(33, 65.944099147, 0),
			new Isotope(34, 66.939190417, 0),
			new Isotope(35, 67.936792976, 0),
			new Isotope(36, 68.932280154, 0),
			new Isotope(37, 69.930927811, 0),
			new Isotope(38, 70.927114724, 0),
			new Isotope(39, 71.926752647, 0),
			new Isotope(40, 72.923825288, 0),
			new Isotope(41, 73.923929076, 0),
			new Isotope(42, 74.921596417, 100.0000),
			new Isotope(43, 75.922393933, 0),
			new Isotope(44, 76.920647703, 0),
			new Isotope(45, 77.921828577, 0),
			new Isotope(46, 78.920948498, 0),
			new Isotope(47, 79.922578162, 0),
			new Isotope(48, 80.922132884, 0),
			new Isotope(49, 81.924504668, 0),
			new Isotope(50, 82.924980625, 0),
			new Isotope(51, 83.929060, 0),
			new Isotope(52, 84.931810, 0),
			new Isotope(53, 85.936230, 0),
			new Isotope(54, 86.939580, 0),
			new Isotope(55, 87.944560, 0),
			new Isotope(56, 88.949230, 0) },
		{	new Isotope(31, 64.964660, 0),			// 34
			new Isotope(32, 65.955210, 0),
			new Isotope(33, 66.950090, 0),
			new Isotope(34, 67.941870, 0),
			new Isotope(35, 68.939562155, 0),
			new Isotope(36, 69.933504, 0),
			new Isotope(37, 70.931868378, 0),
			new Isotope(38, 71.927112313, 0),
			new Isotope(39, 72.926766800, 0),
			new Isotope(40, 73.922476561, 1.8145),
			new Isotope(41, 74.922523571, 0),
			new Isotope(42, 75.919214107, 18.1451),
			new Isotope(43, 76.919914610, 15.3226),
			new Isotope(44, 77.917309522, 47.3790),
			new Isotope(45, 78.918499802, 0),
			new Isotope(46, 79.916521828, 100.0000),
			new Isotope(47, 80.917992931, 0),
			new Isotope(48, 81.916700000, 18.9516),
			new Isotope(49, 82.919119072, 0),
			new Isotope(50, 83.918464523, 0),
			new Isotope(51, 84.922244678, 0),
			new Isotope(52, 85.924271165, 0),
			new Isotope(53, 86.928520749, 0),
			new Isotope(54, 87.931423982, 0),
			new Isotope(55, 88.936020, 0),
			new Isotope(56, 89.939420, 0),
			new Isotope(57, 90.945370, 0),
			new Isotope(58, 91.949330, 0) },
		{	new Isotope(32, 66.964790, 0),			// 35
			new Isotope(33, 67.958248, 0),
			new Isotope(34, 68.950178, 0),
			new Isotope(35, 69.944208, 0),
			new Isotope(36, 70.939246, 0),
			new Isotope(37, 71.936496876, 0),
			new Isotope(38, 72.931794889, 0),
			new Isotope(39, 73.929891152, 0),
			new Isotope(40, 74.925776410, 0),
			new Isotope(41, 75.924541974, 0),
			new Isotope(42, 76.921380123, 0),
			new Isotope(43, 77.921146130, 0),
			new Isotope(44, 78.918337647, 100.0000),
			new Isotope(45, 79.918529952, 0),
			new Isotope(46, 80.916291060, 97.2776),
			new Isotope(47, 81.916804666, 0),
			new Isotope(48, 82.915180219, 0),
			new Isotope(49, 83.916503685, 0),
			new Isotope(50, 84.915608027, 0),
			new Isotope(51, 85.918797162, 0),
			new Isotope(52, 86.920710713, 0),
			new Isotope(53, 87.924065908, 0),
			new Isotope(54, 88.926387260, 0),
			new Isotope(55, 89.930634988, 0),
			new Isotope(56, 90.933965300, 0),
			new Isotope(57, 91.939255258, 0),
			new Isotope(58, 92.943100, 0),
			new Isotope(59, 93.948680, 0) },
		{	new Isotope(33, 68.965320, 0),			// 36
			new Isotope(34, 69.956010, 0),
			new Isotope(35, 70.950510, 0),
			new Isotope(36, 71.941907540, 0),
			new Isotope(37, 72.938931115, 0),
			new Isotope(38, 73.933258225, 0),
			new Isotope(39, 74.931033794, 0),
			new Isotope(40, 75.925948304, 0),
			new Isotope(41, 76.924667880, 0),
			new Isotope(42, 77.920386271, 85.9106140),
			new Isotope(43, 78.920082992, 0),
			new Isotope(44, 79.916378040, 0.6140),
			new Isotope(45, 80.916592419, 0),
			new Isotope(46, 81.913484601, 3.9474),
			new Isotope(47, 82.914135952, 20.3509),
			new Isotope(48, 83.911506627, 100.0000),
			new Isotope(49, 84.912526954, 0),
			new Isotope(50, 85.910610313, 30.3509),
			new Isotope(51, 86.913354251, 0),
			new Isotope(52, 87.914446951, 0),
			new Isotope(53, 88.917632505, 0),
			new Isotope(54, 89.919523803, 0),
			new Isotope(55, 90.923442418, 0),
			new Isotope(56, 91.926152752, 0),
			new Isotope(57, 92.931265246, 0),
			new Isotope(58, 93.934362, 0),
			new Isotope(59, 94.939840, 0),
			new Isotope(60, 95.943070, 0),
			new Isotope(61, 96.948560, 0) },
		{	new Isotope(34, 70.965320, 0),			// 37
			new Isotope(35, 71.959080, 0),
			new Isotope(36, 72.950366, 0),
			new Isotope(37, 73.944470376, 0),
			new Isotope(38, 74.938569199, 0),
			new Isotope(39, 75.935071448, 0),
			new Isotope(40, 76.930406599, 0),
			new Isotope(41, 77.928141485, 0),
			new Isotope(42, 78.923996719, 0),
			new Isotope(43, 79.922519322, 0),
			new Isotope(44, 80.918994165, 0),
			new Isotope(45, 81.918207691, 0),
			new Isotope(46, 82.915111951, 0),
			new Isotope(47, 83.914384676, 0),
			new Isotope(48, 84.911789341, 100.0000),
			new Isotope(49, 85.911167080, 0),
			new Isotope(50, 86.909183465, 38.5710),
			new Isotope(51, 87.911318556, 0),
			new Isotope(52, 88.912279939, 0),
			new Isotope(53, 89.914808941, 0),
			new Isotope(54, 90.916534160, 0),
			new Isotope(55, 91.919725442, 0),
			new Isotope(56, 92.922032765, 0),
			new Isotope(57, 93.926407326, 0),
			new Isotope(58, 94.929319260, 0),
			new Isotope(59, 95.934283962, 0),
			new Isotope(60, 96.937342863, 0),
			new Isotope(61, 97.941703557, 0),
			new Isotope(62, 98.945420616, 0),
			new Isotope(63, 99.949870, 0),
			new Isotope(64, 100.953195994, 0),
			new Isotope(65, 101.959210, 0) },
		{	new Isotope(35, 72.965970, 0),			// 38
			new Isotope(36, 73.956310, 0),
			new Isotope(37, 74.949920, 0),
			new Isotope(38, 75.941610, 0),
			new Isotope(39, 76.937761511, 0),
			new Isotope(40, 77.932179362, 0),
			new Isotope(41, 78.929707076, 0),
			new Isotope(42, 79.924524588, 0),
			new Isotope(43, 80.923213095, 0),
			new Isotope(44, 81.918401258, 0),
			new Isotope(45, 82.917555029, 0),
			new Isotope(46, 83.913424778, 0.6781),
			new Isotope(47, 84.912932689, 0),
			new Isotope(48, 85.909262351, 11.9399),
			new Isotope(49, 86.908879316, 8.4766),
			new Isotope(50, 87.905614339, 100.0000),
			new Isotope(51, 88.907452906, 0),
			new Isotope(52, 89.907737596, 0),
			new Isotope(53, 90.910209845, 0),
			new Isotope(54, 91.911029895, 0),
			new Isotope(55, 92.914022410, 0),
			new Isotope(56, 93.915359856, 0),
			new Isotope(57, 94.919358213, 0),
			new Isotope(58, 95.921680473, 0),
			new Isotope(59, 96.926148757, 0),
			new Isotope(60, 97.928471177, 0),
			new Isotope(61, 98.933315038, 0),
			new Isotope(62, 99.935351729, 0),
			new Isotope(63, 100.940517434, 0),
			new Isotope(64, 101.943018795, 0),
			new Isotope(65, 102.948950, 0),
			new Isotope(66, 103.952330, 0) },
		{	new Isotope(38, 76.949620, 0),			// 39
			new Isotope(39, 77.943500, 0),
			new Isotope(40, 78.937350712, 0),
			new Isotope(41, 79.931982402, 0),
			new Isotope(42, 80.929128719, 0),
			new Isotope(43, 81.926792071, 0),
			new Isotope(44, 82.922352572, 0),
			new Isotope(45, 83.920387768, 0),
			new Isotope(46, 84.916427076, 0),
			new Isotope(47, 85.914887724, 0),
			new Isotope(48, 86.910877833, 0),
			new Isotope(49, 87.909503361, 0),
			new Isotope(50, 88.905847902, 100.0000),
			new Isotope(51, 89.907151443, 0),
			new Isotope(52, 90.907303415, 0),
			new Isotope(53, 91.908946832, 0),
			new Isotope(54, 92.909581582, 0),
			new Isotope(55, 93.911594008, 0),
			new Isotope(56, 94.912823709, 0),
			new Isotope(57, 95.915897787, 0),
			new Isotope(58, 96.918131017, 0),
			new Isotope(59, 97.922219525, 0),
			new Isotope(60, 98.924634736, 0),
			new Isotope(61, 99.927756402, 0),
			new Isotope(62, 100.930313395, 0),
			new Isotope(63, 101.933555501, 0),
			new Isotope(64, 102.936940, 0),
			new Isotope(65, 103.941450, 0),
			new Isotope(66, 104.945090, 0),
			new Isotope(67, 105.950220, 0) },
		{	new Isotope(39, 78.949160, 0),			// 40
			new Isotope(40, 79.940550, 0),
			new Isotope(41, 80.936815296, 0),
			new Isotope(42, 81.931086249, 0),
			new Isotope(43, 82.928652130, 0),
			new Isotope(44, 83.923250, 0),
			new Isotope(45, 84.921465220, 0),
			new Isotope(46, 85.916472851, 0),
			new Isotope(47, 86.914816578, 0),
			new Isotope(48, 87.910226179, 0),
			new Isotope(49, 88.908888916, 0),
			new Isotope(50, 89.904703679, 100.0000),
			new Isotope(51, 90.905644968, 21.9048),
			new Isotope(52, 91.905040106, 33.3822),
			new Isotope(53, 92.906475627, 0),
			new Isotope(54, 93.906315765, 33.6832),
			new Isotope(55, 94.908042739, 0),
			new Isotope(56, 95.908275675, 5.4033),
			new Isotope(57, 96.910950716, 0),
			new Isotope(58, 97.912746366, 0),
			new Isotope(59, 98.916511084, 0),
			new Isotope(60, 99.917761704, 0),
			new Isotope(61, 100.921139958, 0),
			new Isotope(62, 101.922981089, 0),
			new Isotope(63, 102.926597062, 0),
			new Isotope(64, 103.928780, 0),
			new Isotope(65, 104.933050, 0),
			new Isotope(66, 105.935910, 0),
			new Isotope(67, 106.940860, 0),
			new Isotope(68, 107.944280, 0) },
		{	new Isotope(40, 80.949050, 0),			// 41
			new Isotope(41, 81.943130, 0),
			new Isotope(42, 82.936703713, 0),
			new Isotope(43, 83.933570, 0),
			new Isotope(44, 84.927906486, 0),
			new Isotope(45, 85.925037588, 0),
			new Isotope(46, 86.920361435, 0),
			new Isotope(47, 87.918331440, 0),
			new Isotope(48, 88.913495503, 0),
			new Isotope(49, 89.911264109, 0),
			new Isotope(50, 90.906990538, 0),
			new Isotope(51, 91.907193214, 0),
			new Isotope(52, 92.906377543, 100.0000),
			new Isotope(53, 93.907283457, 0),
			new Isotope(54, 94.906835178, 0),
			new Isotope(55, 95.908100076, 0),
			new Isotope(56, 96.908097144, 0),
			new Isotope(57, 97.910330690, 0),
			new Isotope(58, 98.911617864, 0),
			new Isotope(59, 99.914181434, 0),
			new Isotope(60, 100.915251567, 0),
			new Isotope(61, 101.918037417, 0),
			new Isotope(62, 102.919141297, 0),
			new Isotope(63, 103.922459464, 0),
			new Isotope(64, 104.923934023, 0),
			new Isotope(65, 105.928190, 0),
			new Isotope(66, 106.930310, 0),
			new Isotope(67, 107.935010, 0),
			new Isotope(68, 108.937630, 0),
			new Isotope(69, 109.942680, 0) },
		{	new Isotope(41, 82.948740, 0),			// 42
			new Isotope(42, 83.940090, 0),
			new Isotope(43, 84.936590, 0),
			new Isotope(44, 85.930695167, 0),
			new Isotope(45, 86.927326830, 0),
			new Isotope(46, 87.921952728, 0),
			new Isotope(47, 88.919480562, 0),
			new Isotope(48, 89.913936161, 0),
			new Isotope(49, 90.911750754, 0),
			new Isotope(50, 91.906810480, 61.5002),
			new Isotope(51, 92.906812213, 0),
			new Isotope(52, 93.905087578, 38.3340),
			new Isotope(53, 94.905841487, 65.9760),
			new Isotope(54, 95.904678904, 69.1256),
			new Isotope(55, 96.906021033, 39.5773),
			new Isotope(56, 97.905407846, 100.0000),
			new Isotope(57, 98.907711598, 0),
			new Isotope(58, 99.907477149, 39.9088),
			new Isotope(59, 100.910346543, 0),
			new Isotope(60, 101.910297162, 0),
			new Isotope(61, 102.913204596, 0),
			new Isotope(62, 103.913758387, 0),
			new Isotope(63, 104.916972087, 0),
			new Isotope(64, 105.918134284, 0),
			new Isotope(65, 106.921694724, 0),
			new Isotope(66, 107.923973837, 0),
			new Isotope(67, 108.927810, 0),
			new Isotope(68, 109.929730, 0),
			new Isotope(69, 110.934510, 0),
			new Isotope(70, 111.936840, 0),
			new Isotope(71, 112.942030, 0) },
		{	new Isotope(42, 84.948940, 0),			// 43
			new Isotope(43, 85.942880, 0),
			new Isotope(44, 86.936530, 0),
			new Isotope(45, 87.932830, 0),
			new Isotope(46, 88.927542880, 0),
			new Isotope(47, 89.923555830, 0),
			new Isotope(48, 90.918428200, 0),
			new Isotope(49, 91.915259655, 0),
			new Isotope(50, 92.910248473, 0),
			new Isotope(51, 93.909656309, 0),
			new Isotope(52, 94.907656454, 0),
			new Isotope(53, 95.907870803, 0),
			new Isotope(54, 96.906364843, 0),
			new Isotope(55, 97.907215692, 0),
			new Isotope(56, 98.906254554, 0),
			new Isotope(57, 99.907657594, 0),
			new Isotope(58, 100.907314380, 0),
			new Isotope(59, 101.909212938, 0),
			new Isotope(60, 102.909178805, 0),
			new Isotope(61, 103.911444898, 0),
			new Isotope(62, 104.911658043, 0),
			new Isotope(63, 105.914355408, 0),
			new Isotope(64, 106.915081691, 0),
			new Isotope(65, 107.918479973, 0),
			new Isotope(66, 108.919980998, 0),
			new Isotope(67, 109.923390, 0),
			new Isotope(68, 110.925050, 0),
			new Isotope(69, 111.929240, 0),
			new Isotope(70, 112.931330, 0),
			new Isotope(71, 113.935880, 0),
			new Isotope(72, 114.938280, 0) },
		{	new Isotope(43, 86.949180, 0),			// 44
			new Isotope(44, 87.940420, 0),
			new Isotope(45, 88.936110, 0),
			new Isotope(46, 89.929780, 0),
			new Isotope(47, 90.926377434, 0),
			new Isotope(48, 91.920120, 0),
			new Isotope(49, 92.917051523, 0),
			new Isotope(50, 93.911359569, 0),
			new Isotope(51, 94.910412729, 0),
			new Isotope(52, 95.907597681, 17.4684),
			new Isotope(53, 96.907554546, 0),
			new Isotope(54, 97.905287111, 5.9494),
			new Isotope(55, 98.905939307, 40.1899),
			new Isotope(56, 99.904219664, 39.8734),
			new Isotope(57, 100.905582219, 53.7975),
			new Isotope(58, 101.904349503, 100.0000),
			new Isotope(59, 102.906323677, 0),
			new Isotope(60, 103.905430145, 59.1772),
			new Isotope(61, 104.907750341, 0),
			new Isotope(62, 105.907326913, 0),
			new Isotope(63, 106.909907207, 0),
			new Isotope(64, 107.910192211, 0),
			new Isotope(65, 108.913201565, 0),
			new Isotope(66, 109.913966185, 0),
			new Isotope(67, 110.917560, 0),
			new Isotope(68, 111.918821673, 0),
			new Isotope(69, 112.922540, 0),
			new Isotope(70, 113.923891981, 0),
			new Isotope(71, 114.928310, 0),
			new Isotope(72, 115.930160, 0),
			new Isotope(73, 116.934790, 0),
			new Isotope(74, 117.937030, 0) },
		{	new Isotope(44, 88.949380, 0),			// 45
			new Isotope(45, 89.942870, 0),
			new Isotope(46, 90.936550, 0),
			new Isotope(47, 91.931980, 0),
			new Isotope(48, 92.925740, 0),
			new Isotope(49, 93.921698, 0),
			new Isotope(50, 94.915898541, 0),
			new Isotope(51, 95.914518212, 0),
			new Isotope(52, 96.911336643, 0),
			new Isotope(53, 97.910716431, 0),
			new Isotope(54, 98.908132101, 0),
			new Isotope(55, 99.908116630, 0),
			new Isotope(56, 100.906163526, 0),
			new Isotope(57, 101.906842845, 0),
			new Isotope(58, 102.905504182, 100.0000),
			new Isotope(59, 103.906655315, 0),
			new Isotope(60, 104.905692444, 0),
			new Isotope(61, 105.907284615, 0),
			new Isotope(62, 106.906750540, 0),
			new Isotope(63, 107.908730768, 0),
			new Isotope(64, 108.908735621, 0),
			new Isotope(65, 109.910949525, 0),
			new Isotope(66, 110.911660, 0),
			new Isotope(67, 111.913969253, 0),
			new Isotope(68, 112.915420, 0),
			new Isotope(69, 113.917343360, 0),
			new Isotope(70, 114.920124676, 0),
			new Isotope(71, 115.922746643, 0),
			new Isotope(72, 116.925350, 0),
			new Isotope(73, 117.929430, 0),
			new Isotope(74, 118.931360, 0),
			new Isotope(75, 119.935780, 0),
			new Isotope(76, 120.938080, 0) },
		{	new Isotope(45, 90.949480, 0),			// 46
			new Isotope(46, 91.940420, 0),
			new Isotope(47, 92.935910, 0),
			new Isotope(48, 93.928770, 0),
			new Isotope(49, 94.924690, 0),
			new Isotope(50, 95.918221940, 0),
			new Isotope(51, 96.916478921, 0),
			new Isotope(52, 97.912720751, 0),
			new Isotope(53, 98.911767757, 0),
			new Isotope(54, 99.908504596, 0),
			new Isotope(55, 100.908289144, 0),
			new Isotope(56, 101.905607716, 3.7322),
			new Isotope(57, 102.906087204, 0),
			new Isotope(58, 103.904034912, 40.7611),
			new Isotope(59, 104.905084046, 81.7051),
			new Isotope(60, 105.903483087, 100.0000),
			new Isotope(61, 106.905128453, 0),
			new Isotope(62, 107.903894451, 96.8167),
			new Isotope(63, 108.905953535, 0),
			new Isotope(64, 109.905152385, 42.8833),
			new Isotope(65, 110.907643952, 0),
			new Isotope(66, 111.907313277, 0),
			new Isotope(67, 112.910151346, 0),
			new Isotope(68, 113.910365322, 0),
			new Isotope(69, 114.913683410, 0),
			new Isotope(70, 115.914158288, 0),
			new Isotope(71, 116.917840, 0),
			new Isotope(72, 117.918983915, 0),
			new Isotope(73, 118.922680, 0),
			new Isotope(74, 119.924030, 0),
			new Isotope(75, 120.928180, 0),
			new Isotope(76, 121.929800, 0),
			new Isotope(77, 122.934260, 0) },
		{	new Isotope(47, 93.942780, 0),			// 47
			new Isotope(48, 94.935480, 0),
			new Isotope(49, 95.930680, 0),
			new Isotope(50, 96.924000, 0),
			new Isotope(51, 97.921759995, 0),
			new Isotope(52, 98.917597103, 0),
			new Isotope(53, 99.916069387, 0),
			new Isotope(54, 100.912802135, 0),
			new Isotope(55, 101.911999996, 0),
			new Isotope(56, 102.908972453, 0),
			new Isotope(57, 103.908628228, 0),
			new Isotope(58, 104.906528234, 0),
			new Isotope(59, 105.906666431, 0),
			new Isotope(60, 106.905093020, 100.0000),
			new Isotope(61, 107.905953705, 0),
			new Isotope(62, 108.904755514, 92.9050),
			new Isotope(63, 109.906110460, 0),
			new Isotope(64, 110.905294679, 0),
			new Isotope(65, 111.907004132, 0),
			new Isotope(66, 112.906565708, 0),
			new Isotope(67, 113.908807907, 0),
			new Isotope(68, 114.908762282, 0),
			new Isotope(69, 115.911359558, 0),
			new Isotope(70, 116.911684187, 0),
			new Isotope(71, 117.914582383, 0),
			new Isotope(72, 118.915666045, 0),
			new Isotope(73, 119.918788609, 0),
			new Isotope(74, 120.919851074, 0),
			new Isotope(75, 121.923320, 0),
			new Isotope(76, 122.924900, 0),
			new Isotope(77, 123.928530, 0),
			new Isotope(78, 124.930540, 0),
			new Isotope(79, 125.934500, 0),
			new Isotope(80, 126.936880, 0) },
		{	new Isotope(48, 95.939770, 0),			// 48
			new Isotope(49, 96.934940, 0),
			new Isotope(50, 97.927579, 0),
			new Isotope(51, 98.925010, 0),
			new Isotope(52, 99.920230232, 0),
			new Isotope(53, 100.918681442, 0),
			new Isotope(54, 101.914777255, 0),
			new Isotope(55, 102.913418952, 0),
			new Isotope(56, 103.909848091, 0),
			new Isotope(57, 104.909467818, 0),
			new Isotope(58, 105.906458007, 4.3508),
			new Isotope(59, 106.906614232, 0),
			new Isotope(60, 107.904183403, 3.0978),
			new Isotope(61, 108.904985569, 0),
			new Isotope(62, 109.903005578, 43.4737),
			new Isotope(63, 110.904181628, 44.5527),
			new Isotope(64, 111.902757226, 83.9888),
			new Isotope(65, 112.904400947, 42.5339),
			new Isotope(66, 113.903358121, 100.0000),
			new Isotope(67, 114.905430553, 0),
			new Isotope(68, 115.904755434, 26.0703),
			new Isotope(69, 116.907218242, 0),
			new Isotope(70, 117.906914144, 0),
			new Isotope(71, 118.909922582, 0),
			new Isotope(72, 119.909851352, 0),
			new Isotope(73, 120.912980390, 0),
			new Isotope(74, 121.913500, 0),
			new Isotope(75, 122.917003675, 0),
			new Isotope(76, 123.917648302, 0),
			new Isotope(77, 124.921247170, 0),
			new Isotope(78, 125.922353996, 0),
			new Isotope(79, 126.926434822, 0),
			new Isotope(80, 127.927760617, 0),
			new Isotope(81, 128.932260, 0),
			new Isotope(82, 129.933980, 0) },
		{	new Isotope(49, 97.942240, 0),			// 49
			new Isotope(50, 98.934610, 0),
			new Isotope(51, 99.931149033, 0),
			new Isotope(52, 100.926560, 0),
			new Isotope(53, 101.924707541, 0),
			new Isotope(54, 102.919913896, 0),
			new Isotope(55, 103.918338416, 0),
			new Isotope(56, 104.914673434, 0),
			new Isotope(57, 105.913461134, 0),
			new Isotope(58, 106.910292195, 0),
			new Isotope(59, 107.909719683, 0),
			new Isotope(60, 108.907154078, 0),
			new Isotope(61, 109.907168783, 0),
			new Isotope(62, 110.905110677, 0),
			new Isotope(63, 111.905533338, 0),
			new Isotope(64, 112.904061223, 4.4932),
			new Isotope(65, 113.904916758, 0),
			new Isotope(66, 114.903878328, 100.0000),
			new Isotope(67, 115.905259995, 0),
			new Isotope(68, 116.904515731, 0),
			new Isotope(69, 117.906354623, 0),
			new Isotope(70, 118.905846334, 0),
			new Isotope(71, 119.907961505, 0),
			new Isotope(72, 120.907848847, 0),
			new Isotope(73, 121.910277103, 0),
			new Isotope(74, 122.910438951, 0),
			new Isotope(75, 123.913175916, 0),
			new Isotope(76, 124.913601387, 0),
			new Isotope(77, 125.916464532, 0),
			new Isotope(78, 126.917344048, 0),
			new Isotope(79, 127.920170658, 0),
			new Isotope(80, 128.921657958, 0),
			new Isotope(81, 129.924854941, 0),
			new Isotope(82, 130.926767408, 0),
			new Isotope(83, 131.932919005, 0),
			new Isotope(84, 132.938340, 0),
			new Isotope(85, 133.944660, 0) },
		{	new Isotope(50, 99.938954, 0),			// 50
			new Isotope(51, 100.936060, 0),
			new Isotope(52, 101.930490, 0),
			new Isotope(53, 102.928130, 0),
			new Isotope(54, 103.923185469, 0),
			new Isotope(55, 104.921390409, 0),
			new Isotope(56, 105.916880472, 0),
			new Isotope(57, 106.915666702, 0),
			new Isotope(58, 107.911965339, 0),
			new Isotope(59, 108.911286879, 0),
			new Isotope(60, 109.907852688, 0),
			new Isotope(61, 110.907735404, 0),
			new Isotope(62, 111.904820810, 3.0864),
			new Isotope(63, 112.905173373, 0),
			new Isotope(64, 113.902781816, 2.1605),
			new Isotope(65, 114.903345973, 1.2346),
			new Isotope(66, 115.901744149, 45.3704),
			new Isotope(67, 116.902953765, 23.7654),
			new Isotope(68, 117.901606328, 75.0000),
			new Isotope(69, 118.903308880, 26.5432),
			new Isotope(70, 119.902196571, 100.0000),
			new Isotope(71, 120.904236867, 0),
			new Isotope(72, 121.903440138, 14.1975),
			new Isotope(73, 122.905721901, 0),
			new Isotope(74, 123.905274630, 17.2840),
			new Isotope(75, 124.907784924, 0),
			new Isotope(76, 125.907653953, 0),
			new Isotope(77, 126.910350980, 0),
			new Isotope(78, 127.910534953, 0),
			new Isotope(79, 128.913439976, 0),
			new Isotope(80, 129.913852185, 0),
			new Isotope(81, 130.916919144, 0),
			new Isotope(82, 131.917744455, 0),
			new Isotope(83, 132.923814085, 0),
			new Isotope(84, 133.928463576, 0),
			new Isotope(85, 134.934730, 0),
			new Isotope(86, 135.939340, 0),
			new Isotope(87, 136.945790, 0) },
		{	new Isotope(52, 102.940120, 0),			// 51
			new Isotope(53, 103.936287, 0),
			new Isotope(54, 104.931528593, 0),
			new Isotope(55, 105.928183134, 0),
			new Isotope(56, 106.924150, 0),
			new Isotope(57, 107.922160, 0),
			new Isotope(58, 108.918136092, 0),
			new Isotope(59, 109.917533911, 0),
			new Isotope(60, 110.912534147, 0),
			new Isotope(61, 111.912394640, 0),
			new Isotope(62, 112.909377941, 0),
			new Isotope(63, 113.909095876, 0),
			new Isotope(64, 114.906598812, 0),
			new Isotope(65, 115.906797235, 0),
			new Isotope(66, 116.904839590, 0),
			new Isotope(67, 117.905531885, 0),
			new Isotope(68, 118.903946460, 0),
			new Isotope(69, 119.905074315, 0),
			new Isotope(70, 120.903818044, 100.0000),
			new Isotope(71, 121.905175415, 0),
			new Isotope(72, 122.904215696, 74.5201),
			new Isotope(73, 123.905937525, 0),
			new Isotope(74, 124.905247804, 0),
			new Isotope(75, 125.907248153, 0),
			new Isotope(76, 126.906914564, 0),
			new Isotope(77, 127.909167330, 0),
			new Isotope(78, 128.909150092, 0),
			new Isotope(79, 129.911546459, 0),
			new Isotope(80, 130.911946487, 0),
			new Isotope(81, 131.914413247, 0),
			new Isotope(82, 132.915236466, 0),
			new Isotope(83, 133.920551554, 0),
			new Isotope(84, 134.925167962, 0),
			new Isotope(85, 135.930660, 0),
			new Isotope(86, 136.935310, 0),
			new Isotope(87, 137.940960, 0),
			new Isotope(88, 138.945710, 0) },
		{	new Isotope(54, 105.937702, 0),			// 52
			new Isotope(55, 106.935036, 0),
			new Isotope(56, 107.929486838, 0),
			new Isotope(57, 108.927456483, 0),
			new Isotope(58, 109.922407164, 0),
			new Isotope(59, 110.921120589, 0),
			new Isotope(60, 111.917061617, 0),
			new Isotope(61, 112.915452551, 0),
			new Isotope(62, 113.912498025, 0),
			new Isotope(63, 114.911578627, 0),
			new Isotope(64, 115.908420253, 0),
			new Isotope(65, 116.908634180, 0),
			new Isotope(66, 117.905825187, 0),
			new Isotope(67, 118.906408110, 0),
			new Isotope(68, 119.904019891, 0.2840),
			new Isotope(69, 120.904929815, 0),
			new Isotope(70, 121.903047064, 7.6923),
			new Isotope(71, 122.904272951, 2.6864),
			new Isotope(72, 123.902819466, 14.2485),
			new Isotope(73, 124.904424718, 21.1243),
			new Isotope(74, 125.903305543, 56.0651),
			new Isotope(75, 126.905217290, 0),
			new Isotope(76, 127.904461383, 93.7574),
			new Isotope(77, 128.906595593, 0),
			new Isotope(78, 129.906222753, 100.0000),
			new Isotope(79, 130.908521880, 0),
			new Isotope(80, 131.908523782, 0),
			new Isotope(81, 132.910939068, 0),
			new Isotope(82, 133.911540546, 0),
			new Isotope(83, 134.916450782, 0),
			new Isotope(84, 135.920103155, 0),
			new Isotope(85, 136.925324769, 0),
			new Isotope(86, 137.929220, 0),
			new Isotope(87, 138.934730, 0),
			new Isotope(88, 139.938700, 0),
			new Isotope(89, 140.944390, 0),
			new Isotope(90, 141.948500, 0) },
		{	new Isotope(55, 107.943291, 0),			// 53
			new Isotope(56, 108.938191658, 0),
			new Isotope(57, 109.934634181, 0),
			new Isotope(58, 110.930276, 0),
			new Isotope(59, 111.927970, 0),
			new Isotope(60, 112.923644245, 0),
			new Isotope(61, 113.921850, 0),
			new Isotope(62, 114.918272, 0),
			new Isotope(63, 115.916735014, 0),
			new Isotope(64, 116.913647692, 0),
			new Isotope(65, 117.913375230, 0),
			new Isotope(66, 118.910180837, 0),
			new Isotope(67, 119.910047843, 0),
			new Isotope(68, 120.907366063, 0),
			new Isotope(69, 121.907592451, 0),
			new Isotope(70, 122.905597944, 0),
			new Isotope(71, 123.906211423, 0),
			new Isotope(72, 124.904624150, 0),
			new Isotope(73, 125.905619387, 0),
			new Isotope(74, 126.904468420, 100.0000),
			new Isotope(75, 127.905805254, 0),
			new Isotope(76, 128.904987487, 0),
			new Isotope(77, 129.906674018, 0),
			new Isotope(78, 130.906124168, 0),
			new Isotope(79, 131.907994525, 0),
			new Isotope(80, 132.907806465, 0),
			new Isotope(81, 133.909876552, 0),
			new Isotope(82, 134.910050310, 0),
			new Isotope(83, 135.914655105, 0),
			new Isotope(84, 136.917872653, 0),
			new Isotope(85, 137.922383666, 0),
			new Isotope(86, 138.926093402, 0),
			new Isotope(87, 139.931210, 0),
			new Isotope(88, 140.934830, 0),
			new Isotope(89, 141.940180, 0),
			new Isotope(90, 142.944070, 0),
			new Isotope(91, 143.949610, 0) },
		{	new Isotope(56, 109.944476, 0),			// 54
			new Isotope(57, 110.941632, 0),
			new Isotope(58, 111.935665350, 0),
			new Isotope(59, 112.933382836, 0),
			new Isotope(60, 113.928145, 0),
			new Isotope(61, 114.926979032, 0),
			new Isotope(62, 115.921394197, 0),
			new Isotope(63, 116.920564355, 0),
			new Isotope(64, 117.916570920, 0),
			new Isotope(65, 118.915554295, 0),
			new Isotope(66, 119.912151990, 0),
			new Isotope(67, 120.911386497, 0),
			new Isotope(68, 121.908548396, 0),
			new Isotope(69, 122.908470748, 0),
			new Isotope(70, 123.905895774, 0.3717),
			new Isotope(71, 124.906398236, 0),
			new Isotope(72, 125.904268868, 0.3346),
			new Isotope(73, 126.905179581, 0),
			new Isotope(74, 127.903530436, 7.1004),
			new Isotope(75, 128.904779458, 98.1413),
			new Isotope(76, 129.903507903, 15.2416),
			new Isotope(77, 130.905081920, 78.8104),
			new Isotope(78, 131.904154457, 100.0000),
			new Isotope(79, 132.905905660, 0),
			new Isotope(80, 133.905394504, 38.6617),
			new Isotope(81, 134.907207499, 0),
			new Isotope(82, 135.907219526, 33.0855),
			new Isotope(83, 136.911562939, 0),
			new Isotope(84, 137.913988549, 0),
			new Isotope(85, 138.918786859, 0),
			new Isotope(86, 139.921635665, 0),
			new Isotope(87, 140.926646282, 0),
			new Isotope(88, 141.929702981, 0),
			new Isotope(89, 142.934890, 0),
			new Isotope(90, 143.938230, 0),
			new Isotope(91, 144.943670, 0),
			new Isotope(92, 145.947300, 0),
			new Isotope(93, 146.953010, 0) },
		{	new Isotope(57, 111.950331, 0),			// 55
			new Isotope(58, 112.944535512, 0),
			new Isotope(59, 113.940841319, 0),
			new Isotope(60, 114.935939, 0),
			new Isotope(61, 115.932914152, 0),
			new Isotope(62, 116.928639484, 0),
			new Isotope(63, 117.926554883, 0),
			new Isotope(64, 118.922370879, 0),
			new Isotope(65, 119.920678219, 0),
			new Isotope(66, 120.917183637, 0),
			new Isotope(67, 121.916121946, 0),
			new Isotope(68, 122.912990168, 0),
			new Isotope(69, 123.912245731, 0),
			new Isotope(70, 124.909724871, 0),
			new Isotope(71, 125.909447953, 0),
			new Isotope(72, 126.907417600, 0),
			new Isotope(73, 127.907747919, 0),
			new Isotope(74, 128.906063369, 0),
			new Isotope(75, 129.906706163, 0),
			new Isotope(76, 130.905460232, 0),
			new Isotope(77, 131.906429799, 0),
			new Isotope(78, 132.905446870, 100.0000),
			new Isotope(79, 133.906713419, 0),
			new Isotope(80, 134.905971903, 0),
			new Isotope(81, 135.907305741, 0),
			new Isotope(82, 136.907083505, 0),
			new Isotope(83, 137.911010537, 0),
			new Isotope(84, 138.913357921, 0),
			new Isotope(85, 139.917277075, 0),
			new Isotope(86, 140.920043984, 0),
			new Isotope(87, 141.924292317, 0),
			new Isotope(88, 142.927330292, 0),
			new Isotope(89, 143.932027373, 0),
			new Isotope(90, 144.935388226, 0),
			new Isotope(91, 145.940162028, 0),
			new Isotope(92, 146.943864435, 0),
			new Isotope(93, 147.948899539, 0),
			new Isotope(94, 148.952720, 0),
			new Isotope(95, 149.957970, 0),
			new Isotope(96, 150.962000, 0) },
		{	new Isotope(58, 113.950941, 0),			// 56
			new Isotope(59, 114.947710, 0),
			new Isotope(60, 115.941680, 0),
			new Isotope(61, 116.937700229, 0),
			new Isotope(62, 117.933440, 0),
			new Isotope(63, 118.931051927, 0),
			new Isotope(64, 119.926045941, 0),
			new Isotope(65, 120.924485908, 0),
			new Isotope(66, 121.920260, 0),
			new Isotope(67, 122.918850, 0),
			new Isotope(68, 123.915088437, 0),
			new Isotope(69, 124.914620234, 0),
			new Isotope(70, 125.911244146, 0),
			new Isotope(71, 126.911121328, 0),
			new Isotope(72, 127.908308870, 0),
			new Isotope(73, 128.908673749, 0),
			new Isotope(74, 129.906310478, 0.1478),
			new Isotope(75, 130.906930798, 0),
			new Isotope(76, 131.905056152, 0.1409),
			new Isotope(77, 132.906002368, 0),
			new Isotope(78, 133.904503347, 3.3710),
			new Isotope(79, 134.905682749, 9.1939),
			new Isotope(80, 135.904570109, 10.9540),
			new Isotope(81, 136.905821414, 15.6625),
			new Isotope(82, 137.905241273, 100.0000),
			new Isotope(83, 138.908835384, 0),
			new Isotope(84, 139.910599485, 0),
			new Isotope(85, 140.914406439, 0),
			new Isotope(86, 141.916448175, 0),
			new Isotope(87, 142.920617184, 0),
			new Isotope(88, 143.922940468, 0),
			new Isotope(89, 144.926923807, 0),
			new Isotope(90, 145.930106645, 0),
			new Isotope(91, 146.933992519, 0),
			new Isotope(92, 147.937682377, 0),
			new Isotope(93, 148.942460, 0),
			new Isotope(94, 149.945620, 0),
			new Isotope(95, 150.950700, 0),
			new Isotope(96, 151.954160, 0),
			new Isotope(97, 152.959610, 0) },
		{	new Isotope(60, 116.950010, 0),			// 57
			new Isotope(61, 117.946570, 0),
			new Isotope(62, 118.940990, 0),
			new Isotope(63, 119.938070, 0),
			new Isotope(64, 120.933010, 0),
			new Isotope(65, 121.930710, 0),
			new Isotope(66, 122.926240, 0),
			new Isotope(67, 123.924530, 0),
			new Isotope(68, 124.920670, 0),
			new Isotope(69, 125.919370, 0),
			new Isotope(70, 126.916160, 0),
			new Isotope(71, 127.915447940, 0),
			new Isotope(72, 128.912667334, 0),
			new Isotope(73, 129.912320, 0),
			new Isotope(74, 130.910108489, 0),
			new Isotope(75, 131.910110399, 0),
			new Isotope(76, 132.908396372, 0),
			new Isotope(77, 133.908489607, 0),
			new Isotope(78, 134.906971003, 0),
			new Isotope(79, 135.907651181, 0),
			new Isotope(80, 136.906465656, 0),
			new Isotope(81, 137.907106826, 0.0901),
			new Isotope(82, 138.906348160, 100.0000),
			new Isotope(83, 139.909472552, 0),
			new Isotope(84, 140.910957016, 0),
			new Isotope(85, 141.914074489, 0),
			new Isotope(86, 142.916058646, 0),
			new Isotope(87, 143.919591666, 0),
			new Isotope(88, 144.921638370, 0),
			new Isotope(89, 145.925700146, 0),
			new Isotope(90, 146.927819639, 0),
			new Isotope(91, 147.932191197, 0),
			new Isotope(92, 148.934370, 0),
			new Isotope(93, 149.938570, 0),
			new Isotope(94, 150.941560, 0),
			new Isotope(95, 151.946110, 0),
			new Isotope(96, 152.949450, 0),
			new Isotope(97, 153.954400, 0),
			new Isotope(98, 154.958130, 0) },
		{	new Isotope(61, 118.952760, 0),			// 58
			new Isotope(62, 119.946640, 0),
			new Isotope(63, 120.943670, 0),
			new Isotope(64, 121.938010, 0),
			new Isotope(65, 122.935510, 0),
			new Isotope(66, 123.930520, 0),
			new Isotope(67, 124.928540, 0),
			new Isotope(68, 125.924100, 0),
			new Isotope(69, 126.922750, 0),
			new Isotope(70, 127.918870, 0),
			new Isotope(71, 128.918679183, 0),
			new Isotope(72, 129.914339361, 0),
			new Isotope(73, 130.914424137, 0),
			new Isotope(74, 131.911490, 0),
			new Isotope(75, 132.911550, 0),
			new Isotope(76, 133.909026379, 0),
			new Isotope(77, 134.909145555, 0),
			new Isotope(78, 135.907143574, 0.2147),
			new Isotope(79, 136.907777634, 0),
			new Isotope(80, 137.905985574, 0.2825),
			new Isotope(81, 138.906646605, 0),
			new Isotope(82, 139.905434035, 100.0000),
			new Isotope(83, 140.908271103, 0),
			new Isotope(84, 141.909239733, 12.5226),
			new Isotope(85, 142.912381158, 0),
			new Isotope(86, 143.913642686, 0),
			new Isotope(87, 144.917227871, 0),
			new Isotope(88, 145.918689722, 0),
			new Isotope(89, 146.922510962, 0),
			new Isotope(90, 147.924394738, 0),
			new Isotope(91, 148.928289207, 0),
			new Isotope(92, 149.930226399, 0),
			new Isotope(93, 150.934040, 0),
			new Isotope(94, 151.936380, 0),
			new Isotope(95, 152.940580, 0),
			new Isotope(96, 153.943320, 0),
			new Isotope(97, 154.948040, 0),
			new Isotope(98, 155.951260, 0),
			new Isotope(99, 156.956340, 0) },
		{	new Isotope(62, 120.955364, 0),			// 59
			new Isotope(63, 121.951650, 0),
			new Isotope(64, 122.945960, 0),
			new Isotope(65, 123.942960, 0),
			new Isotope(66, 124.937830, 0),
			new Isotope(67, 125.935310, 0),
			new Isotope(68, 126.930830, 0),
			new Isotope(69, 127.928800, 0),
			new Isotope(70, 128.924860, 0),
			new Isotope(71, 129.923380, 0),
			new Isotope(72, 130.920060245, 0),
			new Isotope(73, 131.919120, 0),
			new Isotope(74, 132.916200, 0),
			new Isotope(75, 133.915672, 0),
			new Isotope(76, 134.913139140, 0),
			new Isotope(77, 135.912646935, 0),
			new Isotope(78, 136.910678351, 0),
			new Isotope(79, 137.910748891, 0),
			new Isotope(80, 138.908932181, 0),
			new Isotope(81, 139.909071204, 0),
			new Isotope(82, 140.907647726, 100.0000),
			new Isotope(83, 141.910039865, 0),
			new Isotope(84, 142.910812233, 0),
			new Isotope(85, 143.913300595, 0),
			new Isotope(86, 144.914506897, 0),
			new Isotope(87, 145.917588016, 0),
			new Isotope(88, 146.918979001, 0),
			new Isotope(89, 147.922183237, 0),
			new Isotope(90, 148.923791056, 0),
			new Isotope(91, 149.926995031, 0),
			new Isotope(92, 150.928227869, 0),
			new Isotope(93, 151.931600, 0),
			new Isotope(94, 152.933650, 0),
			new Isotope(95, 153.937390, 0),
			new Isotope(96, 154.939990, 0),
			new Isotope(97, 155.944120, 0),
			new Isotope(98, 156.947170, 0),
			new Isotope(99, 157.951780, 0),
			new Isotope(100, 158.955230, 0) },
		{	new Isotope(66, 125.943070, 0),			// 60
			new Isotope(67, 126.940500, 0),
			new Isotope(68, 127.935390, 0),
			new Isotope(69, 128.932385, 0),
			new Isotope(70, 129.928780, 0),
			new Isotope(71, 130.927102697, 0),
			new Isotope(72, 131.923120, 0),
			new Isotope(73, 132.922210, 0),
			new Isotope(74, 133.918645, 0),
			new Isotope(75, 134.918240, 0),
			new Isotope(76, 135.915020542, 0),
			new Isotope(77, 136.914639730, 0),
			new Isotope(78, 137.912917450, 0),
			new Isotope(79, 138.911924150, 0),
			new Isotope(80, 139.909309824, 0),
			new Isotope(81, 140.909604800, 0),
			new Isotope(82, 141.907718643, 100.0000),
			new Isotope(83, 142.909809626, 44.8949),
			new Isotope(84, 143.910082629, 87.7258),
			new Isotope(85, 144.912568847, 30.5934),
			new Isotope(86, 145.913112139, 63.3616),
			new Isotope(87, 146.916095794, 0),
			new Isotope(88, 147.916888516, 21.2311),
			new Isotope(89, 148.920144190, 0),
			new Isotope(90, 149.920886563, 20.7888),
			new Isotope(91, 150.923824739, 0),
			new Isotope(92, 151.924682428, 0),
			new Isotope(93, 152.927694534, 0),
			new Isotope(94, 153.929483295, 0),
			new Isotope(95, 154.932629551, 0),
			new Isotope(96, 155.935200, 0),
			new Isotope(97, 156.939270, 0),
			new Isotope(98, 157.941870, 0),
			new Isotope(99, 158.946390, 0),
			new Isotope(100, 159.949390, 0),
			new Isotope(101, 160.954330, 0) },
		{	new Isotope(67, 127.948260, 0),			// 61
			new Isotope(68, 128.943160, 0),
			new Isotope(69, 129.940450, 0),
			new Isotope(70, 130.935800, 0),
			new Isotope(71, 131.933750, 0),
			new Isotope(72, 132.929720, 0),
			new Isotope(73, 133.928490, 0),
			new Isotope(74, 134.924617, 0),
			new Isotope(75, 135.923447865, 0),
			new Isotope(76, 136.920713, 0),
			new Isotope(77, 137.920432261, 0),
			new Isotope(78, 138.916759814, 0),
			new Isotope(79, 139.915801649, 0),
			new Isotope(80, 140.913606636, 0),
			new Isotope(81, 141.912950738, 0),
			new Isotope(82, 142.910927571, 0),
			new Isotope(83, 143.912585768, 0),
			new Isotope(84, 144.912743879, 0),
			new Isotope(85, 145.914692165, 0),
			new Isotope(86, 146.915133898, 0),
			new Isotope(87, 147.917467786, 0),
			new Isotope(88, 148.918329195, 0),
			new Isotope(89, 149.920979477, 0),
			new Isotope(90, 150.921202693, 0),
			new Isotope(91, 151.923490557, 0),
			new Isotope(92, 152.924113189, 0),
			new Isotope(93, 153.926547019, 0),
			new Isotope(94, 154.928097047, 0),
			new Isotope(95, 155.931060357, 0),
			new Isotope(96, 156.933200, 0),
			new Isotope(97, 157.936690, 0),
			new Isotope(98, 158.939130, 0),
			new Isotope(99, 159.942990, 0),
			new Isotope(100, 160.945860, 0),
			new Isotope(101, 161.950290, 0),
			new Isotope(102, 162.953520, 0) },
		{	new Isotope(68, 129.948630, 0),			// 62
			new Isotope(69, 130.945890, 0),
			new Isotope(70, 131.940820, 0),
			new Isotope(71, 132.938730, 0),
			new Isotope(72, 133.934020, 0),
			new Isotope(73, 134.932350, 0),
			new Isotope(74, 135.928300, 0),
			new Isotope(75, 136.927046709, 0),
			new Isotope(76, 137.923540, 0),
			new Isotope(77, 138.922302000, 0),
			new Isotope(78, 139.918991000, 0),
			new Isotope(79, 140.918468512, 0),
			new Isotope(80, 141.915193274, 0),
			new Isotope(81, 142.914623555, 0),
			new Isotope(82, 143.911994730, 11.6540),
			new Isotope(83, 144.913405611, 0),
			new Isotope(84, 145.913036760, 0),
			new Isotope(85, 146.914893275, 56.7670),
			new Isotope(86, 147.914817914, 42.4810),
			new Isotope(87, 148.917179521, 52.2560),
			new Isotope(88, 149.917271454, 27.8200),
			new Isotope(89, 150.919928351, 0),
			new Isotope(90, 151.919728244, 100.0000),
			new Isotope(91, 152.922093907, 0),
			new Isotope(92, 153.922205303, 84.9620),
			new Isotope(93, 154.924635940, 0),
			new Isotope(94, 155.925526236, 0),
			new Isotope(95, 156.928354506, 0),
			new Isotope(96, 157.929987938, 0),
			new Isotope(97, 158.933200, 0),
			new Isotope(98, 159.935140, 0),
			new Isotope(99, 160.938830, 0),
			new Isotope(100, 161.941220, 0),
			new Isotope(101, 162.945360, 0),
			new Isotope(102, 163.948280, 0),
			new Isotope(103, 164.952980, 0) },
		{	new Isotope(69, 131.954160, 0),			// 63
			new Isotope(70, 132.948900, 0),
			new Isotope(71, 133.946320, 0),
			new Isotope(72, 134.941720, 0),
			new Isotope(73, 135.939500, 0),
			new Isotope(74, 136.935210, 0),
			new Isotope(75, 137.933450, 0),
			new Isotope(76, 138.928829150, 0),
			new Isotope(77, 139.928083921, 0),
			new Isotope(78, 140.924885867, 0),
			new Isotope(79, 141.923400033, 0),
			new Isotope(80, 142.920286634, 0),
			new Isotope(81, 143.918774116, 0),
			new Isotope(82, 144.916261285, 0),
			new Isotope(83, 145.917199714, 0),
			new Isotope(84, 146.916741206, 0),
			new Isotope(85, 147.918153775, 0),
			new Isotope(86, 148.917925922, 0),
			new Isotope(87, 149.919698294, 0),
			new Isotope(88, 150.919846022, 91.5709),
			new Isotope(89, 151.921740399, 0),
			new Isotope(90, 152.921226219, 100.0000),
			new Isotope(91, 153.922975386, 0),
			new Isotope(92, 154.922889429, 0),
			new Isotope(93, 155.924750855, 0),
			new Isotope(94, 156.925419435, 0),
			new Isotope(95, 157.927841923, 0),
			new Isotope(96, 158.929084500, 0),
			new Isotope(97, 159.931460406, 0),
			new Isotope(98, 160.933680, 0),
			new Isotope(99, 161.937040, 0),
			new Isotope(100, 162.939210, 0),
			new Isotope(101, 163.942990, 0),
			new Isotope(102, 164.945720, 0),
			new Isotope(103, 165.949970, 0),
			new Isotope(104, 166.953050, 0) },
		{	new Isotope(72, 135.947070, 0),			// 64
			new Isotope(73, 136.944650, 0),
			new Isotope(74, 137.939970, 0),
			new Isotope(75, 138.938080, 0),
			new Isotope(76, 139.933236934, 0),
			new Isotope(77, 140.932210, 0),
			new Isotope(78, 141.927908919, 0),
			new Isotope(79, 142.926738636, 0),
			new Isotope(80, 143.923390357, 0),
			new Isotope(81, 144.921687498, 0),
			new Isotope(82, 145.918305344, 0),
			new Isotope(83, 146.919089446, 0),
			new Isotope(84, 147.918109771, 0),
			new Isotope(85, 148.919336427, 0),
			new Isotope(86, 149.918655455, 0),
			new Isotope(87, 150.920344273, 0),
			new Isotope(88, 151.919787882, 0.8052),
			new Isotope(89, 152.921746283, 0),
			new Isotope(90, 153.920862271, 8.7762),
			new Isotope(91, 154.922618801, 59.5813),
			new Isotope(92, 155.922119552, 82.4074),
			new Isotope(93, 156.923956686, 63.0032),
			new Isotope(94, 157.924100533, 100.0000),
			new Isotope(95, 158.926385075, 0),
			new Isotope(96, 159.927050616, 88.0032),
			new Isotope(97, 160.929665688, 0),
			new Isotope(98, 161.930981211, 0),
			new Isotope(99, 162.933990, 0),
			new Isotope(100, 163.935860, 0),
			new Isotope(101, 164.939380, 0),
			new Isotope(102, 165.941600, 0),
			new Isotope(103, 166.945570, 0),
			new Isotope(104, 167.948360, 0),
			new Isotope(105, 168.952870, 0) },
		{	new Isotope(73, 137.952870, 0),			// 65
			new Isotope(74, 138.948030, 0),
			new Isotope(75, 139.945367985, 0),
			new Isotope(76, 140.941160, 0),
			new Isotope(77, 141.939073781, 0),
			new Isotope(78, 142.934750, 0),
			new Isotope(79, 143.932530, 0),
			new Isotope(80, 144.928880, 0),
			new Isotope(81, 145.927180629, 0),
			new Isotope(82, 146.924037176, 0),
			new Isotope(83, 147.924298636, 0),
			new Isotope(84, 148.923241630, 0),
			new Isotope(85, 149.923654158, 0),
			new Isotope(86, 150.923098169, 0),
			new Isotope(87, 151.924071324, 0),
			new Isotope(88, 152.923430858, 0),
			new Isotope(89, 153.924686236, 0),
			new Isotope(90, 154.923500411, 0),
			new Isotope(91, 155.924743749, 0),
			new Isotope(92, 156.924021155, 0),
			new Isotope(93, 157.925410260, 0),
			new Isotope(94, 158.925343135, 100.0000),
			new Isotope(95, 159.927164021, 0),
			new Isotope(96, 160.927566289, 0),
			new Isotope(97, 161.929484803, 0),
			new Isotope(98, 162.930643942, 0),
			new Isotope(99, 163.933347253, 0),
			new Isotope(100, 164.934880, 0),
			new Isotope(101, 165.938050, 0),
			new Isotope(102, 166.940050, 0),
			new Isotope(103, 167.943640, 0),
			new Isotope(104, 168.946220, 0),
			new Isotope(105, 169.950250, 0),
			new Isotope(106, 170.953300, 0) },
		{	new Isotope(74, 139.953790, 0),			// 66
			new Isotope(75, 140.951190, 0),
			new Isotope(76, 141.946695946, 0),
			new Isotope(77, 142.943830, 0),
			new Isotope(78, 143.939070, 0),
			new Isotope(79, 144.936717, 0),
			new Isotope(80, 145.932720118, 0),
			new Isotope(81, 146.930878496, 0),
			new Isotope(82, 147.927177882, 0),
			new Isotope(83, 148.927333981, 0),
			new Isotope(84, 149.925579728, 0),
			new Isotope(85, 150.926179630, 0),
			new Isotope(86, 151.924713874, 0),
			new Isotope(87, 152.925760865, 0),
			new Isotope(88, 153.924422046, 0),
			new Isotope(89, 154.925748950, 0),
			new Isotope(90, 155.924278273, 0.2128),
			new Isotope(91, 156.925461256, 0),
			new Isotope(92, 157.924404637, 0.3546),
			new Isotope(93, 158.925735660, 0),
			new Isotope(94, 159.925193718, 8.2979),
			new Isotope(95, 160.926929595, 67.0212),
			new Isotope(96, 161.926794731, 90.4255),
			new Isotope(97, 162.928727532, 88.2978),
			new Isotope(98, 163.929171165, 100.0000),
			new Isotope(99, 164.931699828, 0),
			new Isotope(100, 165.932803241, 0),
			new Isotope(101, 166.935649025, 0),
			new Isotope(102, 167.937230, 0),
			new Isotope(103, 168.940303648, 0),
			new Isotope(104, 169.942670, 0),
			new Isotope(105, 170.946480, 0),
			new Isotope(106, 171.949110, 0),
			new Isotope(107, 172.953440, 0) },
		{	new Isotope(75, 141.959860, 0),			// 67
			new Isotope(76, 142.954690, 0),
			new Isotope(77, 143.951640, 0),
			new Isotope(78, 144.946880, 0),
			new Isotope(79, 145.944100, 0),
			new Isotope(80, 146.939840, 0),
			new Isotope(81, 147.937269, 0),
			new Isotope(82, 148.933789944, 0),
			new Isotope(83, 149.932760914, 0),
			new Isotope(84, 150.931680791, 0),
			new Isotope(85, 151.931740598, 0),
			new Isotope(86, 152.930194506, 0),
			new Isotope(87, 153.930596268, 0),
			new Isotope(88, 154.929079084, 0),
			new Isotope(89, 155.929001869, 0),
			new Isotope(90, 156.928188059, 0),
			new Isotope(91, 157.928945730, 0),
			new Isotope(92, 158.927708537, 0),
			new Isotope(93, 159.928725679, 0),
			new Isotope(94, 160.927851662, 0),
			new Isotope(95, 161.929092420, 0),
			new Isotope(96, 162.928730286, 0),
			new Isotope(97, 163.930230577, 0),
			new Isotope(98, 164.930319169, 100.0000),
			new Isotope(99, 165.932281267, 0),
			new Isotope(100, 166.933126195, 0),
			new Isotope(101, 167.935496424, 0),
			new Isotope(102, 168.936868306, 0),
			new Isotope(103, 169.939614951, 0),
			new Isotope(104, 170.941461227, 0),
			new Isotope(105, 171.944820, 0),
			new Isotope(106, 172.947290, 0),
			new Isotope(107, 173.951150, 0),
			new Isotope(108, 174.954050, 0) },
		{	new Isotope(76, 143.960590, 0),			// 68
			new Isotope(77, 144.957460, 0),
			new Isotope(78, 145.952120, 0),
			new Isotope(79, 146.949310, 0),
			new Isotope(80, 147.944440, 0),
			new Isotope(81, 148.942780527, 0),
			new Isotope(82, 149.937171034, 0),
			new Isotope(83, 150.937460, 0),
			new Isotope(84, 151.935078452, 0),
			new Isotope(85, 152.935093125, 0),
			new Isotope(86, 153.932777294, 0),
			new Isotope(87, 154.933204273, 0),
			new Isotope(88, 155.931015001, 0),
			new Isotope(89, 156.931945517, 0),
			new Isotope(90, 157.929912, 0),
			new Isotope(91, 158.930680718, 0),
			new Isotope(92, 159.929078924, 0),
			new Isotope(93, 160.930001348, 0),
			new Isotope(94, 161.928774923, 0.4167),
			new Isotope(95, 162.930029273, 0),
			new Isotope(96, 163.929196996, 4.7917),
			new Isotope(97, 164.930722800, 0),
			new Isotope(98, 165.930289970, 100.0000),
			new Isotope(99, 166.932045448, 68.3036),
			new Isotope(100, 167.932367781, 79.7619),
			new Isotope(101, 168.934588082, 0),
			new Isotope(102, 169.935460334, 44.3452),
			new Isotope(103, 170.938025885, 0),
			new Isotope(104, 171.939352149, 0),
			new Isotope(105, 172.942400, 0),
			new Isotope(106, 173.944340, 0),
			new Isotope(107, 174.947930, 0),
			new Isotope(108, 175.950290, 0),
			new Isotope(109, 176.954370, 0) },
		{	new Isotope(77, 145.966495, 0),			// 69
			new Isotope(78, 146.961081, 0),
			new Isotope(79, 147.957550, 0),
			new Isotope(80, 148.952650, 0),
			new Isotope(81, 149.949670, 0),
			new Isotope(82, 150.944842, 0),
			new Isotope(83, 151.944300, 0),
			new Isotope(84, 152.942027631, 0),
			new Isotope(85, 153.940832325, 0),
			new Isotope(86, 154.939191562, 0),
			new Isotope(87, 155.939006895, 0),
			new Isotope(88, 156.936756069, 0),
			new Isotope(89, 157.936996, 0),
			new Isotope(90, 158.934808966, 0),
			new Isotope(91, 159.935090772, 0),
			new Isotope(92, 160.933398042, 0),
			new Isotope(93, 161.933970147, 0),
			new Isotope(94, 162.932647648, 0),
			new Isotope(95, 163.933450972, 0),
			new Isotope(96, 164.932432463, 0),
			new Isotope(97, 165.933553133, 0),
			new Isotope(98, 166.932848844, 0),
			new Isotope(99, 167.934170375, 0),
			new Isotope(100, 168.934211117, 100.0000),
			new Isotope(101, 169.935797877, 0),
			new Isotope(102, 170.936425817, 0),
			new Isotope(103, 171.938396118, 0),
			new Isotope(104, 172.939600336, 0),
			new Isotope(105, 173.942164618, 0),
			new Isotope(106, 174.943832897, 0),
			new Isotope(107, 175.946991412, 0),
			new Isotope(108, 176.949040, 0),
			new Isotope(109, 177.952640, 0),
			new Isotope(110, 178.955340, 0) },
		{	new Isotope(78, 147.966760, 0),			// 70
			new Isotope(79, 148.963480, 0),
			new Isotope(80, 149.957990, 0),
			new Isotope(81, 150.954657965, 0),
			new Isotope(82, 151.950167, 0),
			new Isotope(83, 152.949210, 0),
			new Isotope(84, 153.945651145, 0),
			new Isotope(85, 154.945792, 0),
			new Isotope(86, 155.942847109, 0),
			new Isotope(87, 156.942658650, 0),
			new Isotope(88, 157.939857897, 0),
			new Isotope(89, 158.940153735, 0),
			new Isotope(90, 159.937560, 0),
			new Isotope(91, 160.937357719, 0),
			new Isotope(92, 161.935750, 0),
			new Isotope(93, 162.936265492, 0),
			new Isotope(94, 163.934520, 0),
			new Isotope(95, 164.935397592, 0),
			new Isotope(96, 165.933879623, 0),
			new Isotope(97, 166.934946862, 0),
			new Isotope(98, 167.933894465, 0.4088),
			new Isotope(99, 168.935187120, 0),
			new Isotope(100, 169.934758652, 9.5912),
			new Isotope(101, 170.936322297, 44.9686),
			new Isotope(102, 171.936377696, 68.8679),
			new Isotope(103, 172.938206756, 50.6918),
			new Isotope(104, 173.938858101, 100.0000),
			new Isotope(105, 174.941272494, 0),
			new Isotope(106, 175.942568409, 39.9371),
			new Isotope(107, 176.945257126, 0),
			new Isotope(108, 177.946643396, 0),
			new Isotope(109, 178.950170, 0),
			new Isotope(110, 179.952330, 0),
			new Isotope(111, 180.956150, 0) },
		{	new Isotope(79, 149.972668, 0),			// 71
			new Isotope(80, 150.967147, 0),
			new Isotope(81, 151.963610, 0),
			new Isotope(82, 152.958690, 0),
			new Isotope(83, 153.957100, 0),
			new Isotope(84, 154.953641324, 0),
			new Isotope(85, 155.952907, 0),
			new Isotope(86, 156.950101536, 0),
			new Isotope(87, 157.948577981, 0),
			new Isotope(88, 158.946615113, 0),
			new Isotope(89, 159.945383, 0),
			new Isotope(90, 160.943047504, 0),
			new Isotope(91, 161.943222, 0),
			new Isotope(92, 162.941203796, 0),
			new Isotope(93, 163.941215, 0),
			new Isotope(94, 164.939605886, 0),
			new Isotope(95, 165.939762646, 0),
			new Isotope(96, 166.938307056, 0),
			new Isotope(97, 167.938698576, 0),
			new Isotope(98, 168.937648757, 0),
			new Isotope(99, 169.938472190, 0),
			new Isotope(100, 170.937909903, 0),
			new Isotope(101, 171.939082239, 0),
			new Isotope(102, 172.938926901, 0),
			new Isotope(103, 173.940333522, 0),
			new Isotope(104, 174.940767904, 100.0000),
			new Isotope(105, 175.942682399, 2.6694),
			new Isotope(106, 176.943754987, 0),
			new Isotope(107, 177.945951366, 0),
			new Isotope(108, 178.947324216, 0),
			new Isotope(109, 179.949879968, 0),
			new Isotope(110, 180.951970, 0),
			new Isotope(111, 181.955210, 0),
			new Isotope(112, 182.957570, 0),
			new Isotope(113, 183.961170, 0) },
		{	new Isotope(82, 153.964250, 0),			// 72
			new Isotope(83, 154.962760, 0),
			new Isotope(84, 155.959247, 0),
			new Isotope(85, 156.958127, 0),
			new Isotope(86, 157.954055280, 0),
			new Isotope(87, 158.954003, 0),
			new Isotope(88, 159.950713588, 0),
			new Isotope(89, 160.950330852, 0),
			new Isotope(90, 161.947202977, 0),
			new Isotope(91, 162.947057, 0),
			new Isotope(92, 163.944422, 0),
			new Isotope(93, 164.944540, 0),
			new Isotope(94, 165.942250, 0),
			new Isotope(95, 166.942600, 0),
			new Isotope(96, 167.940630, 0),
			new Isotope(97, 168.941158567, 0),
			new Isotope(98, 169.939650, 0),
			new Isotope(99, 170.940490, 0),
			new Isotope(100, 171.939457980, 0),
			new Isotope(101, 172.940650, 0),
			new Isotope(102, 173.940040159, 0.4545),
			new Isotope(103, 174.941502991, 0),
			new Isotope(104, 175.941401828, 14.7727),
			new Isotope(105, 176.943220013, 52.8409),
			new Isotope(106, 177.943697732, 76.9886),
			new Isotope(107, 178.945815073, 39.0341),
			new Isotope(108, 179.946548760, 100.0000),
			new Isotope(109, 180.949099124, 0),
			new Isotope(110, 181.950552893, 0),
			new Isotope(111, 182.953531012, 0),
			new Isotope(112, 183.955447880, 0),
			new Isotope(113, 184.958780, 0),
			new Isotope(114, 185.960920, 0) },
		{	new Isotope(83, 155.971689, 0),			// 73
			new Isotope(84, 156.968145, 0),
			new Isotope(85, 157.966368, 0),
			new Isotope(86, 158.962323090, 0),
			new Isotope(87, 159.961358, 0),
			new Isotope(88, 160.958372992, 0),
			new Isotope(89, 161.956556553, 0),
			new Isotope(90, 162.954316650, 0),
			new Isotope(91, 163.953570, 0),
			new Isotope(92, 164.950817, 0),
			new Isotope(93, 165.950470, 0),
			new Isotope(94, 166.948639, 0),
			new Isotope(95, 167.947787, 0),
			new Isotope(96, 168.945920, 0),
			new Isotope(97, 169.946090, 0),
			new Isotope(98, 170.944460, 0),
			new Isotope(99, 171.944739818, 0),
			new Isotope(100, 172.944590, 0),
			new Isotope(101, 173.944167937, 0),
			new Isotope(102, 174.943650, 0),
			new Isotope(103, 175.944740551, 0),
			new Isotope(104, 176.944471766, 0),
			new Isotope(105, 177.945750349, 0),
			new Isotope(106, 178.945934113, 0),
			new Isotope(107, 179.947465655, 0.0120),
			new Isotope(108, 180.947996346, 100.0000),
			new Isotope(109, 181.950152414, 0),
			new Isotope(110, 182.951373188, 0),
			new Isotope(111, 183.954009331, 0),
			new Isotope(112, 184.955559086, 0),
			new Isotope(113, 185.958550100, 0),
			new Isotope(114, 186.960410, 0),
			new Isotope(115, 187.963710, 0) },
		{	new Isotope(84, 157.973939, 0),			// 74
			new Isotope(85, 158.972280, 0),
			new Isotope(86, 159.968369, 0),
			new Isotope(87, 160.967089, 0),
			new Isotope(88, 161.962750303, 0),
			new Isotope(89, 162.962532, 0),
			new Isotope(90, 163.958983810, 0),
			new Isotope(91, 164.958335962, 0),
			new Isotope(92, 165.955019896, 0),
			new Isotope(93, 166.954672, 0),
			new Isotope(94, 167.951863, 0),
			new Isotope(95, 168.951759, 0),
			new Isotope(96, 169.948473988, 0),
			new Isotope(97, 170.949460, 0),
			new Isotope(98, 171.948228837, 0),
			new Isotope(99, 172.948884, 0),
			new Isotope(100, 173.946160, 0),
			new Isotope(101, 174.946770, 0),
			new Isotope(102, 175.945590, 0),
			new Isotope(103, 176.946620, 0),
			new Isotope(104, 177.945848364, 0),
			new Isotope(105, 178.947071733, 0),
			new Isotope(106, 179.946705734, 0.4239),
			new Isotope(107, 180.948198054, 0),
			new Isotope(108, 181.948205519, 85.7515),
			new Isotope(109, 182.950224458, 46.6254),
			new Isotope(110, 183.950932553, 100.0000),
			new Isotope(111, 184.953420586, 0),
			new Isotope(112, 185.954362204, 93.2507),
			new Isotope(113, 186.957158365, 0),
			new Isotope(114, 187.958486954, 0),
			new Isotope(115, 188.961912220, 0),
			new Isotope(116, 189.963179541, 0) },
		{	new Isotope(85, 159.981485, 0),			// 75
			new Isotope(86, 160.977661, 0),
			new Isotope(87, 161.975707, 0),
			new Isotope(88, 162.971375872, 0),
			new Isotope(89, 163.970319, 0),
			new Isotope(90, 164.967050268, 0),
			new Isotope(91, 165.965211372, 0),
			new Isotope(92, 166.962564, 0),
			new Isotope(93, 167.961609, 0),
			new Isotope(94, 168.958830, 0),
			new Isotope(95, 169.958163, 0),
			new Isotope(96, 170.955547, 0),
			new Isotope(97, 171.955285, 0),
			new Isotope(98, 172.953062, 0),
			new Isotope(99, 173.952114, 0),
			new Isotope(100, 174.951393, 0),
			new Isotope(101, 175.951570, 0),
			new Isotope(102, 176.950270, 0),
			new Isotope(103, 177.950851081, 0),
			new Isotope(104, 178.949981038, 0),
			new Isotope(105, 179.950787680, 0),
			new Isotope(106, 180.950064596, 0),
			new Isotope(107, 181.951211444, 0),
			new Isotope(108, 182.950821349, 0),
			new Isotope(109, 183.952524289, 0),
			new Isotope(110, 184.952955747, 59.7444),
			new Isotope(111, 185.954986529, 0),
			new Isotope(112, 186.955750787, 100.0000),
			new Isotope(113, 187.958112287, 0),
			new Isotope(114, 188.959228359, 0),
			new Isotope(115, 189.961816139, 0),
			new Isotope(116, 190.963123592, 0),
			new Isotope(117, 191.965960, 0) },
		{	new Isotope(86, 161.983819, 0),			// 76
			new Isotope(87, 162.982048, 0),
			new Isotope(88, 163.977927, 0),
			new Isotope(89, 164.976475, 0),
			new Isotope(90, 165.971934911, 0),
			new Isotope(91, 166.971554, 0),
			new Isotope(92, 167.967832911, 0),
			new Isotope(93, 168.967076205, 0),
			new Isotope(94, 169.963569716, 0),
			new Isotope(95, 170.963040, 0),
			new Isotope(96, 171.960078, 0),
			new Isotope(97, 172.959791, 0),
			new Isotope(98, 173.956307704, 0),
			new Isotope(99, 174.957080, 0),
			new Isotope(100, 175.953757941, 0),
			new Isotope(101, 176.955045, 0),
			new Isotope(102, 177.953348225, 0),
			new Isotope(103, 178.953951, 0),
			new Isotope(104, 179.952308241, 0),
			new Isotope(105, 180.953274494, 0),
			new Isotope(106, 181.952186222, 0),
			new Isotope(107, 182.953110, 0),
			new Isotope(108, 183.952490808, 0.488),
			new Isotope(109, 184.954043023, 0),
			new Isotope(110, 185.953838355, 3.8537),
			new Isotope(111, 186.955747928, 3.9024),
			new Isotope(112, 187.955835993, 32.4390),
			new Isotope(113, 188.958144866, 39.2683),
			new Isotope(114, 189.958445210, 64.3902),
			new Isotope(115, 190.960927951, 0),
			new Isotope(116, 191.961479047, 100.0000),
			new Isotope(117, 192.964148083, 0),
			new Isotope(118, 193.965179314, 0),
			new Isotope(119, 194.968123889, 0),
			new Isotope(120, 195.969622550, 0) },
		{	new Isotope(88, 164.987580, 0),			// 77
			new Isotope(89, 165.985506, 0),
			new Isotope(90, 166.980951577, 0),
			new Isotope(91, 167.979966, 0),
			new Isotope(92, 168.976390868, 0),
			new Isotope(93, 169.974441697, 0),
			new Isotope(94, 170.971779, 0),
			new Isotope(95, 171.970643, 0),
			new Isotope(96, 172.967707, 0),
			new Isotope(97, 173.966804, 0),
			new Isotope(98, 174.964279, 0),
			new Isotope(99, 175.963511, 0),
			new Isotope(100, 176.961170, 0),
			new Isotope(101, 177.960084944, 0),
			new Isotope(102, 178.959150, 0),
			new Isotope(103, 179.958555615, 0),
			new Isotope(104, 180.957642156, 0),
			new Isotope(105, 181.958127689, 0),
			new Isotope(106, 182.956814, 0),
			new Isotope(107, 183.957388318, 0),
			new Isotope(108, 184.956590, 0),
			new Isotope(109, 185.957951104, 0),
			new Isotope(110, 186.957360830, 0),
			new Isotope(111, 187.958851962, 0),
			new Isotope(112, 188.958716473, 0),
			new Isotope(113, 189.960592299, 0),
			new Isotope(114, 190.960591191, 59.4896),
			new Isotope(115, 191.962602198, 0),
			new Isotope(116, 192.962923700, 100.0000),
			new Isotope(117, 193.965075610, 0),
			new Isotope(118, 194.965976800, 0),
			new Isotope(119, 195.968379906, 0),
			new Isotope(120, 196.969636496, 0),
			new Isotope(121, 197.972280, 0),
			new Isotope(122, 198.973787159, 0) },
		{	new Isotope(90, 167.988035, 0),			// 78
			new Isotope(91, 168.986421, 0),
			new Isotope(92, 169.981734918, 0),
			new Isotope(93, 170.981251, 0),
			new Isotope(94, 171.977376138, 0),
			new Isotope(95, 172.976499642, 0),
			new Isotope(96, 173.972811276, 0),
			new Isotope(97, 174.972276, 0),
			new Isotope(98, 175.969000, 0),
			new Isotope(99, 176.968453, 0),
			new Isotope(100, 177.964894223, 0),
			new Isotope(101, 178.965475, 0),
			new Isotope(102, 179.962023729, 0),
			new Isotope(103, 180.963177, 0),
			new Isotope(104, 181.961267637, 0),
			new Isotope(105, 182.961729, 0),
			new Isotope(106, 183.959851685, 0),
			new Isotope(107, 184.960753782, 0),
			new Isotope(108, 185.959432346, 0),
			new Isotope(109, 186.960697, 0),
			new Isotope(110, 187.959395697, 0),
			new Isotope(111, 188.960831900, 0),
			new Isotope(112, 189.959930073, 0.0296),
			new Isotope(113, 190.961684653, 0),
			new Isotope(114, 191.961035158, 2.3373),
			new Isotope(115, 192.962984504, 0),
			new Isotope(116, 193.962663581, 97.3373),
			new Isotope(117, 194.964774449, 100.0000),
			new Isotope(118, 195.964934884, 74.8521),
			new Isotope(119, 196.967323401, 0),
			new Isotope(120, 197.967876009, 21.3018),
			new Isotope(121, 198.970576213, 0),
			new Isotope(122, 199.971423885, 0),
			new Isotope(123, 200.974496467, 0),
			new Isotope(124, 201.975740, 0) },
		{	new Isotope(92, 170.991183, 0),			// 79
			new Isotope(93, 171.990109, 0),
			new Isotope(94, 172.986398138, 0),
			new Isotope(95, 173.984325861, 0),
			new Isotope(96, 174.981552, 0),
			new Isotope(97, 175.980269, 0),
			new Isotope(98, 176.977215, 0),
			new Isotope(99, 177.975975, 0),
			new Isotope(100, 178.973412, 0),
			new Isotope(101, 179.972396, 0),
			new Isotope(102, 180.969948, 0),
			new Isotope(103, 181.968621416, 0),
			new Isotope(104, 182.967620, 0),
			new Isotope(105, 183.966776046, 0),
			new Isotope(106, 184.965806956, 0),
			new Isotope(107, 185.965997671, 0),
			new Isotope(108, 186.964562, 0),
			new Isotope(109, 187.965321662, 0),
			new Isotope(110, 188.964224300, 0),
			new Isotope(111, 189.964698757, 0),
			new Isotope(112, 190.963649239, 0),
			new Isotope(113, 191.964810107, 0),
			new Isotope(114, 192.964131745, 0),
			new Isotope(115, 193.965338890, 0),
			new Isotope(116, 194.965017928, 0),
			new Isotope(117, 195.966551315, 0),
			new Isotope(118, 196.966551609, 100.0000),
			new Isotope(119, 197.968225244, 0),
			new Isotope(120, 198.968748016, 0),
			new Isotope(121, 199.970717886, 0),
			new Isotope(122, 200.971640839, 0),
			new Isotope(123, 201.973788431, 0),
			new Isotope(124, 202.975137256, 0),
			new Isotope(125, 203.977705, 0),
			new Isotope(126, 204.979610, 0) },
		{	new Isotope(95, 174.991411, 0),			// 80
			new Isotope(96, 175.987413248, 0),
			new Isotope(97, 176.986336874, 0),
			new Isotope(98, 177.982476325, 0),
			new Isotope(99, 178.981783, 0),
			new Isotope(100, 179.978322, 0),
			new Isotope(101, 180.977806, 0),
			new Isotope(102, 181.973935460, 0),
			new Isotope(103, 182.974561, 0),
			new Isotope(104, 183.970705219, 0),
			new Isotope(105, 184.971983, 0),
			new Isotope(106, 185.969460021, 0),
			new Isotope(107, 186.969785, 0),
			new Isotope(108, 187.967511693, 0),
			new Isotope(109, 188.968733187, 0),
			new Isotope(110, 189.966958568, 0),
			new Isotope(111, 190.967063110, 0),
			new Isotope(112, 191.965921572, 0),
			new Isotope(113, 192.966644169, 0),
			new Isotope(114, 193.965381832, 0),
			new Isotope(115, 194.966638981, 0),
			new Isotope(116, 195.965814846, 0.5059),
			new Isotope(117, 196.967195333, 0),
			new Isotope(118, 197.966751830, 34.0641),
			new Isotope(119, 198.968262489, 57.3356),
			new Isotope(120, 199.968308726, 77.9089),
			new Isotope(121, 200.970285275, 44.5194),
			new Isotope(122, 201.970625604, 100.0000),
			new Isotope(123, 202.972857096, 0),
			new Isotope(124, 203.973475640, 22.9342),
			new Isotope(125, 204.976056104, 0),
			new Isotope(126, 205.977498672, 0),
			new Isotope(127, 206.982577025, 0),
			new Isotope(128, 207.985940, 0) },
		{	new Isotope(96, 176.996881, 0),			// 81
			new Isotope(97, 177.994637, 0),
			new Isotope(98, 178.991466, 0),
			new Isotope(99, 179.990194, 0),
			new Isotope(100, 180.986904, 0),
			new Isotope(101, 181.985610, 0),
			new Isotope(102, 182.982697, 0),
			new Isotope(103, 183.981760, 0),
			new Isotope(104, 184.979100, 0),
			new Isotope(105, 185.977549881, 0),
			new Isotope(106, 186.976170, 0),
			new Isotope(107, 187.975920, 0),
			new Isotope(108, 188.974290451, 0),
			new Isotope(109, 189.974473379, 0),
			new Isotope(110, 190.972261952, 0),
			new Isotope(111, 191.972770785, 0),
			new Isotope(112, 192.970548, 0),
			new Isotope(113, 193.971053, 0),
			new Isotope(114, 194.969650, 0),
			new Isotope(115, 195.970515, 0),
			new Isotope(116, 196.969536200, 0),
			new Isotope(117, 197.970466294, 0),
			new Isotope(118, 198.969813837, 0),
			new Isotope(119, 199.970945394, 0),
			new Isotope(120, 200.970803770, 0),
			new Isotope(121, 201.972090569, 0),
			new Isotope(122, 202.972329088, 41.8922),
			new Isotope(123, 203.973848646, 0),
			new Isotope(124, 204.974412270, 100.0000),
			new Isotope(125, 205.976095321, 0),
			new Isotope(126, 206.977407908, 0),
			new Isotope(127, 207.982004653, 0),
			new Isotope(128, 208.985349125, 0),
			new Isotope(129, 209.990065574, 0) },
		{	new Isotope(99, 180.996714, 0),			// 82
			new Isotope(100, 181.992676101, 0),
			new Isotope(101, 182.991930, 0),
			new Isotope(102, 183.988198, 0),
			new Isotope(103, 184.987580, 0),
			new Isotope(104, 185.983485388, 0),
			new Isotope(105, 186.984030, 0),
			new Isotope(106, 187.979869108, 0),
			new Isotope(107, 188.980880, 0),
			new Isotope(108, 189.978180008, 0),
			new Isotope(109, 190.978200, 0),
			new Isotope(110, 191.975719811, 0),
			new Isotope(111, 192.976080, 0),
			new Isotope(112, 193.974648056, 0),
			new Isotope(113, 194.975920279, 0),
			new Isotope(114, 195.972710, 0),
			new Isotope(115, 196.973380, 0),
			new Isotope(116, 197.971980, 0),
			new Isotope(117, 198.972909384, 0),
			new Isotope(118, 199.971815560, 0),
			new Isotope(119, 200.972846589, 0),
			new Isotope(120, 201.972143786, 0),
			new Isotope(121, 202.973375491, 0),
			new Isotope(122, 203.973028761, 2.6718),
			new Isotope(123, 204.974467112, 0),
			new Isotope(124, 205.974449002, 45.9923),
			new Isotope(125, 206.975880605, 42.1756),
			new Isotope(126, 207.976635850, 100.0000),
			new Isotope(127, 208.981074801, 0),
			new Isotope(128, 209.984173129, 0),
			new Isotope(129, 210.988731474, 0),
			new Isotope(130, 211.991887495, 0),
			new Isotope(131, 212.996500, 0),
			new Isotope(132, 213.999798147, 0) },
		{	new Isotope(102, 184.997708, 0),		// 83
			new Isotope(103, 185.996480, 0),
			new Isotope(104, 186.993458, 0),
			new Isotope(105, 187.992173, 0),
			new Isotope(106, 188.989505, 0),
			new Isotope(107, 189.987520007, 0),
			new Isotope(108, 190.986053, 0),
			new Isotope(109, 191.985368, 0),
			new Isotope(110, 192.983662229, 0),
			new Isotope(111, 193.983430186, 0),
			new Isotope(112, 194.981126970, 0),
			new Isotope(113, 195.981236107, 0),
			new Isotope(114, 196.978934287, 0),
			new Isotope(115, 197.979024396, 0),
			new Isotope(116, 198.977576953, 0),
			new Isotope(117, 199.978141983, 0),
			new Isotope(118, 200.976970721, 0),
			new Isotope(119, 201.977674504, 0),
			new Isotope(120, 202.976868118, 0),
			new Isotope(121, 203.977805161, 0),
			new Isotope(122, 204.977374688, 0),
			new Isotope(123, 205.978482854, 0),
			new Isotope(124, 206.978455217, 0),
			new Isotope(125, 207.979726699, 0),
			new Isotope(126, 208.980383241, 100.0000),
			new Isotope(127, 209.984104944, 0),
			new Isotope(128, 210.987258139, 0),
			new Isotope(129, 211.991271542, 0),
			new Isotope(130, 212.994374836, 0),
			new Isotope(131, 213.998698664, 0),
			new Isotope(132, 215.001832349, 0),
			new Isotope(133, 216.006199, 0) },
		{	new Isotope(106, 189.994293888, 0),		// 84
			new Isotope(107, 190.994653, 0),
			new Isotope(108, 191.990330390, 0),
			new Isotope(109, 192.991102, 0),
			new Isotope(110, 193.988284107, 0),
			new Isotope(111, 194.988045, 0),
			new Isotope(112, 195.985469432, 0),
			new Isotope(113, 196.985567, 0),
			new Isotope(114, 197.984024384, 0),
			new Isotope(115, 198.985044507, 0),
			new Isotope(116, 199.981735, 0),
			new Isotope(117, 200.982209, 0),
			new Isotope(118, 201.980704, 0),
			new Isotope(119, 202.981412863, 0),
			new Isotope(120, 203.980307113, 0),
			new Isotope(121, 204.981165396, 0),
			new Isotope(122, 205.980465241, 0),
			new Isotope(123, 206.981578228, 0),
			new Isotope(124, 207.981231059, 0),
			new Isotope(125, 208.982415788, 0),
			new Isotope(126, 209.982857396, 0),
			new Isotope(127, 210.986636869, 0),
			new Isotope(128, 211.988851755, 0),
			new Isotope(129, 212.992842522, 0),
			new Isotope(130, 213.995185949, 0),
			new Isotope(131, 214.999414609, 0),
			new Isotope(132, 216.001905198, 0),
			new Isotope(133, 217.006253, 0),
			new Isotope(134, 218.008965773, 0) },
		{	new Isotope(108, 193.000188, 0),		// 85
			new Isotope(109, 193.997973, 0),
			new Isotope(110, 194.996554, 0),
			new Isotope(111, 195.995702, 0),
			new Isotope(112, 196.993891293, 0),
			new Isotope(113, 197.993433680, 0),
			new Isotope(114, 198.991008569, 0),
			new Isotope(115, 199.990920883, 0),
			new Isotope(116, 200.988486908, 0),
			new Isotope(117, 201.988448629, 0),
			new Isotope(118, 202.986847216, 0),
			new Isotope(119, 203.987261559, 0),
			new Isotope(120, 204.986036352, 0),
			new Isotope(121, 205.986599242, 0),
			new Isotope(122, 206.985775861, 0),
			new Isotope(123, 207.986582508, 0),
			new Isotope(124, 208.986158678, 0),
			new Isotope(125, 209.987131308, 0),
			new Isotope(126, 210.987480806, 0),
			new Isotope(127, 211.990734657, 0),
			new Isotope(128, 212.992921150, 0),
			new Isotope(129, 213.996356412, 0),
			new Isotope(130, 214.998641245, 0),
			new Isotope(131, 216.002408839, 0),
			new Isotope(132, 217.004709619, 0),
			new Isotope(133, 218.008681458, 0),
			new Isotope(134, 219.011296478, 0),
			new Isotope(135, 220.015301, 0),
			new Isotope(136, 221.018140, 0),
			new Isotope(137, 222.022330, 0),
			new Isotope(138, 223.025340, 0) },
		{	new Isotope(110, 196.001117268, 0),		// 86
			new Isotope(111, 197.001661, 0),
			new Isotope(112, 197.998779978, 0),
			new Isotope(113, 198.998309, 0),
			new Isotope(114, 199.995634148, 0),
			new Isotope(115, 200.995535, 0),
			new Isotope(116, 201.993899382, 0),
			new Isotope(117, 202.994765192, 0),
			new Isotope(118, 203.991365, 0),
			new Isotope(119, 204.991668, 0),
			new Isotope(120, 205.990160, 0),
			new Isotope(121, 206.990726826, 0),
			new Isotope(122, 207.989631237, 0),
			new Isotope(123, 208.990376634, 0),
			new Isotope(124, 209.989679862, 0),
			new Isotope(125, 210.990585410, 0),
			new Isotope(126, 211.990688899, 0),
			new Isotope(127, 212.993868354, 0),
			new Isotope(128, 213.995346275, 0),
			new Isotope(129, 214.998729195, 0),
			new Isotope(130, 216.000258153, 0),
			new Isotope(131, 217.003914555, 0),
			new Isotope(132, 218.005586315, 0),
			new Isotope(133, 219.009474831, 0),
			new Isotope(134, 220.011384149, 0),
			new Isotope(135, 221.015455, 0),
			new Isotope(136, 222.017570472, 0),
			new Isotope(137, 223.021790, 0),
			new Isotope(138, 224.024090, 0),
			new Isotope(139, 225.028440, 0),
			new Isotope(140, 226.030890, 0),
			new Isotope(141, 227.035407, 0),
			new Isotope(142, 228.038084, 0) },
		{	new Isotope(113, 200.006499, 0),		// 87
			new Isotope(114, 201.004586920, 0),
			new Isotope(115, 202.003968850, 0),
			new Isotope(116, 203.001423829, 0),
			new Isotope(117, 204.001221209, 0),
			new Isotope(118, 204.998663961, 0),
			new Isotope(119, 205.998486886, 0),
			new Isotope(120, 206.996859385, 0),
			new Isotope(121, 207.997133849, 0),
			new Isotope(122, 208.995915421, 0),
			new Isotope(123, 209.996398327, 0),
			new Isotope(124, 210.995529332, 0),
			new Isotope(125, 211.996194988, 0),
			new Isotope(126, 212.996174845, 0),
			new Isotope(127, 213.998954740, 0),
			new Isotope(128, 215.000326029, 0),
			new Isotope(129, 216.003187873, 0),
			new Isotope(130, 217.004616452, 0),
			new Isotope(131, 218.007563326, 0),
			new Isotope(132, 219.009240843, 0),
			new Isotope(133, 220.012312978, 0),
			new Isotope(134, 221.014245654, 0),
			new Isotope(135, 222.017543957, 0),
			new Isotope(136, 223.019730712, 0),
			new Isotope(137, 224.023235513, 0),
			new Isotope(138, 225.025606914, 0),
			new Isotope(139, 226.029343423, 0),
			new Isotope(140, 227.031833167, 0),
			new Isotope(141, 228.034776087, 0),
			new Isotope(142, 229.038426, 0),
			new Isotope(143, 230.042510, 0),
			new Isotope(144, 231.045407, 0),
			new Isotope(145, 232.049654, 0) },
		{	new Isotope(115, 203.009210, 0),		// 88
			new Isotope(116, 204.006434513, 0),
			new Isotope(117, 205.006187, 0),
			new Isotope(118, 206.004463814, 0),
			new Isotope(119, 207.005176607, 0),
			new Isotope(120, 208.001776, 0),
			new Isotope(121, 209.001944, 0),
			new Isotope(122, 210.000446, 0),
			new Isotope(123, 211.000893996, 0),
			new Isotope(124, 211.999783492, 0),
			new Isotope(125, 213.000345847, 0),
			new Isotope(126, 214.000091141, 0),
			new Isotope(127, 215.002704195, 0),
			new Isotope(128, 216.003518402, 0),
			new Isotope(129, 217.006306010, 0),
			new Isotope(130, 218.007123948, 0),
			new Isotope(131, 219.010068787, 0),
			new Isotope(132, 220.011014669, 0),
			new Isotope(133, 221.013907762, 0),
			new Isotope(134, 222.015361820, 0),
			new Isotope(135, 223.018497140, 0),
			new Isotope(136, 224.020202004, 0),
			new Isotope(137, 225.023604463, 0),
			new Isotope(138, 226.025402555, 0),
			new Isotope(139, 227.029170677, 0),
			new Isotope(140, 228.031064101, 0),
			new Isotope(141, 229.034820309, 0),
			new Isotope(142, 230.037084774, 0),
			new Isotope(143, 231.041220, 0),
			new Isotope(144, 232.043693, 0),
			new Isotope(145, 233.047995, 0),
			new Isotope(146, 234.050547, 0) },
		{	new Isotope(118, 207.012469754, 0),		// 89
			new Isotope(119, 208.012112949, 0),
			new Isotope(120, 209.009568736, 0),
			new Isotope(121, 210.009256802, 0),
			new Isotope(122, 211.007648196, 0),
			new Isotope(123, 212.007811441, 0),
			new Isotope(124, 213.006573689, 0),
			new Isotope(125, 214.006893072, 0),
			new Isotope(126, 215.006450832, 0),
			new Isotope(127, 216.008721268, 0),
			new Isotope(128, 217.009332676, 0),
			new Isotope(129, 218.011625045, 0),
			new Isotope(130, 219.012404918, 0),
			new Isotope(131, 220.014752105, 0),
			new Isotope(132, 221.015575746, 0),
			new Isotope(133, 222.017828852, 0),
			new Isotope(134, 223.019126030, 0),
			new Isotope(135, 224.021708435, 0),
			new Isotope(136, 225.023220576, 0),
			new Isotope(137, 226.026089848, 0),
			new Isotope(138, 227.027746979, 0),
			new Isotope(139, 228.031014825, 0),
			new Isotope(140, 229.032930871, 0),
			new Isotope(141, 230.036025144, 0),
			new Isotope(142, 231.038551503, 0),
			new Isotope(143, 232.042022474, 0),
			new Isotope(144, 233.044550, 0),
			new Isotope(145, 234.048420, 0),
			new Isotope(146, 235.051102, 0),
			new Isotope(147, 236.055178, 0) },
		{	new Isotope(120, 210.015711883, 0),		// 90
			new Isotope(121, 211.016306912, 0),
			new Isotope(122, 212.012916, 0),
			new Isotope(123, 213.012962, 0),
			new Isotope(124, 214.011451, 0),
			new Isotope(125, 215.011726597, 0),
			new Isotope(126, 216.011050963, 0),
			new Isotope(127, 217.013066169, 0),
			new Isotope(128, 218.013267744, 0),
			new Isotope(129, 219.015521253, 0),
			new Isotope(130, 220.015733126, 0),
			new Isotope(131, 221.018171499, 0),
			new Isotope(132, 222.018454131, 0),
			new Isotope(133, 223.020795153, 0),
			new Isotope(134, 224.021459250, 0),
			new Isotope(135, 225.023941441, 0),
			new Isotope(136, 226.024890681, 0),
			new Isotope(137, 227.027698859, 0),
			new Isotope(138, 228.028731348, 0),
			new Isotope(139, 229.031755340, 0),
			new Isotope(140, 230.033126574, 0),
			new Isotope(141, 231.036297060, 0),
			new Isotope(142, 232.038050360, 100.0000),
			new Isotope(143, 233.041576923, 0),
			new Isotope(144, 234.043595497, 0),
			new Isotope(145, 235.047504420, 0),
			new Isotope(146, 236.049710, 0),
			new Isotope(147, 237.053894, 0),
			new Isotope(148, 238.056243, 0) },
		{	new Isotope(122, 213.021183209, 0),		// 91
			new Isotope(123, 214.020739230, 0),
			new Isotope(124, 215.019097612, 0),
			new Isotope(125, 216.019109649, 0),
			new Isotope(126, 217.018288571, 0),
			new Isotope(127, 218.020007906, 0),
			new Isotope(128, 219.019880348, 0),
			new Isotope(129, 220.021876493, 0),
			new Isotope(130, 221.021863742, 0),
			new Isotope(131, 222.023726, 0),
			new Isotope(132, 223.023963748, 0),
			new Isotope(133, 224.025614854, 0),
			new Isotope(134, 225.026115172, 0),
			new Isotope(135, 226.027932750, 0),
			new Isotope(136, 227.028793151, 0),
			new Isotope(137, 228.031036942, 0),
			new Isotope(138, 229.032088601, 0),
			new Isotope(139, 230.034532562, 0),
			new Isotope(140, 231.035878898, 0),
			new Isotope(141, 232.038581720, 0),
			new Isotope(142, 233.040240235, 0),
			new Isotope(143, 234.043302325, 0),
			new Isotope(144, 235.045436759, 0),
			new Isotope(145, 236.048675176, 0),
			new Isotope(146, 237.051139430, 0),
			new Isotope(147, 238.054497046, 0),
			new Isotope(148, 239.057130, 0),
			new Isotope(149, 240.060980, 0) },
		{	new Isotope(126, 218.023487, 0),		// 92
			new Isotope(127, 219.024915423, 0),
			new Isotope(128, 220.024712, 0),
			new Isotope(129, 221.026351, 0),
			new Isotope(130, 222.026070, 0),
			new Isotope(131, 223.027722956, 0),
			new Isotope(132, 224.027590139, 0),
			new Isotope(133, 225.029384369, 0),
			new Isotope(134, 226.029339750, 0),
			new Isotope(135, 227.031140069, 0),
			new Isotope(136, 228.031366357, 0),
			new Isotope(137, 229.033496137, 0),
			new Isotope(138, 230.033927392, 0),
			new Isotope(139, 231.036289158, 0),
			new Isotope(140, 232.037146280, 0),
			new Isotope(141, 233.039628196, 0),
			new Isotope(142, 234.040945606, 0.0055),
			new Isotope(143, 235.043923062, 0.7253),
			new Isotope(144, 236.045561897, 0),
			new Isotope(145, 237.048723955, 0),
			new Isotope(146, 238.050782583, 100.0000),
			new Isotope(147, 239.054287777, 0),
			new Isotope(148, 240.056585734, 0),
			new Isotope(149, 241.060330, 0),
			new Isotope(150, 242.062925, 0) },
		{	new Isotope(132, 225.033899689, 0),		// 93
			new Isotope(133, 226.035129, 0),
			new Isotope(134, 227.034958261, 0),
			new Isotope(135, 228.036180, 0),
			new Isotope(136, 229.036246866, 0),
			new Isotope(137, 230.037812591, 0),
			new Isotope(138, 231.038233161, 0),
			new Isotope(139, 232.040099, 0),
			new Isotope(140, 233.040732350, 0),
			new Isotope(141, 234.042888556, 0),
			new Isotope(142, 235.044055876, 0),
			new Isotope(143, 236.046559724, 0),
			new Isotope(144, 237.048167253, 0),
			new Isotope(145, 238.050940464, 0),
			new Isotope(146, 239.052931399, 0),
			new Isotope(147, 240.056168828, 0),
			new Isotope(148, 241.058246266, 0),
			new Isotope(149, 242.061635, 0),
			new Isotope(150, 243.064273, 0),
			new Isotope(151, 244.067850, 0) },
		{	new Isotope(134, 228.038727686, 0),		// 94
			new Isotope(135, 229.040138934, 0),
			new Isotope(136, 230.039645603, 0),
			new Isotope(137, 231.041258, 0),
			new Isotope(138, 232.041179445, 0),
			new Isotope(139, 233.042987570, 0),
			new Isotope(140, 234.043304681, 0),
			new Isotope(141, 235.045281500, 0),
			new Isotope(142, 236.046048088, 0),
			new Isotope(143, 237.048403774, 0),
			new Isotope(144, 238.049553400, 0),
			new Isotope(145, 239.052156519, 0),
			new Isotope(146, 240.053807460, 0),
			new Isotope(147, 241.056845291, 0),
			new Isotope(148, 242.058736847, 0),
			new Isotope(149, 243.061997013, 0),
			new Isotope(150, 244.064197650, 0),
			new Isotope(151, 245.067738657, 0),
			new Isotope(152, 246.070198429, 0),
			new Isotope(153, 247.074070, 0) },
		{	new Isotope(136, 231.045560, 0),		// 95
			new Isotope(137, 232.046590, 0),
			new Isotope(138, 233.046472, 0),
			new Isotope(139, 234.047794, 0),
			new Isotope(140, 235.048029, 0),
			new Isotope(141, 236.049569, 0),
			new Isotope(142, 237.049970748, 0),
			new Isotope(143, 238.051977839, 0),
			new Isotope(144, 239.053018481, 0),
			new Isotope(145, 240.055287826, 0),
			new Isotope(146, 241.056822944, 0),
			new Isotope(147, 242.059543039, 0),
			new Isotope(148, 243.061372686, 0),
			new Isotope(149, 244.064279429, 0),
			new Isotope(150, 245.066445398, 0),
			new Isotope(151, 246.069768438, 0),
			new Isotope(152, 247.072086, 0),
			new Isotope(153, 248.075745, 0),
			new Isotope(154, 249.078480, 0) },
		{	new Isotope(137, 233.050800, 0),		// 96
			new Isotope(138, 234.050240, 0),
			new Isotope(139, 235.051591, 0),
			new Isotope(140, 236.051405, 0),
			new Isotope(141, 237.052891, 0),
			new Isotope(142, 238.053016298, 0),
			new Isotope(143, 239.054951, 0),
			new Isotope(144, 240.055519046, 0),
			new Isotope(145, 241.057646736, 0),
			new Isotope(146, 242.058829326, 0),
			new Isotope(147, 243.061382249, 0),
			new Isotope(148, 244.062746349, 0),
			new Isotope(149, 245.065485586, 0),
			new Isotope(150, 246.067217551, 0),
			new Isotope(151, 247.070346811, 0),
			new Isotope(152, 248.072342247, 0),
			new Isotope(153, 249.075947062, 0),
			new Isotope(154, 250.078350687, 0),
			new Isotope(155, 251.082277873, 0),
			new Isotope(156, 252.084870, 0) },
		{	new Isotope(138, 235.056580, 0),		// 97
			new Isotope(139, 236.057330, 0),
			new Isotope(140, 237.057127, 0),
			new Isotope(141, 238.058266, 0),
			new Isotope(142, 239.058362, 0),
			new Isotope(143, 240.059749, 0),
			new Isotope(144, 241.060223, 0),
			new Isotope(145, 242.062050, 0),
			new Isotope(146, 243.063001570, 0),
			new Isotope(147, 244.065167882, 0),
			new Isotope(148, 245.066355386, 0),
			new Isotope(149, 246.068666836, 0),
			new Isotope(150, 247.070298533, 0),
			new Isotope(151, 248.073080, 0),
			new Isotope(152, 249.074979937, 0),
			new Isotope(153, 250.078310529, 0),
			new Isotope(154, 251.080753440, 0),
			new Isotope(155, 252.084303, 0),
			new Isotope(156, 253.086880, 0),
			new Isotope(157, 254.090600, 0) },
		{	new Isotope(139, 237.062070, 0),		// 98
			new Isotope(140, 238.061410, 0),
			new Isotope(141, 239.062579, 0),
			new Isotope(142, 240.062295, 0),
			new Isotope(143, 241.063716, 0),
			new Isotope(144, 242.063688713, 0),
			new Isotope(145, 243.065421, 0),
			new Isotope(146, 244.065990390, 0),
			new Isotope(147, 245.068039, 0),
			new Isotope(148, 246.068798807, 0),
			new Isotope(149, 247.070992043, 0),
			new Isotope(150, 248.072178080, 0),
			new Isotope(151, 249.074846818, 0),
			new Isotope(152, 250.076399951, 0),
			new Isotope(153, 251.079580056, 0),
			new Isotope(154, 252.081619582, 0),
			new Isotope(155, 253.085126791, 0),
			new Isotope(156, 254.087316198, 0),
			new Isotope(157, 255.091039, 0),
			new Isotope(158, 256.093440, 0) },
		{	new Isotope(141, 240.068920, 0),		// 99
			new Isotope(142, 241.068662, 0),
			new Isotope(143, 242.069699, 0),
			new Isotope(144, 243.069631, 0),
			new Isotope(145, 244.070969, 0),
			new Isotope(146, 245.071317, 0),
			new Isotope(147, 246.072965, 0),
			new Isotope(148, 247.073650, 0),
			new Isotope(149, 248.075458, 0),
			new Isotope(150, 249.076405, 0),
			new Isotope(151, 250.078654, 0),
			new Isotope(152, 251.079983592, 0),
			new Isotope(153, 252.082972247, 0),
			new Isotope(154, 253.084817974, 0),
			new Isotope(155, 254.088016026, 0),
			new Isotope(156, 255.090266386, 0),
			new Isotope(157, 256.093592, 0),
			new Isotope(158, 257.095979, 0) },
		{	new Isotope(142, 242.073430, 0),		// 100
			new Isotope(143, 243.074510, 0),
			new Isotope(144, 244.074077, 0),
			new Isotope(145, 245.075375, 0),
			new Isotope(146, 246.075281634, 0),
			new Isotope(147, 247.076819, 0),
			new Isotope(148, 248.077184411, 0),
			new Isotope(149, 249.079024, 0),
			new Isotope(150, 250.079514759, 0),
			new Isotope(151, 251.081566467, 0),
			new Isotope(152, 252.082460071, 0),
			new Isotope(153, 253.085176259, 0),
			new Isotope(154, 254.086847795, 0),
			new Isotope(155, 255.089955466, 0),
			new Isotope(156, 256.091766522, 0),
			new Isotope(157, 257.095098635, 0),
			new Isotope(158, 258.097069, 0),
			new Isotope(159, 259.100588, 0) },
		{	new Isotope(144, 245.081017, 0),		// 101
			new Isotope(145, 246.081933, 0),
			new Isotope(146, 247.081804, 0),
			new Isotope(147, 248.082909, 0),
			new Isotope(148, 249.083002, 0),
			new Isotope(149, 250.084488, 0),
			new Isotope(150, 251.084919, 0),
			new Isotope(151, 252.086630, 0),
			new Isotope(152, 253.087280, 0),
			new Isotope(153, 254.089725, 0),
			new Isotope(154, 255.091075196, 0),
			new Isotope(155, 256.094052757, 0),
			new Isotope(156, 257.095534643, 0),
			new Isotope(157, 258.098425321, 0),
			new Isotope(158, 259.100503, 0),
			new Isotope(159, 260.103645, 0) },
		{	new Isotope(147, 249.087823, 0),		// 102
			new Isotope(148, 250.087493, 0),
			new Isotope(149, 251.088960, 0),
			new Isotope(150, 252.088965909, 0),
			new Isotope(151, 253.090649, 0),
			new Isotope(152, 254.090948746, 0),
			new Isotope(153, 255.093232449, 0),
			new Isotope(154, 256.094275879, 0),
			new Isotope(155, 257.096852778, 0),
			new Isotope(156, 258.098200, 0),
			new Isotope(157, 259.101024, 0),
			new Isotope(158, 260.102636, 0),
			new Isotope(159, 261.105743, 0),
			new Isotope(160, 262.107520, 0) },
		{	new Isotope(148, 251.094360, 0),		// 103
			new Isotope(149, 252.095330, 0),
			new Isotope(150, 253.095258, 0),
			new Isotope(151, 254.096587, 0),
			new Isotope(152, 255.096769, 0),
			new Isotope(153, 256.098763, 0),
			new Isotope(154, 257.099606, 0),
			new Isotope(155, 258.101883, 0),
			new Isotope(156, 259.102990, 0),
			new Isotope(157, 260.105572, 0),
			new Isotope(158, 261.106941, 0),
			new Isotope(159, 262.109692, 0),
			new Isotope(160, 263.111394, 0) },
		{	new Isotope(149, 253.100679, 0),		// 104
			new Isotope(150, 254.100166, 0),
			new Isotope(151, 255.101492, 0),
			new Isotope(152, 256.101179573, 0),
			new Isotope(153, 257.103072, 0),
			new Isotope(154, 258.103568, 0),
			new Isotope(155, 259.105628, 0),
			new Isotope(156, 260.106434, 0),
			new Isotope(157, 261.108752, 0),
			new Isotope(158, 262.109918, 0),
			new Isotope(159, 263.112540, 0),
			new Isotope(160, 264.113978, 0) },
		{	new Isotope(150, 255.107398, 0),		// 105
			new Isotope(151, 256.108110, 0),
			new Isotope(152, 257.107858, 0),
			new Isotope(153, 258.109438, 0),
			new Isotope(154, 259.109721, 0),
			new Isotope(155, 260.111427, 0),
			new Isotope(156, 261.112106, 0),
			new Isotope(157, 262.114153, 0),
			new Isotope(158, 263.115078, 0),
			new Isotope(159, 264.117473, 0),
			new Isotope(160, 265.118659, 0) },
		{	new Isotope(152, 258.113151, 0),		// 106
			new Isotope(153, 259.114652, 0),
			new Isotope(154, 260.114435447, 0),
			new Isotope(155, 261.116199, 0),
			new Isotope(156, 262.116477, 0),
			new Isotope(157, 263.118313, 0),
			new Isotope(158, 264.118924, 0),
			new Isotope(159, 265.121066, 0),
			new Isotope(160, 266.121928, 0) },
		{	new Isotope(153, 260.121803, 0),		// 107
			new Isotope(154, 261.121800, 0),
			new Isotope(155, 262.123009, 0),
			new Isotope(156, 263.123146, 0),
			new Isotope(157, 264.124730, 0),
			new Isotope(158, 265.125198, 0),
			new Isotope(159, 266.127009, 0),
			new Isotope(160, 267.127740, 0) },
		{	new Isotope(155, 263.128710, 0),		// 108
			new Isotope(156, 264.128408258, 0),
			new Isotope(157, 265.130001, 0),
			new Isotope(158, 266.130042, 0),
			new Isotope(159, 267.131774, 0),
			new Isotope(160, 268.132156, 0),
			new Isotope(161, 269.134114, 0) },
		{	new Isotope(156, 265.136567, 0),		// 109
			new Isotope(157, 266.137940, 0),
			new Isotope(158, 267.137526, 0),
			new Isotope(159, 268.138816, 0),
			new Isotope(160, 269.139106, 0),
			new Isotope(161, 270.140723, 0),
			new Isotope(162, 271.141229, 0) }	};

	public static int[] getIsotopeList(int atomicNo) {
		int[] isotopeList = new int[sIsotope[atomicNo].length];
		for (int i=0; i<sIsotope[atomicNo].length; i++)
			isotopeList[i] = atomicNo + sIsotope[atomicNo][i].neutrones;
		return isotopeList;
		} 

	public static double getAbsoluteMass(int atomicNo, int mass) {
		int neutrones = mass - atomicNo;
		for (int i=0; i<sIsotope[atomicNo].length; i++)
			if (sIsotope[atomicNo][i].neutrones == neutrones)
				return sIsotope[atomicNo][i].absoluteMass;
		return Double.NaN;
		}

	public static double getNaturalPercentage(int atomicNo, int mass) {
		int neutrones = mass - atomicNo;
		for (int i=0; i<sIsotope[atomicNo].length; i++)
			if (sIsotope[atomicNo][i].neutrones == neutrones)
				return sIsotope[atomicNo][i].percentage;
		return Double.NaN;
		}
	}

class Isotope {
	protected int neutrones;
	protected double absoluteMass;
	protected double percentage;
	
	protected Isotope(int neutrones, double absoluteMass, double percentage) {
		this.neutrones = neutrones;
		this.absoluteMass = absoluteMass;
		this.percentage = percentage;
		}
	}
