import os
import sys

try:
    # TODO: If we made the tests dir a package this could be avoided by using
    # package-relative imports
    import conv_base
except ImportError:
    sys.path.insert(0, os.path.abspath(os.path.join(os.path.dirname(__file__),
                                                    os.pardir)))
    import conv_base


class Test841(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,flam),band(cousins,i),15,vegamag)"
        cls.fname="C841_%s.fits"
        cls.setup2()

class Test842(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,flam),band(johnson,k),15,vegamag)"
        cls.fname="C842_%s.fits"
        cls.setup2()

class Test843(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,flam),band(johnson,k),20,vegamag)"
        cls.fname="C843_%s.fits"
        cls.setup2()

class Test844(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,flam),band(johnson,v),15,vegamag)"
        cls.fname="C844_%s.fits"
        cls.setup2()

class Test845(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,flam),band(johnson,v),20,vegamag)"
        cls.fname="C845_%s.fits"
        cls.setup2()

class Test846(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,flam),band(nicmos,2,f110w),15,vegamag)"
        cls.fname="C846_%s.fits"
        cls.setup2()

class Test847(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,flam),band(nicmos,2,f160w),15,vegamag)"
        cls.fname="C847_%s.fits"
        cls.setup2()

class Test848(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,flam),band(sdss,i),15,vegamag)"
        cls.fname="C848_%s.fits"
        cls.setup2()

class Test849(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,flam),box(10000.0,1.0),1.00E-06,jy)"
        cls.fname="C849_%s.fits"
        cls.setup2()

class Test850(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,flam),box(10000.0,1.0),1.00E-13,flam)"
        cls.fname="C850_%s.fits"
        cls.setup2()

class Test851(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,flam),box(10000.0,1.0),1.00E-13,flam)*ebmvx(3.0,gal1)"
        cls.fname="C851_%s.fits"
        cls.setup2()

class Test852(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,flam),box(10000.0,1.0),1.00E-13,flam)*ebmvx(3.0,gal3)"
        cls.fname="C852_%s.fits"
        cls.setup2()

class Test853(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,flam),box(10000.0,1.0),1.00E-13,flam)*ebmvx(3.0,lmc)"
        cls.fname="C853_%s.fits"
        cls.setup2()

class Test854(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,flam),box(10000.0,1.0),1.00E-13,flam)*ebmvx(3.0,xgal)"
        cls.fname="C854_%s.fits"
        cls.setup2()

class Test855(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,flam),box(10000.0,1.0),1.00E-13,flam)+em(10000.0,10.0,1.0E-13,flam)"
        cls.fname="C855_%s.fits"
        cls.setup2()

class Test856(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,flam),box(15999.999999999998,1.0),1.00E-06,jy)"
        cls.fname="C856_%s.fits"
        cls.setup2()

class Test857(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,flam),box(15999.999999999998,1.0),1.00E-13,flam)"
        cls.fname="C857_%s.fits"
        cls.setup2()

class Test858(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,flam),box(22000.0,1.0),1.00E-06,jy)"
        cls.fname="C858_%s.fits"
        cls.setup2()

class Test859(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,flam),box(22000.0,1.0),1.00E-13,flam)"
        cls.fname="C859_%s.fits"
        cls.setup2()

class Test860(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(unit(1.0,fnu),box(10000.0,1.0),1.00E-13,flam)"
        cls.fname="C860_%s.fits"
        cls.setup2()

class Test861(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(z(spec($PYSYN_CDBS/calspec/g191b2b_mod_004.fits),0.5),box(10000.0,1.0),1.00E-13,flam)"
        cls.fname="C861_%s.fits"
        cls.setup2()

class Test862(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(z(spec($PYSYN_CDBS/calspec/g191b2b_mod_004.fits),1.0),box(10000.0,1.0),1.00E-13,flam)"
        cls.fname="C862_%s.fits"
        cls.setup2()

class Test863(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(z(spec($PYSYN_CDBS/calspec/g191b2b_mod_004.fits),2.0),box(10000.0,1.0),1.00E-13,flam)"
        cls.fname="C863_%s.fits"
        cls.setup2()

class Test864(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="rn(z(spec(qso_template.fits),2.0),box(10000.0,1.0),1.00E-13,flam)"
        cls.fname="C864_%s.fits"
        cls.setup2()

class Test865(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec($PYSYN_CDBS/calspec/1740346_nic_001.fits)"
        cls.fname="C865_%s.fits"
        cls.setup2()

class Test866(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec($PYSYN_CDBS/calspec/g191b2b_mod_004.fits)"
        cls.fname="C866_%s.fits"
        cls.setup2()

class Test867(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec($PYSYN_CDBS/calspec/gd153_mod_004.fits)"
        cls.fname="C867_%s.fits"
        cls.setup2()

class Test868(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec($PYSYN_CDBS/calspec/gd71_mod_005.fits)"
        cls.fname="C868_%s.fits"
        cls.setup2()

class Test869(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),21.628378447488586,vegamag)"
        cls.fname="C869_%s.fits"
        cls.setup2()

class Test870(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.0086,vegamag)"
        cls.fname="C870_%s.fits"
        cls.setup2()

class Test871(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.1,vegamag)"
        cls.fname="C871_%s.fits"
        cls.setup2()

class Test872(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.26738684931507,vegamag)"
        cls.fname="C872_%s.fits"
        cls.setup2()

class Test873(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.40573333333333,vegamag)"
        cls.fname="C873_%s.fits"
        cls.setup2()

class Test874(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.7,vegamag)"
        cls.fname="C874_%s.fits"
        cls.setup2()

class Test875(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.808112328767123,vegamag)"
        cls.fname="C875_%s.fits"
        cls.setup2()

class Test876(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.9514,vegamag)"
        cls.fname="C876_%s.fits"
        cls.setup2()

class Test877(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.964448767123287,vegamag)"
        cls.fname="C877_%s.fits"
        cls.setup2()

class Test878(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),23.067600000000002,vegamag)"
        cls.fname="C878_%s.fits"
        cls.setup2()

class Test879(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),23.1514,vegamag)"
        cls.fname="C879_%s.fits"
        cls.setup2()

class Test880(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),23.3,vegamag)"
        cls.fname="C880_%s.fits"
        cls.setup2()

class Test881(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),28.0,vegamag)"
        cls.fname="C881_%s.fits"
        cls.setup2()

class Test882(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),30.0,vegamag)"
        cls.fname="C882_%s.fits"
        cls.setup2()

class Test883(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec(earthshine.fits)*0.5+spec(Zodi.fits)*1.0"
        cls.fname="C883_%s.fits"
        cls.setup2()

class Test884(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec(earthshine.fits)*0.5+spec(Zodi.fits)*1.5"
        cls.fname="C884_%s.fits"
        cls.setup2()

class Test885(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec(earthshine.fits)*1.0+rn(spec(Zodi.fits),band(johnson,v),22.7,vegamag)"
        cls.fname="C885_%s.fits"
        cls.setup2()

class Test886(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec(earthshine.fits)*2.0+rn(spec(Zodi.fits),band(johnson,v),22.7,vegamag)"
        cls.fname="C886_%s.fits"
        cls.setup2()

class Test887(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f110w"
        cls.spectrum="spec(earthshine.fits)+rn(spec(Zodi.fits),band(johnson,v),22.7,vegamag)"
        cls.fname="C887_%s.fits"
        cls.setup2()

class Test888(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f113n"
        cls.spectrum="rn(bb(5500),band(bessell,h),22,vegamag)"
        cls.fname="C888_%s.fits"
        cls.setup2()

class Test889(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f113n"
        cls.spectrum="spec(earthshine.fits)*0.5+rn(spec(Zodi.fits),band(johnson,v),22.7,vegamag)"
        cls.fname="C889_%s.fits"
        cls.setup2()

class Test890(conv_base.ThermCase):
    @classmethod
    def setUpClass(cls):
        cls.obsmode="nicmos,1,f140w"
        cls.spectrum="rn(bb(5500),band(bessell,h),22,vegamag)"
        cls.fname="C890_%s.fits"
        cls.setup2()

