/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.AngularDistanceComputer;
import cds.healpix.CompassPoint;
import cds.healpix.HashComputer;
import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import cds.healpix.HealpixNestedBMOC;
import cds.healpix.HealpixNestedFixedRadiusConeComputer;
import cds.healpix.NeighbourList;
import cds.healpix.NeighbourSelector;
import cds.healpix.NestedLargeCell;
import cds.healpix.NewtonMethod;
import cds.healpix.VerticesAndPathComputer;
import cds.healpix.common.math.HackersDelight;
import cds.healpix.common.math.Math;
import java.util.EnumMap;
import java.util.EnumSet;

final class NestedLargeCellSmallRadius
implements HealpixNestedFixedRadiusConeComputer {
    private static final EnumSet<CompassPoint.Cardinal> ALL_CARDINALS = EnumSet.allOf(CompassPoint.Cardinal.class);
    private final int nIterMax;
    private final double epsLat;
    private final HealpixNested hn;
    private final double rRad;
    private final double squareOfsinOfHalfR;
    private final HashComputer hComputer;
    private final NeighbourSelector neigSelector;
    private final VerticesAndPathComputer vpComputer;
    private final AngularDistanceComputer angDistComputer;
    private final EnumMap<CompassPoint.Cardinal, double[]> vertices = new EnumMap(CompassPoint.Cardinal.class);
    private final EnumSet<CompassPoint.MainWind> neigSet = EnumSet.noneOf(CompassPoint.MainWind.class);
    private final NeighbourList neigList;
    private final long[] neig = new long[8];
    private int iNeig = 0;

    public NestedLargeCellSmallRadius(HealpixNested hnTarget, double radiusRad) {
        this(hnTarget, radiusRad, radiusRad * 1.0E-4, 10);
    }

    protected NestedLargeCellSmallRadius(HealpixNested hnTarget, double radiusRad, double epsLat, int nIterMax) {
        assert (radiusRad > 0.0);
        this.hn = hnTarget;
        this.epsLat = epsLat;
        this.nIterMax = nIterMax;
        this.rRad = radiusRad;
        this.angDistComputer = AngularDistanceComputer.getComputer(this.rRad);
        double sinHalfR = this.angDistComputer.sin(0.5 * radiusRad);
        this.squareOfsinOfHalfR = sinHalfR * sinHalfR;
        this.hComputer = this.hn.newHashComputer();
        this.neigSelector = this.hn.newNeighbourSelector();
        this.vpComputer = this.hn.newVerticesAndPathComputer();
        this.neigList = new NeighbourList(-1);
        this.initVerticesMap();
    }

    private void initVerticesMap() {
        for (CompassPoint.Cardinal c : CompassPoint.Cardinal.values()) {
            this.vertices.put(c, new double[2]);
        }
    }

    @Override
    public double getRadius() {
        return this.rRad;
    }

    @Override
    public HealpixNestedBMOC overlappingCells(double coneCenterLonRad, double coneCenterLatRad, HealpixNestedFixedRadiusConeComputer.ReturnedCells returnedCells) {
        switch (returnedCells) {
            case FULLY_IN: {
                return this.overlappingFullyIn(coneCenterLonRad, coneCenterLatRad);
            }
            case OVERLAPPING: {
                return this.overlappingCells(coneCenterLonRad, coneCenterLatRad);
            }
            case CENTER_IN: {
                return this.overlappingCenters(coneCenterLonRad, coneCenterLatRad);
            }
        }
        throw new Error("Type " + (Object)((Object)returnedCells) + " not implemented!");
    }

    private HealpixNestedBMOC overlappingFullyIn(double coneCenterLonRad, double coneCenterLatRad) {
        double cosConeCenterLat = Math.cos(coneCenterLatRad);
        long centerHash = this.hComputer.hash(coneCenterLonRad, coneCenterLatRad);
        this.neigSelector.neighbours(centerHash, this.neigList);
        this.neigList.put(centerHash, CompassPoint.MainWind.C);
        this.iNeig = 0;
        double[] center = new double[2];
        for (int i = 0; i < this.neigList.size(); ++i) {
            long h = this.neigList.get(i);
            if (!this.allVerticesOk(h, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat)) continue;
            this.insertSortRmDuplicates(h);
        }
        long[] moc = new long[this.iNeig];
        for (int i = 0; i < this.iNeig; ++i) {
            moc[i] = HealpixNestedBMOC.buildValue(this.hn.depth(), this.neig[i], false, this.hn.depth());
        }
        return HealpixNestedBMOC.createUnsafe(this.hn.depth(), moc);
    }

    private boolean allVerticesOk(long hash, double coneCenterLon, double coneCenterLat, double cosCenterLat) {
        for (double[] vertex : this.vpComputer.vertices(hash, ALL_CARDINALS).values()) {
            double vLat;
            double vLon = vertex[0];
            double dConeCell = this.angDistComputer.haversineDistInRad(vLon - coneCenterLon, (vLat = vertex[1]) - coneCenterLat, cosCenterLat, Math.cos(vLat));
            if (!(dConeCell > this.rRad)) continue;
            return false;
        }
        return true;
    }

    @Override
    public HealpixNestedBMOC overlappingCenters(double coneCenterLonRad, double coneCenterLatRad) {
        double cosConeCenterLat = Math.cos(coneCenterLatRad);
        long centerHash = this.hComputer.hash(coneCenterLonRad, coneCenterLatRad);
        this.neigSelector.neighbours(centerHash, this.neigList);
        this.neig[0] = centerHash;
        this.iNeig = 1;
        double[] center = new double[2];
        for (int i = 0; i < this.neigList.size(); ++i) {
            long neigH = this.neigList.get(i);
            this.vpComputer.center(neigH, center);
            double lat = center[1];
            double deltaLon = NestedLargeCellSmallRadius.computeDeltaLon(coneCenterLonRad, center[0]);
            double deltaLat = coneCenterLatRad - lat;
            if (!(this.squareOfSinOfHalfR(deltaLon, deltaLat, Math.cos(lat), cosConeCenterLat) <= this.squareOfsinOfHalfR)) continue;
            this.insertSortRmDuplicates(neigH);
        }
        assert (this.iNeig == this.neigList.size() + 1);
        long[] moc = new long[this.iNeig];
        for (int i = 0; i < this.iNeig; ++i) {
            moc[i] = HealpixNestedBMOC.buildValue(this.hn.depth(), this.neig[i], false, this.hn.depth());
        }
        return HealpixNestedBMOC.createUnsafe(this.hn.depth(), moc);
    }

    @Override
    public HealpixNestedBMOC overlappingCells(double coneCenterLonRad, double coneCenterLatRad) {
        double cosSouthVertexLat;
        double deltaLat;
        double deltaLon;
        double southVertexLat;
        double cosNorthVertexLat;
        double deltaLat2;
        double deltaLon2;
        double cosConeCenterLat = Math.cos(coneCenterLatRad);
        double sinConeCenterLat = Math.sin(coneCenterLatRad);
        coneCenterLonRad = NestedLargeCellSmallRadius.normalizeLon(coneCenterLonRad);
        assert (0.0 <= coneCenterLonRad && coneCenterLonRad <= java.lang.Math.PI * 2);
        long centerHash = this.hComputer.hash(coneCenterLonRad, coneCenterLatRad);
        assert (-1.5707963267948966 <= coneCenterLatRad && coneCenterLatRad <= 1.5707963267948966);
        this.vpComputer.vertices(centerHash, this.vertices);
        double latMax = coneCenterLatRad + this.rRad;
        double latMin = coneCenterLatRad - this.rRad;
        int nVerticesInCone = 0;
        boolean testNE = true;
        boolean testNW = true;
        boolean testSE = true;
        boolean testSW = true;
        boolean testN = true;
        boolean testS = true;
        double northVertexLat = this.vertices.get((Object)CompassPoint.Cardinal.N)[1];
        if (northVertexLat <= latMax && this.squareOfSinOfHalfR(deltaLon2 = NestedLargeCellSmallRadius.computeDeltaLon(coneCenterLonRad, this.vertices.get((Object)CompassPoint.Cardinal.N)[0]), deltaLat2 = northVertexLat - coneCenterLatRad, cosNorthVertexLat = Math.cos(northVertexLat), cosConeCenterLat) <= this.squareOfsinOfHalfR) {
            this.neigSet.add(CompassPoint.MainWind.N);
            this.neigSet.add(CompassPoint.MainWind.NE);
            this.neigSet.add(CompassPoint.MainWind.NW);
            ++nVerticesInCone;
            testN = false;
            testNE = false;
            testNW = false;
        }
        if (latMin <= (southVertexLat = this.vertices.get((Object)CompassPoint.Cardinal.S)[1]) && this.squareOfSinOfHalfR(deltaLon = NestedLargeCellSmallRadius.computeDeltaLon(coneCenterLonRad, this.vertices.get((Object)CompassPoint.Cardinal.S)[0]), deltaLat = coneCenterLatRad - southVertexLat, cosSouthVertexLat = Math.cos(southVertexLat), cosConeCenterLat) <= this.squareOfsinOfHalfR) {
            this.neigSet.add(CompassPoint.MainWind.S);
            this.neigSet.add(CompassPoint.MainWind.SE);
            this.neigSet.add(CompassPoint.MainWind.SW);
            ++nVerticesInCone;
            testS = false;
            testSE = false;
            testSW = false;
        }
        double eastWestVerticesLat = this.vertices.get((Object)CompassPoint.Cardinal.W)[1];
        assert (this.vertices.get((Object)CompassPoint.Cardinal.W)[1] == this.vertices.get((Object)CompassPoint.Cardinal.E)[1]);
        if (latMin <= eastWestVerticesLat && eastWestVerticesLat <= latMax) {
            double cosEastWestVerticesLat = Math.cos(eastWestVerticesLat);
            double squareOfSinOfHalfDeltaLonMax = this.squareOfSinOfHalfDeltaLon(eastWestVerticesLat - coneCenterLatRad, cosEastWestVerticesLat, cosConeCenterLat);
            if (this.squareOfSinOfHalfOf(NestedLargeCellSmallRadius.computeDeltaLon(coneCenterLonRad, this.vertices.get((Object)CompassPoint.Cardinal.E)[0])) <= squareOfSinOfHalfDeltaLonMax) {
                this.neigSet.add(CompassPoint.MainWind.E);
                this.neigSet.add(CompassPoint.MainWind.NE);
                this.neigSet.add(CompassPoint.MainWind.SE);
                ++nVerticesInCone;
                testNE = false;
                testSE = false;
            }
            if (this.squareOfSinOfHalfOf(NestedLargeCellSmallRadius.computeDeltaLon(coneCenterLonRad, this.vertices.get((Object)CompassPoint.Cardinal.W)[0])) <= squareOfSinOfHalfDeltaLonMax) {
                this.neigSet.add(CompassPoint.MainWind.W);
                this.neigSet.add(CompassPoint.MainWind.NW);
                this.neigSet.add(CompassPoint.MainWind.SW);
                ++nVerticesInCone;
                testNW = false;
                testSW = false;
            }
        }
        this.neig[0] = centerHash;
        this.iNeig = 1;
        if (nVerticesInCone > 0) {
            this.neigSelector.neighbours(centerHash, this.neigSet, this.neigList);
            for (int i = 0; i < this.neigList.size(); ++i) {
                this.insertSortRmDuplicates(this.neigList.get(i));
            }
            assert (this.iNeig == this.neigList.size() + 1);
        }
        if (testNE || testNW || testN) {
            if (Healpix.isLatInNorthPolarCap(northVertexLat)) {
                this.edgesNEWinNPC(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, testNE, testNW, testN);
            } else if (Healpix.isLatInSouthPolarCap(eastWestVerticesLat)) {
                this.edgesNEWinSPC(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, testNE, testNW);
            } else if (testNE || testNW) {
                this.edgesNEWinEQR(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, testNE, testNW);
            }
        }
        if (testSE || testSW || testS) {
            if (Healpix.isLatInNorthPolarCap(eastWestVerticesLat)) {
                this.edgesSEWinNPC(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, testNE, testNW);
            } else if (Healpix.isLatInSouthPolarCap(southVertexLat)) {
                this.edgesSEWinSPC(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, testNE, testNW, testS);
            } else if (testSE || testSW) {
                this.edgesSEWinEQR(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, testNE, testNW);
            }
        }
        long[] moc = new long[this.iNeig];
        for (int i = 0; i < this.iNeig; ++i) {
            moc[i] = HealpixNestedBMOC.buildValue(this.hn.depth(), this.neig[i], false, this.hn.depth());
        }
        return HealpixNestedBMOC.createUnsafe(this.hn.depth(), moc);
    }

    private final void insertSortRmDuplicates(long hash) {
        for (int i = 0; i < this.iNeig; ++i) {
            long hashi = this.neig[i];
            if (hash == hashi) {
                return;
            }
            if (hash >= hashi) continue;
            int j = this.iNeig++;
            while (j > i) {
                this.neig[j--] = this.neig[j];
            }
            this.neig[i] = hash;
            return;
        }
        this.neig[this.iNeig++] = hash;
    }

    private double toLocalX(double lonRad, double latRad, double coneCenterLonRad, double coneCenterLatRad, double cosConeCenterLat) {
        return cosConeCenterLat * this.smallSin(lonRad - coneCenterLonRad) / this.smallCos(lonRad - coneCenterLonRad);
    }

    private double toLocalY(double latRad, double coneCenterLatRad) {
        return this.smallSin(latRad - coneCenterLatRad);
    }

    private double straitLineSlope(double xA, double yA, double xB, double yB) {
        return (yB - yA) / (xB - xA);
    }

    private double straitLineIntercept(double xA, double yA, double xB, double yB) {
        return (yA * xB - xA * yB) / (xB - xA);
    }

    private double smallSin(double aRad) {
        return this.angDistComputer.sin(aRad);
    }

    private double smallCos(double aRad) {
        return this.angDistComputer.cos(aRad);
    }

    private double smallAsin(double a) {
        return this.angDistComputer.asin(a);
    }

    private double latOfParallelLineTangentToCone(double coneCenterLonRad, double coneCenterLatRad, double cosConeCenterLat, double sinConeCenterLat, double lonA, double latA, double lonB, double latB, boolean northSolution, double discriminantToleranceInRadiusUnits) {
        double c;
        double a;
        boolean hasSolution;
        double xA = this.toLocalX(lonA, latA, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat);
        double yA = this.toLocalY(latA, coneCenterLatRad);
        double xB = this.toLocalX(lonB, latB, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat);
        double yB = this.toLocalY(latB, coneCenterLatRad);
        double slope = this.straitLineSlope(xA, yA, xB, yB);
        double r = this.smallSin(this.rRad);
        if (!Math.isFinite(slope)) {
            assert (Math.abs(xB - xA) < 1.0E-15);
            if (Math.abs(xA) < r * (1.0 + discriminantToleranceInRadiusUnits)) {
                return coneCenterLatRad;
            }
            return Double.NaN;
        }
        double intercept = this.straitLineIntercept(xA, yA, xB, yB);
        double b = 2.0 * slope * intercept;
        boolean bl = hasSolution = b * b - 4.0 * (a = slope * slope + 1.0) * (c = intercept * intercept - r * r) >= -r * discriminantToleranceInRadiusUnits;
        if (hasSolution) {
            double interceptUniqSolution = (northSolution ? r : -r) * java.lang.Math.sqrt(a);
            double bUniqSolution = 2.0 * slope * interceptUniqSolution;
            double x = -bUniqSolution / (2.0 * a);
            double y = slope * x + interceptUniqSolution;
            return coneCenterLatRad + this.smallAsin(y);
        }
        return Double.NaN;
    }

    private final void edgesNEWinEQR(double coneCenterLonRad, double coneCenterLatRad, double cosConeCenterLat, double sinConeCenterLat, boolean testNE, boolean testNW) {
        double[] lonLatE;
        double[] lonLatN = this.vertices.get((Object)CompassPoint.Cardinal.N);
        double latRad = this.latOfParallelLineTangentToCone(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatN[0], lonLatN[1], (lonLatE = this.vertices.get((Object)CompassPoint.Cardinal.E))[0], lonLatE[1], true, 1.0);
        if (!Math.isFinite(latRad)) {
            return;
        }
        if (!Math.isFinite(latRad = NewtonMethod.newtonSolveEquatorialZone(latRad, coneCenterLatRad, cosConeCenterLat, this.squareOfsinOfHalfR, false, this.epsLat, this.nIterMax, this.angDistComputer))) {
            return;
        }
        double zDxDyEq1 = Math.sin(latRad);
        double deltaLon = this.angDistComputer.coneDeltaLon(this.squareOfsinOfHalfR, cosConeCenterLat, latRad - coneCenterLatRad, zDxDyEq1);
        if (testNE) {
            this.insertSortRmDuplicates(this.hComputer.hash(coneCenterLonRad + deltaLon, latRad));
        }
        if (testNW) {
            this.insertSortRmDuplicates(this.hComputer.hash(coneCenterLonRad - deltaLon, latRad));
        }
    }

    private final void edgesSEWinEQR(double coneCenterLonRad, double coneCenterLatRad, double cosConeCenterLat, double sinConeCenterLat, boolean testSE, boolean testSW) {
        double[] lonLatE;
        double[] lonLatS = this.vertices.get((Object)CompassPoint.Cardinal.S);
        double latRad = this.latOfParallelLineTangentToCone(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatS[0], lonLatS[1], (lonLatE = this.vertices.get((Object)CompassPoint.Cardinal.E))[0], lonLatE[1], false, 1.0);
        if (!Math.isFinite(latRad)) {
            return;
        }
        if (!Math.isFinite(latRad = NewtonMethod.newtonSolveEquatorialZone(latRad, coneCenterLatRad, cosConeCenterLat, this.squareOfsinOfHalfR, true, this.epsLat, this.nIterMax, this.angDistComputer))) {
            return;
        }
        double zDxDyEq1 = Math.sin(latRad);
        double deltaLon = this.angDistComputer.coneDeltaLon(this.squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
        if (testSE) {
            this.insertSortRmDuplicates(this.hComputer.hash(coneCenterLonRad + deltaLon, latRad));
        }
        if (testSW) {
            this.insertSortRmDuplicates(this.hComputer.hash(coneCenterLonRad - deltaLon, latRad));
        }
    }

    private final void edgesNEWinNPC(double coneCenterLonRad, double coneCenterLatRad, double cosConeCenterLat, double sinConeCenterLat, boolean testNE, boolean testNW, boolean testN) {
        double deltaLon;
        double zDxDyEq1;
        double latRad;
        double coneCenterLonModHalfPi = coneCenterLonRad % 1.5707963267948966;
        double[] lonLatN = this.vertices.get((Object)CompassPoint.Cardinal.N);
        double[] lonLatE = this.vertices.get((Object)CompassPoint.Cardinal.E);
        double[] lonLatW = this.vertices.get((Object)CompassPoint.Cardinal.W);
        if (testNE || testN) {
            latRad = this.latOfParallelLineTangentToCone(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatN[0], lonLatN[1], lonLatE[0], lonLatE[1], true, 1.0);
            latRad = NewtonMethod.newtonSolveNorthPolarCapZone(latRad, true, coneCenterLonModHalfPi, coneCenterLatRad, cosConeCenterLat, this.squareOfsinOfHalfR, true, this.epsLat, this.nIterMax, this.angDistComputer);
            zDxDyEq1 = Math.sin(latRad);
            deltaLon = this.angDistComputer.coneDeltaLon(this.squareOfsinOfHalfR, cosConeCenterLat, latRad - coneCenterLatRad, zDxDyEq1);
            this.insertSortRmDuplicates(this.hComputer.hash(coneCenterLonRad + deltaLon, latRad));
            if (coneCenterLonModHalfPi + deltaLon > 0.7853981633974483 && lonLatN[1] < 1.5707963267948966) {
                latRad = this.latOfParallelLineTangentToCone(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatN[0], lonLatN[1], 2.0 * lonLatN[0] - lonLatW[0], lonLatW[1], true, 1.0);
                deltaLon = this.angDistComputer.coneDeltaLon(this.squareOfsinOfHalfR, cosConeCenterLat, (latRad = NewtonMethod.newtonSolveNorthPolarCapZone(latRad, true, coneCenterLonModHalfPi - 1.5707963267948966, coneCenterLatRad, cosConeCenterLat, this.squareOfsinOfHalfR, true, this.epsLat, this.nIterMax, this.angDistComputer)) - coneCenterLatRad, zDxDyEq1 = Math.sin(latRad));
                if (Math.isFinite(deltaLon)) {
                    this.insertSortRmDuplicates(this.hComputer.hash(coneCenterLonRad + deltaLon, latRad));
                }
            }
        }
        if (testNW || testN) {
            latRad = this.latOfParallelLineTangentToCone(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatW[0], lonLatW[1], lonLatN[0], lonLatN[1], true, 1.0);
            latRad = NewtonMethod.newtonSolveNorthPolarCapZone(latRad, false, coneCenterLonModHalfPi, coneCenterLatRad, cosConeCenterLat, this.squareOfsinOfHalfR, false, this.epsLat, this.nIterMax, this.angDistComputer);
            zDxDyEq1 = Math.sin(latRad);
            deltaLon = this.angDistComputer.coneDeltaLon(this.squareOfsinOfHalfR, cosConeCenterLat, latRad - coneCenterLatRad, zDxDyEq1);
            this.insertSortRmDuplicates(this.hComputer.hash(coneCenterLonRad - deltaLon, latRad));
            if (coneCenterLonModHalfPi - deltaLon < 0.0 && lonLatN[1] < 1.5707963267948966) {
                latRad = this.latOfParallelLineTangentToCone(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, 2.0 * lonLatN[0] - lonLatE[0], lonLatE[1], lonLatN[0], lonLatN[1], true, 1.0);
                deltaLon = this.angDistComputer.coneDeltaLon(this.squareOfsinOfHalfR, cosConeCenterLat, (latRad = NewtonMethod.newtonSolveNorthPolarCapZone(latRad, false, coneCenterLonModHalfPi + 1.5707963267948966, coneCenterLatRad, cosConeCenterLat, this.squareOfsinOfHalfR, false, this.epsLat, this.nIterMax, this.angDistComputer)) - coneCenterLatRad, zDxDyEq1 = Math.sin(latRad));
                if (Math.isFinite(deltaLon)) {
                    this.insertSortRmDuplicates(this.hComputer.hash(coneCenterLonRad - deltaLon, latRad));
                }
            }
        }
    }

    private final void edgesNEWinSPC(double coneCenterLonRad, double coneCenterLatRad, double cosConeCenterLat, double sinConeCenterLat, boolean testNE, boolean testNW) {
        double deltaLon;
        double zDxDyEq1;
        double latRad;
        double coneCenterLonModHalfPi = coneCenterLonRad % 1.5707963267948966;
        double[] lonLatN = this.vertices.get((Object)CompassPoint.Cardinal.N);
        double[] lonLatE = this.vertices.get((Object)CompassPoint.Cardinal.E);
        double[] lonLatW = this.vertices.get((Object)CompassPoint.Cardinal.W);
        if (testNE) {
            latRad = this.latOfParallelLineTangentToCone(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatN[0], lonLatN[1], lonLatE[0], lonLatE[1], true, 1.0);
            if (!Math.isFinite(latRad)) {
                return;
            }
            if (!Math.isFinite(latRad = -NewtonMethod.newtonSolveNorthPolarCapZone(-latRad, true, coneCenterLonModHalfPi, -coneCenterLatRad, cosConeCenterLat, this.squareOfsinOfHalfR, false, this.epsLat, this.nIterMax, this.angDistComputer))) {
                return;
            }
            zDxDyEq1 = Math.sin(latRad);
            deltaLon = this.angDistComputer.coneDeltaLon(this.squareOfsinOfHalfR, cosConeCenterLat, latRad - coneCenterLatRad, zDxDyEq1);
            this.insertSortRmDuplicates(this.hComputer.hash(coneCenterLonRad + deltaLon, latRad));
        }
        if (testNW) {
            latRad = this.latOfParallelLineTangentToCone(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatW[0], lonLatW[1], lonLatN[0], lonLatN[1], true, 1.0);
            if (!Math.isFinite(latRad)) {
                return;
            }
            if (!Math.isFinite(latRad = -NewtonMethod.newtonSolveNorthPolarCapZone(-latRad, false, coneCenterLonModHalfPi, -coneCenterLatRad, cosConeCenterLat, this.squareOfsinOfHalfR, true, this.epsLat, this.nIterMax, this.angDistComputer))) {
                return;
            }
            zDxDyEq1 = Math.sin(latRad);
            deltaLon = this.angDistComputer.coneDeltaLon(this.squareOfsinOfHalfR, cosConeCenterLat, latRad - coneCenterLatRad, zDxDyEq1);
            this.insertSortRmDuplicates(this.hComputer.hash(coneCenterLonRad - deltaLon, latRad));
        }
    }

    private final void edgesSEWinNPC(double coneCenterLonRad, double coneCenterLatRad, double cosConeCenterLat, double sinConeCenterLat, boolean testSE, boolean testSW) {
        double deltaLon;
        double zDxDyEq1;
        double latRad;
        double coneCenterLonModHalfPi = coneCenterLonRad % 1.5707963267948966;
        double[] lonLatS = this.vertices.get((Object)CompassPoint.Cardinal.S);
        double[] lonLatE = this.vertices.get((Object)CompassPoint.Cardinal.E);
        double[] lonLatW = this.vertices.get((Object)CompassPoint.Cardinal.W);
        if (testSE) {
            latRad = this.latOfParallelLineTangentToCone(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatS[0], lonLatS[1], lonLatE[0], lonLatE[1], false, 1.0);
            if (!Math.isFinite(latRad)) {
                return;
            }
            if (!Math.isFinite(latRad = NewtonMethod.newtonSolveNorthPolarCapZone(latRad, true, coneCenterLonModHalfPi, coneCenterLatRad, cosConeCenterLat, this.squareOfsinOfHalfR, false, this.epsLat, this.nIterMax, this.angDistComputer))) {
                return;
            }
            zDxDyEq1 = Math.sin(latRad);
            deltaLon = this.angDistComputer.coneDeltaLon(this.squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            this.insertSortRmDuplicates(this.hComputer.hash(coneCenterLonRad + deltaLon, latRad));
        }
        if (testSW) {
            latRad = this.latOfParallelLineTangentToCone(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatW[0], lonLatW[1], lonLatS[0], lonLatS[1], false, 1.0);
            if (!Math.isFinite(latRad)) {
                return;
            }
            if (!Math.isFinite(latRad = NewtonMethod.newtonSolveNorthPolarCapZone(latRad, false, coneCenterLonModHalfPi, coneCenterLatRad, cosConeCenterLat, this.squareOfsinOfHalfR, true, this.epsLat, this.nIterMax, this.angDistComputer))) {
                return;
            }
            zDxDyEq1 = Math.sin(latRad);
            deltaLon = this.angDistComputer.coneDeltaLon(this.squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            this.insertSortRmDuplicates(this.hComputer.hash(coneCenterLonRad - deltaLon, latRad));
        }
    }

    private final void edgesSEWinSPC(double coneCenterLonRad, double coneCenterLatRad, double cosConeCenterLat, double sinConeCenterLat, boolean testSE, boolean testSW, boolean testS) {
        double deltaLon;
        double zDxDyEq1;
        double latRad;
        double coneCenterLonModHalfPi = coneCenterLonRad % 1.5707963267948966;
        double[] lonLatS = this.vertices.get((Object)CompassPoint.Cardinal.S);
        double[] lonLatE = this.vertices.get((Object)CompassPoint.Cardinal.E);
        double[] lonLatW = this.vertices.get((Object)CompassPoint.Cardinal.W);
        if (testSE || testS) {
            latRad = this.latOfParallelLineTangentToCone(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatS[0], lonLatS[1], lonLatE[0], lonLatE[1], true, 1.0);
            deltaLon = this.angDistComputer.coneDeltaLon(this.squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - (latRad = -NewtonMethod.newtonSolveNorthPolarCapZone(-latRad, true, coneCenterLonModHalfPi, -coneCenterLatRad, cosConeCenterLat, this.squareOfsinOfHalfR, true, this.epsLat, this.nIterMax, this.angDistComputer)), zDxDyEq1 = Math.sin(latRad));
            if (coneCenterLonModHalfPi + deltaLon > 0.7853981633974483 && lonLatS[1] > -1.5707963267948966) {
                latRad = this.latOfParallelLineTangentToCone(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatS[0], lonLatS[1], 2.0 * lonLatS[0] - lonLatW[0], lonLatW[1], false, 1.0);
                latRad = -NewtonMethod.newtonSolveNorthPolarCapZone(-latRad, true, coneCenterLonModHalfPi - 1.5707963267948966, -coneCenterLatRad, cosConeCenterLat, this.squareOfsinOfHalfR, true, this.epsLat, this.nIterMax, this.angDistComputer);
                zDxDyEq1 = Math.sin(latRad);
                deltaLon = this.angDistComputer.coneDeltaLon(this.squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            }
            if (Math.isFinite(latRad)) {
                this.insertSortRmDuplicates(this.hComputer.hash(coneCenterLonRad + deltaLon, latRad));
            }
        }
        if (testSW || testS) {
            latRad = this.latOfParallelLineTangentToCone(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatW[0], lonLatW[1], lonLatS[0], lonLatS[1], false, 1.0);
            deltaLon = this.angDistComputer.coneDeltaLon(this.squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - (latRad = -NewtonMethod.newtonSolveNorthPolarCapZone(-latRad, false, coneCenterLonModHalfPi, -coneCenterLatRad, cosConeCenterLat, this.squareOfsinOfHalfR, false, this.epsLat, this.nIterMax, this.angDistComputer)), zDxDyEq1 = Math.sin(latRad));
            if (coneCenterLonModHalfPi - deltaLon < 0.0 && lonLatS[1] > -1.5707963267948966) {
                latRad = this.latOfParallelLineTangentToCone(coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, 2.0 * lonLatS[0] - lonLatE[0], lonLatE[1], lonLatS[0], lonLatS[1], false, 1.0);
                latRad = -NewtonMethod.newtonSolveNorthPolarCapZone(-latRad, false, coneCenterLonModHalfPi + 1.5707963267948966, -coneCenterLatRad, cosConeCenterLat, this.squareOfsinOfHalfR, false, this.epsLat, this.nIterMax, this.angDistComputer);
                zDxDyEq1 = Math.sin(latRad);
                deltaLon = this.angDistComputer.coneDeltaLon(this.squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            }
            if (Math.isFinite(latRad)) {
                this.insertSortRmDuplicates(this.hComputer.hash(coneCenterLonRad - deltaLon, latRad));
            }
        }
    }

    @Override
    public HealpixNestedFixedRadiusConeComputer newComputer() {
        return new NestedLargeCell(this.hn, this.rRad);
    }

    private static double normalizeLon(double lonRad) {
        if (lonRad < 0.0 || java.lang.Math.PI * 2 < lonRad) {
            int k = HackersDelight.floorInt(lonRad * 0.15915494309189535);
            return lonRad - (double)k * (java.lang.Math.PI * 2);
        }
        return lonRad;
    }

    private static double computeDeltaLon(double lonARad, double lonBRad) {
        double res = Math.abs(lonARad - lonBRad);
        return res <= java.lang.Math.PI ? res : java.lang.Math.PI * 2 - res;
    }

    private final double squareOfSinOfHalfR(double deltaLonRad, double deltaLatRad, double cosLat, double cosLatCenter) {
        return this.angDistComputer.squareOfsinOfhalfDistInRad2(deltaLonRad, deltaLatRad, cosLat, cosLatCenter);
    }

    private final double squareOfSinOfHalfOf(double angleRad) {
        double sin = this.angDistComputer.sin(0.5 * angleRad);
        return sin * sin;
    }

    private final double squareOfSinOfHalfDeltaLon(double deltaLatRad, double cosLat, double cosLatCenter) {
        assert (cosLat >= 0.0 && cosLatCenter >= 0.0);
        double n = this.squareOfsinOfHalfR - this.squareOfSinOfHalfOf(deltaLatRad);
        double d = cosLat * cosLatCenter;
        if (n < 0.0) {
            return Double.NaN;
        }
        if (n >= d) {
            return 1.0;
        }
        return n / d;
    }
}

