'\"
'\" Generated from file 'machineparameters\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2008 Michael Baudin <michael\&.baudin@sourceforge\&.net>
'\"
.TH "tclrep/machineparameters" n 1\&.0 tcllib "tclrep"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
tclrep/machineparameters \- Compute double precision machine parameters\&.
.SH SYNOPSIS
package require \fBsnit \fR
.sp
package require \fBmath::machineparameters  0\&.1\fR
.sp
\fBmachineparameters\fR create \fIobjectname\fR ?\fIoptions\fR\&.\&.\&.?
.sp
\fIobjectname\fR \fBconfigure\fR ?\fIoptions\fR\&.\&.\&.?
.sp
\fIobjectname\fR \fBcget\fR \fIopt\fR
.sp
\fIobjectname\fR \fBdestroy\fR
.sp
\fIobjectname\fR \fBcompute\fR
.sp
\fIobjectname\fR \fBget\fR \fIkey\fR
.sp
\fIobjectname\fR \fBtostring\fR
.sp
\fIobjectname\fR \fBprint\fR
.sp
.BE
.SH DESCRIPTION
The \fImath::machineparameters\fR package
is the Tcl equivalent of the DLAMCH LAPACK function\&.
In floating point systems, a floating point number is represented
by
.CS


x = +/- d1 d2 \&.\&.\&. dt basis^e

.CE
where digits satisfy
.CS


0 <= di <= basis - 1, i = 1, t

.CE
with the convention :
.IP \(bu
t is the size of the mantissa
.IP \(bu
basis is the basis (the "radix")
.PP
.PP
The \fBcompute\fR method computes all machine parameters\&.
Then, the \fBget\fR method can be used to get each
parameter\&.
The \fBprint\fR method prints a report on standard output\&.
.SH EXAMPLE
In the following example, one compute the parameters of a desktop
under Linux with the following Tcl 8\&.4\&.19 properties :
.CS


% parray tcl_platform
tcl_platform(byteOrder) = littleEndian
tcl_platform(machine)   = i686
tcl_platform(os)        = Linux
tcl_platform(osVersion) = 2\&.6\&.24-19-generic
tcl_platform(platform)  = unix
tcl_platform(tip,268)   = 1
tcl_platform(tip,280)   = 1
tcl_platform(user)      = <username>
tcl_platform(wordSize)  = 4

.CE
The following example creates a machineparameters object,
computes the properties and displays it\&.
.CS


     set pp [machineparameters create %AUTO%]
     $pp compute
     $pp print
     $pp destroy

.CE
This prints out :
.CS


     Machine parameters
     Epsilon : 1\&.11022302463e-16
     Beta : 2
     Rounding : proper
     Mantissa : 53
     Maximum exponent : 1024
     Minimum exponent : -1021
     Overflow threshold : 8\&.98846567431e+307
     Underflow threshold : 2\&.22507385851e-308

.CE
That compares well with the results produced by Lapack 3\&.1\&.1 :
.CS


     Epsilon                      =   1\&.11022302462515654E-016
     Safe minimum                 =   2\&.22507385850720138E-308
     Base                         =    2\&.0000000000000000
     Precision                    =   2\&.22044604925031308E-016
     Number of digits in mantissa =    53\&.000000000000000
     Rounding mode                =   1\&.00000000000000000
     Minimum exponent             =   -1021\&.0000000000000
     Underflow threshold          =   2\&.22507385850720138E-308
     Largest exponent             =    1024\&.0000000000000
     Overflow threshold           =   1\&.79769313486231571E+308
     Reciprocal of safe minimum   =   4\&.49423283715578977E+307

.CE
The following example creates a machineparameters object,
computes the properties and gets the epsilon for
the machine\&.
.CS


     set pp [machineparameters create %AUTO%]
     $pp compute
     set eps [$pp get -epsilon]
     $pp destroy

.CE
.SH REFERENCES
.IP \(bu
"Algorithms to Reveal Properties of Floating-Point Arithmetic", Michael A\&. Malcolm, Stanford University, Communications of the ACM, Volume 15 ,  Issue 11  (November 1972), Pages: 949 - 951
.IP \(bu
"More on Algorithms that Reveal Properties of Floating, Point Arithmetic Units", W\&. Morven Gentleman, University of Waterloo, Scott B\&. Marovich, Purdue University, Communications of the ACM, Volume 17 ,  Issue 5  (May 1974), Pages: 276 - 277
.PP
.SH "CLASS API"
.TP
\fBmachineparameters\fR create \fIobjectname\fR ?\fIoptions\fR\&.\&.\&.?
The command creates a new machineparameters object and returns the fully
qualified name of the object command as its result\&.
.RS
.TP
\fB-verbose\fR \fIverbose\fR
Set this option to 1 to enable verbose logging\&.
This option is mainly for debug purposes\&.
The default value of \fIverbose\fR is 0\&.
.RE
.PP
.SH "OBJECT API"
.TP
\fIobjectname\fR \fBconfigure\fR ?\fIoptions\fR\&.\&.\&.?
The command configure the options of the object \fIobjectname\fR\&. The options
are the same as the static method \fBcreate\fR\&.
.TP
\fIobjectname\fR \fBcget\fR \fIopt\fR
Returns the value of the option which name is \fIopt\fR\&. The options
are the same as the method \fBcreate\fR and \fBconfigure\fR\&.
.TP
\fIobjectname\fR \fBdestroy\fR
Destroys the object \fIobjectname\fR\&.
.TP
\fIobjectname\fR \fBcompute\fR
Computes the machine parameters\&.
.TP
\fIobjectname\fR \fBget\fR \fIkey\fR
Returns the value corresponding with given key\&.
The following is the list of available keys\&.
.RS
.IP \(bu
-epsilon : smallest value so that 1+epsilon>1 is false
.IP \(bu
-rounding : The rounding mode used on the machine\&.
The rounding occurs when more than t digits would be required to
represent the number\&.
Two modes can be determined with the current system :
"chop" means than only t digits are kept, no matter the value of the number
"proper" means that another rounding mode is used, be it "round to nearest",
"round up", "round down"\&.
.IP \(bu
-basis : the basis of the floating-point representation\&.
The basis is usually 2, i\&.e\&. binary representation (for example IEEE 754 machines),
but some machines (like HP calculators for example) uses 10, or 16, etc\&.\&.\&.
.IP \(bu
-mantissa : the number of bits in the mantissa
.IP \(bu
-exponentmax :  the largest positive exponent before overflow occurs
.IP \(bu
-exponentmin : the largest negative exponent before (gradual) underflow occurs
.IP \(bu
-vmax : largest positive value before overflow occurs
.IP \(bu
-vmin : largest negative value before (gradual) underflow occurs
.RE
.TP
\fIobjectname\fR \fBtostring\fR
Return a report for machine parameters\&.
.TP
\fIobjectname\fR \fBprint\fR
Print machine parameters on standard output\&.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fImath\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH COPYRIGHT
.nf
Copyright (c) 2008 Michael Baudin <michael\&.baudin@sourceforge\&.net>

.fi