from _typeshed import StrOrBytesPath

from .Image import Image

LUT_SIZE: int
ROTATION_MATRIX: list[int]
MIRROR_MATRIX: list[int]

class LutBuilder:
    patterns: list[str]
    lut: bytearray
    def __init__(self, patterns: list[str] | None = ..., op_name: str | None = ...) -> None: ...
    def add_patterns(self, patterns: list[str]) -> None: ...
    def build_default_lut(self) -> None: ...
    def get_lut(self) -> bytearray: ...
    def build_lut(self) -> bytearray: ...

class MorphOp:
    lut: bytearray
    def __init__(self, lut: bytearray | None = ..., op_name: str | None = ..., patterns: list[str] | None = ...) -> None: ...
    def apply(self, image: Image) -> tuple[int, Image]: ...
    def match(self, image: Image) -> list[tuple[int, int]]: ...
    def get_on_pixels(self, image: Image) -> list[tuple[int, int]]: ...
    def load_lut(self, filename: StrOrBytesPath) -> None: ...
    def save_lut(self, filename: StrOrBytesPath) -> None: ...
    def set_lut(self, lut: bytearray) -> None: ...
