/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.functions;

import edu.hws.jcm.data.Cases;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.StackOfDouble;
import edu.hws.jcm.data.Variable;
import edu.hws.jcm.functions.CubicSegment;
import edu.hws.jcm.functions.FunctionParserExtension;

public class TableFunction
extends FunctionParserExtension {
    public static final int SMOOTH = 0;
    public static final int PIECEWISE_LINEAR = 1;
    public static final int STEP = 2;
    public static final int STEP_LEFT = 3;
    public static final int STEP_RIGHT = 4;
    private int style;
    private double[] xCoords = new double[10];
    private double[] yCoords = new double[10];
    private CubicSegment[] segments;
    private int pointCt;

    public TableFunction() {
        this(0);
    }

    public TableFunction(int n) {
        this.style = this.style;
        if (this.style == 0) {
            this.segments = new CubicSegment[9];
        }
    }

    public void copyDataFrom(TableFunction tableFunction) {
        this.xCoords = (double[])tableFunction.xCoords.clone();
        this.yCoords = (double[])tableFunction.yCoords.clone();
        this.style = -1;
        this.setStyle(tableFunction.style);
    }

    public void setStyle(int n) {
        if (n == this.style || n < 0 || n > 4) {
            return;
        }
        this.style = n;
        if (n == 0) {
            int n2;
            this.segments = new CubicSegment[this.xCoords.length - 1];
            for (n2 = 0; n2 < this.pointCt - 1; ++n2) {
                this.segments[n2] = new CubicSegment(this.xCoords[n2], this.xCoords[n2 + 1], this.yCoords[n2], this.yCoords[n2 + 1], 0.0, 0.0);
            }
            for (n2 = 0; n2 < this.pointCt - 1; ++n2) {
                this.interpolateDerivatives(n2);
            }
        } else {
            this.segments = null;
        }
    }

    public int getStyle() {
        return this.style;
    }

    public void addPoints(double[] dArray, double[] dArray2) {
        int n;
        if (dArray == null) {
            return;
        }
        int n2 = dArray.length;
        if (dArray2 == null) {
            n2 = 0;
        } else if (dArray2.length < n2) {
            n2 = dArray2.length;
        }
        for (n = 0; n < n2; ++n) {
            this.addPoint(dArray[n], dArray2[n]);
        }
        for (n = n2; n < dArray.length; ++n) {
            this.addPoint(dArray[n], 0.0);
        }
    }

    public void addIntervals(int n, double d, double d2) {
        if (n < 1) {
            return;
        }
        double d3 = (d2 - d) / (double)n;
        for (int i = 0; i < n; ++i) {
            this.addPoint(d + (double)i * d3, 0.0);
        }
        this.addPoint(d2, 0.0);
    }

    public int addPoint(double d, double d2) {
        int n;
        int n2;
        if (Double.isNaN(d)) {
            return -1;
        }
        for (n2 = 0; n2 < this.pointCt && this.xCoords[n2] < d; ++n2) {
        }
        if (n2 < this.pointCt && this.xCoords[n2] == d) {
            this.yCoords[n2] = d2;
        } else {
            if (this.pointCt == this.xCoords.length) {
                double[] dArray = new double[2 * this.xCoords.length];
                System.arraycopy(this.xCoords, 0, dArray, 0, this.xCoords.length);
                this.xCoords = dArray;
                dArray = new double[2 * this.yCoords.length];
                System.arraycopy(this.yCoords, 0, dArray, 0, this.yCoords.length);
                this.yCoords = dArray;
                if (this.style == 0) {
                    CubicSegment[] cubicSegmentArray = new CubicSegment[this.xCoords.length - 1];
                    System.arraycopy(this.segments, 0, cubicSegmentArray, 0, this.pointCt - 1);
                    this.segments = cubicSegmentArray;
                }
            }
            for (n = this.pointCt; n > n2; --n) {
                this.xCoords[n] = this.xCoords[n - 1];
                this.yCoords[n] = this.yCoords[n - 1];
            }
            this.xCoords[n2] = d;
            this.yCoords[n2] = d2;
            if (this.style == 0 && this.pointCt > 0) {
                if (n2 == this.pointCt) {
                    this.segments[this.pointCt - 1] = new CubicSegment();
                } else {
                    for (n = this.pointCt - 1; n > n2; --n) {
                        this.segments[n] = this.segments[n - 1];
                    }
                    this.segments[n2] = new CubicSegment();
                }
            }
            ++this.pointCt;
        }
        if (this.style == 0 && this.pointCt > 0) {
            if (n2 > 0) {
                this.segments[n2 - 1].setData(this.xCoords[n2 - 1], this.xCoords[n2], this.yCoords[n2 - 1], this.yCoords[n2], 0.0, 0.0);
            }
            if (n2 < this.pointCt - 1) {
                this.segments[n2].setData(this.xCoords[n2], this.xCoords[n2 + 1], this.yCoords[n2], this.yCoords[n2 + 1], 0.0, 0.0);
            }
            for (n = n2 - 2; n <= n2 + 1; ++n) {
                this.interpolateDerivatives(n);
            }
        }
        return n2;
    }

    private void interpolateDerivatives(int n) {
        if (n < 0 || n > this.pointCt - 2) {
            return;
        }
        if (this.pointCt == 2) {
            this.segments[0].setDerivativesFromNeighbors(Double.NaN, 0.0, Double.NaN, 0.0);
        } else if (n == 0) {
            this.segments[0].setDerivativesFromNeighbors(Double.NaN, 0.0, this.xCoords[2], this.yCoords[2]);
        } else if (n == this.pointCt - 2) {
            this.segments[this.pointCt - 2].setDerivativesFromNeighbors(this.xCoords[this.pointCt - 3], this.yCoords[this.pointCt - 3], Double.NaN, 0.0);
        } else {
            this.segments[n].setDerivativesFromNeighbors(this.xCoords[n - 1], this.yCoords[n - 1], this.xCoords[n + 2], this.yCoords[n + 2]);
        }
    }

    public int getPointCount() {
        return this.pointCt;
    }

    public double getX(int n) {
        if (n >= 0 && n < this.pointCt) {
            return this.xCoords[n];
        }
        throw new IllegalArgumentException("Point index out of range: " + n);
    }

    public double getY(int n) {
        if (n >= 0 && n < this.pointCt) {
            return this.yCoords[n];
        }
        throw new IllegalArgumentException("Point index out of range: " + n);
    }

    public void setY(int n, double d) {
        if (n < 0 || n >= this.pointCt) {
            throw new IllegalArgumentException("Point index out of range: " + n);
        }
        this.yCoords[n] = d;
        if (this.style == 0) {
            if (n > 0) {
                this.segments[n - 1].setData(this.xCoords[n - 1], this.xCoords[n], this.yCoords[n - 1], this.yCoords[n], 0.0, 0.0);
            }
            if (n < this.pointCt - 1) {
                this.segments[n].setData(this.xCoords[n], this.xCoords[n + 1], this.yCoords[n], this.yCoords[n + 1], 0.0, 0.0);
            }
            for (int i = n - 2; i <= n + 1; ++i) {
                this.interpolateDerivatives(i);
            }
        }
    }

    public int findPoint(double d) {
        for (int i = 0; i < this.pointCt; ++i) {
            if (d == this.xCoords[i]) {
                return i;
            }
            if (!(d > this.xCoords[i])) break;
        }
        return -1;
    }

    public void removePointAt(int n) {
        if (n < 0 || n >= this.pointCt) {
            throw new IllegalArgumentException("Point index out of range: " + n);
        }
        --this.pointCt;
        for (int i = n; i < this.pointCt; ++i) {
            this.xCoords[i] = this.xCoords[i + 1];
            this.yCoords[i] = this.yCoords[i + 1];
        }
        if (this.style == 0) {
            this.style = -1;
            this.setStyle(0);
        }
    }

    public void removeAllPoints() {
        this.pointCt = 0;
        this.xCoords = new double[10];
        this.yCoords = new double[10];
    }

    public double getVal(double d) {
        return this.computeValue(d, null, 0);
    }

    private double computeValue(double d, Cases cases, int n) {
        double d2;
        int n2;
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (this.pointCt == 0 || d < this.xCoords[0] || d > this.xCoords[this.pointCt - 1]) {
            return Double.NaN;
        }
        if (this.pointCt == 1) {
            if (n > 0) {
                return Double.NaN;
            }
            if (cases == null) {
                cases.addCase(0);
            }
            return this.yCoords[0];
        }
        switch (this.style) {
            case 2: {
                int n3;
                for (n3 = 0; n3 < this.pointCt - 1 && d > (this.xCoords[n3] + this.xCoords[n3 + 1]) / 2.0; ++n3) {
                }
                n2 = n3;
                if (n == 0) {
                    d2 = this.yCoords[n3];
                    break;
                }
                if (d < (this.xCoords[n3] + this.xCoords[n3 + 1]) / 2.0 || n3 == this.pointCt - 1 || this.yCoords[n3] == this.yCoords[n3 + 1]) {
                    d2 = 0.0;
                    break;
                }
                d2 = Double.NaN;
                break;
            }
            case 4: {
                int n3;
                while (n3 < this.pointCt - 1 && d > this.xCoords[n3]) {
                    ++n3;
                }
                n2 = n3;
                if (n == 0) {
                    d2 = this.yCoords[n3];
                    break;
                }
                if (d < this.xCoords[n3] || n3 >= this.pointCt - 1 || this.yCoords[n3] == this.yCoords[n3 + 1]) {
                    d2 = 0.0;
                    break;
                }
                d2 = Double.NaN;
                break;
            }
            case 3: {
                int n3;
                while (n3 < this.pointCt - 1 && d >= this.xCoords[n3 + 1]) {
                    ++n3;
                }
                n2 = n3;
                if (n == 0) {
                    d2 = this.yCoords[n3];
                    break;
                }
                if (d > this.xCoords[n3] || n3 == 0 || this.yCoords[n3] == this.yCoords[n3 - 1]) {
                    d2 = 0.0;
                    break;
                }
                d2 = Double.NaN;
                break;
            }
            case 1: {
                int n3;
                while (n3 < this.pointCt - 1 && d > this.xCoords[n3]) {
                    ++n3;
                }
                n2 = n3;
                if (d == this.xCoords[n3]) {
                    if (n == 0) {
                        d2 = this.yCoords[n3];
                        break;
                    }
                    if (n3 == 0) {
                        if (n == 1) {
                            d2 = (this.yCoords[1] - this.yCoords[0]) / (this.xCoords[1] - this.xCoords[0]);
                            break;
                        }
                        d2 = 0.0;
                        break;
                    }
                    if (n3 == this.pointCt - 1) {
                        if (n == 1) {
                            d2 = (this.yCoords[this.pointCt - 1] - this.yCoords[this.pointCt - 2]) / (this.xCoords[this.pointCt - 1] - this.xCoords[this.pointCt - 2]);
                            break;
                        }
                        d2 = 0.0;
                        break;
                    }
                    double d3 = (this.yCoords[n3] - this.yCoords[n3 - 1]) / (this.xCoords[n3] - this.xCoords[n3 - 1]);
                    double d4 = (this.yCoords[n3] - this.yCoords[n3 + 1]) / (this.xCoords[n3] - this.xCoords[n3 + 1]);
                    if (Math.abs(d3 - d4) < 1.0E-12) {
                        if (n == 1) {
                            d2 = d3;
                            break;
                        }
                        d2 = 0.0;
                        break;
                    }
                    d2 = Double.NaN;
                    break;
                }
                if (n == 0) {
                    d2 = this.yCoords[n3 - 1] + (this.yCoords[n3] - this.yCoords[n3 - 1]) / (this.xCoords[n3] - this.xCoords[n3 - 1]) * (d - this.xCoords[n3 - 1]);
                    break;
                }
                if (n == 1) {
                    d2 = (this.yCoords[n3] - this.yCoords[n3 - 1]) / (this.xCoords[n3] - this.xCoords[n3 - 1]);
                    break;
                }
                d2 = 0.0;
                break;
            }
            default: {
                int n3;
                while (n3 < this.pointCt - 2 && d > this.xCoords[n3 + 1]) {
                    ++n3;
                }
                n2 = n3;
                if (d == this.xCoords[n3 + 1] && n3 < this.pointCt - 2 && n3 > 0) {
                    double d5;
                    if (n == 0) {
                        d2 = this.yCoords[n3 + 1];
                        break;
                    }
                    if (n == 1) {
                        d2 = this.segments[n3].derivativeValue(d, 1);
                        break;
                    }
                    double d6 = this.segments[n3 - 1].derivativeValue(d, 2);
                    if (Math.abs(d6 - (d5 = this.segments[n3].derivativeValue(d, 2))) < 1.0E-12) {
                        d2 = this.segments[n3].derivativeValue(d, n);
                        break;
                    }
                    d2 = Double.NaN;
                    break;
                }
                d2 = this.segments[n3].derivativeValue(d, n);
            }
        }
        if (cases != null) {
            cases.addCase(n2);
        }
        return d2;
    }

    public double getValueWithCases(double[] dArray, Cases cases) {
        return this.computeValue(dArray[0], cases, 0);
    }

    public double getVal(double[] dArray) {
        return this.computeValue(dArray[0], null, 0);
    }

    public Function derivative(int n) {
        if (n != 1) {
            throw new IllegalArgumentException("Attempt to take the derivative of a function of one argument with respect to argument number " + n);
        }
        return new Deriv(this);
    }

    public Function derivative(Variable variable) {
        return null;
    }

    public boolean dependsOn(Variable variable) {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public void apply(StackOfDouble stackOfDouble, Cases cases) {
        double d = stackOfDouble.pop();
        stackOfDouble.push(this.computeValue(d, cases, 0));
    }

    private static class Deriv
    extends FunctionParserExtension {
        TableFunction derivativeOf;
        int derivativeLevel;

        Deriv(Deriv deriv) {
            this.derivativeLevel = deriv.derivativeLevel + 1;
            this.derivativeOf = deriv.derivativeOf;
        }

        Deriv(TableFunction tableFunction) {
            this.derivativeLevel = 1;
            this.derivativeOf = tableFunction;
        }

        public String getName() {
            String string = this.derivativeOf.getName();
            for (int i = 0; i < this.derivativeLevel; ++i) {
                string = string + "'";
            }
            return string;
        }

        public void setName(String string) {
        }

        public double getValueWithCases(double[] dArray, Cases cases) {
            return this.derivativeOf.computeValue(dArray[0], cases, this.derivativeLevel);
        }

        public double getVal(double[] dArray) {
            return this.derivativeOf.computeValue(dArray[0], null, this.derivativeLevel);
        }

        public Function derivative(int n) {
            if (n != 1) {
                throw new IllegalArgumentException("Attempt to take the derivative of a function of one argument with respect to argument number " + n);
            }
            return new Deriv(this);
        }

        public Function derivative(Variable variable) {
            return null;
        }

        public boolean dependsOn(Variable variable) {
            return false;
        }

        public int getArity() {
            return 1;
        }

        public void apply(StackOfDouble stackOfDouble, Cases cases) {
            double d = stackOfDouble.pop();
            stackOfDouble.push(this.derivativeOf.computeValue(d, cases, this.derivativeLevel));
        }
    }
}

