#!/usr/bin/env python




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from xpdeint.Features._Feature import _Feature
from xpdeint.CallOnceGuards import callOnceGuard

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '2.4.4'
__CHEETAH_versionTuple__ = (2, 4, 4, 'development', 0)
__CHEETAH_genTime__ = 1413234538.554493
__CHEETAH_genTimestamp__ = 'Tue Oct 14 08:08:58 2014'
__CHEETAH_src__ = '/Users/graham/Library/XMDS/src/xmds2/admin/staging/xmds-2.2.2/xpdeint/Features/OpenMP.tmpl'
__CHEETAH_srcLastModified__ = 'Thu Oct 18 19:50:44 2012'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class OpenMP(_Feature):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(OpenMP, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def description(self, **KWS):



        ## Generated from @def description: OpenMP at line 26, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''OpenMP''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    @callOnceGuard
    def includes(self, **KWS):



        ## CHEETAH: generated from @def includes at line 31, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        _v = super(OpenMP, self).includes()
        if _v is not None: write(_filter(_v))
        # 
        write(u'''#ifdef _OPENMP
#include <omp.h>
#endif
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def mainBegin(self, dict, **KWS):



        ## CHEETAH: generated from @def mainBegin($dict) at line 41, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        if VFFSL(SL,"threadCount",True): # generated from line 43, col 3
            write(u'''#ifdef _OPENMP
omp_set_num_threads(''')
            _v = VFFSL(SL,"threadCount",True) # u'$threadCount' on line 45, col 21
            if _v is not None: write(_filter(_v, rawExpr=u'$threadCount')) # from line 45, col 21.
            write(u''');
#endif
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def loopOverVectorsWithInnerContentTemplateBegin(self, dict, **KWS):



        ## CHEETAH: generated from @def loopOverVectorsWithInnerContentTemplateBegin($dict) at line 51, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        if 'UNVECTORISABLE' in dict['templateString']: # generated from line 53, col 3
            return
        write(u'''#ifdef _OPENMP
#pragma omp parallel for
#endif
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def loopOverVectorsWithInnerContentBegin(self, dict, **KWS):



        ## CHEETAH: generated from @def loopOverVectorsWithInnerContentBegin($dict) at line 62, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        if 'UNVECTORISABLE' in dict['loopCode']: # generated from line 64, col 3
            return
        # 
        vectors = dict['vectors']
        index_pointers = [''.join([u'_',str(VFFSL(SL,"vector.id",True)),u'_index_pointer']) for vector in vectors]
        # 
        write(u'''bool __initialised = false;
#ifdef _OPENMP
''')
        suffix = ''
        if index_pointers: # generated from line 74, col 3
            suffix = ''.join([u' private(',str(", ".join(index_pointers)),u')'])
        write(u'''#pragma omp parallel for firstprivate(__initialised)''')
        _v = VFFSL(SL,"suffix",True) # u'${suffix}' on line 77, col 53
        if _v is not None: write(_filter(_v, rawExpr=u'${suffix}')) # from line 77, col 53.
        write(u'''
#endif
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def loopOverVectorsWithInnerContentEnd(self, dict, **KWS):



        ## CHEETAH: generated from @def loopOverVectorsWithInnerContentEnd($dict) at line 82, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        if 'UNVECTORISABLE' in dict['loopCode']: # generated from line 84, col 3
            return
        # 
        vectors = dict['vectors']
        # 
        write(u'''if (!__initialised) {
''')
        for vector in vectors: # generated from line 91, col 3
            write(u'''  _''')
            _v = VFFSL(SL,"vector.id",True) # u'${vector.id}' on line 92, col 4
            if _v is not None: write(_filter(_v, rawExpr=u'${vector.id}')) # from line 92, col 4.
            write(u'''_index_pointer = _i0 * _''')
            _v = VFFSL(SL,"vector.id",True) # u'${vector.id}' on line 92, col 40
            if _v is not None: write(_filter(_v, rawExpr=u'${vector.id}')) # from line 92, col 40.
            write(u'''_ncomponents;
''')
        write(u'''  __initialised = true;
}
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def loopOverFieldInBasisWithVectorsAndInnerContentLoopOpenBegin(self, dict, **KWS):



        ## CHEETAH: generated from @def loopOverFieldInBasisWithVectorsAndInnerContentLoopOpenBegin($dict) at line 98, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        #  What about the copyDeltaA code? Is that parallel-safe?
        #  If we have already parallelised a dimension, don't do any more
        #  and if we can't parallelise, don't.
        if 'UNVECTORISABLE' in dict['loopCode'] or 'openMPParallelDimRep' in dict: # generated from line 103, col 3
            return
        # 
        vectorOverrides = dict['vectorOverrides']
        field = dict['field']
        basis = dict['basis']
        dimRep = dict['dimRep']
        dimensionsBeingIntegratedOver = set()
        if vectorOverrides: # generated from line 112, col 3
            dimensionsBeingIntegratedOver.update(field.dimensions)
            for dim in dimensionsBeingIntegratedOver.copy(): # generated from line 114, col 5
                for vector in vectorOverrides: # generated from line 115, col 7
                    if vector.field.hasDimension(dim): # generated from line 116, col 9
                        dimensionsBeingIntegratedOver.discard(dim)
                        break
        # 
        #  If this dim rep is being integrated over, we can't parallelise this dimension, so return
        for dim in dimensionsBeingIntegratedOver: # generated from line 125, col 3
            if dim.inBasis(basis) == dimRep: # generated from line 126, col 5
                return
        # 
        for fieldDimRep in reversed(field.inBasis(basis)): # generated from line 131, col 3
            #  If there's pre or post dimension loop opening code, we can't trust that we can parallelise this.
            if fieldDimRep.name in dict['preDimensionLoopOpeningCode'] or fieldDimRep.name in dict['postDimensionLoopClosingCode']: # generated from line 133, col 5
                return
            # 
            if fieldDimRep == dimRep: # generated from line 137, col 5
                break
        # 
        dict['openMPParallelDimRep'] = dict['dimRep']
        # 
        vectorsNotRequiringExplicitIndexPointers = dict['vectorsNotRequiringExplicitIndexPointers']
        private_variables = [''.join([u'_',str(VFFSL(SL,"vector.id",True)),u'_index_pointer']) for vector in vectorsNotRequiringExplicitIndexPointers]
        for vector in dict['vectorOverrides']: # generated from line 146, col 3
            private_variables.extend(vector.components)
        # 
        suffix = ''
        if private_variables: # generated from line 151, col 3
            suffix = ''.join([u' private(',str(", ".join(private_variables)),u')'])
        write(u'''bool __initialised = false;
#ifdef _OPENMP
#pragma omp parallel for firstprivate(__initialised)''')
        _v = VFFSL(SL,"suffix",True) # u'${suffix}' on line 156, col 53
        if _v is not None: write(_filter(_v, rawExpr=u'${suffix}')) # from line 156, col 53.
        write(u'''
#endif
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def loopOverFieldInBasisWithVectorsAndInnerContentLoopOpenEnd(self, dict, **KWS):



        ## CHEETAH: generated from @def loopOverFieldInBasisWithVectorsAndInnerContentLoopOpenEnd($dict) at line 161, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        #  Only complete initialisation for the parallel loop if this is that loop
        if dict.get('openMPParallelDimRep') is not dict['dimRep']: # generated from line 164, col 3
            return
        # 
        vectorsNotRequiringExplicitIndexPointers = dict['vectorsNotRequiringExplicitIndexPointers']
        dimRep = dict['dimRep']
        field = dict['field']
        basis = dict['basis']
        # 
        write(u'''if (!__initialised) {
''')
        for vector in vectorsNotRequiringExplicitIndexPointers: # generated from line 174, col 3
            write(u'''  _''')
            _v = VFFSL(SL,"vector.id",True) # u'${vector.id}' on line 175, col 4
            if _v is not None: write(_filter(_v, rawExpr=u'${vector.id}')) # from line 175, col 4.
            write(u'''_index_pointer = ''')
            _v = VFFSL(SL,"dimRep.loopIndex",True) # u'${dimRep.loopIndex}' on line 175, col 33
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.loopIndex}')) # from line 175, col 33.
            write(u''' * ''')
            _v = VFN(VFFSL(SL,"vector.field",True),"localPointsInDimensionsAfterDimRepInBasis",False)(dimRep, basis) # u'${vector.field.localPointsInDimensionsAfterDimRepInBasis(dimRep, basis)}' on line 175, col 55
            if _v is not None: write(_filter(_v, rawExpr=u'${vector.field.localPointsInDimensionsAfterDimRepInBasis(dimRep, basis)}')) # from line 175, col 55.
            write(u''' * _''')
            _v = VFFSL(SL,"vector.id",True) # u'${vector.id}' on line 175, col 131
            if _v is not None: write(_filter(_v, rawExpr=u'${vector.id}')) # from line 175, col 131.
            write(u'''_ncomponents;
''')
            for prefixDimRep in field.inBasis(basis): # generated from line 176, col 5
                if prefixDimRep is dimRep: # generated from line 177, col 7
                    break
                write(u'''  _''')
                _v = VFFSL(SL,"vector.id",True) # u'${vector.id}' on line 180, col 4
                if _v is not None: write(_filter(_v, rawExpr=u'${vector.id}')) # from line 180, col 4.
                write(u'''_index_pointer += ''')
                _v = VFFSL(SL,"prefixDimRep.loopIndex",True) # u'${prefixDimRep.loopIndex}' on line 180, col 34
                if _v is not None: write(_filter(_v, rawExpr=u'${prefixDimRep.loopIndex}')) # from line 180, col 34.
                write(u''' * ''')
                _v = VFN(VFFSL(SL,"vector.field",True),"localPointsInDimensionsAfterDimRepInBasis",False)(prefixDimRep, basis) # u'${vector.field.localPointsInDimensionsAfterDimRepInBasis(prefixDimRep, basis)}' on line 180, col 62
                if _v is not None: write(_filter(_v, rawExpr=u'${vector.field.localPointsInDimensionsAfterDimRepInBasis(prefixDimRep, basis)}')) # from line 180, col 62.
                write(u''' * _''')
                _v = VFFSL(SL,"vector.id",True) # u'${vector.id}' on line 180, col 144
                if _v is not None: write(_filter(_v, rawExpr=u'${vector.id}')) # from line 180, col 144.
                write(u'''_ncomponents;
''')
        write(u'''  __initialised = true;
}
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        # OpenMP.tmpl
        # 
        # Created by Graham Dennis on 2007-12-18.
        # 
        # Copyright (c) 2007-2012, Graham Dennis
        # 
        # This program is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program.  If not, see <http://www.gnu.org/licenses/>.
        # 
        write(u'''








''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    featureName = 'OpenMP'

    uselib = ['openmp']

    _mainCheetahMethod_for_OpenMP= 'writeBody'

## END CLASS DEFINITION

if not hasattr(OpenMP, '_initCheetahAttributes'):
    templateAPIClass = getattr(OpenMP, '_CHEETAH_templateClass', Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(OpenMP)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit http://www.CheetahTemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=OpenMP()).run()


